'*******************************************************
'*                                                     *
'*  Polar Plotting Phun                                *
'*  Released as Open Source                            *
'*  Version 1.0 by Tom Nally, steelweaver52@aol.com    *
'*  Made with Liberty Basic by Carl Gundel             *
'*  Made with Liberty Basic Workshop by Alyce Watson   *
'*  Made with Windows Paint by Microsoft               *
'*                                                     *
'*******************************************************

'Initialize Arrays (um, except pi...it's not an array, of course)

pi = 3.14159

Dim fn1$(1)
Dim fn2$(1)
Dim fn3$(1)

fn1$(0) = "sin( )"
fn1$(1) = "cos( )"
fn2$(0) = "sin( )"
fn2$(1) = "cos( )"
fn3$(0) = "sin( )"
fn3$(1) = "cos( )"

Dim PlotRange(98)
Dim PlotRange$(98)

For i = 0 to 98
    PlotRange(i) = (i+2)*pi
    PlotRange$(i) = " " + Str$(2+i)+ "  pi"
Next i

Dim PlotIncrement(28)
Dim PlotIncrement$(28)

For i = 0 to 14
    PlotIncrement(i) = ((i+1)/360)*2*pi
    PlotIncrement$(i) = " " + Str$(i+1) + " degrees"
Next i

    PlotIncrement$(0) = " 1 degree"

'Initialize Variables

AA = 2
BB = 2.5
CC = 3
DD = 3.5
EE = 4
FF = 4.5
GG = 5

AA$ = "2"
BB$ = "2.5"
CC$ = "3"
DD$ = "3.5"
EE$ = "4"
FF$ = "4.5"
GG$ = "5"

fn1Index = 1
fn2Index = 2
fn3Index = 1

fn1$ = "sin"
fn2$ = "cos"
fn3$ = "sin"

PlotRangeIndex = 1
PlotIncrementIndex = 1

PlotRange = PlotRange(0)
PlotIncrement = PlotIncrement(0)

Graph.Appearance$ = "LinesOnly"
'Graph.Appearance$ = "MarkersOnly"
'Graph.Appearance$ = "LinesAndMarkers"

RR = 0

MaxRR = 0
MinRR = 0
ExtremeRR = 0
Xprojection = 0
Yprojection = 0

PlotScale = 1

    True = 1 : False = 0

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Lightgray"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NoMainWin
    WindowWidth = 800 : WindowHeight = 580
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Graphicbox  #main.PlotArea, 345, 120, 420, 420

Groupbox    #main.groupbox1, "Polar Graph Appearance", 25, 225, 290, 100

Statictext  #main.statictext2, "R = ", 15, 85, 25, 20
Statictext  #main.statictext3, "General Formula:", 10, 10, 110, 20
Statictext  #main.statictext4, "A", 60, 60, 15, 20
Statictext  #main.statictext5, "+", 90, 85, 15, 20
Statictext  #main.statictext6, "B", 120, 60, 15, 20
Statictext  #main.statictext7, "", 150, 85, 10, 20
Statictext  #main.statictext8, "C", 245, 60, 15, 20
Statictext  #main.statictext10, "fn1", 180, 60, 20, 20
Statictext  #main.statictext11, "+", 315, 85, 15, 20
Statictext  #main.statictext12, "", 375, 85, 10, 20
Statictext  #main.statictext13, "D", 345, 60, 15, 20
Statictext  #main.statictext14, "fn2", 400, 60, 20, 20
Statictext  #main.statictext15, "E", 470, 60, 15, 20
Statictext  #main.statictext16, "+", 540, 85, 15, 20
Statictext  #main.statictext17, "", 600, 85, 10, 20
Statictext  #main.statictext19, "F", 570, 60, 15, 20
Statictext  #main.statictext20, "G", 690, 60, 15, 20
Statictext  #main.statictext21, "fn3", 625, 60, 20, 20
Statictext  #main.statictext23, "Below, fill in the variables for A through G, which can be positive or negative numbers.  Then select sin() or cos() for fn1, fn2 and fn3.", 10, 40, 765, 20
Statictext  #main.statictext20, "Plot Range From 0pi to :", 55, 160, 150, 20
Statictext  #main.statictext21, "Plot Increment :", 110, 200, 95, 20
Statictext  #main.statictextaa, "Plot Status:", 25, 425, 75, 20

Button      #main.Huh, "Huh?",[Huh.click],UL, 445, 5, 75, 25
Button      #main.Tips0, "Tips...",[Tips.click],UL, 525, 5, 75, 25
Button      #main.Quit, "Quit",[Quit.click],UL, 240, 515, 75, 25
Button      #main.About..., "About...",[About.click],UL, 160, 515, 75, 25
Button      #main.Randomize, "*** Randomize Functions and Constants ***",[Randomize.click],UL, 25, 120, 290, 25

BmpButton   #main.bmpPLOT, "plotbtn.bmp",[PLOT.click],UL, 25, 335

BmpButton   #main.bmpbutton1, "form1.bmp",[dummy.click],UL, 125, 5
BmpButton   #main.bmpbutton2, "openp.bmp",[dummy.click],UL, 215, 75
BmpButton   #main.bmpbutton3, "closedp.bmp",[dummy.click],UL, 295, 75
BmpButton   #main.bmpbutton4, "phi.bmp",[dummy.click],UL, 270, 80
BmpButton   #main.bmpbutton5, "openp.bmp",[dummy.click],UL, 440, 75
BmpButton   #main.bmpbutton6, "phi.bmp",[dummy.click],UL, 495, 80
BmpButton   #main.bmpbutton7, "closedp.bmp",[dummy.click],UL, 520, 75
BmpButton   #main.bmpbutton8, "openp.bmp",[dummy.click],UL, 665, 75
BmpButton   #main.bmpbutton9, "closedp.bmp",[dummy.click],UL, 745, 75
BmpButton   #main.bmpbutton10, "phi.bmp",[dummy.click],UL, 720, 80

Textbox     #main.AA, 45, 80, 40, 24
Textbox     #main.BB, 105, 80, 40, 24
Textbox     #main.CC, 230, 80, 40, 24
Textbox     #main.DD, 330, 80, 40, 24
Textbox     #main.EE, 455, 80, 40, 24
Textbox     #main.FF, 555, 80, 40, 24
Textbox     #main.GG, 680, 80, 40, 24
TextboxColor$    = "cyan"
Textbox     #main.PlotStatus, 105, 425, 210, 24

Radiobutton #main.LinesOnly, "Plot lines only",[LinesOnly.click],[loop], 40, 245, 140, 25
Radiobutton #main.MarkersOnly, "Plot markers only",[MarkersOnly.click],[loop], 40, 270, 129, 25
Radiobutton #main.LinesAndMarkers, "Plot lines and markers",[LinesAndMarkers.click],[loop], 40, 295, 165, 25

Combobox    #main.fn1,fn1$(,[fn1.click], 160, 80, 55, 300
Combobox    #main.fn2,fn2$(,[fn2.click], 385, 80, 55, 300
Combobox    #main.fn3,fn3$(,[fn3.click], 610, 80, 55, 300
Combobox    #main.PlotRange,PlotRange$(,[PlotRange.click], 205, 155, 90, 150
Combobox    #main.PlotIncrement,PlotIncrement$(,[PlotIncrement.click], 205, 190, 90, 150

Open "PolarPhun - Plotting Trig Functions Using Polar Coordinates" For Window As #main

    Print #main, "trapclose [Quit.click]"
    Print #main.PlotArea, "down; fill White; flush"
    Print #main, "font arial 10"

    GoSub [Initialize.Window.Controls]

[loop]
    Wait

[Initialize.Window.Controls]

    Print #main.AA, " " + Str$(AA)
    Print #main.BB, " " + Str$(BB)
    Print #main.CC, " " + Str$(CC)
    Print #main.DD, " " + Str$(DD)
    Print #main.EE, " " + Str$(EE)
    Print #main.FF, " " + Str$(FF)
    Print #main.GG, " " + Str$(GG)

    Print #main.fn1, "selectindex " + Str$(fn1Index)
    Print #main.fn2, "selectindex " + Str$(fn2Index)
    Print #main.fn3, "selectindex " + Str$(fn3Index)
    Print #main.PlotRange, "selectindex " + Str$(PlotRangeIndex)
    Print #main.PlotIncrement, "selectindex " + Str$(PlotIncrementIndex)
    Print #main.LinesOnly, "set"
    Print #main.PlotStatus, " Idle..."

    Return



[Quit.click]

    Close #main : End
    GoTo [loop]

[Randomize.click]

    AA = -10 + Int(21 * Rnd(1))
    BB = -10 + Int(21 * Rnd(1))
    CC = -10 + Int(21 * Rnd(1))
    DD = -10 + Int(21 * Rnd(1))
    EE = -10 + Int(21 * Rnd(1))
    FF = -10 + Int(21 * Rnd(1))
    GG = -10 + Int(21 * Rnd(1))


    If (Rnd(1) <= 0.5) Then
        fn1Index = 1
    Else
        fn1Index = 2
    End If
    If (Rnd(1) <= 0.5) Then
        fn2Index = 1
    Else
        fn2Index = 2
    End If
    If (Rnd(1) <= 0.5) Then
        fn3Index = 1
    Else
        fn3Index = 2
    End If

    GoSub [Initialize.Window.Controls]

    GoTo [PLOT.click]


[PLOT.click]
    'Clear the Plotting Area

    Print #main.PlotStatus, " Calculating..."
    Print #main.PlotArea, "discard"
    Print #main.PlotArea, "fill white"

    'Get all of the values in the text boxes
    Print #main.AA, "!contents? AA$"
    AA = Val(AA$)
    Print #main.BB, "!contents? BB$"
    BB = Val(BB$)
    Print #main.CC, "!contents? CC$"
    CC = Val(CC$)
    Print #main.DD, "!contents? DD$"
    DD = Val(DD$)
    Print #main.EE, "!contents? EE$"
    EE = Val(EE$)
    Print #main.FF, "!contents? FF$"
    FF = Val(FF$)
    Print #main.GG, "!contents? GG$"
    GG = Val(GG$)

    'Get the minimum and maximum values of RR
    'followed by the extreme value of RR

    MinRR = 0: MaxRR = 0
    For phi = 0 to PlotRange step PlotIncrement
        If (fn1$ = "sin") Then
            Part1 = BB*Sin(CC*phi)
        Else
            Part1 = BB*Cos(CC*phi)
        End If

        If (fn2$ = "sin") Then
            Part2 = DD*Sin(EE*phi)
        Else
            Part2 = DD*Cos(EE*phi)
        End If

        If (fn3$ = "sin") Then
            Part3 = FF*Sin(GG*phi)
        Else
            Part3 = FF*Cos(GG*phi)
        End If

        RR = AA + Part1 + Part2 + Part3
        Xprojection = RR * Cos(phi)
        Yprojection = RR * Sin(phi)

        If (Xprojection > MaxRR) Then
            MaxRR = Xprojection
        End If
        If (Yprojection > MaxRR) Then
            MaxRR = Yprojection
        End If
        If (Xprojection < MinRR) Then
            MinRR = Xprojection
        End If
        If (Yprojection < MinRR) Then
            MinRR = Yprojection
        End If

    Next phi

    ExtremeRR = Max(abs(MinRR),abs(MaxRR))


    'Set the plot scale

    PlotScale = (200 / ExtremeRR)

    Print #main.PlotStatus, " Wait...Plotting..."

    Print #main.PlotArea, "down"

    'Plot markers if the user has selected "MarkersOnly" or "LinesAndMarkers"

    If (Graph.Appearance$ = "MarkersOnly") or (Graph.Appearance$ = "LinesAndMarkers") Then
    For phi = 0 to PlotRange step PlotIncrement
        If (fn1$ = "sin") Then
            Part1 = BB*Sin(CC*phi)
        Else
            Part1 = BB*Cos(CC*phi)
        End If

        If (fn2$ = "sin") Then
            Part2 = DD*Sin(EE*phi)
        Else
            Part2 = DD*Cos(EE*phi)
        End If

        If (fn3$ = "sin") Then
            Part3 = FF*Sin(GG*phi)
        Else
            Part3 = FF*Cos(GG*phi)
        End If

        RR = AA + Part1 + Part2 + Part3
        Xplot = 210 + RR * Cos(phi) * PlotScale
        Yplot = 210 + RR * Sin(phi) * PlotScale

        Print #main.PlotArea, "place " + Str$(Xplot) + " " + Str$(Yplot)
        Print #main.PlotArea, "circle 2"

    Next phi
    End If


    'Print Lines if user has selected lines, or lines and markers

    If (Graph.Appearance$ = "LinesOnly") or (Graph.Appearance$ = "LinesAndMarkers") Then
    phi = 0
    If (fn1$ = "sin") Then
        Part1 = BB*Sin(CC*phi)
    Else
        Part1 = BB*Cos(CC*phi)
    End If

    If (fn2$ = "sin") Then
        Part2 = DD*Sin(EE*phi)
    Else
        Part2 = DD*Cos(EE*phi)
    End If

    If (fn3$ = "sin") Then
        Part3 = FF*Sin(GG*phi)
    Else
        Part3 = FF*Cos(GG*phi)
    End If

    RR = AA + Part1 + Part2 + Part3
    Xplot1 = 210 + RR * Cos(phi) * PlotScale
    Yplot1 = 210 + RR * Sin(phi) * PlotScale

    For phi = PlotIncrement to PlotRange step PlotIncrement
        If (fn1$ = "sin") Then
            Part1 = BB*Sin(CC*phi)
        Else
            Part1 = BB*Cos(CC*phi)
        End If

        If (fn2$ = "sin") Then
            Part2 = DD*Sin(EE*phi)
        Else
            Part2 = DD*Cos(EE*phi)
        End If

        If (fn3$ = "sin") Then
            Part3 = FF*Sin(GG*phi)
        Else
            Part3 = FF*Cos(GG*phi)
        End If

        RR = AA + Part1 + Part2 + Part3
        Xplot2 = 210 + RR * Cos(phi) * PlotScale
        Yplot2 = 210 + RR * Sin(phi) * PlotScale

        Print #main.PlotArea, "line " + Str$(Xplot1) + " " + Str$(Yplot1) + " " + Str$(Xplot2) + " " + Str$(Yplot2)
        Xplot1 = Xplot2
        Yplot1 = Yplot2

    Next phi
    End If



    Print #main.PlotArea, "flush"
    Print #main.PlotStatus, " Finished..."

    GoTo [loop]

[dummy.click]

    GoTo [loop]


[LinesOnly.click]
    Graph.Appearance$ = "LinesOnly"

    GoTo [loop]

[MarkersOnly.click]
    Graph.Appearance$ = "MarkersOnly"

    GoTo [loop]

[LinesAndMarkers.click]
    Graph.Appearance$ = "LinesAndMarkers"

    GoTo [loop]

[fn1.click]
    Print #main.fn1, "selectionindex? fn1Index"

    If (fn1Index = 1) Then
        fn1$ = "sin"
    Else
        fn1$ = "cos"
    End If

    GoTo [loop]

[fn2.click]
    Print #main.fn2, "selectionindex? fn2Index"

    If (fn2Index = 1) Then
        fn2$ = "sin"
    Else
        fn2$ = "cos"
    End If

    GoTo [loop]

[fn3.click]
    Print #main.fn3, "selectionindex? fn3Index"

    If (fn3Index = 1) Then
        fn3$ = "sin"
    Else
        fn3$ = "cos"
    End If

    GoTo [loop]

[PlotRange.click]
    Print #main.PlotRange, "selectionindex? PlotRangeIndex"
    PlotRange = PlotRange(PlotRangeIndex - 1)

    GoTo [loop]

[PlotIncrement.click]
    Print #main.PlotIncrement, "selectionindex? PlotIncrementIndex"
    PlotIncrement = PlotIncrement(PlotIncrementIndex - 1)

    GoTo [loop]

[About.click]

    ForegroundColor$ = "Black"
    BackgroundColor$ = "Lightgray"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"


    NoMainWin
    WindowWidth = 386 : WindowHeight = 380
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)


Statictext  #AboutPolar.statictext2, "Plotting Trig Functions Using Polar Coordinates !", 45, 130, 290, 20
Statictext  #AboutPolar.statictext3, "                                                   ", 40, 110, 300, 20
Statictext  #AboutPolar.statictext4, "                                                   ", 40, 150, 300, 20
Statictext  #AboutPolar.statictext5, "Version 1.0 by TJNally    Released as Open Source", 35, 185, 310, 20
Statictext  #AboutPolar.statictext6, "...Windows Paint by Microsoft.", 55, 285, 180, 20
Statictext  #AboutPolar.statictext7, "...Liberty Basic Workshop by Alyce Watson, and", 55, 265, 290, 20
Statictext  #AboutPolar.statictext8, "...Liberty Basic by Carl Gundel, and", 55, 245, 215, 20
Statictext  #AboutPolar.statictext11, "Made With...", 55, 220, 85, 20
Button      #AboutPolar.Enough, "Enough, already !",[Enough.click],UL, 125, 315, 125, 25
BmpButton   #AboutPolar.bmpbutton1, "psplash.bmp",[dummy2.click],UL, 45, 0

Open "About PolarPhun" For Window As #AboutPolar

    Print #AboutPolar, "trapclose [Enough.click]"
    Print #AboutPolar, "font arial 10"

[About.loop]
    Wait

[Enough.click]

    Close #AboutPolar
    GoTo [loop]

[dummy2.click]

    GoTo [About.loop]


[Huh.click]


    ForegroundColor$ = "Black"
    BackgroundColor$ = "Lightgray"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

    NoMainWin
    WindowWidth = 440 : WindowHeight = 455
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)


Statictext  #Huh.statictext1, "PolarPhun plots the equation shown below. ", 15, 5, 395, 20
Statictext  #Huh.statictext2, "This equation contains three trigonometric functions (fn1, fn2 and fn3) and seven constants (A through G).  For every value of phi ", 15, 65, 395, 35
Statictext  #Huh.statictext3, "(the angle) the equation outputs one value of R (the radius).  One value of phi and it's associated value of R forms a polar coordinate pair.  This pair of values is sufficient to identify a unique point in", 15, 100, 400, 50
Statictext  #Huh.statictext4, "space.  This point can be plotted on a graph by locating the angle phi, then placing a point at a distance R from the polar origin.", 15, 150, 400, 35
Statictext  #Huh.statictext5, "As phi changes, the value of R changes too, and more coordinate pairs are generated.  When adjacent coordinates are connected", 15, 185, 405, 35
Statictext  #Huh.statictext6, "by lines, you get the interesting types of graphs shown on the main screen!", 15, 220, 390, 35
Statictext  #Huh.statictext7, "Each of the three trig functions -- fn1, fn2 and fn3 -- can hold either the sin( ) function or the cos( ) function.  Each of the seven", 15, 265, 390, 35
Statictext  #Huh.statictext8, "constants can hold any real number.  Therefore, the number of possible polar graphs generated by this equation is unlimited!", 15, 300, 390, 35
Statictext  #Huh.statictext9, "Go ahead!  Vary the constants and the functions, and see what kinds of interesting graphs you can make!", 20, 345, 390, 35
Button      #Huh.CloseHuh, "Close",[CloseHuh.click],UL, 250, 390, 75, 25
Button      #Huh.Tips1, "Tips --->",[Tips1.click],UL, 330, 390, 75, 25
BmpButton   #Huh.bmpbutton1, "form1.bmp",[dummy3.click],UL, 15, 30

Open "Huh?  What's PolarPhun?" For Window As #Huh

    Print #Huh, "trapclose [CloseHuh.click]"
    Print #Huh, "font arial 10"

[Huh.loop]
    Wait

[CloseHuh.click]

    Close #Huh

    GoTo [loop]

[Tips1.click]

    Close #Huh

    GoTo [Tips.click]

[dummy3.click]

    GoTo [Huh.loop]



[Tips.click]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Lightgray"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"


    NoMainWin
    WindowWidth = 440 : WindowHeight = 455
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

Statictext  #Tips.statictext10, "                           PolarPhun Tips!                            ", 10, 5, 410, 20
Statictext  #Tips.statictext12, "1.  The constants A through G can hold practically any real number value, including negative numbers.  While you are experimenting early, however, it might be best to keep them within the same order of magnitude.  The effects of changing the magnitude of a constant are easier to observe that way.", 10, 30, 410, 85
Statictext  #Tips.statictext13, "2.  You might plot a polar graph, and observe that the two ends of the curve do not meet.  This often occurs if the constants C, E or G have values less than 1.0.  To correct this, increase the plot range.  You might have to increase it to 10pi, 20pi or larger until the 'loop is closed'.", 10, 125, 410, 85
Statictext  #Tips.statictext14, "3.  One way to have fun with the program is to make relatively small changes in the magnitudes of the constants, and observe the effects.  Another interesting thing to do is to vary the constants and functions until you graph a shape that has some recognizable form, such as amoebas, flowers, butterflies or woven baskets.", 10, 220, 410, 90
Statictext  #Tips.static5, "4.  The 'Randomize' button will select integers between -10 and + 10 for the constants, randomly select the three functions, then plot the results.  If plotting is slow, try re-setting the plot range back to 2pi.", 10, 320, 410, 60
Button      #Tips.TipsClose, "Close",[TipsClose.click],UL, 330, 390, 75, 25

Open "PolarPhun Tips" For Window As #Tips

    Print #Tips, "trapclose [TipsClose.click]"
    Print #Tips, "font arial 10"

[Tips.loop]
    Wait

[TipsClose.click]

    Close #Tips
    GoTo [loop]
