'***********************************************
'
'Polar1.bas by Nally + April 2000
'Released as open source
'
'Polar1.bas plots the function defined
'by R = 2.5 + 2*sin(12*phi) using polar
'coordinates.
'
'To change the function plotted, locate
'the branch label [Plot.click].  The
'function is defined a few lines below
'that branch label.
'
'***********************************************



pi = 3.141592
PlotType$    = "Markers"
MarkerValue$ = "set"
LineValue$   = "reset"
Scalefactor = 1
BiggestXY = 0
xmin = 0
xmax = 0
ymin = 0
ymax = 0

Dim R(360)
Dim x(360)
Dim y(360)
Dim xscaled(360)
Dim yscaled(360)
Dim xplot(360)
Dim yplot(360)


    nomainwin
    WindowWidth = 440
    WindowHeight = 265

    graphicbox #main.PlotArea, 214, 21, 200, 200
    button #main.Plot, "Plot !", [Plot.click], UL, 25, 126, 170, 30
    groupbox #main.groupbox4, "Plot Appearance", 26, 16, 168, 105
    radiobutton #main.radioMarkers, " Plot markers", [markers.Set], [markers.Set], 38, 46, 112, 20
    radiobutton #main.radioLines, " Plot Lines", [Lines.Set], [Lines.Set], 38, 71, 96, 20
    button #main.About, "About...", [About.click], UL, 30, 186, 74, 25
    button #main.Quit, "Quit", [Quit.click], UL, 118, 186, 72, 25
    open "Plotting Polar Coordinates" for window as #main
    print #main.PlotArea, "fill white; flush"
    print #main, "font arial 10"
    print #main, "trapclose [Quit.click]"

    gosub [Print.Initial.Control.Values]

[main.inputLoop]   'wait here for input event
    wait
    goto [main.inputLoop]


[Quit.click]


    close #main: end

[Print.Initial.Control.Values]

    print #main.radioMarkers, "Set"
    print #main.PlotArea, "fill white"

    return




[markers.Set]

    print #main.radioMarkers, "value? MarkerValue$"
    If (MarkerValue$ = "set") then
         PlotType$ = "Markers"
    end if
    If (MarkerValue$ = "reset") then
         PlotType$ = "Lines"
    end if

    goto [main.inputLoop]


[Lines.Set]

    print #main.radioLines, "value? LineValue$"
    If (LineValue$ = "set") then
         PlotType$ = "Lines"
    end if
    If (LineValue$ = "reset") then
         PlotType$ = "Markers"
    end if

    goto [main.inputLoop]


[Plot.click]

    'for all angles between zero and 360 degrees,
    'find the value of R as defined by
    'R = 2.5 + 2*sin(12*phi)
    for degree = 0 to 360
        phi = (degree/360) *(2*pi)
        R(degree) = 2.5 + 2*sin(12*phi)
    next degree

    'Convert polar coordinates to
    'cartesian coordinates
    for degree = 0 to 360
        phi = (degree/360) * (2*pi)
        x(degree) = R(degree) * cos(phi)
        y(degree) = R(degree) * sin(phi)
    next degree

    'Find the extreme values of all cartesian
    'x and y values as a prelude to
    'finding the scalefactor
    xmax = 0
    xmin = 0
    ymax = 0
    ymin = 0

    for degree = 0 to 360
        if (x(degree) > xmax) then xmax = x(degree)
        if (x(degree) < xmin) then xmin = x(degree)
        if (y(degree) > ymax) then ymax = y(degree)
        if (y(degree) < ymin) then ymin = y(degree)
    next degree

    BiggestXY = 0
    If (abs(xmax) > BiggestXY) then BiggestXY = abs(xmax)
    If (abs(xmin) > BiggestXY) then BiggestXY = abs(xmin)
    If (abs(ymax) > BiggestXY) then BiggestXY = abs(ymax)
    If (abs(ymin) > BiggestXY) then BiggestXY = abs(ymin)


    'Establish the scalefactor
    Scalefactor = 90 / BiggestXY

    'Create a scaled set of the cartesian coordinates
    'so that the data will plot nicely in the Graphicbox
    for degree = 0 to 360
        xscaled(degree) = Scalefactor * x(degree)
        yscaled(degree) = Scalefactor * y(degree)
    next degree

    'Shift the data set to the center of the
    'Graphicbox, while also reversing the
    'direction of y.
    for degree = 0 to 360
        xplot(degree) = 100 + xscaled(degree)
        yplot(degree) = 100 - yscaled(degree)
    next degree

    If (PlotType$ = "Lines") then [Skip.To.Lines]

    'If markers have been selected, plot markers
    print #main.PlotArea, "discard"
    print #main.PlotArea, "cls"
    print #main.PlotArea, "fill white"
    print #main.PlotArea, "down"

    for degree = 0 to 360
        print #main.PlotArea, "place " + str$(xplot(degree)) + " " + str$(yplot(degree))
        print #main.PlotArea, "circle 2"
    next degree

    goto [Plotting.Accomplished]

    [Skip.To.Lines]

    'If lines have been selected, plot lines
    print #main.PlotArea, "discard"
    print #main.PlotArea, "cls"
    print #main.PlotArea, "fill white"
    print #main.PlotArea, "down"

    for degree = 1 to 360
        xplot1 = xplot(degree - 1)
        yplot1 = yplot(degree - 1)
        xplot2 = xplot(degree)
        yplot2 = yplot(degree)

        print #main.PlotArea, "line " + str$(xplot1) + " " + str$(yplot1) + " " + _
                              str$(xplot2) + " " + str$(yplot2)
    next degree

    [Plotting.Accomplished]

    print #main.PlotArea, "flush"

    goto [main.inputLoop]



[About.click]

    notice "About Plotting Polar Coordinates" + chr$(13) + _
           "By Nally + April 2000      " + chr$(13) + _
           "Made with Liberty Basic    " + chr$(13) + _
           "Released as open source    "
    goto [main.inputLoop]

