nomainwin

WindowWidth=610
WindowHeight=548
UpperLeftX=(DisplayWidth-WindowWidth)/2
UpperLeftY=(DisplayHeight-WindowHeight)/2
TRUE=1:FALSE=0
fullPath$=""

dim command$(300,3)
struct TextToFind, min as long, max as long, text$ as ptr, min2 as long, max2 as long

gosub [constants]
gosub [load.cmndlist]

KeyWords$="abs( acs( and append as asc( asn( atn( beep bmpbutton bmpsave boolean button call callback calldll callfn case checkbox chr$( close cls colordialog combobox confirm cos( cursor data date$( dechex$( dialog dim dll double dump dword else end eof( exit exp( field filedialog files fontdialog for function get gettrim gosub goto graphicbox graphics groupbox hbmp( hexdec( hwnd( if inp( input input$( inputto$( instr( int( kill left$( len( let line listbox loadbmp lof( log( long lower$( lprint mainwin max( menu mid$( min( mkdir( name next nomainwin none not( notice oncomerror open or out output password playwave popupmenu print printerdialog prompt ptr put radiobutton random read redim rem restore return right$( rmdir( rnd( run scan select short sin( sort space$( sqr( statictext stop str$( struct sub tan( text textbox texteditor then time$( timer titlebar trace trim$( ulong unloadbmp upper$( ushort using( val( void wait wend while window winstring( word word$( xor"

menu #main, "&File", "&New", [new], "&Open", [open], "&Save", [save], "Save &As", [save.as], |,_
            "&Print", [print] ,|,"E&xit", [quit]
menu #main, "&Edit", "&Undo", [undo], "&Redo", [redo], |, "Cu&t", [cut], "&Copy", [copy],_
            "&Paste", [paste], |, "Cl&ear", [clear], "Select &All", [select.all], |, "&Find", [find], _
            "Find A&gain", [find.again]
menu #main, "&Tools", "Goto &Line", [goto.line], "Hili&ght Line", [hilight.line],_
            "Line &Numbers", [line.numbers], "&Indentation Guides", [indent.guides], _
            "&Brace Match", [brace.match], "Insert &Keyword        F5", [insert.keyword],_
            "Syntax &Help            F6", [syntax.help], |, "&Toggle Bookmark", [toggle.bookmark],_
            "&Goto Next Bookmark", [next.bookmark], "Goto &Previous Bookmark", [prev.bookmark]
menu #main, "&Colors", "Active &Line", [set.line.color], "Selection &Foreground", [set.selfore.color], _
            "Selection &Background", [set.selback.color], "&Syntax Help Background", [set.shback.color]
menu #main, "&Help", "&About", [about]
open "Scintilla Demo" for window as #main
#main "trapclose [quit]"
#main "resizehandler [resize]"

hWnd=hwnd(#main)
hInstance=GetWindowLong(hWnd, _GWL_HINSTANCE)
hDLL=LoadLibrary("SciLexerLB.DLL")
if not(hDLL) then notice "Error loading Scintilla Library":goto [quit]
hSci = CreateWindowEx(_WS_EX_CLIENTEDGE, "Scintilla", _
        "TEST", _WS_CHILD Or _WS_VISIBLE, 2, 2, 600, 500, _
        hWnd, hInstance)

r=SendMessage(hSci, SCI.SETSELFORE, 1, RGB(255,255,255))
r=SendMessage(hSci, SCI.SETSELBACK, 1, RGB(0,0,0))
r=SendMessage(hSci, SCI.SETCARETLINEBACK, RGB(255,255,220), 0)
r=SendMessage(hSci, SCI.SETCARETLINEVISIBLE, 1, 0)

r=SendMessage(hSci, SCI.SETLEXER, SCLEX.LB, 0)
r=SendMessage(hSci, SCI.SETSTYLEBITS, 7, 0)
r=SendMessagePtr(hSci, SCI.SETKEYWORDS, 0, KeyWords$)
r=SendMessagePtrPtr(hSci, SCI.SETPROPERTY, "fold", "1")'??

r=SendMessage(hSci, SCI.STYLESETFORE, STYLE.DEFAULT, RGB(0,0,0))
r=SendMessage(hSci, SCI.STYLESETBACK, STYLE.DEFAULT, RGB(255,255,255))
r=SendMessage(hSci, SCI.STYLESETSIZE, STYLE.DEFAULT, 9)
r=SendMessagePtr(hSci, SCI.STYLESETFONT, STYLE.DEFAULT, "FixedSys")
r=SendMessage(hSci, SCI.STYLECLEARALL,0,0)

r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.DEFAULT, RGB(0,0,0))
r=SendMessage(hSci, SCI.STYLESETBACK, SCE.B.DEFAULT, RGB(255,255,255))

r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.KEYWORD, RGB(0,0,255))
r=SendMessage(hSci, SCI.STYLESETCASE, SCE.B.KEYWORD, SC.CASE.UPPER)
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.COMMENT, RGB(100,100,100))
r=SendMessage(hSci, SCI.STYLESETITALIC, SCE.B.COMMENT, TRUE)
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.NUMBER, RGB(255,0,0))
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.STRING, RGB(0,120,0))
r=SendMessagePtr(hSci, SCI.STYLESETFONT, SCE.B.STRING, "Comic Sans MS")
r=SendMessage(hSci, SCI.STYLESETSIZE, SCE.B.STRING, 11)
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.OPERATOR, RGB(150,0,0))
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.IDENTIFIER, RGB(0,00,100))
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.HANDLE, RGB(150,0,150))
r=SendMessage(hSci, SCI.STYLESETFORE, SCE.B.LABEL, RGB(0,0,0))
r=SendMessage(hSci, SCI.STYLESETBACK, SCE.B.LABEL, RGB(200,220,255))

r=SendMessage(hSci, SCI.STYLESETFORE, 34, RGB(0,0,255))'brace good
r=SendMessage(hSci, SCI.STYLESETFORE, 35, RGB(255,0,0))'brace bad
r=SendMessage(hSci, SCI.STYLESETBACK, 37, RGB(0,0,0))'indention guide

r=SendMessage(hSci, SCI.MARKERSETBACK, SC.MARKER.CRICLE, RGB(0,255,255))

r=SendMessage(hSci, SCI.SETTABWIDTH, 4, 0)
r=SendMessage(hSci, SCI.SETUSETABS, FALSE, 0)
r=SendMessage(hSci, SCI.SETBACKSPACEUNINDENTS, TRUE, 0)

r=SendMessage(hSci, SCI.SETMARGINWIDTHN, 0, 48)'number margin
r=SendMessage(hSci, SCI.SETMARGINWIDTHN, 1, 24)'bookmark margin

r=SetFocus(hSci)
r=SendMessage(hSci, SCI.GOTOPOS, 0, 0)
r=SendMessage(hSci, SCI.SETSAVEPOINT, 0, 0)

timer 100, [check.keys]
wait

[check.keys]
    scan
    if GetFocus()=hSci then
        F5=GetAsyncKeyState(_VK_F5)
        F6=GetAsyncKeyState(_VK_F6)
        ENTER=GetAsyncKeyState(_VK_RETURN)
        if F5<0 then [insert.keyword]
        if F6<0 then [syntax.help]
        if ENTER<0 then [auto.indent]
    end if
wait

[quit]
    r=SendMessage(hSci, SCI.GETMODIFY, 0, 0)
    if r then
        confirm "Save "+fullPath$+"?"; c$
        if c$="yes" then [save]
    end if
    close #main
    r=FreeLibrary(hDLL)
end

[resize]
    r=SetWindowPos(hSci, 0, 2, 2, WindowWidth - 2, WindowHeight - 2, 0)
wait

'HELP MENU'
[about]
    notice "About Scintilla for LB"+chr$(13)+_
           "Scintilla Copyright 1998-2002 by Neil Hodgson <neilh@scintilla.org>"+chr$(13)+_
           "Ported to Liberty Basic by Mitchell"
wait

'FILE MENU'
[new]
    r=SendMessage(hSci, SCI.GETMODIFY, 0, 0)
    if r then
        confirm "Save "+fullPath$+"?"; c$
        if c$="yes" then [save]
    end if
    r=SendMessage(hSci, SCI.CLEARALL, 0, 0)
    r=SendMessage(hSci, _EM_EMPTYUNDOBUFFER, 0, 0)
    r=SendMessage(hSci, SCI.SETSAVEPOINT, 0, 0)
    r=SetFocus(hSci)
    r=SetWindowText(hWnd,"Scintilla Demo")
    fullPath$=""
wait

[open]
    r=SendMessage(hSci, SCI.GETMODIFY, 0, 0)
    if r then
        confirm "Save "+fullPath$+"?"; c$
        if c$="yes" then [save]
    end if
    filedialog "Open a file...", "*.bas", file$
    if exists(file$) then
        r=SendMessage(hSci, SCI.CLEARALL, 0, 0)
        open file$ for input as #file
        r=SendMessagePtr(hSci, SCI.ADDTEXT, lof(#file), input$(#file,lof(#file)))
        close #file
        r=SetWindowText(hWnd,"Scintilla Demo - ";file$(file$))
        fullPath$=file$
        r=SendMessage(hSci, _EM_EMPTYUNDOBUFFER, 0, 0)
        r=SendMessage(hSci, SCI.SETSAVEPOINT, 0, 0)
        r=SetFocus(hSci)
        r=SendMessage(hSci, SCI.GOTOPOS, 0, 0)
    else
        if file$<>"" then notice "Error Opening File"
    end if
wait

[save]
    length=SendMessage(hSci, SCI.GETLENGTH, 0, 0)+1
    buffer$=space$(length)+chr$(0)
    r=SendMessagePtr(hSci, SCI.GETTEXT, length, buffer$)
    buffer$=left$(buffer$,length-1)
    if fullPath$="" then
        filedialog "Save file as...", "*.bas", file$
        if exists(file$) then
            confirm "Overwrite?"; c$
            if c$="yes" then
                fullPath$=file$
                r=SetWindowText(hWnd,"Scintilla Demo - ";file$(file$))
            end if
        end if
    end if
    if fullPath$<>"" then
        open fullPath$ for output as #file
        print #file, buffer$
        close #file
        r=SendMessage(hSci, SCI.SETSAVEPOINT, 0, 0)
    end if
wait

[save.as]
    c$="yes"
    filedialog "Save file as...", "*.bas", file$
    if exists(file$) then
        confirm "Overwrite?"; c$
    end if
    if c$="yes" then
        length=SendMessage(hSci, SCI.GETLENGTH, 0, 0)+1
        buffer$=space$(length)+chr$(0)
        r=SendMessagePtr(hSci, SCI.GETTEXT, length, buffer$)
        buffer$=left$(buffer$,length-1)
        if file$<>"" then
            open file$ for output as #file
            print #file, buffer$
            close #file
            r=SetWindowText(hWnd,"Scintilla Demo - ";file$(file$))
            fullPath$=file$
            r=SendMessage(hSci, SCI.SETSAVEPOINT, 0, 0)
        end if
    end if
wait

[print]
    printerdialog
    length=SendMessage(hSci, SCI.GETLENGTH, 0, 0)+1
    buffer$=space$(length)+chr$(0)
    r=SendMessagePtr(hSci, SCI.GETTEXT, length, buffer$)
    buffer$=left$(buffer$,length-1)
    lprint buffer$
    dump
wait

'EDIT MENU'
[undo]
    r=SendMessage(hSci, SCI.CANUNDO, 0, 0)
    if r then
        r=SendMessage(hSci, SCI.UNDO, 0, 0)
    else
        notice "Can't Undo"
    end if
wait

[redo]
    r=SendMessage(hSci, SCI.CANREDO, 0, 0)
    if r then
        r=SendMessage(hSci, SCI.REDO, 0, 0)
    else
        notice "Can't Redo"
    end if
wait

[cut]
    r=SendMessage(hSci, SCI.CUT, 0, 0)
wait

[copy]
    r=SendMessage(hSci, SCI.COPY, 0, 0)
wait

[paste]
    r=SendMessage(hSci, SCI.PASTE, 0, 0)
wait

[clear]
    r=SendMessage(hSci, SCI.CLEAR, 0, 0)
wait

[select.all]
    r=SendMessage(hSci, SCI.SELECTALL, 0, 0)
wait

'TOOLS MENU'

[goto.line]
    prompt "Goto Line:"; linenum
    r=SetFocus(hSci)
    if linenum<>0 then r=SendMessage(hSci, SCI.GOTOLINE, linenum-1, 0)
wait

[find]
    length=SendMessage(hSci, SCI.GETLENGTH, 0, 0)+1
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    TextToFind.min.struct=pos
    TextToFind.max.struct=length
    findFlags=0

    'Form created with the help of Freeform 3
    'Generated on May 14, 2002 at 14:01:06
    '-----Begin main GUI window code
    WindowWidth = 275
    WindowHeight = 160
    UpperLeftX=int((DisplayWidth-WindowWidth)/2)
    UpperLeftY=int((DisplayHeight-WindowHeight)/2)
    '-----Begin GUI objects code
    statictext #find.1, "Find:", 5, 5, 30, 20
    textbox #find.find, 5, 25, 250, 25
    checkbox #find.case, "Match Case", [case], [case], 5, 55, 96, 25
    checkbox #find.word, "Whole Word", [word], [word], 5, 75, 100, 25
    checkbox #find.start, "Word Start", [start], [start], 115, 55, 88, 25
    checkbox #find.regexp, "Regular Expressions", [regexp], [regexp], 115, 75, 150, 25
    button #find.default, "Find", [find.go], UL, 15, 100, 75, 25
    button #find.can, "&Cancel", [find.can], UL, 135, 100, 75, 25
    '-----End GUI objects code
    open "Find/Replace" for dialog_modal as #find
    print #find, "font ms_sans_serif 0 16"
    print #find, "trapclose [find.can]"
wait

[case]
    findFlags=findFlags XOR SCFIND.MATCHCASE
wait

[word]
    findFlags=findFlags XOR SCFIND.WHOLEWORD
wait

[start]
    findFlags=findFlags XOR SCFIND.WORDSTART
wait

[regexp]
    findFlags=findFlags XOR SCFIND.REGEXP
wait

[find.can]
    close #find
wait

[find.go]
    #find.find "!contents? find$"
    TextToFind.text$.struct=find$
    in=SendMessageFind(hSci, SCI.FINDTEXT, findFlags)
    if in<>-1 then
        r=SendMessage(hSci, SCI.SETSEL, in, in+len(find$))
    else
        notice "Not Found!"
    end if
    close #find
    r=SetFocus(hSci)
wait

[find.again]
    length=SendMessage(hSci, SCI.GETLENGTH, 0, 0)+1
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    TextToFind.min.struct=pos
    TextToFind.max.struct=length
    TextToFind.text$.struct=find$
    in=SendMessageFind(hSci, SCI.FINDTEXT, findFlags)
    if in<>-1 then
        r=SendMessage(hSci, SCI.SETSEL, in, in+len(find$))
    else
        notice "Not Found!"
    end if
    r=SetFocus(hSci)
wait


[hilight.line]
    r=SendMessage(hSci, SCI.GETCARETLINEVISIBLE, 0, 0)
    r=SendMessage(hSci, SCI.SETCARETLINEVISIBLE, not(r), 0)
wait

[line.numbers]
    ln=SendMessage(hSci, SCI.GETMARGINTYPEN, 0, 0)
    if ln then r=SendMessage(hSci, SCI.SETMARGINWIDTHN, 0, 12)
    if not(ln) then r=SendMessage(hSci, SCI.SETMARGINWIDTHN, 0, 36)
    r=SendMessage(hSci, SCI.SETMARGINTYPEN, 0, not(ln))
wait

[indent.guides]
    r=SendMessage(hSci, SCI.GETINDENTATIONGUIDES, TRUE, 0)
    r=SendMessage(hSci, SCI.SETINDENTATIONGUIDES, not(r), 0)
wait

[brace.match]
    pos1=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    char=SendMessage(hSci, SCI.GETCHARAT, pos1, 0)
    if instr("(){}[]<>",chr$(char)) then
        pos2=SendMessage(hSci, SCI.BRACEMATCH, pos1, 0)
        if pos2=-1 then
            r=SendMessage(hSci, SCI.BRACEBADLIGHT, pos1, 0)
        else
            r=SendMessage(hSci, SCI.BRACEHIGHLIGHT, pos1, pos2)
        end if
    end if
wait

[insert.keyword]
    r=SendMessage(hSci, SCI.AUTOCSETIGNORECASE, TRUE, 0)
    pos1=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    pos2=SendMessage(hSci, SCI.WORDSTARTPOSITION, pos1, TRUE)
    r=SendMessagePtr(hSci, SCI.AUTOCSHOW, pos1-pos2, KeyWords$)
wait

[toggle.bookmark]
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    lin=SendMessage(hSci, SCI.LINEFROMPOSITION, pos, 0)
    r=SendMessage(hSci, SCI.MARKERGET, lin, 0)
    if not(r) then
        r=SendMessage(hSci, SCI.MARKERADD, lin, SC.MARK.CIRCLE)
    else
        r=SendMessage(hSci, SCI.MARKERDELETE, lin, SC.MARK.CIRCLE)
    end if
wait

[next.bookmark]
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    lin=SendMessage(hSci, SCI.LINEFROMPOSITION, pos, 0)
    lin=SendMessage(hSci, SCI.MARKERNEXT, lin, 2^SC.MARKER.CIRCLE)
    if lin<>-1 then r=SendMessage(hSci, SCI.GOTOLINE, lin, 0)
wait

[prev.bookmark]
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    lin=SendMessage(hSci, SCI.LINEFROMPOSITION, pos, 0)
    lin=SendMessage(hSci, SCI.MARKERPREVIOUS, lin, 2^SC.MARKER.CIRCLE)
    if lin<>-1 then r=SendMessage(hSci, SCI.GOTOLINE, lin, 0)
wait

[syntax.help]
    r=SendMessage(hSci, SCI.CALLTIPCANCEL, 0, 0)
    buffer$=space$(80)+chr$(0)
    r=SendMessagePtr(hSci, SCI.GETSELTEXT, 0, buffer$)
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    if r=0 then
        lin=SendMessage(hSci, SCI.LINEFROMPOSITION, pos, 0)
        r=SendMessagePtr(hSci, SCI.GETLINE, lin, buffer$)
        buffer$=word$(buffer$,1)
    end if
    buffer$=upper$(trim$(buffer$))
    for i = 1 to command.count
        if command$(i,1)=buffer$ then
            buffer$=command$(i,2)+CHR$(10)+command$(i,3)
            r=SendMessagePtr(hSci, SCI.CALLTIPSHOW, pos, buffer$)
            r=SendMessage(hSci, SCI.CALLTIPSETHLT, 0, len(buffer$))
            exit for
        end if
    next i
    if i = command.count+1 then
        buffer$="Sorry, No Help For That Word"
        r=SendMessagePtr(hSci, SCI.CALLTIPSHOW, pos, buffer$)
        r=SendMessage(hSci, SCI.CALLTIPSETHLT, 0, len(buffer$))
    end if
wait

[auto.indent]
    buffer$=space$(80)+chr$(0)
    pos=SendMessage(hSci, SCI.GETCURRENTPOS, 0, 0)
    lin=SendMessage(hSci, SCI.LINEFROMPOSITION, pos, 0)
    i=SendMessage(hSci, SCI.GETLINEINDENTATION, lin-1, 0)
    r=SendMessagePtr(hSci, SCI.ADDTEXT, i, space$(i))
wait

'COLORS MENU'
[set.line.color]
    colordialog "yellow", color$
    if color$<>"" then r=SendMessage(hSci, SCI.SETCARETLINEBACK, RGB(val(word$(color$,1)),val(word$(color$,2)),val(word$(color$,3))), 0)
wait

[set.selfore.color]
    colordialog "white", color$
    if color$<>"" then r=SendMessage(hSci, SCI.SETSELFORE, 1, RGB(val(word$(color$,1)),val(word$(color$,2)),val(word$(color$,3))))
wait


[set.selback.color]
    colordialog "black", color$
    if color$<>"" then r=SendMessage(hSci, SCI.SETSELBACK, 1, RGB(val(word$(color$,1)),val(word$(color$,2)),val(word$(color$,3))))
wait

[set.shback.color]
    colordialog "white", color$
    if color$<>"" then r=SendMessage(hSci, SCI.CALLTIPSETBACK, RGB(val(word$(color$,1)),val(word$(color$,2)),val(word$(color$,3))), 0)
wait




'FUNCTIONS'
function exists(fileName$)
    file$=file$(fileName$)
    path$=path$(fileName$)
    dim info$(10,10)
    files path$, file$, info$(
    if val(info$(0, 0)) > 0 then exists=1 else exists=0
end function

function file$(path$)
    while instr(path$,"\")
        path$=right$(path$,len(path$)-1)
    wend
    file$=path$
end function

function path$(file$)
    fileindex=len(file$)  'separate path and filename
    filelength=len(file$)
    while mid$(file$, fileindex,1)<>"\"
        fileindex=fileindex-1
        if fileindex<0 then exit while
    wend
    path$=left$(file$,fileindex)
end function

Function RGB(r,g,b)
    RGB = r + g*256 + b*256*256
End Function

'WRAPPED API''''''''''''''''''''''''''''''''''''''''''''''''''''''
Function GetWindowLong(hW, type)
    CallDLL #user32, "GetWindowLongA", _
    hW As long, type As long,_
    re As long
    GetWindowLong=re
End Function

Function LoadLibrary(file$)
    CallDLL #kernel32, "LoadLibraryA",_
    file$ As ptr, re As long
    LoadLibrary=re
End Function

Function FreeLibrary(hDLL)
    CallDLL #kernel32, "FreeLibrary",_
    hDLL As long, re As long
    FreeLibrary=re
End Function


Function CreateWindowEx(exStyle, class$, text$, style, x, y, w, h, hW, hInst)
    CallDLL #user32, "CreateWindowExA",exStyle As long, class$ As ptr,_
        text$ As ptr, style As long,_
        x As long,y As long,w As long,h As long,_
        hW As long, 0 As long, hInst As long, 0 As long,_
        hT As long
    CreateWindowEx=hT
End Function

function SendMessage(hWnd,msg,w,l)
    CallDLL #user32, "SendMessageA", hWnd As long, _
    msg As long, w As long, l As long, re As long
    SendMessage=re
End function

Function SendMessagePtr(hWnd,msg,w,p$)
    CallDLL #user32, "SendMessageA", hWnd As long, _
    msg As long, w As long, p$ As ptr, re As long
    SendMessagePtr=re
End function

Function SendMessagePtrPtr(hWnd,msg,w$,p$)
    CallDLL #user32, "SendMessageA", hWnd As long, _
    msg As long, w$ As ptr, p$ As ptr, re As long
    SendMessagePtrPtr=re
End function

function SendMessageFind(hWnd,msg,w)
    calldll #user32, "SendMessageA", hWnd as long,_
    msg as long, w as long, TextToFind as struct,_
    re as long
    SendMessageFind=re
End function

Function SetWindowPos(hWnd, toTop,x,y,w,h,flags)
    CallDLL #user32, "SetWindowPos", hWnd As long, toTop As long, _
    x As long, y As long, w As long, h As long, flags As long, result As void
End function

Function SetWindowText(hWnd, text$)
    CallDLL #user32, "SetWindowTextA", hWnd As long, text$ As ptr, _
    result As long
End function

Function SetFocus(hWnd)
    CallDLL #user32, "SetFocus", hWnd As long,_
    result As long
End function

Function GetFocus()
    CallDLL #user32, "GetFocus",_
    GetFocus As long
End function

function GetAsyncKeyState(vk)
    calldll #user32, "GetAsyncKeyState", vk as long, GetAsyncKeyState as long
end function

'LOAD FILES'
[load.cmndlist]
    open "cmndlist.dat" for input as #list
    while not(eof(#list))
        command.count = command.count + 1
        line input #list, command$(command.count,1)
        line input #list, command$(command.count,2)
        line input #list, command$(command.count,3)
        line input #list, dummy$ ' Place holder
    wend
    close #list
return

'CONSTANTS'''''''''''''''''''''''''''''''''''''''''''''''''''
[constants]
SCI.START = 2000
SCI.OPTIONAL.START = 3000
SCI.LEXER.START = 4000
SCI.ADDTEXT = 2001
SCI.ADDSTYLEDTEXT = 2002
SCI.INSERTTEXT = 2003
SCI.CLEARALL = 2004
SCI.CLEARDOCUMENTSTYLE = 2005
SCI.GETLENGTH = 2006
SCI.GETCHARAT = 2007
SCI.GETCURRENTPOS = 2008
SCI.GETANCHOR = 2009
SCI.GETSTYLEAT = 2010
SCI.REDO = 2011
SCI.SETUNDOCOLLECTION = 2012
SCI.SELECTALL = 2013
SCI.SETSAVEPOINT = 2014
SCI.GETSTYLEDTEXT = 2015
SCI.CANREDO = 2016
SCI.MARKERLINEFROMHANDLE = 2017
SCI.MARKERDELETEHANDLE = 2018
SCI.GETUNDOCOLLECTION = 2019
SCWS.INVISIBLE = 0
SCWS.VISIBLEALWAYS = 1
SCWS.VISIBLEAFTERINDENT = 2
SCI.GETVIEWWS = 2020
SCI.SETVIEWWS = 2021
SCI.POSITIONFROMPOINT = 2022
SCI.POSITIONFROMPOINTCLOSE = 2023
SCI.GOTOLINE = 2024
SCI.GOTOPOS = 2025
SCI.SETANCHOR = 2026
SCI.GETCURLINE = 2027
SCI.GETENDSTYLED = 2028
SC.EOL.CRLF = 0
SC.EOL.CR = 1
SC.EOL.LF = 2
SCI.CONVERTEOLS = 2029
SCI.GETEOLMODE = 2030
SCI.SETEOLMODE = 2031
SCI.STARTSTYLING = 2032
SCI.SETSTYLING = 2033
SCI.GETBUFFEREDDRAW = 2034
SCI.SETBUFFEREDDRAW = 2035
SCI.SETTABWIDTH = 2036
SCI.GETTABWIDTH = 2121
SC.CP.UTF8 = 65001
SCI.SETCODEPAGE = 2037
SCI.SETUSEPALETTE = 2039
SC.MARK.CIRCLE = 0
SC.MARK.ROUNDRECT = 1
SC.MARK.ARROW = 2
SC.MARK.SMALLRECT = 3
SC.MARK.SHORTARROW = 4
SC.MARK.EMPTY = 5
SC.MARK.ARROWDOWN = 6
SC.MARK.MINUS = 7
SC.MARK.PLUS = 8
SC.MARK.VLINE = 9
SC.MARK.LCORNER = 10
SC.MARK.TCORNER = 11
SC.MARK.BOXPLUS = 12
SC.MARK.BOXPLUSCONNECTED = 13
SC.MARK.BOXMINUS = 14
SC.MARK.BOXMINUSCONNECTED = 15
SC.MARK.LCORNERCURVE = 16
SC.MARK.TCORNERCURVE = 17
SC.MARK.CIRCLEPLUS = 18
SC.MARK.CIRCLEPLUSCONNECTED = 19
SC.MARK.CIRCLEMINUS = 20
SC.MARK.CIRCLEMINUSCONNECTED = 21
SC.MARK.BACKGROUND = 22
SC.MARK.CHARACTER = 10000
SC.MARKNUM.FOLDEREND = 25
SC.MARKNUM.FOLDEROPENMID = 26
SC.MARKNUM.FOLDERMIDTAIL = 27
SC.MARKNUM.FOLDERTAIL = 28
SC.MARKNUM.FOLDERSUB = 29
SC.MARKNUM.FOLDER = 30
SC.MARKNUM.FOLDEROPEN = 31
SC.MASK.FOLDERS = hexdec("FE000000")
SCI.MARKERDEFINE = 2040
SCI.MARKERSETFORE = 2041
SCI.MARKERSETBACK = 2042
SCI.MARKERADD = 2043
SCI.MARKERDELETE = 2044
SCI.MARKERDELETEALL = 2045
SCI.MARKERGET = 2046
SCI.MARKERNEXT = 2047
SCI.MARKERPREVIOUS = 2048
SC.MARGIN.SYMBOL = 0
SC.MARGIN.NUMBER = 1
SCI.SETMARGINTYPEN = 2240
SCI.GETMARGINTYPEN = 2241
SCI.SETMARGINWIDTHN = 2242
SCI.GETMARGINWIDTHN = 2243
SCI.SETMARGINMASKN = 2244
SCI.GETMARGINMASKN = 2245
SCI.SETMARGINSENSITIVEN = 2246
SCI.GETMARGINSENSITIVEN = 2247
SC.CHARSET.ANSI = 0
SC.CHARSET.DEFAULT = 1
SC.CHARSET.BALTIC = 186
SC.CHARSET.CHINESEBIG5 = 136
SC.CHARSET.EASTEUROPE = 238
SC.CHARSET.GB2312 = 134
SC.CHARSET.GREEK = 161
SC.CHARSET.HANGUL = 129
SC.CHARSET.MAC = 77
SC.CHARSET.OEM = 255
SC.CHARSET.RUSSIAN = 204
SC.CHARSET.SHIFTJIS = 128
SC.CHARSET.SYMBOL = 2
SC.CHARSET.TURKISH = 162
SC.CHARSET.JOHAB = 130
SC.CHARSET.HEBREW = 177
SC.CHARSET.ARABIC = 178
SC.CHARSET.VIETNAMESE = 163
SC.CHARSET.THAI = 222
SCI.STYLECLEARALL = 2050
SCI.STYLESETFORE = 2051
SCI.STYLESETBACK = 2052
SCI.STYLESETBOLD = 2053
SCI.STYLESETITALIC = 2054
SCI.STYLESETSIZE = 2055
SCI.STYLESETFONT = 2056
SCI.STYLESETEOLFILLED = 2057
SCI.STYLERESETDEFAULT = 2058
SCI.STYLESETUNDERLINE = 2059
SC.CASE.MIXED = 0
SC.CASE.UPPER = 1
SC.CASE.LOWER = 2
SCI.STYLESETCASE = 2060
SCI.STYLESETCHARACTERSET = 2066
SCI.SETSELFORE = 2067
SCI.SETSELBACK = 2068
SCI.SETCARETFORE = 2069
SCI.ASSIGNCMDKEY = 2070
SCI.CLEARCMDKEY = 2071
SCI.CLEARALLCMDKEYS = 2072
SCI.SETSTYLINGEX = 2073
SCI.STYLESETVISIBLE = 2074
SCI.GETCARETPERIOD = 2075
SCI.SETCARETPERIOD = 2076
SCI.SETWORDCHARS = 2077
SCI.BEGINUNDOACTION = 2078
SCI.ENDUNDOACTION = 2079
SCI.INDICSETSTYLE = 2080
SCI.INDICGETSTYLE = 2081
SCI.INDICSETFORE = 2082
SCI.INDICGETFORE = 2083
SCI.SETSTYLEBITS = 2090
SCI.GETSTYLEBITS = 2091
SCI.SETLINESTATE = 2092
SCI.GETLINESTATE = 2093
SCI.GETMAXLINESTATE = 2094
SCI.GETCARETLINEVISIBLE = 2095
SCI.SETCARETLINEVISIBLE = 2096
SCI.GETCARETLINEBACK = 2097
SCI.SETCARETLINEBACK = 2098
SCI.STYLESETCHANGEABLE = 2099
SCI.AUTOCSHOW = 2100
SCI.AUTOCCANCEL = 2101
SCI.AUTOCACTIVE = 2102
SCI.AUTOCPOSSTART = 2103
SCI.AUTOCCOMPLETE = 2104
SCI.AUTOCSTOPS = 2105
SCI.AUTOCSETSEPARATOR = 2106
SCI.AUTOCGETSEPARATOR = 2107
SCI.AUTOCSELECT = 2108
SCI.AUTOCSETCANCELATSTART = 2110
SCI.AUTOCGETCANCELATSTART = 2111
SCI.AUTOCSETFILLUPS = 2112
SCI.AUTOCSETCHOOSESINGLE = 2113
SCI.AUTOCGETCHOOSESINGLE = 2114
SCI.AUTOCSETIGNORECASE = 2115
SCI.AUTOCGETIGNORECASE = 2116
SCI.USERLISTSHOW = 2117
SCI.AUTOCSETAUTOHIDE = 2118
SCI.AUTOCGETAUTOHIDE = 2119
SCI.AUTOCSETDROPRESTOFWORD = 2270
SCI.AUTOCGETDROPRESTOFWORD = 2271
SCI.SETINDENT = 2122
SCI.GETINDENT = 2123
SCI.SETUSETABS = 2124
SCI.GETUSETABS = 2125
SCI.SETLINEINDENTATION = 2126
SCI.GETLINEINDENTATION = 2127
SCI.GETLINEINDENTPOSITION = 2128
SCI.GETCOLUMN = 2129
SCI.SETHSCROLLBAR = 2130
SCI.GETHSCROLLBAR = 2131
SCI.SETINDENTATIONGUIDES = 2132
SCI.GETINDENTATIONGUIDES = 2133
SCI.SETHIGHLIGHTGUIDE = 2134
SCI.GETHIGHLIGHTGUIDE = 2135
SCI.GETLINEENDPOSITION = 2136
SCI.GETCODEPAGE = 2137
SCI.GETCARETFORE = 2138
SCI.GETUSEPALETTE = 2139
SCI.GETREADONLY = 2140
SCI.SETCURRENTPOS = 2141
SCI.SETSELECTIONSTART = 2142
SCI.GETSELECTIONSTART = 2143
SCI.SETSELECTIONEND = 2144
SCI.GETSELECTIONEND = 2145
SCI.SETPRINTMAGNIFICATION = 2146
SCI.GETPRINTMAGNIFICATION = 2147
SC.PRINT.NORMAL = 0
SC.PRINT.INVERTLIGHT = 1
SC.PRINT.BLACKONWHITE = 2
SC.PRINT.COLOURONWHITE = 3
SC.PRINT.COLOURONWHITEDEFAULTBG = 4
SCI.SETPRINTCOLOURMODE = 2148
SCI.GETPRINTCOLOURMODE = 2149
SCFIND.WHOLEWORD = 2
SCFIND.MATCHCASE = 4
SCFIND.WORDSTART = hexdec("00100000")
SCFIND.REGEXP = hexdec("00200000")
SCI.FINDTEXT = 2150
SCI.FORMATRANGE = 2151
SCI.GETFIRSTVISIBLELINE = 2152
SCI.GETLINE = 2153
SCI.GETLINECOUNT = 2154
SCI.SETMARGINLEFT = 2155
SCI.GETMARGINLEFT = 2156
SCI.SETMARGINRIGHT = 2157
SCI.GETMARGINRIGHT = 2158
SCI.GETMODIFY = 2159
SCI.SETSEL = 2160
SCI.GETSELTEXT = 2161
SCI.GETTEXTRANGE = 2162
SCI.HIDESELECTION = 2163
SCI.POINTXFROMPOSITION = 2164
SCI.POINTYFROMPOSITION = 2165
SCI.LINEFROMPOSITION = 2166
SCI.POSITIONFROMLINE = 2167
SCI.LINESCROLL = 2168
SCI.SCROLLCARET = 2169
SCI.REPLACESEL = 2170
SCI.SETREADONLY = 2171
SCI.NULL = 2172
SCI.CANPASTE = 2173
SCI.CANUNDO = 2174
SCI.EMPTYUNDOBUFFER = 2175
SCI.UNDO = 2176
SCI.CUT = 2177
SCI.COPY = 2178
SCI.PASTE = 2179
SCI.CLEAR = 2180
SCI.SETTEXT = 2181
SCI.GETTEXT = 2182
SCI.GETTEXTLENGTH = 2183
SCI.GETDIRECTFUNCTION = 2184
SCI.GETDIRECTPOINTER = 2185
SCI.SETOVERTYPE = 2186
SCI.GETOVERTYPE = 2187
SCI.SETCARETWIDTH = 2188
SCI.GETCARETWIDTH = 2189
SCI.SETTARGETSTART = 2190
SCI.GETTARGETSTART = 2191
SCI.SETTARGETEND = 2192
SCI.GETTARGETEND = 2193
SCI.REPLACETARGET = 2194
SCI.REPLACETARGETRE = 2195
SCI.SEARCHINTARGET = 2197
SCI.SETSEARCHFLAGS = 2198
SCI.GETSEARCHFLAGS = 2199
SCI.CALLTIPSHOW = 2200
SCI.CALLTIPCANCEL = 2201
SCI.CALLTIPACTIVE = 2202
SCI.CALLTIPPOSSTART = 2203
SCI.CALLTIPSETHLT = 2204
SCI.CALLTIPSETBACK = 2205
SCI.VISIBLEFROMDOCLINE = 2220
SCI.DOCLINEFROMVISIBLE = 2221
SC.FOLDLEVELBASE = hexdec("400")
SC.FOLDLEVELWHITEFLAG = hexdec("1000")
SC.FOLDLEVELHEADERFLAG = hexdec("2000")
SC.FOLDLEVELNUMBERMASK = hexdec("0FFF")
SCI.SETFOLDLEVEL = 2222
SCI.GETFOLDLEVEL = 2223
SCI.GETLASTCHILD = 2224
SCI.GETFOLDPARENT = 2225
SCI.SHOWLINES = 2226
SCI.HIDELINES = 2227
SCI.GETLINEVISIBLE = 2228
SCI.SETFOLDEXPANDED = 2229
SCI.GETFOLDEXPANDED = 2230
SCI.TOGGLEFOLD = 2231
SCI.ENSUREVISIBLE = 2232
SCI.SETFOLDFLAGS = 2233
SCI.ENSUREVISIBLEENFORCEPOLICY = 2234
SCI.SETTABINDENTS = 2260
SCI.GETTABINDENTS = 2261
SCI.SETBACKSPACEUNINDENTS = 2262
SCI.GETBACKSPACEUNINDENTS = 2263
SC.TIME.FOREVER = 10000000
SCI.SETMOUSEDWELLTIME = 2264
SCI.GETMOUSEDWELLTIME = 2265
SCI.WORDSTARTPOSITION = 2266
SCI.WORDENDPOSITION = 2267
SC.WRAP.NONE = 0
SC.WRAP.WORD = 1
SCI.SETWRAPMODE = 2268
SCI.GETWRAPMODE = 2269
SC.CACHE.NONE = 0
SC.CACHE.CARET = 1
SC.CACHE.PAGE = 2
SC.CACHE.DOCUMENT = 3
SCI.SETLAYOUTCACHE = 2272
SCI.GETLAYOUTCACHE = 2273
SCI.LINEDOWN = 2300
SCI.LINEDOWNEXTEND = 2301
SCI.LINEUP = 2302
SCI.LINEUPEXTEND = 2303
SCI.CHARLEFT = 2304
SCI.CHARLEFTEXTEND = 2305
SCI.CHARRIGHT = 2306
SCI.CHARRIGHTEXTEND = 2307
SCI.WORDLEFT = 2308
SCI.WORDLEFTEXTEND = 2309
SCI.WORDRIGHT = 2310
SCI.WORDRIGHTEXTEND = 2311
SCI.HOME = 2312
SCI.HOMEEXTEND = 2313
SCI.LINEEND = 2314
SCI.LINEENDEXTEND = 2315
SCI.DOCUMENTSTART = 2316
SCI.DOCUMENTSTARTEXTEND = 2317
SCI.DOCUMENTEND = 2318
SCI.DOCUMENTENDEXTEND = 2319
SCI.PAGEUP = 2320
SCI.PAGEUPEXTEND = 2321
SCI.PAGEDOWN = 2322
SCI.PAGEDOWNEXTEND = 2323
SCI.EDITTOGGLEOVERTYPE = 2324
SCI.CANCEL = 2325
SCI.DELETEBACK = 2326
SCI.TAB = 2327
SCI.BACKTAB = 2328
SCI.NEWLINE = 2329
SCI.FORMFEED = 2330
SCI.VCHOME = 2331
SCI.VCHOMEEXTEND = 2332
SCI.ZOOMIN = 2333
SCI.ZOOMOUT = 2334
SCI.DELWORDLEFT = 2335
SCI.DELWORDRIGHT = 2336
SCI.LINECUT = 2337
SCI.LINEDELETE = 2338
SCI.LINETRANSPOSE = 2339
SCI.LOWERCASE = 2340
SCI.UPPERCASE = 2341
SCI.LINESCROLLDOWN = 2342
SCI.LINESCROLLUP = 2343
SCI.DELETEBACKNOTLINE = 2344
SCI.MOVECARETINSIDEVIEW = 2401
SCI.LINELENGTH = 2350
SCI.BRACEHIGHLIGHT = 2351
SCI.BRACEBADLIGHT = 2352
SCI.BRACEMATCH = 2353
SCI.GETVIEWEOL = 2355
SCI.SETVIEWEOL = 2356
SCI.GETDOCPOINTER = 2357
SCI.SETDOCPOINTER = 2358
SCI.SETMODEVENTMASK = 2359
SCI.GETEDGECOLUMN = 2360
SCI.SETEDGECOLUMN = 2361
SCI.GETEDGEMODE = 2362
SCI.SETEDGEMODE = 2363
SCI.GETEDGECOLOUR = 2364
SCI.SETEDGECOLOUR = 2365
SCI.SEARCHANCHOR = 2366
SCI.SEARCHNEXT = 2367
SCI.SEARCHPREV = 2368
SCI.SETCARETPOLICY = 2369
SCI.LINESONSCREEN = 2370
SCI.USEPOPUP = 2371
SCI.SELECTIONISRECTANGLE = 2372
SCI.SETZOOM = 2373
SCI.GETZOOM = 2374
SCI.CREATEDOCUMENT = 2375
SCI.ADDREFDOCUMENT = 2376
SCI.RELEASEDOCUMENT = 2377
SCI.GETMODEVENTMASK = 2378
SCI.SETFOCUS = 2380
SCI.GETFOCUS = 2381
SCI.SETSTATUS = 2382
SCI.GETSTATUS = 2383
SCI.SETMOUSEDOWNCAPTURES = 2384
SCI.GETMOUSEDOWNCAPTURES = 2385
SC.CURSORNORMAL = -1
SC.CURSORWAIT = 3
SCI.SETCURSOR = 2386
SCI.GETCURSOR = 2387
SCI.SETCONTROLCHARSYMBOL = 2388
SCI.GETCONTROLCHARSYMBOL = 2389
SCI.WORDPARTLEFT = 2390
SCI.WORDPARTLEFTEXTEND = 2391
SCI.WORDPARTRIGHT = 2392
SCI.WORDPARTRIGHTEXTEND = 2393
SCI.SETVISIBLEPOLICY = 2394
SCI.DELLINELEFT = 2395
SCI.DELLINERIGHT = 2396
SCI.SETXOFFSET = 2397
SCI.GETXOFFSET = 2398
SCI.GRABFOCUS = 2400
SCI.STARTRECORD = 3001
SCI.STOPRECORD = 3002
SCI.SETLEXER = 4001
SCI.GETLEXER = 4002
SCI.COLOURISE = 4003
SCI.SETPROPERTY = 4004
SCI.SETKEYWORDS = 4005
SCI.SETLEXERLANGUAGE = 4006
SC.MOD.INSERTTEXT = hexdec("1")
SC.MOD.DELETETEXT = hexdec("2")
SC.MOD.CHANGESTYLE = hexdec("4")
SC.MOD.CHANGEFOLD = hexdec("8")
SC.PERFORMED.USER = hexdec("10")
SC.PERFORMED.UNDO = hexdec("20")
SC.PERFORMED.REDO = hexdec("40")
SC.LASTSTEPINUNDOREDO = hexdec("100")
SC.MOD.CHANGEMARKER = hexdec("200")
SC.MOD.BEFOREINSERT = hexdec("400")
SC.MOD.BEFOREDELETE = hexdec("800")
SC.MODEVENTMASKALL = hexdec("F77")
SCEN.CHANGE = 768
SCEN.SETFOCUS = 512
SCEN.KILLFOCUS = 256
SCK.DOWN = 300
SCK.UP = 301
SCK.LEFT = 302
SCK.RIGHT = 303
SCK.HOME = 304
SCK.END = 305
SCK.PRIOR = 306
SCK.NEXT = 307
SCK.DELETE = 308
SCK.INSERT = 309
SCK.ESCAPE = 7
SCK.BACK = 8
SCK.TAB = 9
SCK.RETURN = 13
SCK.ADD = 310
SCK.SUBTRACT = 311
SCK.DIVIDE = 312
SCMOD.SHIFT = 1
SCMOD.CTRL = 2
SCMOD.ALT = 4
SCN.STYLENEEDED = 2000
SCN.CHARADDED = 2001
SCN.SAVEPOINTREACHED = 2002
SCN.SAVEPOINTLEFT = 2003
SCN.MODIFYATTEMPTRO = 2004
SCN.KEY = 2005
SCN.DOUBLECLICK = 2006
SCN.UPDATEUI = 2007
SCN.MODIFIED = 2008
SCN.MACRORECORD = 2009
SCN.MARGINCLICK = 2010
SCN.NEEDSHOWN = 2011
SCN.PAINTED = 2013
SCN.USERLISTSELECTION = 2014
SCN.URIDROPPED = 2015
SCN.DWELLSTART = 2016
SCN.DWELLEND = 2017
SCN.POSCHANGED = 2012
SCN.CHECKBRACE = 2007
SCLEX.CONTAINER = 0
SCLEX.NULL = 1
SCLEX.PYTHON = 2
SCLEX.CPP = 3
SCLEX.HTML = 4
SCLEX.XML = 5
SCLEX.PERL = 6
SCLEX.SQL = 7
SCLEX.VB = 8
SCLEX.PROPERTIES = 9
SCLEX.ERRORLIST = 10
SCLEX.MAKEFILE = 11
SCLEX.BATCH = 12
SCLEX.XCODE = 13
SCLEX.LATEX = 14
SCLEX.LUA = 15
SCLEX.DIFF = 16
SCLEX.CONF = 17
SCLEX.PASCAL = 18
SCLEX.AVE = 19
SCLEX.ADA = 20
SCLEX.LISP = 21
SCLEX.RUBY = 22
SCLEX.EIFFEL = 23
SCLEX.EIFFELKW = 24
SCLEX.TCL = 25
SCLEX.NNCRONTAB = 26
SCLEX.BULLANT = 27
SCLEX.VBSCRIPT = 28
SCLEX.ASP = 29
SCLEX.PHP = 30
SCLEX.BAAN = 31
SCLEX.MATLAB = 32
SCLEX.AUTOMATIC = 1000
SCE.P.DEFAULT = 0
SCE.P.COMMENTLINE = 1
SCE.P.NUMBER = 2
SCE.P.STRING = 3
SCE.P.CHARACTER = 4
SCE.P.WORD = 5
SCE.P.TRIPLE = 6
SCE.P.TRIPLEDOUBLE = 7
SCE.P.CLASSNAME = 8
SCE.P.DEFNAME = 9
SCE.P.OPERATOR = 10
SCE.P.IDENTIFIER = 11
SCE.P.COMMENTBLOCK = 12
SCE.P.STRINGEOL = 13
SCE.C.DEFAULT = 0
SCE.C.COMMENT = 1
SCE.C.COMMENTLINE = 2
SCE.C.COMMENTDOC = 3
SCE.C.NUMBER = 4
SCE.C.WORD = 5
SCE.C.STRING = 6
SCE.C.CHARACTER = 7
SCE.C.UUID = 8
SCE.C.PREPROCESSOR = 9
SCE.C.OPERATOR = 10
SCE.C.IDENTIFIER = 11
SCE.C.STRINGEOL = 12
SCE.C.VERBATIM = 13
SCE.C.REGEX = 14
SCE.C.COMMENTLINEDOC = 15
SCE.C.WORD2 = 16
SCE.C.COMMENTDOCKEYWORD = 17
SCE.C.COMMENTDOCKEYWORDERROR = 18
SCE.B.DEFAULT = 0
SCE.B.COMMENT = 1
SCE.B.NUMBER = 2
SCE.B.KEYWORD = 3
SCE.B.STRING = 4
SCE.B.PREPROCESSOR = 5
SCE.B.OPERATOR = 6
SCE.B.IDENTIFIER = 7
SCE.B.DATE = 8
SCE.H.DEFAULT = 0
SCE.H.TAG = 1
SCE.H.TAGUNKNOWN = 2
SCE.H.ATTRIBUTE = 3
SCE.H.ATTRIBUTEUNKNOWN = 4
SCE.H.NUMBER = 5
SCE.H.DOUBLESTRING = 6
SCE.H.SINGLESTRING = 7
SCE.H.OTHER = 8
SCE.H.COMMENT = 9
SCE.H.ENTITY = 10
SCE.H.TAGEND = 11
SCE.H.XMLSTART = 12
SCE.H.XMLEND = 13
SCE.H.SCRIPT = 14
SCE.H.ASP = 15
SCE.H.ASPAT = 16
SCE.H.CDATA = 17
SCE.H.QUESTION = 18
SCE.H.VALUE = 19
SCE.H.XCCOMMENT = 20
SCE.H.SGML.DEFAULT = 21
SCE.H.SGML.COMMAND = 22
SCE.H.SGML.1ST.PARAM = 23
SCE.H.SGML.DOUBLESTRING = 24
SCE.H.SGML.SIMPLESTRING = 25
SCE.H.SGML.ERROR = 26
SCE.H.SGML.SPECIAL = 27
SCE.H.SGML.ENTITY = 28
SCE.H.SGML.COMMENT = 29
SCE.H.SGML.1ST.PARAM.COMMENT = 30
SCE.H.SGML.BLOCK.DEFAULT = 31
SCE.HJ.START = 40
SCE.HJ.DEFAULT = 41
SCE.HJ.COMMENT = 42
SCE.HJ.COMMENTLINE = 43
SCE.HJ.COMMENTDOC = 44
SCE.HJ.NUMBER = 45
SCE.HJ.WORD = 46
SCE.HJ.KEYWORD = 47
SCE.HJ.DOUBLESTRING = 48
SCE.HJ.SINGLESTRING = 49
SCE.HJ.SYMBOLS = 50
SCE.HJ.STRINGEOL = 51
SCE.HJ.REGEX = 52
SCE.HJA.START = 55
SCE.HJA.DEFAULT = 56
SCE.HJA.COMMENT = 57
SCE.HJA.COMMENTLINE = 58
SCE.HJA.COMMENTDOC = 59
SCE.HJA.NUMBER = 60
SCE.HJA.WORD = 61
SCE.HJA.KEYWORD = 62
SCE.HJA.DOUBLESTRING = 63
SCE.HJA.SINGLESTRING = 64
SCE.HJA.SYMBOLS = 65
SCE.HJA.STRINGEOL = 66
SCE.HJA.REGEX = 67
SCE.HB.START = 70
SCE.HB.DEFAULT = 71
SCE.HB.COMMENTLINE = 72
SCE.HB.NUMBER = 73
SCE.HB.WORD = 74
SCE.HB.STRING = 75
SCE.HB.IDENTIFIER = 76
SCE.HB.STRINGEOL = 77
SCE.HBA.START = 80
SCE.HBA.DEFAULT = 81
SCE.HBA.COMMENTLINE = 82
SCE.HBA.NUMBER = 83
SCE.HBA.WORD = 84
SCE.HBA.STRING = 85
SCE.HBA.IDENTIFIER = 86
SCE.HBA.STRINGEOL = 87
SCE.HP.START = 90
SCE.HP.DEFAULT = 91
SCE.HP.COMMENTLINE = 92
SCE.HP.NUMBER = 93
SCE.HP.STRING = 94
SCE.HP.CHARACTER = 95
SCE.HP.WORD = 96
SCE.HP.TRIPLE = 97
SCE.HP.TRIPLEDOUBLE = 98
SCE.HP.CLASSNAME = 99
SCE.HP.DEFNAME = 100
SCE.HP.OPERATOR = 101
SCE.HP.IDENTIFIER = 102
SCE.HPA.START = 105
SCE.HPA.DEFAULT = 106
SCE.HPA.COMMENTLINE = 107
SCE.HPA.NUMBER = 108
SCE.HPA.STRING = 109
SCE.HPA.CHARACTER = 110
SCE.HPA.WORD = 111
SCE.HPA.TRIPLE = 112
SCE.HPA.TRIPLEDOUBLE = 113
SCE.HPA.CLASSNAME = 114
SCE.HPA.DEFNAME = 115
SCE.HPA.OPERATOR = 116
SCE.HPA.IDENTIFIER = 117
SCE.HPHP.DEFAULT = 118
SCE.HPHP.HSTRING = 119
SCE.HPHP.SIMPLESTRING = 120
SCE.HPHP.WORD = 121
SCE.HPHP.NUMBER = 122
SCE.HPHP.VARIABLE = 123
SCE.HPHP.COMMENT = 124
SCE.HPHP.COMMENTLINE = 125
SCE.HPHP.HSTRING.VARIABLE = 126
SCE.HPHP.OPERATOR = 127
SCE.PL.DEFAULT = 0
SCE.PL.ERROR = 1
SCE.PL.COMMENTLINE = 2
SCE.PL.POD = 3
SCE.PL.NUMBER = 4
SCE.PL.WORD = 5
SCE.PL.STRING = 6
SCE.PL.CHARACTER = 7
SCE.PL.PUNCTUATION = 8
SCE.PL.PREPROCESSOR = 9
SCE.PL.OPERATOR = 10
SCE.PL.IDENTIFIER = 11
SCE.PL.SCALAR = 12
SCE.PL.ARRAY = 13
SCE.PL.HASH = 14
SCE.PL.SYMBOLTABLE = 15
SCE.PL.REGEX = 17
SCE.PL.REGSUBST = 18
SCE.PL.LONGQUOTE = 19
SCE.PL.BACKTICKS = 20
SCE.PL.DATASECTION = 21
SCE.PL.HERE.DELIM = 22
SCE.PL.HERE.Q = 23
SCE.PL.HERE.QQ = 24
SCE.PL.HERE.QX = 25
SCE.PL.STRING.Q = 26
SCE.PL.STRING.QQ = 27
SCE.PL.STRING.QX = 28
SCE.PL.STRING.QR = 29
SCE.PL.STRING.QW = 30
SCE.L.DEFAULT = 0
SCE.L.COMMAND = 1
SCE.L.TAG = 2
SCE.L.MATH = 3
SCE.L.COMMENT = 4
SCE.LUA.DEFAULT = 0
SCE.LUA.COMMENT = 1
SCE.LUA.COMMENTLINE = 2
SCE.LUA.COMMENTDOC = 3
SCE.LUA.NUMBER = 4
SCE.LUA.WORD = 5
SCE.LUA.STRING = 6
SCE.LUA.CHARACTER = 7
SCE.LUA.LITERALSTRING = 8
SCE.LUA.PREPROCESSOR = 9
SCE.LUA.OPERATOR = 10
SCE.LUA.IDENTIFIER = 11
SCE.LUA.STRINGEOL = 12
SCE.LUA.WORD2 = 13
SCE.LUA.WORD3 = 14
SCE.LUA.WORD4 = 15
SCE.LUA.WORD5 = 16
SCE.LUA.WORD6 = 17
SCE.ERR.DEFAULT = 0
SCE.ERR.PYTHON = 1
SCE.ERR.GCC = 2
SCE.ERR.MS = 3
SCE.ERR.CMD = 4
SCE.ERR.BORLAND = 5
SCE.ERR.PERL = 6
SCE.ERR.NET = 7
SCE.ERR.LUA = 8
SCE.ERR.DIFF.CHANGED = 10
SCE.ERR.DIFF.ADDITION = 11
SCE.ERR.DIFF.DELETION = 12
SCE.ERR.DIFF.MESSAGE = 13
SCE.BAT.DEFAULT = 0
SCE.BAT.COMMENT = 1
SCE.BAT.WORD = 2
SCE.BAT.LABEL = 3
SCE.BAT.HIDE = 4
SCE.BAT.COMMAND = 5
SCE.BAT.IDENTIFIER = 6
SCE.BAT.OPERATOR = 7
SCE.MAKE.DEFAULT = 0
SCE.MAKE.COMMENT = 1
SCE.MAKE.PREPROCESSOR = 2
SCE.MAKE.IDENTIFIER = 3
SCE.MAKE.OPERATOR = 4
SCE.MAKE.TARGET = 5
SCE.MAKE.IDEOL = 9
SCE.CONF.DEFAULT = 0
SCE.CONF.COMMENT = 1
SCE.CONF.NUMBER = 2
SCE.CONF.IDENTIFIER = 3
SCE.CONF.EXTENSION = 4
SCE.CONF.PARAMETER = 5
SCE.CONF.STRING = 6
SCE.CONF.OPERATOR = 7
SCE.CONF.IP = 8
SCE.CONF.DIRECTIVE = 9
SCE.AVE.DEFAULT = 0
SCE.AVE.COMMENT = 1
SCE.AVE.NUMBER = 2
SCE.AVE.WORD = 3
SCE.AVE.KEYWORD = 4
SCE.AVE.STATEMENT = 5
SCE.AVE.STRING = 6
SCE.AVE.ENUM = 7
SCE.AVE.STRINGEOL = 8
SCE.AVE.IDENTIFIER = 9
SCE.AVE.OPERATOR = 10
SCE.ADA.DEFAULT = 0
SCE.ADA.COMMENT = 1
SCE.ADA.NUMBER = 2
SCE.ADA.WORD = 3
SCE.ADA.STRING = 4
SCE.ADA.CHARACTER = 5
SCE.ADA.OPERATOR = 6
SCE.ADA.IDENTIFIER = 7
SCE.ADA.STRINGEOL = 8
SCE.BAAN.DEFAULT = 0
SCE.BAAN.COMMENT = 1
SCE.BAAN.COMMENTDOC = 2
SCE.BAAN.NUMBER = 3
SCE.BAAN.WORD = 4
SCE.BAAN.STRING = 5
SCE.BAAN.PREPROCESSOR = 6
SCE.BAAN.OPERATOR = 7
SCE.BAAN.IDENTIFIER = 8
SCE.BAAN.STRINGEOL = 9
SCE.BAAN.WORD2 = 10
SCE.LISP.DEFAULT = 0
SCE.LISP.COMMENT = 1
SCE.LISP.NUMBER = 2
SCE.LISP.KEYWORD = 3
SCE.LISP.STRING = 6
SCE.LISP.STRINGEOL = 8
SCE.LISP.IDENTIFIER = 9
SCE.LISP.OPERATOR = 10
SCE.EIFFEL.DEFAULT = 0
SCE.EIFFEL.COMMENTLINE = 1
SCE.EIFFEL.NUMBER = 2
SCE.EIFFEL.WORD = 3
SCE.EIFFEL.STRING = 4
SCE.EIFFEL.CHARACTER = 5
SCE.EIFFEL.OPERATOR = 6
SCE.EIFFEL.IDENTIFIER = 7
SCE.EIFFEL.STRINGEOL = 8
SCE.NNCRONTAB.DEFAULT = 0
SCE.NNCRONTAB.COMMENT = 1
SCE.NNCRONTAB.TASK = 2
SCE.NNCRONTAB.SECTION = 3
SCE.NNCRONTAB.KEYWORD = 4
SCE.NNCRONTAB.MODIFIER = 5
SCE.NNCRONTAB.ASTERISK = 6
SCE.NNCRONTAB.NUMBER = 7
SCE.NNCRONTAB.STRING = 8
SCE.NNCRONTAB.ENVIRONMENT = 9
SCE.NNCRONTAB.IDENTIFIER = 10
SCE.MATLAB.DEFAULT = 0
SCE.MATLAB.COMMENT = 1
SCE.MATLAB.COMMAND = 2
SCE.MATLAB.NUMBER = 3
SCE.MATLAB.KEYWORD = 4
SCE.MATLAB.STRING = 5
SCE.MATLAB.OPERATOR = 6
SCE.MATLAB.IDENTIFIER = 7
STYLE.DEFAULT = 32
STYLE.LINENUMBER = 33
STYLE.BRACELIGHT = 34
STYLE.BRACEBAD = 35
STYLE.CONTROLCHAR = 36
STYLE.INDENTGUIDE = 37
STYLE.LASTPREDEFINED = 39
STYLE.MAX = 127
'JUST FOR LB
SCLEX.LB=SCLEX.VB
SCE.B.HANDLE=SCE.B.PREPROCESSOR
SCE.B.LABEL=SCE.B.DATE
return


