'   HocusFocus.bas
'   by Brad Moore - copyright 2002
'   Last revision 6/17/2002
'-----------------------------------------------
'   Inclusion within other works is permitted
'   without requirement of credit or permission.
'   All rights are retained by author.
'-----------------------------------------------
'   This is written for Liberty Basic v3.x
'   To learn more about Liberty Basic please
'   visit the website http://www.libertybasic.com


'Initalize the settings for the window
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    NoMainWin
    WindowWidth = 393 : WindowHeight = 210
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

'setup the controls
Statictext  #main.st1, "", 80, 20, 130, 25
Statictext  #main.st2, "", 55, 54, 155, 25
Statictext  #main.st3, "", 20, 88, 195, 25
Button      #main.quit, "",[quit],UL, 220, 125, 140, 35
Textbox     #main.tbx1, 220, 15, 137, 24
Textbox     #main.tbx2, 220, 50, 137, 24
Textbox     #main.tbx3, 220, 85, 137, 24

Open "Hocus Focus" For Window As #main

    #main "trapclose [quit]"
    #main "font ms_sans_serif 10"

'I assigned text to labels to avoid line wrap above
    #main.st1 "Handle of this window"
    #main.st2 "Last window to have focus"
    #main.st3 "What window/control has focus?"
    #main.quit "I am done" 

'Enumerate the open windows/controls in the lb form
    hmain = hWnd(#main)
    tb1main = hWnd(#main.tbx1) 
    tb2main = hWnd(#main.tbx2)
    tb3main = hWnd(#main.tbx3)
    btnmain = hWnd(#main.quit)

'Intialize values for the textboxes
    #main.tbx1 Str$(hmain)
    #main.tbx2 Str$(hmain)
    #main.tbx3 "Main Window"
    
'set the timer to 50 milliseconds    
    Timer 50, [events]

'Wait for events
    Wait

'Process the events
[quit]
    Close #main
    End

[events]
    'Find out who has the focus currently
    CallDLL #user32, "GetFocus", handle As long
    'Display the value
    #main.tbx2 Str$(handle)

    'Evaluate the result of call    
    Select Case handle
       Case hmain
          #main.tbx3 "Main Window"
       Case tb1main
          #main.tbx3 "Textbox 1 Control"
       Case tb2main
          #main.tbx3 "Textbox 2 Control"
       Case tb3main
          #main.tbx3 "Textbox 3 Control"
       Case btnmain
          #main.tbx3 "Quit Button Control"
       Case Else
         #main.tbx3 "External Window"
    End Select
    Wait













