'Plastic Surgery for radiobuttons (or How to make bitmap radiobuttons to improve
'your application user interface) by Mike Bradbury.

'Requires LibertyBASIC v3 and tested with Win98SE in 16 bit colour.

'Using bitmap buttons instead of standard windows buttons makes the user interface
'more interesting and functional. This demo uses two bitmap images to display a
'button in the off and on states, the on state indicated by an 'illuminated' green
'bar at the centre of the button. The window also contains a bitmap button
'labelled On/Off. When this button is in the off state, all other buttons are locked
'in the off state and when this button is on, the other buttons become active and a
'label for the buttons is displayed. Also for the purposes of this example, when a
'button is clicked, the previously active button is reset to off, the buttons behaving
'like radiobuttons.
'For a personal style, replace the bitmaps with your own design, using a painting
'package like MSPaint or PaintShop Pro etc., making the bitmaps 63x25 pixels in size.

'Remember to click the On/Off button first, else you will not see the illuminated effect!

if left$(Version$,1)<>"3" then notice "Sorry...";chr$(13);"for LB Version 3 only!":end
nomainwin
controlsOn=0
label$="  B1       B2       B3       B4       B5"
off$="buttonOff.bmp"   'bitmap file for the button displayed off
on$="buttonOn.bmp"     'bitmap file for the button displayed on
loadbmp "off",off$
loadbmp "on",on$
WindowWidth = 336
WindowHeight = 363
    bmpbutton #m1.1, off$, [001], UL, 8, 43
    bmpbutton #m1.2, off$, [002], UL, 70, 43
    bmpbutton #m1.3, off$, [003], UL, 133, 43
    bmpbutton #m1.4, off$, [004], UL, 194, 43
    bmpbutton #m1.5, off$, [005], UL, 256, 43
    bmpbutton #m1.6, off$, [006], UL, 8, 306
    graphicbox #m1.label, 8, 16, 309, 25 'button labels
    graphicbox #m1.back, 6, 68, 316, 235
    statictext #m1.st1, "On/Off", 75, 312,75,20

    open "Illuminated buttons" for dialog_nf as #m1
    #m1, "trapclose [quit]"
    #m1.back, "down;backcolor buttonface;fill buttonface;flush"
    #m1.back, "font arial 18"
    #m1.label, "down;fill buttonface"
    #m1.label, "font courier_new 9;backcolor buttonface"
    #m1.label, "flush"
wait

'******** Code for buttons, allowing only one to be in the On state ********

[001]
if controlsOn=0 then wait           'do nothing if on/off button is off
call resetButtonOff activeButton    'reset last active button to off
#m1.1, "bitmap on"                  'set this button to on
activeButton=1                      'flag this button now being active
call doButtonTask activeButton      'do whatever button does!
wait
[002]
if controlsOn=0 then wait
call resetButtonOff activeButton
#m1.2, "bitmap on"
activeButton=2
call doButtonTask activeButton
wait
[003]
if controlsOn=0 then wait
call resetButtonOff activeButton
#m1.3, "bitmap on"
activeButton=3
call doButtonTask activeButton
wait
[004]
if controlsOn=0 then wait
call resetButtonOff activeButton
#m1.4, "bitmap on"
activeButton=4
call doButtonTask activeButton
wait
[005]
if controlsOn=0 then wait
call resetButtonOff activeButton
#m1.5, "bitmap on"
activeButton=5
call doButtonTask activeButton
wait
[006]
controlsOn=1-controlsOn
if controlsOn=1 then
    #m1.6, "bitmap on"
    #m1.label, "color red;place 5 15;\";label$
    #m1.label, "flush"
    else
    #m1.6, "bitmap off"
    #m1.label, "discard"
    #m1.label, "fill buttonface;flush"
    #m1.back, "cls"
    call resetButtonOff activeButton
end if
wait

' Program specific code
[doSomething]
wait


[quit]
unloadbmp "off"
unloadbmp "on"
close #m1
end

'********************* subs *********************

sub doButtonTask activeButton
'next line just for demo, to give the button something to do!
#m1.back, "color black;place 100 100;\Button ";activeButton
'enter task code for each button below.
select case activeButton
       case 1
       'task code for button 1
       case 2
       'task code for button 2
       case 3
       'task code for button 3
       case 4
       'task code for button 4
       case 5
       'task code for button 5
end select
end sub

sub resetButtonOff activeButton  'redraw previously active button in off state
select case activeButton
       case 1
            #m1.1, "bitmap off"
       case 2
            #m1.2, "bitmap off"
       case 3
            #m1.3, "bitmap off"
       case 4
            #m1.4, "bitmap off"
       case 5
            #m1.5, "bitmap off"
end select
end sub
