SCRIPTER.BAS
	by Alyce Watson

'** 5/22/02 7:58:13 AM
'** Scripter

If Val(Version$)<3.01 Then
    Notice "You must have at least LB3.01 to run this program."
    End
End If

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    dsteps           = 0    'number of drawing steps
    cstep            = 0    'current drawing step
    Dim steps$(20)          'array to hold drawing script info
    crlf$=Chr$(13)+Chr$(10) 'carriage return/line feed

[WindowSetup]
    NoMainWin
    WindowWidth = 606 : WindowHeight = 480
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu        #1, "&File", "&Open", [open], "&Save", [save],_
                "E&xit", [quit]
Menu        #1, "Edit"  'position automatic Edit menu in second spot
Menu        #1, "&Run", "R&un",[runit]
Menu        #1, "&Help", "&Instructions", [help], "&Commands",_
                [commands], "&About",[about]

Button      #1.open, "Open",[open],UL,10,6,80,24
Button      #1.run, "Run",[runit],UL,92,6,80,24

Statictext  #1.s, "", 210,4,200,30
Statictext  #1.pen, "Pen is down!",411,4,200,30
Graphicbox  #1.g, 200,38,400,400
Texteditor  #1.t, 0,38,198,400

Open "Scripter Demo" For Window_nf As #1

    #1 "trapclose [quit]"
    #1.g "down; fill Darkblue; flush"
    #1.g "color cyan ; size 2"
    #1.t "!font courier_new 10"
    #1.s "!font courier_new 12"
    #1.pen "!font courier_new 14 bold"

[loop]
    Wait

[quit]
    Timer 0
    Close #1 : End


[open]  'extension is sss
    FileDialog "Open","*.sss",file$
    If file$="" Then Wait 'user cancelled

    'open file and load contents into texteditor
    Open file$ For Input As #f
    #1.t "!contents #f"
    Close #f
    Wait


[save]  'extension is sss
    FileDialog "Save As","*.sss",file$
    If file$="" Then Wait   'user cancelled

    'get texteditor contents and write to file
    #1.t "!contents? saveit$";
    Open file$ For Output As #f
    Print #f, saveit$
    Close #f
    Notice "File saved as ";file$
    Wait


[runit] 'read and parse commands, start timer for drawing
    #1.g "cls; fill Darkblue; color cyan ; size 2"
    #1.g "north; home"
    #1.t "!lines dsteps"    'get number of lines in texteditor

    ReDim steps$(dsteps)    'redim array to number of lines

    'fill array with drawing commands
    For i = 1 to dsteps
        #1.t "!line ";i;" txt$"
        'trap blank lines:
        If Len(txt$)=0 Then txt$="move 0"
        steps$(i)=txt$
    Next

    okay = Parse(dsteps)    'the heart of the scripter program

    If okay>0 Then  'there was an error
        Notice "An error occured on line ";okay
        Wait
    End If

    If dsteps=0 Then
        Notice "No code!"
        Timer 0
    Else
        'everything is okay, start the drawing process
        cursor hourglass    'to show user something is happening
        #1.g "cls; fill Darkblue; color cyan ; size 2"
        #1.g "north; home"
        cstep=0
        Timer 500, [draw]
    End If
    Wait


[draw]  'draw on timer until all commands have been executed
    If (dsteps=0) Then Timer 0  'nothing to draw

    cstep=cstep+1   'increment drawing step number

    'draw the current step
    #1.g " " + steps$(cstep) + " "

    'scroll the code window in sync with current drawing step
    #1.t "!origin ";cstep;" 1";

    'get current script command, write to statictext
    #1.t "!line ";cstep;" txt$"
    #1.s txt$

    'let user know if pen is up or down
    t$=Lower$(Word$(txt$,1))
    If Lower$(t$)="down" Then Print #1.pen, "Pen is DOWN!"
    If Lower$(t$)="up" Then Print #1.pen, "Pen is UP!"


    If (cstep>=dsteps) Then  'last step was reached
        Timer 0              'turn timer off
        cursor normal   'to show user drawing is done
        #1.g "color red; circlefilled 4"
        #1.g "flush"
        #1.t "!origin 1 1"  'reset code window to top line
    End If
    Wait


[help]
    msg$="Scripter Instructions" + crlf$
    msg$=msg$ + "Write commands in the code window, and then" + crlf$
    msg$=msg$ + "watch the pen execute your commands in the" + crlf$
    msg$=msg$ + "drawing box!" + crlf$ + crlf$
    msg$=msg$ + "Place one command on each line.  Commands " + crlf$ 
    msg$=msg$ + "are listed under 'Commands' in the Help menu." + crlf$ + crlf$
    msg$=msg$ + "Choose 'Run' from the menu or click the 'Run' button" + crlf$
    msg$=msg$ + "to run the program.  The code window will scroll as" + crlf$
    msg$=msg$ + "commands are executed, and commands will be " + crlf$
    msg$=msg$ + "displayed above the drawing box as well." + crlf$ + crlf$
    msg$=msg$ + "Scripts can be saved to disk and opened" + crlf$
    msg$=msg$ + "at another time, if desired."
    Notice msg$
    Wait

[commands]
    msg$="Commands" + crlf$
    msg$=msg$ + "center = center the pen" + crlf$
    msg$=msg$ + "north = turn north" + crlf$
    msg$=msg$ + "west = turn west" + crlf$
    msg$=msg$ + "south = turn south" + crlf$
    msg$=msg$ + "east = turn east" + crlf$
    msg$=msg$ + "turn a = turn number of degrees in a" + crlf$
    msg$=msg$ + "moveto x y = goto point indicated" + crlf$
    msg$=msg$ + "move n = go distance of n in current direction" + crlf$
    msg$=msg$ + "up = pen up, move without drawing" + crlf$
    msg$=msg$ + "down = pen down, draw while moving"
    Notice msg$
    Wait


[about]
    Notice "Scripter Demo for LB Newsletter, 2002."
    Wait


Function Parse(num) 'parse commands, fill array and debug!
    result=0 'will return 0 unless there is an error
    #1.s "Compiling, please wait!"
    For i = 1 to num

        s$=Lower$(steps$(i))            'entire command line
        c$=Lower$(Word$(steps$(i),1))   'command is first word
        Select Case c$  'use script command to determine needed
                        'Liberty BASIC drawing command

            Case "center"   'equivalent to LB home command
                steps$(i)="home"
            Case "north"    'equivalent to LB north command
                steps$(i)="north"
            Case "south"    'south=north+180
                steps$(i)="north; turn 180"
            Case "east"     'east=north+90
                steps$(i)="north; turn 90"
            Case "west"     'west=north+270
                steps$(i)="north; turn 270"

            Case "turn" 'equivalent to LB turn command
                'check for value, in case second word has
                'no numeric equivalent - it will then be 0
                a=Val(Word$(s$,2))
                a$=Str$(a)
                steps$(i)="turn ";a$

            Case "moveto"  'goto point indicated
                         'trap x,y values that are larger
                         'than drawing area
                x=Val(Word$(s$,2))
                If x>396 Then x=396
                x$=Str$(x)

                y=Val(Word$(s$,3))
                If y>396 Then y=396
                y$=Str$(y)

                steps$(i)="goto "+x$+" "+y$

            Case "move" 'travel set distance in current direction
                d=Val(Word$(s$,2))
                'not perfect, but trap distances outside
                'of drawing area:
                #1.g "posxy x y"

                if x+d>396 then d=396-x
                if y+d>396 then d=396-y

                d$=Str$(d)
                steps$(i)="go "+d$

            Case "down" 'equivalent to LB down command
                #1.g "down"

            Case "up"   'equivalent to LB up command
                #1.g "up"

            Case Else   'script command not understood by parser
                result=i    'return line number of error
                'scroll to error line:
                #1.t "!origin ";i;" 1 ";    'row, column
                #1.t "!select 1 ";i         'column, row
                exit for    'error, exit for/next loop
        End Select
    Next
    #1.s, ""
    Parse=result
    End Function

