'updown (spinner) control
if val(Version$)<3 then
    notice "Requires LB3."
    end
end if

nomainwin

'constants
UDS.SETBUDDYINT = hexdec("2")   'Causes the up-down control to set the text of the buddy window
                                '(using the WM_SETTEXT message) when the position changes. The text
                                'consists of the position formatted as a decimal or hexadecimal string.
UDS.NOTHOUSANDS = hexdec("80")  'Does not insert a thousands separator between every three decimal digits.
UDS.HOTTRACK = hexdec("100")    'Causes the control to exhibit "hot tracking" behavior. That is,
                                'it highlights the UP ARROW and DOWN ARROW on the control as the
                                'pointer passes over them. This style requires Microsoft Windows 98
                                'or Windows 2000. If the system is running Windows 95 or Windows NT 4.0,
                                'the flag is ignored. To check whether hot tracking is enabled, call SystemParametersInfo.
UDS.HORZ = hexdec("40")         'Causes the up-down control's arrows to point left and right instead of up and down.
UDS.AUTOBUDDY = hexdec("10")    'Automatically selects the previous window in the z-order as the
                                'up-down control's buddy window.
UDS.ARROWKEYS = hexdec("20")    'Causes the up-down control to increment and decrement
                                'the position when the UP ARROW and DOWN ARROW keys are pressed.
UDS.ALIGNRIGHT = hexdec("4")    'Positions the up-down control next to the right edge
                                'of the buddy window. The width of the buddy window is
                                'decreased to accommodate the width of the up-down control.
UDS.ALIGNLEFT = hexdec("8")     'Positions the up-down control next to the left edge
                                'of the buddy window. The buddy window is moved to the right,
                                'and its width is decreased to accommodate the width of the up-down control.
UDS.WRAP = hexdec("1")          'Causes the position to "wrap" if it is incremented or decremented beyond the
                                'ending or beginning of the range.

calldll #comctl32, "InitCommonControls",re as void

WindowWidth = 240: WindowHeight = 200
UpperLeftX = 10: UpperLeftY = 10

statictext #1.s, "Percent:",50,16,120,24
button #1.get, "Get Percent",[percent],UL,30,80,100,24
textbox #1.t, 50,40,60,26
open "Spinner Test" for dialog as #1

    #1 "trapclose [quit]"
    hwndParent = hwnd(#1)
    hText=hwnd(#1.t)

    'get parent instance handle:
    CallDLL #user32, "GetWindowLongA",_
    hwndParent As long,_    'window handle
    _GWL_HINSTANCE As long,_'want instance handle
    hInstance As long       'returns instance handle of window

    dwStyle = _WS_CHILD or _WS_VISIBLE or _WS_BORDER _
         or UDS.SETBUDDYINT or UDS.ALIGNRIGHT _
         or UDS.ARROWKEYS

    x=0:y=0:wide=0:high=0:upr=100:lwr=0:pos=50

    calldll #comctl32, "CreateUpDownControl",_
        dwStyle as ulong,_      'style
        x as long,_             'x placement
        y as long,_             'y placement
        wide as long,_          'width
        high as long,_          'height
        hwndParent as long,_    'parent handle
        id as long,_            'an ID number
        hInstance as long,_     'parent instance handle
        hText as long,_         'buddy control - a textbox handle
        upr as long,_           'upper limit
        lwr as long,_           'lower limit
        pos as long,_           'initial value
        hSpinner as long        'handle of control

    wait


[percent]
    #1.t "!contents? txt$"
    notice "Percent is ";txt$
    wait

[quit]
    calldll #user32, "DestroyWindow",_
    hSpinner as long, re as long
    close #1:end





