
    'For LibertyBASIC tested with version 3.01, Win98, 800x600
    'Formatted listbox with column labels which become field
    'selection buttons for editing. To enable editing, click
    'the Edit button, select an item from the listbox and then
    'click the button for the field you wish to change. When
    'finished editing, click the Lock button and the listbox
    'resumes its' normal behaviour.
    'Obviously data would usually be saved to disc file rather
    'than data statements and editing would require changes to
    'be written back to the file.
    'mike@karemi.fsnet.co.uk

    '~~~~~~~~~~~~~~~~~~~~~~~ Window size ~~~~~~~~~~~~~~~~~~~~~~~~~
    ' following dimensions are pixels
    dw=DisplayWidth: dh=DisplayHeight
    WindowWidth = dw: WindowHeight = dh
    '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
disable=0:enable=1
BackgroundColor$="darkcyan"
NoMainWin
Dim buy$(20)
Dim array$(20)  'array for listbox
'arrays for individual columns in listbox
Dim serial$(20):Dim item$(20):Dim cost$(20)
'fill arrays. Building array$() from separate elements enables
'easy manipulation of the listbox contents.
For n=1 to 20 'ignore element zero, see LB help file re-listbox
ser$=Str$(n)
serial$(n)=formatLeadingZeros$(5, ser$)      'fix length of serial$(),padded with zeros
Read a$:item$(n)=a$ 'load demo data
item$(n)=formatTrailingSpaces$(14, a$)       'fix length of item$(), paddedwith spaces
Read cost 'load demo data
cost$(n)=formatCost$(cost)                   'format cost, aligning decimals
array$(n)=makeListboxEntry$(n)               'build array for listbox
Next n
xRef=200
Menu #m1, "&About program", "&Info", [info]
Button #m1.L0, "", [], UL, xRef,140,49,20
Button #m1.L1, "Item", [editItem], UL, xRef+49,140,121,20
Button #m1.L2, "Cost", [editCost], UL, xRef+170,140,86,20
Button #m1.L3, "Spare", [spare], UL, xRef+256,140,86,20
Button #m1.b0, "BUY", [shop], UL, xRef,440,70,20
Button #m1.b1, "Exit", [quit], UL, 0,0,0,0
Button #m1.b3, "Edit", [edit], UL, xRef,110,70,20
Listbox #m1.lb1, array$(,[show],xRef, 160, 341, 135
Texteditor #m1.tb1, xRef,300,255,130
Open "Listview" For window_popup As #m1 'no titlebar/close box
'array of handles for buttons to be used as labels
hCont(0)=hWnd(#m1.L0)
hCont(1)=hWnd(#m1.L1)
hCont(2)=hWnd(#m1.L2)
hCont(3)=hWnd(#m1.L3)
'font for button labels (use bold font for clarity)
#m1.L0, "!font arial 9 bold"
#m1.L1, "!font arial 9 bold"
#m1.L2, "!font arial 9 bold"
#m1.L3, "!font arial 9 bold"
'disable buttons used as labels
Call disableControl disable, 0, 3
'Button can still be written to even though disabled
#m1.L0, "Serial"
#m1.tb1, "!font technical 12"
'font for listbox (only use fixedwidth font or columns will not align)
#m1.lb1, "font courier_new 10"
#m1.lb1, "singleclickselect"
#m1.tb1, "Click items in the listbox to add";Chr$(13);"those items to your shopping list!";_
         Chr$(13);"Then click BUY";Chr$(13);"Apologies to female programmers,";Chr$(13);_
         "for the list contents!"
buy=1
Wait
'
[shop]
#m1.b1, "!locate 300 440 70 20"
#m1, "refresh"
#m1.tb1, "!cls"
#m1.tb1, "You have bought:"
For i=1 to buy
#m1.tb1, buy$(i)
Next
#m1.tb1, "Total cost: ";totalcost
If totalcost <>0 Then #m1.tb1, "Please mail me with your";Chr$(13);"credit card number!"
Wait
'
[show]
'show choice from listbox in texteditor
If editControl<>1 Then
If buy=1 Then #m1.tb1, "!cls"
#m1.lb1, "selectionindex? index"
#m1.tb1, "Selected from listbox:"
#m1.tb1, "Serial is ";serial$(index)
#m1.tb1, "Item is ";item$(index)
#m1.tb1, "Cost is ";cost$(index)
buy$(buy)=array$(index)
totalcost=totalcost+Val(Right$(cost$(index),5))
buy=buy+1
End If
Wait
'
[edit]
editControl=1-editControl
If editControl=1 Then
    Call disableControl enable, 1, 2
    #m1.b3, "Lock"
    #m1.tb1, "!cls"
    Else
    Call disableControl disable, 1, 2
    #m1.b3, "Edit"
    #m1.lb1, "selectindex 0"
End If
Wait

[editItem] 'edit item
#m1.lb1, "selectionindex? index"
If index<>0 Then
    p$=item$(index)
    Prompt "Enter new item..."; p$
    If p$<>"" Then
        '**** reformatting *********
        item$(index)=formatTrailingSpaces$(14, p$)
        'update listbox array
        array$(index)=makeListboxEntry$(index)
        #m1.lb1, "reload"
        #m1.lb1, "selectindex "; index
    End If
End If
Wait

[editCost] 'edit cost
#m1.lb1, "selectionindex? index"
If index<>0 Then
p$=cost$(index)
Prompt "Enter new cost..."; p$
If p$<>"" Then
    '**** reformatting *********
    char=Asc(Left$(p$,1))
    If char<48 or char>57 Then p$=Mid$(p$,2)
    temp$=formatCost$(Val(p$))
        If Len(temp$)<=7 Then
           cost$(index)=formatCost$(Val(p$))
           'update listbox array
           array$(index)=makeListboxEntry$(index)
            #m1.lb1, "reload"
            #m1.lb1, "selectindex "; index 'keep item selected
            Else
            Notice "Invalid entry"
        End If
    End If
End If
Wait

[spare]
'The number of columns in the list box can be expanded to suit.
Wait

[info]
Notice "About Program";Chr$(13);"Formatted Listbox with column labels";Chr$(13);_
       "Data for each column is from a separate array."
Wait
'
[quit]
Close #m1
End

Sub disableControl state, strt, fin
    For n=strt to fin
    hC=hCont(n)
    CallDLL #user32, "EnableWindow",_
    hC As long,_
    state As ushort,_
    result As void
    Next n
End Sub

Function formatLeadingZeros$(fieldWidth, ser$)
    formatLeadingZeros$=Right$("00000",fieldWidth-Len(ser$))+ser$
End Function

Function formatTrailingSpaces$(fieldWidth, ft$)
    temp$=ft$+Right$(Space$(fieldWidth),fieldWidth-Len(ft$))
    formatTrailingSpaces$=Left$(temp$,fieldWidth) 'truncate if too long
End Function

Function formatCost$(cost)
    formatCost$=""+Using("###.##",cost)
End Function

Function makeListboxEntry$(n)
    makeListboxEntry$=serial$(n)+Space$(1)+item$(n)+Space$(1)+cost$(n)
End Function

'data to fill arrays for demo
Data "Socks(2)",5.35,"Tie",7.29,"Shirt",12.50,"Tie pin",1.99,"Gloves",9.95
Data "Wool jumper",23.68,"Shoes(lace)",57.75,"Tie",8.34,"Slippers",11.67,"Socks(3)",5.49
Data "Silver Pen",5.35, "Hairbrush",7.29,"Razor",12.50,"Toothbrush",1.99
Data "Sun lotion",9.95,"Trainers",23.68,"Shoes(slip-on)",57.75,"Mouse",8.34,
Data "Gold pen",11.67,"Mousemat",3.49
