'--------------------------------------

'   wrapText.bas

'LB3x required.
'Word wrap text in a scrollable LB textEditor
'using 'stringWidth' in a graphicbox to
'find the wrap point.
'Works with TXT files too. See [getFile].
'In addition to wrapping at the nearest space,
'the code will also wrap at hyphens, and replace
'tabs with spaces.
'   Bill Jennings, Aug 2002.

   nomainwin

    CrLf$=chr$(13)+chr$(10)
    gosub [inData]  'get txIn$
  '  gosub [getFile]

    font$="Courier_New 0 22"
 '*** Try these too: ******************
   ' font$="Arial 0 16"
   ' font$="Times_New_Roman 0 36"

    WindowWidth=400 : WindowHeight=400
       'Pixels to wrap at
    Xwidth=WindowWidth-35

    UpperLeftX=200 : UpperLeftY=50
    graphicbox #w1.gr1, 0,0,0,0
    texteditor #w1.te1, 5,5,WindowWidth-15,200
    open "textEditor" for window as #w1
      print #w1, "trapclose [quit]"
      print #w1.te1, "!font ";font$
      print #w1.gr1, "font ";font$
      hW1=hwnd(#w1)
      gosub [removeMenu]
      txOut$=""
      gosub [format]
      print #w1.te1, txOut$ 
  WAIT

[format]
'** replace tabs with spaces **
       'pt=position of tab
    pt=instr(txIn$,chr$(9))
    while pt>0
      lef$=left$(txIn$,pt-1)
      rt$=mid$(txIn$,pt+1)
      txIn$=lef$+"    "+rt$ 
      pt=instr(txIn$,chr$(9),1)
    wend
'** find CR+LF & do lines one at a time **
    while len(txIn$)>0
      line$=txIn$
      p=instr(txIn$,CrLf$)
      if p then
        line$=left$(txIn$,p+1)
        txIn$=mid$(txIn$,p+2)
      end if
      L$="" : gosub [wrap]
      if line$>"" then L$=L$+line$
      txOut$=txOut$+L$
    wend
  RETURN

[wrap]
    width=stringWidth(line$) '(function)
    if width<=Xwidth then RETURN

    ps=0    'position of space
  [repeat1]
    p=instr(line$," ",ps+1)
    if p=0 then [end1]
    width=stringWidth(left$(line$,p-1))
    if width>Xwidth then [end1]
    ps=p : goto [repeat1]
  [end1]
    ph=0    'position of hyphen
  [repeat2]
    p=instr(line$,"-",ph+1)
    if p=0 then [end2]
    width=stringWidth(left$(line$,p-1))
    if width>Xwidth then [end2]
    ph=p : goto [repeat2]
  [end2]

    if not(ps) and not(ph) then  'no space or hyphen
      aa$=""
      for j=1 to len(line$)
        aa$=aa$+mid$(line$,j,1)
        wide=stringWidth(aa$)
        if wide>Xwidth-8 then Exit For
        a0$=aa$
      next j
      ph=len(a0$)  'force a hyphen
      line$=left$(a0$,len(a0$))+mid$(line$,len(a0$))
    end if

    p0=ps : en$=""
    if ph>ps then p0=ph : en$="-"
    L$=L$+left$(line$,p0-1)+en$+CrLf$
    line$=mid$(line$,p0+1) : goto [wrap]

[quit]
    close #w1 :END

[removeMenu]    'Removes entire MenuBar
    calldll #user32, "SetMenu",_
      hW1 as long,_ 'handle of nongraphics window
      0 as long,_  '0 removes the MENU BAR
      results as ushort 'returns nonzero if successful
  RETURN

[getFile]
    f$="  '*** your text file path&name here ***"
    open f$ for input as #1
  '** Input entire file as string **
      txIn$=input$(#1,lof(#1))
    close #1
  RETURN

[inData]
    a$="This is a long first line, This is the 2nd part. "+_
      "This is the 3rd part. This is the 4th part. "+_
      "This is the 5th part. This is the 6th part."
    b$=chr$(9)+"This is a long second line, "+_
      "starting with a tab. This is the 2nd part. "+_
      "This is the 3rd part with a hyphenated-word. "+_
      "This is the 4th part. "+_
      "This is the 5th part. This is the 6th part."
    c$="This/is/a/long/line/with/no/spaces/or/hyphens."+_
       "This/is/a/long/line/with/no/spaces/or/hyphens."
    d$=CrLf$+"Try pressing 'Home', then 'PageDown'"+_
      " & 'PageUp' keys."
    txIn$=a$+CrLf$+b$+CrLf$+c$+CrLf$+d$+CrLf$
  RETURN

  Function stringWidth(text$)
    print #w1.gr1, "stringWidth? text$ width"
    stringWidth=width
  End Function
'--------------------------------------

