'#############################################
'#                  NumbWord                 #
'#      (my, what an imaginative name!)      #
'#                by Rob Durk                #
'#          12th/13th September 2002         #
'# Version 2 - parsing done in a single loop #
'#    (comments and input loop - B.Moore)    #
'#############################################

[numbword.start]
    Dim title$(1)
    title$(1)="NumbWord 2"

    num$ = "##"


[get.input]
    Print "Type in the number you wish to convert (zero to quit):";
    Input num$
    num$=Trim$(num$)
    If num$ = "0" Then GoTo [numbword.end] 
    'make sure result$ is cleared
    result$ = ""

    'dispose of anything after a decimal point...
    If Int(Val(num$))<>Val(num$) Then 
        Call MsgWin "Don't do bitty numbers, sorry!"
        num$=Str$(Int(Val(num$)))
    End If

    num.len=Len(num$) 'we get this AFTER any line which might trim the length of num$

    'make sure no non-numeric characters are in there
    If Str$(Val(num$))<>num$ Then 
        Call MsgWin "Sorry, can't make sense of that.."
        GoTo [numbword.end]
    End If

    'sorry, you're limited to numbers less than 1 quadrillion - how lazy I am!
    If num.len>15 Then 
        Call MsgWin "Gosh!!"+Chr$(13)+"I'm not clever enough to count that high.."
        GoTo [numbword.end]
    End If


[divide.into.3s]
'expand string to be an exact multiple of 3 in length
'This is the logical break for numbers, 100's 100,000's 100,000,000's etc
    num.tmp=num.len-(3*(Int(num.len/3)))
    If num.tmp<>0 Then num$=Right$("000"+num$,(3-num.tmp+num.len))
    num.len=Len(num$)
    num.group=Int(num.len/3)

'make arrays to hold the groups of 3
    Dim group$(num.group)
    Dim numbword$(num.group)

'divide (and conquer) the input into 3s
    For loop=1 to num.group
        group$(loop)=Mid$(num$,((loop-1)*3)+1,3)
    Next loop


[parse.3s]
'parse each group of 3
    For loop=num.group to 1 step -1

[1st.digit]
    If Val(Left$(group$(loop),1))<1 Then GoTo [2nd.digit]
    numbword$(loop)=Word$("one two three four five six seven eight nine", _
            Val(Left$(group$(loop),1)))+" hundred"
    If Val(Right$(group$(loop),2))>0 Then numbword$(loop)=numbword$(loop)+" and"

[2nd.digit]
    If Val(Mid$(group$(loop),2,1))<1 Then GoTo [3rd.digit]
    If Val(Right$(group$(loop),2))<20 Then GoTo [those.awkward.teen.years]
    numbword$(loop)=numbword$(loop)+" "+Word$("ten twenty thirty forty fifty sixty seventy "+ _
        "eighty ninety",Val(Mid$(group$(loop),2,1)))

[3rd.digit]
    If Val(Right$(group$(loop),1))<1 Then GoTo [next.group]
    numbword$(loop)=numbword$(loop)+" "+Word$("one two three four five six seven eight nine", _
            Val(Right$(group$(loop),1)))
    GoTo [next.group]

[those.awkward.teen.years]
    If Val(num$)>Val(group$(loop)) and Val(Left$(group$(loop),1))<1 and loop=num.group Then _
        numbword$(loop)=numbword$(loop)+" and"
    numbword$(loop)=numbword$(loop)+" "+Word$("ten eleven twelve thirteen fourteen fifteen "+ _
        "sixteen seventeen eighteen nineteen",(Val(Right$(group$(loop),2))-9))

[next.group]
    Next loop


'dimension an array for the multipliers
    Dim multiply$(5) 'maximum value of num.group (=max length of numeric input/3)

'multiply$(arrayindex)=name of multiplier equalling 10^((arrayindex-1)*3)
'add commas if you like them..

        multiply$(5)=" trillion"   '10^12
        multiply$(4)=" billion"    '10^9
        multiply$(3)=" million"    '10^6
        multiply$(2)=" thousand"   '10^3
        multiply$(1)=""            '10^0 =1, thus has no multiplier


'tag multipliers to groups with a value
    For loop=1 to num.group
        If Trim$(numbword$(loop))<>"" Then _
            numbword$(loop)=numbword$(loop)+multiply$(num.group-loop+1)
    Next loop


'stitch it all together
    For loop=1 to num.group
        result$=result$+Trim$(numbword$(loop))+" "
    Next loop

'tadaa!
    Print "You typed ";Trim$(result$)
    goto [get.input]


[numbword.end]
    End


' sub - MsgWin
Sub MsgWin msg$
    Notice "Message from "+title$(1)+Chr$(13)+msg$
    End Sub
