'** Temperature Conversion
'   Should work in LB2 and LB3
'   by Brad Moore
'   released to the public domain Oct 2002   

'Window Setup
NoMainWin
WindowWidth = 276
WindowHeight = 187
'Center the window
UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

'Control Setup
Statictext  #main.st1, "Fahrenheit", 25, 20, 75, 16
Statictext  #main.st2, "Centigrade", 25, 45, 75, 20
Button      #main.F2C, "Fahrenheit -> Centigrade", _
                       [F2C],UL, 20, 75, 230, 25
Button      #main.C2F, "Centigrade -> Fahrenheit ", _
                       [C2F],UL, 20, 105, 230, 25
Textbox     #main.tb1, 110, 15, 137, 24
Textbox     #main.tb2, 110, 40, 137, 24

'Open the window
Open "Temperature Conversion" For Window As #main

'Trap the close window EVENT (hey! this is an event trap!)
Print #main, "trapclose [quit]"
Print #main, "font ms_sans_serif 10"

'Wait here for events
[loop]
    Wait

'Handle the close window event
[quit]
    Close #main
    End

'Handle the F to C event
[F2C]
    'get contents of textbox1
    Print #main.tb1, "!contents? a$" 
    'Get the numeric value and insure it is a number
    a = Val(a$)
    If a$ <> "0" and a = 0 Then 
       Notice "A numeric value is required for Fahrenheit"
       GoTo [loop]
    End If
    'Display the conversion in the Other textbox
    Print #main.tb2, Using("####.#",Str$((a - 32) * 5/9)) 
    Wait

'Handle the C to F event
[C2F]
    'get contents of textbox2
    Print #main.tb2, "!contents? a$"
    'Get the numeric value and insure it is a number
    a = Val(a$)
    If a$ <> "0" and a = 0 Then 
       Notice "A numeric value is required for Centigrade"
       GoTo [loop]
    End If
    'Display the conversion in the Other textbox
    Print #main.tb1, Using("####.#",Str$(a * 9/5 + 32)) 
    Wait

