'** 11/12/2002 5:56:51 PM
'** Tip of the Day
'By Kevin Bruce
'November 2002
'with the help of:
'-the LB Newsletter
'-the LB community
'-LB Workshop by Alyce Watson
' and of course a great programming language by Carl Gundel

'check for existanse of tip.ini in DefaultDir$
Dim info$(10, 10)
Files DefaultDir$, "tip.ini", info$(
    qtyFiles = Val(info$(0, 0))
    If qtyFiles = 0 Then ' create it
        'ProgInit entry
        Section$="ProgInit"
        Entry$="Startup"
        String$="YES"
        FileName$= DefaultDir$;"\tip.ini"

        CallDLL #kernel32, "WritePrivateProfileStringA", _
        Section$ As ptr, _
        Entry$ As ptr, _
        String$ As ptr, _
        FileName$ As ptr, _
        result As long

        'TipIndex entry
        Section$="TipIndex"
        Entry$="NextTip"
        String$="1"
        FileName$= DefaultDir$;"\tip.ini"

        CallDLL #kernel32, "WritePrivateProfileStringA", _
        Section$ As ptr, _
        Entry$ As ptr, _
        String$ As ptr, _
        FileName$ As ptr, _
        result As long

    Else ' read ProgInit data from it
        Section$="ProgInit"
        Entry$="Startup"
        FileName$=DefaultDir$;"\tip.ini"
        Default$ = "no name" + Chr$(0)
        SizeString=100
        ReturnString$=Space$(SizeString)+Chr$(0)

        CallDLL #kernel32, "GetPrivateProfileStringA", _
        Section$ As ptr, _
        Entry$ As ptr, _
        Default$ As ptr, _
        ReturnString$ As ptr, _
        SizeString As long, _
        FileName$ As ptr, _
        result As long

        Show$ = Left$(ReturnString$,result)
    End If

'if No Show At Startup then end
If Show$ = "NO" Then End

LoadBmp "cowabunga", "cowabungaSP.bmp"

    True = 1 : False = 0

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TextboxColor$    = "Green"

[WindowSetup]
    NoMainWin
    WindowWidth = 274 : WindowHeight = 202
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Graphicbox  #tip.graphicbox,-5,-5, 275, 183
Groupbox    #tip.group, "Did you know?", 5, 0, 190, 145
Button      #tip.close, "Close", [quit], UL, 190, 147, 70, 25
Checkbox    #tip.check, "Show At Startup",[checkbox.click],[checkbox.reset], 5, 150, 120, 20
Button      #tip.previous, "<",[previous],UL, 130, 147, 20, 25
Button      #tip.next, ">",[next],UL, 155, 147, 20, 25
Statictext  #tip.text, "", 8, 20, 182, 120

Open "Tip of the Day" For Window_nf As #tip

    Print #tip, "trapclose [quit]"
    Print #tip.graphicbox, "down; fill Buttonface; flush"
    Print #tip, "font ms_sans_serif 10"

    Open "comctl32.dll" For DLL As #cctl
    Call MakeTooltips hWnd(#tip)
    #tip.text, "!font courier_new 10"
    #tip.close "!setfocus"
    #tip.graphicbox "Getbmp back 0 0 275 183"
    #tip.graphicbox "background back"
    #tip.graphicbox "addsprite cowabunga cowabunga"
    #tip.graphicbox "spritexy cowabunga 200 50"
    #tip.graphicbox "drawsprites"
    #tip.graphicbox "Getbmp back 0 0 275 183"
    #tip.graphicbox "drawbmp back 0 0"
    #tip.graphicbox "Flush"

'check tip.ini for next tip
    Section$="TipIndex"
    Entry$="NextTip"
    FileName$=DefaultDir$;"\tip.ini"
    Default$ = "no name" + Chr$(0)
    SizeString=100
    ReturnString$=Space$(SizeString)+Chr$(0)

    CallDLL #kernel32, "GetPrivateProfileStringA", _
    Section$ As ptr, _
    Entry$ As ptr, _
    Default$ As ptr, _
    ReturnString$ As ptr, _
    SizeString As long, _
    FileName$ As ptr, _
    result As long

    TipNumber = Val(Left$(ReturnString$,result))

'check for existanse of tip.txt in DefaultDir$
    Dim info$(10, 10)
    Files DefaultDir$, "tip.txt", info$(
    qtyFiles = Val(info$(0, 0))
    If qtyFiles = 0 Then 
        Notice "No tip data found!"
        GoTo [quit]
    End If


'read tip from tip.dat
    Open DefaultDir$;"\tip.txt" For Input As #readfile
    'read to find out the number entries in file to dim the array
    While Eof(#readfile) = 0
        Line Input #readfile, line$
        If line$ = "\tipend" Then TotalTips = TotalTips + 1
    Wend
    Close #readfile
    Dim Tip$(TotalTips)
    'read tip data into array
    Open DefaultDir$;"\tip.txt" For Input As #readfile
    For i = 1 to TotalTips
        Line Input #readfile, line$
        While line$ <> "\tipend"
            Tips$(i)= Tips$(i) + line$ + Chr$(13)
            Line Input #readfile, line$
        Wend
    Next i
    Close #readfile
'display tip
    #tip.text, Tips$(TipNumber)

    #tip.check, "set"
    GoTo [checkbox.click]

[loop]
    Wait

[quit]
    'write to tip.ini for next tip number
    TipNumber = TipNumber + 1
    If TipNumber > TotalTips Then TipNumber = 1
    Section$="TipIndex"
    Entry$="NextTip"
    String$=Str$(TipNumber)
    FileName$= DefaultDir$;"\tip.ini"

    CallDLL #kernel32, "WritePrivateProfileStringA", _
    Section$ As ptr, _
    Entry$ As ptr, _
    String$ As ptr, _
    FileName$ As ptr, _
    result As long

    UnloadBmp "back"
    UnloadBmp "cowabunga"
    Close #cctl
    Close #tip : End

[previous]
    TipNumber = TipNumber - 1
    If TipNumber <= 0 Then TipNumber = TotalTips
    #tip.text, Tips$(TipNumber)
    GoTo [loop]

[next]
    TipNumber = TipNumber + 1
    If TipNumber > TotalTips Then TipNumber = 1
    #tip.text, Tips$(TipNumber)
    GoTo [loop]

[checkbox.click]
    Print #tip.check, "value? result$"
    'write to tip.ini TO show on startup
        Section$="ProgInit"
        Entry$="Startup"
        String$="YES"
        FileName$= DefaultDir$;"\tip.ini"

        CallDLL #kernel32, "WritePrivateProfileStringA", _
        Section$ As ptr, _
        Entry$ As ptr, _
        String$ As ptr, _
        FileName$ As ptr, _
        result As long
    GoTo [loop]

[checkbox.reset]
    'write to tip.ini to NOT show on startup
        Section$="ProgInit"
        Entry$="Startup"
        String$="NO"
        FileName$= DefaultDir$;"\tip.ini"

        CallDLL #kernel32, "WritePrivateProfileStringA", _
        Section$ As ptr, _
        Entry$ As ptr, _
        String$ As ptr, _
        FileName$ As ptr, _
        result As long
    GoTo [loop]

Sub MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    CallDLL #cctl,"InitCommonControls", re As void
    CallDLL #user32, "GetWindowLongA", hWin As long, _GWL_HINSTANCE As long, hInstance As long
    CallDLL #user32, "CreateWindowExA", _WS_EX_TOPMOST As long,"tooltips_class32" As ptr, "" As ptr,_
        style As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long,_
        hWin As long, 0 As long, hInstance As long, "" As ptr, hwndTT As long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    CallDLL #user32, "SetWindowPos", hwndTT As long,_HWND_TOPMOST As long, 0 As long, 0 As long, 0 As long, 0 As long, flags As long, r As long

    'create a struct for the tooltips:
    struct toolinfo, cbSize As long, uFlags As long, hWindow As long, uId As long, x As long, y As long, w As long, h As long, hInst As long, lpstrText$ As ptr
    toolinfo.cbSize.struct = Len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#tip.previous)
    toolinfo.lpstrText$.struct = "Previous Tip"  '*** CHANGE TOOLTIP TEXT HERE!
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#tip.next)
    toolinfo.lpstrText$.struct = "Next Tip"  '*** CHANGE TOOLTIP TEXT HERE!
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Textbox Tooltip:
    toolinfo.uId.struct = hWnd(#tip.graphicbox)
    toolinfo.lpstrText$.struct = "A Tip of the Day - keeps ignorance at bay"  '*** CHANGE TOOLTIP TEXT HERE!
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Checkbox Tooltip:
    toolinfo.uId.struct = hWnd(#tip.check)
    toolinfo.lpstrText$.struct = "Un check to stop seeing this window"  '*** CHANGE TOOLTIP TEXT HERE!
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

    End Sub

