''''''''''''''''''''''''''''''''''''''
'  Liberty Basic Simple Help (LBSH)  '
'  Version 1 by Tom Nally            '
'  Copyright 2002                    '
'  Steelweaver52@aol.com             '
'                                    '
'  Released as open source           '
'                                    '
'  Made with Liberty Basic           '
'  Made with Liberty Basic Workshop  '
'                                    '
'  Special thanks to Alyce for       '
'  interface assistance!             '
''''''''''''''''''''''''''''''''''''''

'''''''''''''''Begin Section 1''''''''''''''''''''''''''''
'Where do you place Section 1 in your own programs?
'Section 1 is the initialization section, so it
'will most likely be placed at the top of your
'source file.

'Liberty Basic Simple Help (LBSH) Settings
'*******************************************************

TabSpaces$ = "  "             'The TabSpaces$ variable is used to place blank
                              'spaces in front of text lines.  This helps improve
                              'the appearance of your help articles once they are
                              'displayed when LBSH activates.  I find that 2-4
                              'spaces in front of a text line provides a nice
                              'appearance.

WrapLength = 50               'The WrapLength is the maximum number of characters
                              'that LBSH will display before it wraps the line.
                              'LBSH attempts to find the last space character
                              'prior to the WrapLength (inclusive) and breaks
                              'the line at that location.

LBSHFontIndex = 1             'The LBSHFontIndex is the index of the font that
                              'you would like to use to display your Help articles.
                              'The index is associated with a member of the
                              'LBSHfont$() array defined below.  An index value of
                              '1 produces a Courier New font at 10 points.
                              'Help authors may provide any fonts that work for them.

LastHelpArticleIndex = 13     'LastHelpArticleIndex essentially tells the program
                              'how many help articles there are.  That way, when
                              'your user navigates to the last article and presses
                              'the "Next" button, the program knows to wrap around
                              'to the first article.

Dim LBSHfont$(6)

LBSHfont$(1) = "!font courier_new 10"
LBSHfont$(2) = "!font courier_new 12"
LBSHfont$(3) = "!font arial 10"
LBSHfont$(4) = "!font arial 12"
LBSHfont$(5) = "!font times_new_roman 10"
LBSHfont$(6) = "!font times_new_roman 12"

'Other Variables....
TextEdHomeX = 15
TextEdOffWX = 2000


'LBSH Article Titles
'These titles will appear in the ComboBox near the
'the top of the LBSH window.  For every title
'listed, there must be a unique article provided
'by the Help Author.
'*******************************************************
Dim HelpArtTitle$(40)
HelpArtTitle$(1)   = "What is 'Liberty Basic Simple Help' (LBSH)?"
HelpArtTitle$(2)   = "What does LBSH look like?"
HelpArtTitle$(3)   = "Why are LBSH Help documents referred to as 'articles'?"
HelpArtTitle$(4)   = "How do I create LBSH's help articles?"
HelpArtTitle$(5)   = "What extension should I give my help article filenames?"
HelpArtTitle$(6)   = "In what folder should my Help articles reside?"
HelpArtTitle$(7)   = "Do I have to manually wrap my text lines?"
HelpArtTitle$(8)   = "I don't see paragraph breaks in my articles in LBSH!"
HelpArtTitle$(9)   = "What are LBSH's four settings? "
HelpArtTitle$(10)  = "How do I use LBSH in my own programs?"
HelpArtTitle$(11)  = "When I close LBSH, my whole program closes!"
HelpArtTitle$(12)  = "What are the advantages and disadvantages of LBSH?"
HelpArtTitle$(13)  = "Can I freely use LBSH?"


'LBSH Help File Names
'The array below contains the list of Help Article
'filenames.  For every filename below, there must
'be a corresponding article title in the array above.
'In addition, the file names listed in the array
'below must match the filenames on disk exactly.
'*******************************************************
Dim HelpFileName$(40)

HelpFileName$(1)   = "LBSH01.txt"
HelpFileName$(2)   = "LBSH02.txt"
HelpFileName$(3)   = "LBSH03.txt"
HelpFileName$(4)   = "LBSH04.txt"
HelpFileName$(5)   = "LBSH05.txt"
HelpFileName$(6)   = "LBSH06.txt"
HelpFileName$(7)   = "LBSH07.txt"
HelpFileName$(8)   = "LBSH08.txt"
HelpFileName$(9)   = "LBSH09.txt"
HelpFileName$(10)  = "LBSH10.txt"
HelpFileName$(11)  = "LBSH11.txt"
HelpFileName$(12)  = "LBSH12.txt"
HelpFileName$(13)  = "LBSH13.txt"

'''''''''''''''''End Section 1''''''''''''''''''''''''''''


'''''''''''''''''Begin Section 2''''''''''''''''''''''''''
[InitColors]
    ForegroundColor$ = "Black"             'Where should you place Section 2 in your program?
    BackgroundColor$ = "Buttonface"        'Place it as the branch label indicated by
    TexteditorColor$ = "White"             'your Help command.  For instance, if select
    TextboxColor$    = "White"             '"Help" from your menu points to [My.Programs.Help],
    ComboboxColor$   = "White"             'then Section 2 needs to go there.
    ListboxColor$    = "White"

[WindowSetup]
    NoMainWin
    WindowWidth = 500 : WindowHeight = 480
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu #SimHelp, "File", "Exit", [CloseHelp.click]

Statictext  #SimHelp.StatText01, "Select Help Article:", 15, 5, 150, 20
Button      #SimHelp.btnPrev, "<--- Previous",[btnPrev.click],UL, 15, 390, 105, 30
Button      #SimHelp.btnNext, "Next --->",[btnNext.click],UL, 125, 390, 105, 30
Button      #SimHelp.CloseHelp, "Close",[CloseHelp.click],UL, 370, 390, 105, 30
Texteditor  #SimHelp.EditBox, TextEdHomeX, 65, 460, 310
Texteditor  #SimHelp.hide,    TextEdOffWX, 65, 460, 310
Combobox    #SimHelp.cboHelp,HelpArtTitle$(,[cboArticleTitles.click], 15, 30, 460, 160

Open "Liberty Basic Simple Help" For Window As #SimHelp

    Print #SimHelp, "trapclose [CloseHelp.click]"
    Print #SimHelp, "font arial 10"
    Print #SimHelp.EditBox, LBSHfont$(LBSHFontIndex)

    GoSub [Initialize.Help.System.Controls]

[loop]
    Wait

[quit]
    Close #SimHelp
    End

[Initialize.Help.System.Controls]

    HelpArticleIndex = 1
    Print #SimHelp.cboHelp, "selectindex "; HelpArticleIndex

    HelpFile2Open$ = HelpFileName$(HelpArticleIndex)

    GoSub [Move.TextEditor.Off.Window]

    Open HelpFile2Open$ For Input As #1
    While Eof(#1) = 0
    Line Input #1, HelpTextLine$
        While (Len(HelpTextLine$) > 0)
            SpacePosition = CharacterPosition(HelpTextLine$, WrapLength, " ")
            Print #SimHelp.EditBox, TabSpaces$ + Left$(HelpTextLine$, SpacePosition)
            LengthRemainingText = (Len(HelpTextLine$) - SpacePosition)
            HelpTextLine$ = Right$(HelpTextLine$, LengthRemainingText)
        Wend
    Wend
    Close #1

    Print #SimHelp.EditBox, "!origin 1 1"

    GoSub [Move.TextEditor.Back.To.Window]

    Return

[cboArticleTitles.click]

    Print #SimHelp.cboHelp, "selectionindex? HelpArticleIndex"

    HelpFile2Open$ = HelpFileName$(HelpArticleIndex)

    GoSub [Move.TextEditor.Off.Window]

    Print #SimHelp.EditBox, "!cls"

    Open HelpFile2Open$ For Input As #1
    While Eof(#1) = 0
    Line Input #1, HelpTextLine$
        While (Len(HelpTextLine$) > 0)
            SpacePosition = CharacterPosition(HelpTextLine$, WrapLength, " ")
            Print #SimHelp.EditBox, TabSpaces$ + Left$(HelpTextLine$, SpacePosition)
            LengthRemainingText = (Len(HelpTextLine$) - SpacePosition)
            HelpTextLine$ = Right$(HelpTextLine$, LengthRemainingText)
        Wend
    Wend
    Close #1

    Print #SimHelp.EditBox, "!origin 1 1"

    GoSub [Move.TextEditor.Back.To.Window]

    Wait

[btnPrev.click]

    HelpArticleIndex = (HelpArticleIndex - 1)
    If (HelpArticleIndex = 0) Then
        HelpArticleIndex = LastHelpArticleIndex
    End If

    Print #SimHelp.cboHelp, "selectindex "; HelpArticleIndex

    HelpFile2Open$ = HelpFileName$(HelpArticleIndex)

    GoSub [Move.TextEditor.Off.Window]

    Print #SimHelp.EditBox, "!cls"

    Open HelpFile2Open$ For Input As #1
    While Eof(#1) = 0
    Line Input #1, HelpTextLine$
        While (Len(HelpTextLine$) > 0)
            SpacePosition = CharacterPosition(HelpTextLine$, WrapLength, " ")
            Print #SimHelp.EditBox, TabSpaces$ + Left$(HelpTextLine$, SpacePosition)
            LengthRemainingText = (Len(HelpTextLine$) - SpacePosition)
            HelpTextLine$ = Right$(HelpTextLine$, LengthRemainingText)
        Wend
    Wend
    Close #1

    Print #SimHelp.EditBox, "!origin 1 1"

    GoSub [Move.TextEditor.Back.To.Window]

    Wait

[btnNext.click]

    HelpArticleIndex = (HelpArticleIndex + 1)
    If (HelpArticleIndex = (LastHelpArticleIndex + 1)) Then
        HelpArticleIndex = 1
    End If

    Print #SimHelp.cboHelp, "selectindex "; HelpArticleIndex

    HelpFile2Open$ = HelpFileName$(HelpArticleIndex)

    GoSub [Move.TextEditor.Off.Window]

    Print #SimHelp.EditBox, "!cls"

    Open HelpFile2Open$ For Input As #1
    While Eof(#1) = 0
    Line Input #1, HelpTextLine$
        While (Len(HelpTextLine$) > 0)
            SpacePosition = CharacterPosition(HelpTextLine$, WrapLength, " ")
            Print #SimHelp.EditBox, TabSpaces$ + Left$(HelpTextLine$, SpacePosition)
            LengthRemainingText = (Len(HelpTextLine$) - SpacePosition)
            HelpTextLine$ = Right$(HelpTextLine$, LengthRemainingText)
        Wend
    Wend
    Close #1

    Print #SimHelp.EditBox, "!origin 1 1"

    GoSub [Move.TextEditor.Back.To.Window]

    Wait


[CloseHelp.click]

    Close #SimHelp : End


[Move.TextEditor.Off.Window]

    Print #SimHelp.EditBox, "!locate "; TextEdOffWX; " 65 460 310"
    Print #SimHelp.hide, "!locate "; TextEdHomeX; " 65 460 310"
    Print #SimHelp, "refresh"
    GoSub [Pause.Just.A.Moment]

Return


[Move.TextEditor.Back.To.Window]

    Print #SimHelp.hide, "!locate "; TextEdOffWX; " 65 460 310"
    Print #SimHelp.EditBox, "!locate "; TextEdHomeX; " 65 460 310"
    Print #SimHelp, "refresh"

Return


[Pause.Just.A.Moment]              'This routine merely creates a half-second
                                   'pause before restoring the TextEditor control
    Timer 400, [End.Of.Pause]      'to the center of the Window.  While it may
    Wait                           'seem silly or unnecessary, it does help
                                   'reduce the sence of chaos that arises when
    [End.Of.Pause]                 'a new article is displayed.
    Timer 0

Return

'''''''''''''''''End Section 2''''''''''''''''''''''''''''





'''''''''''''''''Begin Section 3''''''''''''''''''''''''''

Function CharacterPosition(SomeText$, EvalLength, Char01$)

    CharacterPosition = 9999

    If (Len(SomeText$) <= EvalLength) Then                      'Where should Section 3 be placed in your programs.
        CharacterPosition = Len(SomeText$)                      'Section 3 consists exclusively of this user-defined
    Else                                                        'function, CharacterPosition().  So, Section 3 should
        For i = 0 to (EvalLength - 1)                           'either be placed at the end of your source code, or
            TestChar$ = Mid$(SomeText$, (EvalLength - i), 1)    'wherever you place your other user-defined functions.
            If (TestChar$ = Char01$) Then
                CharacterPosition = (EvalLength - i)
                i = (EvalLength - 1)
            End If
        Next i
    End If

    If (CharacterPosition = 9999) Then
        CharacterPosition = EvalLength
    End If

End Function

'''''''''''''''''End Section 3''''''''''''''''''''''''''''

