
'** Platform for Tip-Of-The-Day
''''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''
' The menu item 'Show' is disabled and enabled as
' appropriate so that only one instance of the
' "Tip of the Day" can run.
''''''''''''''''''''''''''''''''''''''''''''''''''
' modified rmf (16.11.2002)
[InitColors]
ForegroundColor$ = "Black"
BackgroundColor$ = "Buttonface"
TexteditorColor$ = "White"
TextboxColor$ = "White"
ComboboxColor$ = "White"
ListboxColor$ = "White"

[WindowSetup]
NoMainWin
WindowWidth = 275 : WindowHeight = 320
UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Statictext #main.static1, "My Tip-Of-The-Day Demonstration!", 30,  95, 230, 20
statictext #main.static2, "r.m.fisher (16.11.2002)",          60, 135, 200, 20
statictext #main.static2, "rmfisher@talk21.com",              63, 165, 200, 20
Button     #main.btnExit, "Exit",[Exit.App], UL,              90, 235,  80, 25
menu       #main, "Tip of the Day", "Show", [tip]
' Use menu to show tipofday if not shown
' on startup or after it was closed.

Open "Platform for Tip-Of-The-Day" For Window As #main

Print #main, "trapclose [Exit.App]"
Print #main, "font arial 10"
''''''''''''''''''''''''''''''''''''''''''''''''
' This section required for enabling or disabling
' the menu item that is used to call TOTD
hMain = hwnd(#main)
calldll #user32, "GetMenu", _
  hMain    as long,_ 'handle of window
  hMenuBar as long   'returns handle of MENU BAR
calldll #user32, "GetSubMenu", _
  hMenuBar as long,_   'handle of MENU BAR
  0        as long,_   'position:0 = first, 1 = second, etc.
  hSubMenu as long     'handle of submenu
calldll #user32, "GetMenuItemID", _
  hSubMenu as long, _   'handle of the submenu
  0        as long, _   'position of the menu item
  menu.id  as long      'the handle (or ID) of the menu item
'1 = disable 0 = enabled
enable  = 0
disable = 1
''''''''''''''''''''''''''''''''''''''''''''''''
' retrieve whether check box was "set" or "reset"
open "set.ini" for input as #1
  input #1, flag$
close #1
if flag$ = "set" then
  ' Disable menu item so that a second
  ' instance cannot be  called.
  calldll #user32, "EnableMenuItem", _
    hSubMenu as long,_  'handle of SubMenu
    menu.id  as long,_   'ID of menu item
    disable  as long,_
    ret     as boolean  'returns previous state of menu item
  run "tipofday.tkn"
end if
'Since Tips of the Day usually appear after
'the main window of an application has been
'opened, your TOTD mini-app should probably
'be called from this location
''''''''''''''''''''''''''''''''''''''''''''''''
[pre.loop]
' When TOTD is closed, enable menu item
' so that TOTD can be called again.
calldll #user32, "EnableMenuItem", _
  hSubMenu as long,_  'handle of SubMenu
  menu.id as long,_   'ID of menu item
  enable  as long,_
  ret     as boolean  'returns previous state of menu item
[loop]
wait

[tip]
' Use menu to show tipofday if not shown
' on startup or after it was closed.
' Disable menu item so that a second
' instance cannot be  called.
calldll #user32, "EnableMenuItem", _
  hSubMenu as long,_    'handle of SubMenu
  menu.id  as long,_    'ID of menu item
  disable  as long,_
  ret      as boolean   'returns previous state of menu item
run "tipofday.tkn"
goto [pre.loop]

[Exit.App]
Close #main : End

