' set up the main structure for communication with the database

' based on the following, from the Tsunami documentation
' Dim Tsu As TRMtype
' Tsu.op 
' Tsu.file 
' Tsu.dataptr 
' Tsu.datalen 
' Tsu.keyptr 
' Tsu.keylen 
' Tsu.keyno 
' Result& 


struct Tsu , _
op as long, _
file as long, _
dataptr$ as PTR, _
datalen as long, _
keyptr$ as PTR, _
keylen as long, _
keyno as long

dim error$(1)
dim error(1)
dim errorlist$(100)
dim maxstring$(1)
maxstring(1) = 200
call loaderrorlist
'================The end of set up for database

open "trm.dll" for dll as #tzunami

notice " trm.dll opened "
dbHandle = opendb("newfile2.dat",0)
print error$(1)
notice "database opened"
 result$ = GetFirst$(dbHandle , 1 )
 print error$(1)
print result$
numrecs = count(dbHandle)
print "we have "; numrecs ; " records"
for x = 2 to numrecs
result$ = GetNext$(dbHandle)
print error$(1)
print " record "; x ; " " ; result$
next x
notice "end of get and next things"

' result = delete(dbHandle)
' print error$(1)
' result = count(dbHandle)
' print "number of records now is "; result
' print error$(1)
result = closedb(dbHandle )
print error$(1)


close #tzunami
notice "the end of code"
stop

'====== opcode 0 - open the database ==========
function opendb(datafile$, usermode)
Tsu.op.struct = 0 
Tsu.keyptr$.struct = datafile$
Tsu.keylen.struct = len(datafile$)
Tsu.keyno.struct = usermode	
calldll #tzunami , "trm_udt", Tsu as struct, result as long
dbHandle = Tsu.file.struct
error(1) = result
error$(1) = errorlist$(result)
opendb = dbHandle
end function

'======= opcode 1 - close database =============
function closedb(dbHandle)
 Tsu.op.struct = 1 ' the open code
 Tsu.file.struct = dbHandle
 
calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
closedb = result
end function

'======= opcode 2 - insert record  ===============
function insert(dbHandle, recordstring$)
Tsu.op.struct = 2
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = recordstring$
Tsu.datalen.struct = len(recordstring$)
 
calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
insert = result 
end function

'========= opcode 3 - update record =============
function update(dbHandle , recordstring$ )
Tsu.op.struct = 3
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = recordstring$
Tsu.datalen.struct = len(recordstring$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
update= result 
end function

'========= opcode 4 - delete record =============
function delete( dbHandle )
Tsu.op.struct = 4
Tsu.file.struct = dbHandle

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
delete = result 
end function

'========= opcode 5 - get equal record =============

function GetEqual$( dbHandle, KeyNo, KeyVal$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 5
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = KeyVal$
Tsu.keylen.struct = len(KeyVal$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetEqual$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function
'========= opcode 6 - get next record =============
function GetNext$( dbHandle)
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 6
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetNext$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function


'========= opcode 7 - get previous record =============
function GetPrev$( dbHandle)
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 7
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
Getprev$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 8 - get greater record =============
function GetGreater$( dbHandle, KeyNo, KeyVal$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 8
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = KeyVal$
Tsu.keylen.struct = len(KeyVal$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetGreater$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 9 - get equal or greater record ====
function GetEqualorGreater$( dbHandle, KeyNo, KeyVal$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 9
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = KeyVal$
Tsu.keylen.struct = len(KeyVal$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetEqualorGreater$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 10 - get less record =============
function GetLess$( dbHandle, KeyNo, KeyVal$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 10
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = KeyVal$
Tsu.keylen.struct = len(KeyVal$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetLess$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 11 - get equal or less record ====
function GetEqualorLess$( dbHandle, KeyNo, KeyVal$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 11
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = KeyVal$
Tsu.keylen.struct = len(KeyVal$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetEqualorLess$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 12 - get first record =============
function GetFirst$( dbHandle, KeyNo )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 12
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetFirst$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 13 - get last record =============
function GetLast$( dbHandle, KeyNo )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 13
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetLast$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct )
end function

'========= opcode 14 - create record =============

function createdatabase(file$, definition$, overwrite )

Tsu.op.struct = 14
Tsu.dataptr$.struct = definition$
Tsu.datalen.struct = len(definition$)
Tsu.keyptr$.struct = file$
Tsu.keylen.struct = len(file$)
Tsu.keyno.struct = overwrite

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
createdatabase = result
end function

'========= opcode 16 - file is open =============
function fileisopen( dbHandle )
Tsu.op.struct = 16 
Tsu.file.struct = dbHandle

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
fileisopen = result
end function

'========= opcode 17 - count records =============
function count( dbHandle )
Tsu.op.struct = 17 
Tsu.file.struct = dbHandle

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
count = Tsu.keyno.struct
end function

'========= opcode 18 - filesize  =============
function filesize( dbHandle )
Tsu.op.struct = 18 
Tsu.file.struct = dbHandle

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
filesize = Tsu.keyno.struct
end function


'========= opcode 22 - get position =============
function GetPosition$( dbHandle, modifier )
recordptr$ = space$(20) + chr$(0)

Tsu.op.struct = 22
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = recordptr$
Tsu.datalen.struct = len(recordptr$)
Tsu.keyno.struct = modifier 

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetPosition$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 23 - get direct record =============
function GetDirect$( dbHandle, recordpointer$ )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 23
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)
Tsu.keyptr$.struct = recordpointer$
Tsu.keylen.struct = len(recordpointer$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
GetDirect$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 24 - step next record =============
function StepNext$( dbHandle )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 24
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
StepNext$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 25 - get file version =============
function getFileVer$( dbHandle)
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 25
Tsu.file.struct = dbHandle 
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
getFileVer$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 26 - get tsunami version ====
function Version( dummy )

Tsu.op.struct = 26

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
Version =  Tsu.keyno.struct
end function

'========= opcode 28 - close all databases ====

function closeall( dummy )
Tsu.op.struct = 28 
calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
closeall = result
end function
'========= opcode 29 - flush databases =============
function flush( dummy )
Tsu.op.struct = 29 
calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
flush = result
end function

'========= opcode 30 - set key path =============
function SetKeyPath( dbHandle, KeyNo )

Tsu.op.struct = 30
Tsu.file.struct = dbHandle
Tsu.keyno.struct = KeyNo

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
SetKeyPath = result
end function

'========= opcode 31 - timeout function =============
function TimeOut( timeLimit )

Tsu.op.struct = 31
Tsu.keyno.struct = timeLimit

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
TimeOut = result
end function

'========= opcode 32 - accellerate access ============

function accellerate( dbHandle, accval )
Tsu.op.struct = 32
Tsu.file.struct = dbHandle 
Tsu.keyno.struct = accval 	

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
accellerate = result
end function

'========= opcode 33 - step first =============
function StepFirst$( dbHandle )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 33
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
StepFirst$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 34 - step last =============
function StepLast$( dbHandle )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 34
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
StepLast$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 35 - step previous  =============
function StepPrev$( dbHandle )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 35
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
StepPrev$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 36 - get file definition ========
function getFileDef$( dbHandle)
record$ = space$(1000) + chr$(0)


Tsu.op.struct = 36
Tsu.file.struct = dbHandle 
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
getFileDef$ = left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 37 - database integrity =============
function Integrity( dbHandle)

Tsu.op.struct = 37
Tsu.file.struct = dbHandle 

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
Integrity = result
end function

'========= opcode 38 - rebuild database =============
function Rebuild(NewFile$, Filedef$)

Tsu.op.struct = 38
Tsu.file.struct = 0
Tsu.dataptr$.struct = Filedef$
Tsu.datalen.struct = len(Filedef$)
Tsu.keyptr$.struct = NewFile$
Tsu.keylen.struct = len(NewFile$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
Rebuild = result
end function

'========= opcode 39 - recover database =============

Function Recover(SourceFile$, TargetFile$, Pagesize, Compression )

Tsu.op.struct = 39
Tsu.file.struct = Pagesize
Tsu.dataptr$.struct = TargetFile$
Tsu.datalen.struct = len(TargetFile$)
Tsu.keyptr$.struct = SourceFile$
Tsu.keylen.struct = len(SourceFile$)
Tsu.keyno.struct = Compression

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
Recover = result
end function
'========= opcode 44 - get by key position  =========
function GetByKeyPos$(dbHandle, KeyPos )
record$ = space$(maxstring(1)) + chr$(0)

Tsu.op.struct = 44
Tsu.file.struct = dbHandle
Tsu.dataptr$.struct = record$
Tsu.datalen.struct = len(record$)

calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
getcurrkeypos$ =left$(winstring(Tsu.dataptr$.struct),Tsu.datalen.struct)
end function

'========= opcode 45 - current key position ========
function getCurrKeyPos(dbHandle)
Tsu.op.struct = 45
Tsu.file.struct = dbHandle 
 	
calldll #tzunami , "trm_udt", Tsu as struct, result as long
error(1) = result
error$(1) = errorlist$(result)
getCurrKeyPos = Tsu.keyno.struct
end function


'===========end of individual calls ======================

function geterror$( errorno )
error$(1)=errorlist$(errorno)
geterror$=error$(1)
end function

sub loaderrorlist

errorlist$(0) = "operation successful"
errorlist$(1) = "not a tsunami file"
errorlist$(2) = "I/O error"
errorlist$(3) = "file not opened"
errorlist$(4) = "key not found"
errorlist$(5) = "duplicate key"
errorlist$(6) = "invalid key"
errorlist$(7) = "file corrupt"
errorlist$(8) = "no current position"
errorlist$(9) = "end of file"
errorlist$(10) = "invalid page size"
errorlist$(11) = "invalid number of key segments"
errorlist$(12) = "invalid file definition string"
errorlist$(13) = "invalid key segment position"
errorlist$(14) = "invalid key segment length"
errorlist$(15) = "inconsistent key segment definitions"
errorlist$(20) = "invalid record length"
errorlist$(21) = "invalid record address"
errorlist$(22) = "lost record position"
errorlist$(30) = "access denied"
errorlist$(31) = "file already exists"
errorlist$(32) = "no more file handles"
errorlist$(33) = "maximum number of files open"
errorlist$(40) = "accelerated access denied"
errorlist$(41) = "acceleration cache error"
errorlist$(46) = "access to file denied"
errorlist$(50) = "data buffer too small"
errorlist$(99) = "time-out"

loaderrorlist$= "error strings loaded"
end sub













