
''''''''''''''''''''''''''''''''''''
' Accelerating Donuts              '
' Copyright December 2002          '
' by Tom Nally                     '
' Steelweaver52@aol.com            '
''''''''''''''''''''''''''''''''''''
' Released as Open Source          '
''''''''''''''''''''''''''''''''''''
' Made with Liberty Basic          '
'    by Carl Gundel                '
''''''''''''''''''''''''''''''''''''
' Mady with Liberty Basic Workshop '
'    by Alyce Watson               '
''''''''''''''''''''''''''''''''''''
' Made with Microsoft Paint and    '
' Microsoft Excel                  '
'   by Microsoft                   '
''''''''''''''''''''''''''''''''''''


    True = 1 : False = 0
        EnableSounds = 0
       ReturnToStart = 1

    LoadBmp "Bkgnd1", "DonutBkgnd.bmp"
    LoadBmp "DonutVan", "DonutVan.bmp"
    LoadBmp "RollAbout", "RollAbout.bmp"

Dim Acc(30)
Dim Acc$(30)

For i = 1 to 30
    Acc(i) = i
    Acc$(i)  = Str$(i) + " ft/sec^2"
Next i

Dim GSysDelay(11)
Dim GSysDelay$(11)

For i = 1 to 11
    GSysDelay(i) = (i - 1) * 5
Next i

GSysDelay$(1) = "11 - Fastest"
GSysDelay$(2) = "10"
GSysDelay$(3) = "9"
GSysDelay$(4) = "8"
GSysDelay$(5) = "7"
GSysDelay$(6) = "6"
GSysDelay$(7) = "5"
GSysDelay$(8) = "4"
GSysDelay$(9) = "3"
GSysDelay$(10) = "2"
GSysDelay$(11) = "1 - Slowest"

GSSDelayIndex = 1
GSSDelay = GSysDelay(GSSDelayIndex)



Dim TruckX(2000)
Dim TruckV(2000)

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NoMainWin
    WindowWidth = 810 : WindowHeight = 399
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]


Graphicbox  #main.GBox1, 13, 10, 774, 279
Statictext  #main.statictext1, "Set Acceleration:", 10, 300, 105, 20
Statictext  #main.statictext2, "time, sec", 382, 300, 60, 20
Statictext  #main.statictext3, "x, feet", 452, 300, 55, 16
Statictext  #main.statictext4, "v, ft/s", 517, 300, 45, 20
Statictext  #main.statictext6, "Enable", 135, 300, 45, 20
BmpButton   #main.Deliver, "GloSpeed.bmp",[Global.Sys.Delay.Click],UL, 185, 300
BmpButton   #main.Deliver, "DelivDon.bmp",[Deliver.click],UL, 295, 300
BmpButton   #main.TruckBack, "SendBack.bmp",[TruckBack.click],UL, 572, 300
BmpButton   #main.btnQuick, "Quitbtn.bmp",[btnQuit.click],UL, 745, 300
BmpButton   #main.About, "RollCredits.bmp",[About.click],UL, 680, 300
Textbox     #main.txtTime, 377, 320, 60, 24
Textbox     #main.txtXfeet, 442, 320, 60, 24
Textbox     #main.velocity, 507, 320, 60, 24
Checkbox    #main.ckSounds, "Sounds",[ckSoundsON.click],[ckSoundsOFF.click], 115, 320, 70, 25
Combobox    #main.cboAccel, Acc$(,[cboAccel.click], 10, 320, 95, 300

Open "Accelerating Donuts" For Window As #main

    Print #main, "trapclose [btnQuit.click]"
    Print #main.GBox1, "down; fill White; flush"

    Print #main, "font arial 10"
    Print #main.GBox1, "background Bkgnd1"
    Print #main.GBox1, "addsprite DonutVan DonutVan"
    Print #main.GBox1, "spritexy DonutVan 16 198"
    Print #main.GBox1, "spritevisible DonutVan on"
    Print #main.GBox1, "addsprite RollAbout RollAbout"
    Print #main.GBox1, "spritexy RollAbout 256 284"
    Print #main.GBox1, "spritevisible RollAbout on"
    Print #main.GBox1, "drawsprites"

    GoSub [Initialize.All.Controls]

[loop]
    Wait

[Initialize.All.Controls]

    TruckX = 0
    AccIndex = 10
    Accel = Acc(AccIndex)
    Print #main.cboAccel, "selectindex "; AccIndex
    Print #main.ckSounds, "reset"
    EnableSounds = 0
    
    Print #main.txtTime,  " idle"
    Print #main.txtXfeet, " idle"
    Print #main.velocity, " idle"

    Return

[cboAccel.click]
    Print #main.cboAccel, "selectionindex? AccIndex"
    Accel = Acc(AccIndex)


    Wait



[Deliver.click]

    'If the rolling credits have been stopped in
    'mid-roll, then send them back to their
    'home position.
    GoSub [Send.Credits.To.Home.Position]

    'First, find truck position and velocity
    'for each time increment between x = 0
    'and x = 200.

    If (ReturnToStart = 0) Then
        Notice "Not too fast..." + Chr$(13) + _
               "Please back truck up to   " + Chr$(13) + _
               "starting postion before   " + Chr$(13) + _
               "delivering Donuts.        "
    End If
    If (ReturnToStart = 0) Then Wait

    TimeTil200ft = Sqr(401/Accel)

    Xcount = 0
    ReturnToStart = 0

    For t = 0 to TimeTil200ft step 0.05
        Xcount = Xcount + 1
        TruckX(Xcount) = (1/2) * Accel * t^2
        TruckV(Xcount) = Accel * t
    Next t

    LastXposition = TruckX(Xcount)
    LastVelocity = TruckV(Xcount)

    TimeTil400ft = (401 - LastXposition) / LastVelocity

    'Find truck position and velocity for
    'all time increments between
    'x = LastXposition and x = 400

    For t = 0 to TimeTil400ft step 0.05
        Xcount = Xcount + 1
        TruckX(Xcount) = LastXposition + LastVelocity * t
        TruckV(Xcount) = LastVelocity
    Next t

    LastXPosition2 = TruckX(Xcount)
    V02 = LastVelocity

    'Find the truck position and velocity
    'for the third leg of the donut run.

    For t = 0 to 100 step 0.05
        Xcount = Xcount + 1
        TruckX(Xcount) = LastXPosition2 + V02*(t) - (1/2) * Accel * t^2
        TruckV(Xcount) = V02 - Accel * t

        If ((TruckX(Xcount) >= 600) or (TruckV(Xcount) <= 0)) Then
            t = 100
        End If
    Next t


    If (EnableSounds = 1) Then
        PlayWave "carstart.wav", sync
    End If

    If (EnableSounds = 1) Then
        PlayWave "truck2a.wav", loop
        GoSub [Delay.A.While]
    End If

    i = 1
    [Continue.Forward.Van.Movement]
        Scan
        Print #main.GBox1, "spritexy DonutVan "; (TruckX(i) + 16); " 198"
        Print #main.GBox1, "drawsprites"
        Print #main.txtTime,  Using("###.#", (0.1 * i))
        Print #main.txtXfeet, Using("###.#", TruckX(i))
        Print #main.velocity, Using("###.#", TruckV(i))
        DelayingOperation = SystemDelay(GSSDelay)
        i = i + 1
    If (i <= Xcount) Then [Continue.Forward.Van.Movement]

    PlayWave ""
    Xcount = 0

    Wait

[TruckBack.click]

    'If the rolling credits have been stopped in
    'mid-roll, then send them back to their
    'home position.
    GoSub [Send.Credits.To.Home.Position]

    If (ReturnToStart = 1) Then
        Notice "Oops..." + Chr$(13) + _
               "Truck is already at the   " + Chr$(13) + _
               "starting postion.  No     " + Chr$(13) + _
               "need to back it up.       "
    End If

    If (ReturnToStart = 1) Then Wait

    Print #main.txtTime,  " idle"
    Print #main.txtXfeet, " idle"
    Print #main.velocity, " idle"


    If (EnableSounds = 1) Then
        PlayWave "truckhorn.wav", loop
    End If

    For i = 600 to 0 step -2.0
        Scan
        Print #main.GBox1, "spritexy DonutVan "; (i + 16); " 198"
        Print #main.GBox1, "drawsprites"
        DelayingOperation = SystemDelay(GSSDelay)
    Next i

    Print #main.GBox1, "spritexy DonutVan 16 198"
    Print #main.GBox1, "drawsprites"
    ReturnToStart = 1
    PlayWave ""

    Wait

[btnQuit.click]
    Close #main : End

    Wait

[About.click]
    
    i = 280
    [Continue.Rolling.Credits]
        Scan
        Print #main.GBox1, "spritexy RollAbout 256 "; Str$(i); " "
        Print #main.GBox1, "drawsprites"
        DelayingOperation = SystemDelay(GSSDelay)
        i = i - 1
    If (i >= -344) Then [Continue.Rolling.Credits]
   

    Print #main.GBox1, "spritexy RollAbout 256 284"

    Wait

[ckSoundsON.click]
    
    EnableSounds = 1
    Wait

[ckSoundsOFF.click]

    EnableSounds = 0
    Wait

[Global.Sys.Delay.Click]

    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

    NoMainWin
    WindowWidth = 200 : WindowHeight = 261
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

Statictext  #GSS.statictext1, "Set Global System Speed", 15, 10, 175, 20
Statictext  #GSS.statictext2, "A speed of 11, fastest, works well with 266mHz computers.  A speed of 1, slowest, works better with computers of 1gHz and above.", 15, 40, 165, 100
Button      #GSS.GSSCancel, "Cancel",[GSSCancel.click],UL, 15, 190, 75, 25
Button      #GSS.GSSOkay, "OK",[GSSOkay.click],UL, 95, 190, 75, 25
Combobox    #GSS.cboGSS, GSysDelay$(,[cboGSS.click], 15, 150, 125, 300

Open "Global System Speed" For Dialog As #GSS

    Print #GSS, "trapclose [GSSCancel.click]"
    Print #GSS, "font arial 10"
    Print #GSS.statictext1, "!font arial 10 underscore"
    GoSub [Initialize.GSS.Controls]

[GSS.loop]
    Wait

[Initialize.GSS.Controls]

    Print #GSS.cboGSS, "selectindex "; GSSDelayIndex
    GSSDelay = GSysDelay(GSSDelayIndex)
    
    Return


[GSSCancel.click]

    Close #GSS
    Wait

[GSSOkay.click]

    GSSDelayIndex = NewGSSDelayIndex
    GSSDelay = GSysDelay(GSSDelayIndex)
    
    Close #GSS
    Wait

[cboGSS.click]
    Print #GSS.cboGSS, "selectionindex? NewGSSDelayIndex"
    

    Wait


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Delay.A.While]

    Timer 750, [Delay.Is.Complete]
    Wait

    [Delay.Is.Complete]
    Timer 0

    Return

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
[Send.Credits.To.Home.Position]

    Print #main.GBox1, "spritexy RollAbout 256 284"
    Print #main.GBox1, "drawsprites"

    Return

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Function SystemDelay(TargetDelay)

    If (TargetDelay = 0) Then [Delay.Operation.Finished]
    
    StartTime = Time$("milliseconds")
    AccumulatedDelay = 0
    
    While (AccumulatedDelay < TargetDelay)
        AccumulatedDelay = (Time$("milliseconds") - StartTime)
    Wend
    
    [Delay.Operation.Finished]
    
    SystemDelay = 0

End Function
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''