'QuadClicks.bas  'demo for free use.
'Detect left mouse click within a quadrilateral (4-sided figure).
'A quad can be irregular (not necessarily rectangular).
'Complex figures can be made of several overlapping quads.
'Useful for odd-shaped bitmaps.

'Coordinates of the four corners of the quad are defined in a Data line.
'Any corner can be first and the others can be listed clockwise or
'  counter-clockwise, but define them consecutively (no jumping around).
'Bill Jennings,  Dec 2002.

    NoMainWin
    Dim a$(9) : Dim tuck(9)
    UpperLeftX=1 : UpperLeftY=1
    WindowWidth=680 : WindowHeight=480
    Statictext #w1.st1, "LEFT CLICK IN OR OUT OF THESE FIGURES",_
      180,12,300,30
    Statictext #w1.st2, "Non-rectangular quadrilaterals",60,54,200,30
    Statictext #w1.st3, "Four quads make an approximation of a doughnut",_
      350,40,200,30
    Statictext #w1.st4, "Try clicking in the doughnut hole!",_
      350,410,290,30
    Statictext #w1.st1f, "Figure 1",70,190,60,30
    Statictext #w1.st2f, "Figure 2",192,240,60,30
    Statictext #w1.st3f, "Figure 3",80,304,60,30
    Statictext #w1.st4f, "Figure 4",180,390,60,30
    Open Space$(52)+"QUADRILATERAL CLICKS" For Graphics_nsb As #w1
      Print #w1, "trapclose [quit]"
      GoSub [drawFigures]
  [loopW1]
    Print #w1, "when leftButtonDown [detectClick]"
    Scan
  GoTo [loopW1]

[quit]
    Close #w1 : End

[drawFigures]
'first word in Data line is the figure number, and the
'following words are coordinates x1,y1,x2,y2,x3,y3,x4,y4.
    Data "1 60 150 130 100 110 140 140 190"  'figure 1
    Data "2 180 150 210 190 190 230 250 200"  'figure 2
    Data "3 50 320 90 280 130 290 100 240"  'figure 3
    Data "4 170 330 200 380 250 320 210 350"  'figure 4
    Data "5 300 165 375 90 525 90 600 165"  'figure 5, quad 1
    Data "5 525 90 600 165 600 315 525 390"  'figure 5, quad 2
    Data "5 600 315 525 390 375 390 300 315"  'figure 5, quad 3
    Data "5 375 390 300 315 300 165 375 90"  'figure 5, quad 4
    numQuads=8
    For f=1 to numQuads
      Read a$ : a$(f)=a$
      GoSub [getCoordinates]

      '*** See if quad is tucked in at the side:
    sidetuck=1
    For j=1 to 4
      If x(j+1)<x(j) Then less=less+1 Else less=less-1
      If less<-1 or less>2 Then sidetuck=0
    Next j : less=0
    If sidetuck Then tuck(f)=1  '*** flag quad as side tucked.

      If f<5 Then Print #w1, "down; color red"
      If f=5 Then Print #w1, "color black; size 2"
      If f=6 Then Print #w1, "color blue"
      If f=7 Then Print #w1, "color pink"
      If f=8 Then Print #w1, "color green"
      For j=1 to 4
        Print #w1, "line ";x(j);" ";y(j);" ";x(j+1);" ";y(j+1)
      Next j
    Next f
    Print #w1, "place 450 240; color yellow; size 4"
    Print #w1, "circle 160"
    Print #w1, "circle 80"
  Return

[detectClick]
    inside=0
    For c=1 to numQuads
      a$=a$(c)
      figure=Val(Word$(a$,1))  '*** identify figure
      GoSub [detectInside]
      If inside Then
        If c<5 Then
          Notice "Inside figure ";c
        Else
          Notice "Inside figure ";figure;", quad ";c-4
        End If
        c=numQuads
      End If
    Next c
  GoTo [loopW1]

[getCoordinates]  'of quadrilateral
    For g=1 to 4
      x(g)=Val(Word$(a$,g*2))
      y(g)=Val(Word$(a$,g*2+1))
    Next g
    x(5)=x(1) : y(5)=y(1)  '*** complete quad for 4th check
  Return

[detectInside]  '*** see if click is within quadrilateral
    GoSub [getCoordinates]  '*** Quad side tucked?
    If tuck(c) Then GoSub [sideTucked] Else GoSub [noSideTuck]
  Return

[sideTucked]
    abvX=0 : outY=0
    For d=1 to 4  '*** compare mouse click to lines
        '*** check MouseY relative to line segment:
      If abs(y(d)-MouseY)+abs(y(d+1)-MouseY)>abs(y(d)-y(d+1)) Then
        outY=outY+1
        'skip checking MouseX if click is above or below line segment
      Else  '*** see if MouseY is above or below line segment:
          '*** avoid division by zero in function:
        If (y(d+1)-y(d))=0 Then y(d+1)=.0000000001
        xLine=xLine(x(d),y(d),x(d+1),y(d+1),MouseY)  '*** FUNCTION
        If MouseX<xLine Then abvX=abvX+1 Else abvX=abvX-1
          '*** MouseX is outside the line, else within
      End If
    Next d
    If abvX=0 Then inside=1  '*** inside boundaries
    If outY>2 Then inside=0  '*** not within figure
  Return

[noSideTuck]
    abvY=0 : outX=0
    For d=1 to 4  '*** compare mouse click to lines
        '*** check MouseX relative to line segment:
      If abs(x(d)-MouseX)+abs(x(d+1)-MouseX)>abs(x(d)-x(d+1)) Then
        outX=outX+1
        'skip checking MouseY if click is left or right of line segment
      Else  '*** see if MouseY is above or below line segment:
          '*** avoid division by zero in function:
        If (x(d+1)-x(d))=0 Then x(d+1)=.0000000001
        yLine=yLine(x(d),y(d),x(d+1),y(d+1),MouseX)  '*** FUNCTION
        If MouseY<yLine Then abvY=abvY+1 Else abvY=abvY-1
          '*** MouseY is above the line, else below
      End If
    Next d
    If abvY=0 Then inside=1  '*** inside boundaries
    If outX>2 Then inside=0  '*** not within figure
  Return
'----------------------------------------
Function yLine(x1,y1,x2,y2,xClick)
    yLine=(y2-y1)/(x2-x1)*(xClick-x1)+y1
  End Function

Function xLine(x1,y1,x2,y2,yClick)
    xLine=(x2-x1)/(y2-y1)*(yClick-y1)+x1
  End Function

