'DatePup32 Tester GUI
'written by Brad Moore
'Placed into the Public Domain on 10/15/2002
'This code is for Liberty Basic 3.x
'Find out more about Liberty Basic at http://www.libertybasic.com


'call sub to setup structs we will be using
Call SetupStructs

'An array to hold output
Dim Out$(20)

'An array to hold temparay output
Dim Temp$(10)

'InitColors
ForegroundColor$ = "Black"
BackgroundColor$ = "Buttonface"
TexteditorColor$ = "White"
TextboxColor$    = "White"
ComboboxColor$   = "White"
ListboxColor$    = "White"

'WindowSetup
NoMainWin
WindowWidth = 513
WindowHeight = 520
UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

'ControlSetup
Groupbox    #main.Results, "Results", 179, 50, 305, 390
Statictext  #main.stxt1, "Primary Input", 15, 15, 82, 20
Statictext  #main.stxt3, "Optional Input", 236, 15, 86, 20
Statictext  #main.Output, "Output Results here...", 195, 70, 270, 320
Button      #main.GJDa, "Get Julian (Adj)",[JulianAdj],UL, 15, 55, 145, 25
Button      #main.GGDa, "Get Greg Date (Adj)",[GregDateAdj],UL, 15, 85, 145, 25
Button      #main.GJD, "Get Julian Day",[JulianDay],UL, 15, 115, 145, 25
Button      #main.GGD, "Get Gregorian Date",[GregDate],UL, 15, 145, 145, 25
Button      #main.VD, "Validate Date",[ValidateDate],UL, 15, 175, 145, 25
Button      #main.LY, "is Leap Year",[isLeapYear],UL, 15, 205, 145, 25
Button      #main.DoW, "Day of Week",[DayWeek],UL, 15, 415, 145, 25
Button      #main.Info, "About DatePup32",[Info],UL, 15, 445, 145, 25
Button      #main.DSt, "Date Statistics",[DateStat],UL, 15, 325, 145, 25
Button      #main.WNS, "Week Num Stats",[WkNumStat],UL, 15, 355, 145, 25
Button      #main.DF, "Date Format",[DateFmt],UL, 15, 385, 145, 25
Button      #main.DA, "Date Add",[DateAdd],UL, 15, 235, 145, 25
Button      #main.quit, "Quit",[quit],UL, 340, 445, 145, 25
Button      #main.clear, "Clear Output",[clear],UL, 179, 445, 145, 25
Button      #main.DS, "Date Subtract",[DateSub],UL, 15, 265, 145, 25
Button      #main.DD, "Date Difference",[DateDif],UL, 15, 295, 145, 25
Button      #main.help, "?",[help],UL, 460, 10, 25, 25
Textbox     #main.tbx1, 98, 10, 130, 24
Textbox     #main.tbx2, 324, 10, 130, 24

Open "DatePup32 Tester GUI" For Window_nf As #main

    Print #main, "trapclose [quit]"
    Print #main, "font ms_sans_serif 10"
    print #main.help, "!font ariel 12 bold"

    Open "comctl32.dll" For DLL As #cctl
    Call MakeTooltips hWnd(#main)

[loop]
    Wait

[quit]
    Close #cctl
    Close #main
    End


[Info]
    Call Information
    GoTo [loop]

[JulianAdj]
    'Get the values from the input fields
    #main.tbx1 "!contents? date1$"
    #main.tbx2 "!contents? date2$"
    If date1$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value = GetDays(date1$)

    Temp$(1) = "Function: GetDays"
    Temp$(2) = "  Info: Returns adjusted JD from 1/1/1901"
    Temp$(3) = "  Input: " + date1$
    Temp$(4) = "  Result: " + Str$(value)

    Call Display 4

    GoTo [loop]


[GregDateAdj]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value$ = GetDate$(Val(valInput$))

    Temp$(1) = "Function: GetDate"
    Temp$(2) = "  Info: using JD returns an adjusted DATE"
    Temp$(3) = "        from 1/1/1901"
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Result: " + value$

    Call Display 5

    GoTo [loop]

[JulianDay]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value = GetJulian(valInput$)

    Temp$(1) = "Function: GetJulian"
    Temp$(2) = "  Info: Accepts date, returns a true Julian Date"
    Temp$(3) = "  Input: " + valInput$
    Temp$(4) = "  Result: " + Str$(value)

    Call Display 4

    GoTo [loop]

[GregDate]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value$ = GetGregorian$(Val(valInput$))

    Temp$(1) = "Function: GetGregorian"
    Temp$(2) = "  Info: using JD returns a Gregorian date"
    Temp$(3) = "  Input: " + valInput$
    Temp$(4) = "  Result: " + value$

    Call Display 4

    GoTo [loop]

[ValidateDate]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value = ValidateDate(valInput$)

    Temp$(1) = "Function: ValidateDate"
    Temp$(2) = "  Info: Accepts date, returns 0 for valid date,"
    Temp$(3) = "        returns values 1 - 5 for errors."
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Result: " + Str$(value)

    Call Display 5

    GoTo [loop]

[isLeapYear]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    value = isLeapYear(Val(valInput$))

    Temp$(1) = "Function: isLeapYear"
    Temp$(2) = "  Info: Accepts year, returns 0 for leap-year,"
    Temp$(3) = "        returns value of 1 for nonleap-years"
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Result: " + Str$(value)

    Call Display 5

    GoTo [loop]

[DayWeek]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    'index value
    value = DayofWeek(valInput$)
    'actual name of day
    value$ = DayofWeek$(valInput$)

    Temp$(1) = "Function: DayofWeek"
    Temp$(2) = "  Info: Accepts date, returns index for day,"
    Temp$(3) = "        of week and name of day"
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Index: " + Str$(value)
    Temp$(6) = "  Name: " + value$

    Call Display 6

    GoTo [loop]

[DateStat]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    'days left in year
    value = DaysLeft(valInput$)
    'day of year
    value2 = DayNumber(valInput$)
    'Week Number
    value3 = WeekNumber(valInput$)

    Temp$(1) = "Function: GetDateStat"
    Temp$(2) = "  Info: Accepts date, returns day of year,"
    Temp$(3) = "        days left in year and week number. "
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Days Left: " + Str$(value)
    Temp$(6) = "  Day Number: " + Str$(value2)
    Temp$(7) = "  Week Number: " + Str$(value3)

    Call Display 7

    GoTo [loop]

[WkNumStat]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    'weeks in year
    value = WeeksInYear(Val(valInput$))
    'date of first week start
    wk1$ = FirstWeekStart$(Val(valInput$))
    'date of last week start
    wk2$ = LastWeekStart$(Val(valInput$))

    Temp$(1) = "Function: GetWkNumStat"
    Temp$(2) = "  Info: Accepts year, returns weeks in year,"
    Temp$(3) = "        dates first and last week start on. "
    Temp$(4) = "  Input: " + valInput$
    Temp$(5) = "  Weeks in Year: " + Str$(value)
    Temp$(6) = "  1st Week Start: " + wk1$
    Temp$(7) = "  Last Wk Start: " + wk2$

    Call Display 7

    GoTo [loop]

[DateFmt]
    'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A value is required for Primary Input!"
       GoTo [loop]
    End If

    'format 1
    value1$ = dateFmt$(valInput$,4,1)
    'format 2
    value2$ = dateFmt$(valInput$,4,2)
    'format 3
    value3$ = dateFmt$(valInput$,4,3)

    Temp$(1) = "Function: DateFormat"
    Temp$(2) = "  Info: Accepts date, reformats as specified"
    Temp$(3) = "  Input: " + valInput$
    Temp$(4) = "  Format 1: " + value1$
    Temp$(5) = "  Format 2: " + value2$
    Temp$(6) = "  Format 3: " + value3$

    Call Display 6

    GoTo [loop]

[DateAdd]
     'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A Date value is required for Primary Input!"
       GoTo [loop]
    End If

    #main.tbx2 "!contents? valInput2$"
    If valInput2$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A numeric value is required for Optional Input field!"
       GoTo [loop]
    End If

    value$ = AddDate$(valInput$,val(valInput2$))

    Temp$(1) = "Function: IncDate"
    Temp$(2) = "  Info: Accepts date and value in days to add"
    Temp$(3) = "        returns incremented date"
    Temp$(4) = "  Date Input: " + valInput$
    Temp$(5) = "  Days Input: " + valInput2$
    Temp$(6) = "  Result: " + value$

    Call Display 6

    GoTo [loop]

[DateSub]
     'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A Date value is required for Primary Input!"
       GoTo [loop]
    End If

    #main.tbx2 "!contents? valInput2$"
    If valInput2$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A numeric value is required for Optional Input field!"
       GoTo [loop]
    End If

    value$ = SubDate$(valInput$,val(valInput2$))

    Temp$(1) = "Function: DecDate"
    Temp$(2) = "  Info: Accepts date and value in days to"
    Temp$(3) = "        subtract - returns decremented date"
    Temp$(4) = "  Date Input: " + valInput$
    Temp$(5) = "  Days Input: " + valInput2$
    Temp$(6) = "  Result: " + value$

    Call Display 6

    GoTo [loop]

[DateDif]
     'Get the values from the input fields
    #main.tbx1 "!contents? valInput$"
    If valInput$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A Date value is required for Primary Input!"
       GoTo [loop]
    End If

    #main.tbx2 "!contents? valInput2$"
    If valInput2$ = "" Then
       Notice "Input Error" + Chr$(13) + _
              "A numeric value is required for Optional Input field!"
       GoTo [loop]
    End If

    value = DateDifference(valInput$,valInput2$)

    Temp$(1) = "Function: CompareDate"
    Temp$(2) = "  Info: Accepts two date values and returns"
    Temp$(3) = "        the difference between them in days"
    Temp$(4) = "  Date Input: " + valInput$
    Temp$(5) = "  Days Input: " + valInput2$
    Temp$(6) = "  Result: " + str$(value)

    Call Display 6

    GoTo [loop]

[clear]
   'clear the array holding past and current output
   For x = 1 to 20
      Out$(x) = ""
   Next x
   'clear the output into the control
   #main.Output ""
   GoTo [loop]


[help]
    RUN "WINHLP32 datepup32.HLP"
    GoTo [loop]


'*************************************************************************
'***                          F U N C T I O N S                        ***
'*************************************************************************

Sub SetupStructs

'set up the struct used by GetGregorian
struct greg, _
       julian As ulong, _
       value$ As char[10]

'set up the struct for day of week
struct dow, _
       dateval$ As char[12], _
       index As long, _
       dayname$ As char[10]

'set up the struct for getdatestat
struct dtstat, _
       dateval$ As char[12], _
       daysleft As long, _
       weeknum As long, _
       daynum As long

'set up the struct for GetWkNumStat
struct wkstat, _
       year As long, _
       wk1dt$ As char[10], _
       wk52dt$ As char[10], _
       yearweeks As long

'set up the struct for incdate, decdate and comparedate
struct datemath, _
       datein$ As char[12], _
       days As long, _
       dateout$ As char[12]

'set up the struct for formatDate
struct dateFmt, _
       dateIn As char[30],_
       formatIn As long, _
       formatOut As long, _
       dateOut As char[30]

End Sub


Function GetDays(dateIn$)
   'Calls the GetDays function which returns an adjusted (from 1/1/1901) Julian Day Number


   Open "datepup32.dll" For DLL As #dp32
   CallDLL #dp32, "GetDays", dateIn$ As ptr, result As long
   GetDays = result
   Close #dp32

End Function


Function GetJulian(dateIn$)
   'Calls the GetJulian function which returns a Julian Day numjber (JD)

   Open "datepup32.dll" For DLL As #dp32
   CallDLL #dp32, "GetJulian", dateIn$ As ptr, result As long
   GetJulian = result
   Close #dp32

End Function


Function GetDate$(julian)
   'Calls the GetDate function which returns a gregorian date from adjusted JD

   Open "datepup32.dll" For DLL As #dp32
   greg.julian.struct = julian
   CallDLL #dp32, "GetDate", greg As struct, result As long
   GetDate$=Left$(greg.value$.struct,10)
   Close #dp32

End Function


Function ValidateDate(dateIn$)
   'Calls the date validate routine to verify whether the passed date is valid
   'returns 0 (zero) for all valid dates, returns error code (1-5) for errors - see docs

   Open "datepup32.dll" For DLL As #dp32
   CallDLL #dp32, "DateValidate", dateIn$ As ptr, result As long
   ValidateDate = result
   Close #dp32

End Function


Function isLeapYear(year)
   'Calls isLeapYear routine with year value (1 - 3600)
   'Returns 0 (zero) if it IS a leap year and 1 (one) if it is NOT a leap year

   Open "datepup32.dll" For DLL As #dp32
   CallDLL #dp32, "isLeapYear", year As long, result As long
   isLeapYear = result
   Close #dp32

End Function


Function GetGregorian$(julian)
   'Calls the Gregorian conversion routine for the Julian Day value passed to it

   Open "datepup32.dll" For DLL As #dp32
   greg.julian.struct = julian
   CallDLL #dp32, "GetGregorian", greg As struct, result As long
   GetGregorian$ = greg.value$.struct
   Close #dp32

End Function


Function DayofWeek(dateIn$)
   'Call the day of the week for a specific date and return the week day (1 - 7: Monday = 1)

   Open "datepup32.dll" For DLL As #dp32
   dow.dateval$.struct = dateIn$
   CallDLL #dp32, "DayOfWeek", dow As struct, result As long
   DayofWeek = dow.index.struct
   'dow.dayname$.struct
   Close #dp32

End Function


Function DayofWeek$(dateIn$)
   'Call the day of the week for a specific date and return the week day name

   Open "datepup32.dll" For DLL As #dp32
   dow.dateval$.struct = dateIn$
   CallDLL #dp32, "DayOfWeek", dow As struct, result As long
   DayofWeek$ = dow.dayname$.struct
   Close #dp32

End Function

Function DaysLeft(dateIn$)
   'call the date statistics function for a specific day of the year
   'return number of days left in year

   Open "datepup32.dll" For DLL As #dp32
   dtstat.dateval$.struct = dateIn$
   CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
   DaysLeft = dtstat.daysleft.struct
   Close #dp32

End Function


Function DayNumber(dateIn$)
   'call the date statistics function for a specific day of the year
   'return number of days left in year

   Open "datepup32.dll" For DLL As #dp32
   dtstat.dateval$.struct = dateIn$
   CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
   DayNumber = dtstat.daynum.struct
   Close #dp32

End Function


Function WeekNumber(dateIn$)
   'call the date statistics function for a specific day of the year
   'return number of days left in year

   Open "datepup32.dll" For DLL As #dp32
   dtstat.dateval$.struct = dateIn$
   CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
   WeekNumber = dtstat.weeknum.struct
   Close #dp32

End Function


Function WeeksInYear(year)
   'Call the Week Number Statistics call - return weeks in the year

   Open "datepup32.dll" For DLL As #dp32
   wkstat.year.struct = year
   CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
   WeeksInYear = wkstat.yearweeks.struct
   Close #dp32

End Function

Function FirstWeekStart$(year)
   'Call the Week Number Statistics call - return start date of week one of the year

   Open "datepup32.dll" For DLL As #dp32
   wkstat.year.struct = year
   CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
   FirstWeekStart$ = wkstat.wk1dt$.struct
   Close #dp32

End Function

Function LastWeekStart$(year)
   'Call the Week Number Statistics call - return weeks in the year

   Open "datepup32.dll" For DLL As #dp32
   wkstat.year.struct = year
   CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
   LastWeekStart$ = wkstat.wk52dt$.struct
   Close #dp32

End Function


Function AddDate$(dateIn$,days)
   'call IncDate to add days to a passed date

   Open "datepup32.dll" For DLL As #dp32
   datemath.datein$.struct = dateIn$
   datemath.days.struct = days
   CallDLL #dp32, "IncDate", datemath As struct, result As long
   AddDate$ = datemath.dateout$.struct
   Close #dp32

End Function


Function SubDate$(dateIn$,days)
   'call DecDate to subtract days from a passed date

   Open "datepup32.dll" For DLL As #dp32
   datemath.datein$.struct = dateIn$
   datemath.days.struct = days
   CallDLL #dp32, "DecDate", datemath As struct, result As long
   SubDate$ = datemath.dateout$.struct
   Close #dp32

End Function


Function DateDifference(dateOne$,dateTwo$)
   'call DecDate to subtract days from a passed date

   Open "datepup32.dll" For DLL As #dp32
   datemath.datein$.struct = dateOne$
   datemath.dateout$.struct = dateTwo$
   CallDLL #dp32, "CompareDate", datemath As struct, result As long
   DateDifference = datemath.days.struct
   Close #dp32

End Function


Function dateFmt$(dateIn$, fmtIn, fmtOut)
   'Call the date formatter / reformatter function - return date in given format

   Open "datepup32.dll" For DLL As #dp32
   dateFmt.dateIn.struct = dateIn$
   dateFmt.formatIn.struct = fmtIn
   dateFmt.formatOut.struct = fmtOut
   CallDLL #dp32, "DateFormat", dateFmt As struct, result As long
   dateFmt$ = dateFmt.dateOut.struct
   Close #dp32

End Function

Sub Information
   'Call the information function

   Open "datepup32.dll" For DLL As #dp32
   CallDLL #dp32, "Version", result As long
   Close #dp32

End sub

'-----------------------------------------------------------------------------------
'  These functions and Sub Programs are specific to the operation of the tester

Sub Display lines
   'Function is just for this program -
   'displays the new lines of text with past lines of text in
   'the statictext control

   For x = 20 to 2+lines step -1
      Out$(x) = Out$(x-lines-1)
   Next x
   For x = 1 to lines
      Out$(x) = Temp$(x)
   Next x
   Out$(lines+1) = " ------------------------------ "
   'build the output string
   Output$ = ""
   For x = 1 to 20
      Output$ = Output$ + Out$(x) + Chr$(13)
   Next x
   'put the output into the control
   #main.Output Output$

End Sub


Sub MakeTooltips hWin
    TTS.ALWAYSTIP = 1 : TTS.NOPREFIX = 2 : style = _WS_POPUP or TTS.NOPREFIX or TTS.ALWAYSTIP
    CallDLL #cctl,"InitCommonControls", re As void
    CallDLL #user32, "GetWindowLongA", hWin As long, _GWL_HINSTANCE As long, hInstance As long
    CallDLL #user32, "CreateWindowExA", _WS_EX_TOPMOST As long,"tooltips_class32" As ptr, "" As ptr,_
        style As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long, _CW_USEDEFAULT As long,_
        hWin As long, 0 As long, hInstance As long, "" As ptr, hwndTT As long
    flags=_SWP_NOMOVE or _SWP_NOSIZE or _SWP_NOACTIVATE
    CallDLL #user32, "SetWindowPos", hwndTT As long,_HWND_TOPMOST As long, 0 As long, 0 As long, 0 As long, 0 As long, flags As long, r As long

    'create a struct for the tooltips:
    struct toolinfo, cbSize As long, uFlags As long, hWindow As long, uId As long, x As long, y As long, w As long, h As long, hInst As long, lpstrText$ As ptr
    toolinfo.cbSize.struct = Len(toolinfo.struct)
    toolinfo.uFlags.struct = 1 Or 16
    toolinfo.hWindow.struct = hWin

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.GJDa)
    toolinfo.lpstrText$.struct = "Get Julian Adjusted Day - Requires MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.GGDa)
    toolinfo.lpstrText$.struct = "Get Date Adjusted to 1/1/1901 - requires an adjusted Julian Day number"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.GJD)
    toolinfo.lpstrText$.struct = "Get true Julian Day - requires date MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.GGD)
    toolinfo.lpstrText$.struct = "Get true Gregorian date from Julian Day - required Julian Day Number"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.VD)
    toolinfo.lpstrText$.struct = "Determines whether the passed date is formatted correctly - requires MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.LY)
    toolinfo.lpstrText$.struct = "Determines whether the year passed is a leap year - requires numeric value (year)"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DoW)
    toolinfo.lpstrText$.struct = "Returns information about the specific day of the week - requires date MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DS)
    toolinfo.lpstrText$.struct = "Returns statistics about a specific date - requires date value MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.WNS)
    toolinfo.lpstrText$.struct = "Returns number of weeks statistics for a given year - requires a numeric value (year)"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DF)
    toolinfo.lpstrText$.struct = "Reformatts a date from one format to another - can accept many date formatts, this example requires MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DA)
    toolinfo.lpstrText$.struct = "Returns a date from a base date value and number days passed to it - date must be in format MM/DD/YYYY - see Helpfile"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.quit)
    toolinfo.lpstrText$.struct = "Exit the DatePup32 GUI based tester"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DSt)
    toolinfo.lpstrText$.struct = "Returns statistics about a specific date - requires date value MM/DD/YYYY"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DS)
    toolinfo.lpstrText$.struct = "Returns a date subtracted from a base date value and number days passed to it - date must be in format MM/DD/YYYY - see Helpfile"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.DD)
    toolinfo.lpstrText$.struct = "Returns the difference in days detween two dates - dates must be in format MM/DD/YYYY - see Helpfile"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.help)
    toolinfo.lpstrText$.struct = "Display the helpfile"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.clear)
    toolinfo.lpstrText$.struct = "Clear the results window"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Textbox Tooltip:
    toolinfo.uId.struct = hWnd(#main.tbx1)
    toolinfo.lpstrText$.struct = "Enter text here."
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Textbox Tooltip:
    toolinfo.uId.struct = hWnd(#main.tbx2)
    toolinfo.lpstrText$.struct = "Enter text here."
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

'Button Tooltip:
    toolinfo.uId.struct = hWnd(#main.Info)
    toolinfo.lpstrText$.struct = "Calls Version function and displays information about DLL - always returns a zero"
    CallDLL #user32, "SendMessageA", hwndTT As long, 1028 As long, 0 As long, toolinfo As struct, re As long

End Sub
