Open "datepup32.dll" For DLL As #dp32

'set up the struct used by GetGregorian
struct greg, _
       julian As ulong, _ 
       value$ As char[10]

'set up the struct for day of week
struct dow, _
       dateval$ As char[12], _
       index As long, _
       dayname$ As char[10]

'set up the struct for getdatestat
struct dtstat, _
       dateval$ As char[12], _
       daysleft As long, _
       weeknum As long, _
       daynum As long

'set up the struct for GetWkNumStat
struct wkstat, _
       year As long, _
       wk1dt$ As char[10], _
       wk52dt$ As char[10], _
       yearweeks As long

'set up the struct for incdate, decdate and comparedate
struct datemath, _
       datein$ As char[12], _
       days As long, _
       dateout$ As char[12]

'set up the struct for formatDate
struct dateFmt, _
       dateIn As char[30],_
       formatIn As long, _
       formatOut As long, _
       dateOut As char[30]

'Set up some test values
Dim b$(10)
b$(1) = "08/13/2002"+Chr$(0)
b$(2) = "02/29/2002"+Chr$(0)
b$(3) = "11/31/2002"+Chr$(0)
b$(4) = "05/15/0002"+Chr$(0)
b$(5) = "02/29/2000"+Chr$(0)
b$(6) = "00/00/2002"+Chr$(0)
b$(7) = "12/31/2222"+Chr$(0)
b$(8) = "6/5/02"+Chr$(0)
b$(9) = "06/05/2002"+Chr$(0)
b$(10) = "08/15/4202"+Chr$(0)


'Test the GetDays function which returns an adjusted (from 1/1/1901) Julian Day Number
'----------------------------------------------------------------------------------------------
a$ = Date$("mm/dd/yyyy")+Chr$(0)
CallDLL #dp32, "GetDays", a$ As ptr, result As long
Print result; " Days since ";Left$(a$,10)
Print "LB Result of Date$(days): ";Str$(Date$("days"))

'Test the GetJulian function which returns a Julian Day numjber (JD)
'----------------------------------------------------------------------------------------------
CallDLL #dp32, "GetJulian", a$ As ptr, result As long
Print result; " is the Julian date for  ";Left$(a$,10)

a$ = "01/01/1901"+Chr$(0)
CallDLL #dp32, "GetJulian", a$ As ptr, result As long
Print result; " is the Julian date for  ";Left$(a$,10)

'Test the GetDate function which returns a gregorian date from adjusted JD
'----------------------------------------------------------------------------------------------
greg.julian.struct = 36000
CallDLL #dp32, "GetDate", greg As struct, result As long
Print "36000 days since 1/1/1901 is the date : ";Left$(greg.value$.struct,10)

greg.julian.struct = 37114
CallDLL #dp32, "GetDate", greg As struct, result As long
Print "37114 days since 1/1/1901 is the date : ";Left$(greg.value$.struct,10)


'Test the date validate routine to verify whether 10 example dates are valid
'----------------------------------------------------------------------------------------------
For x = 1 to 10
  a$ = b$(x)
  CallDLL #dp32, "DateValidate", a$ As ptr, result As long
  If result = 0 Then
    Print Left$(b$(x),Len(b$(x))-1); " is a valid date that can be evaluated" 
  Else
    Print Left$(b$(x),Len(b$(x))-1); " is NOT a valid date and CAN NOT be evaluated" 
  End If
Next x

'Test the year for eight randon years to determine whether they are leap years
'----------------------------------------------------------------------------------------------
For x = 1 to 8
  year = Int(Rnd(1)*98) + 1912
  CallDLL #dp32, "isLeapYear", year As long, result As long
  If result = 0 Then
    Print year;" Was a leap year"
  Else
    Print year;" Was NOT a leap year"
  End If
Next x

'Test the Gregorian conversion routines for four random Julian Day values
'----------------------------------------------------------------------------------------------
For x = 1 to 4
  greg.julian.struct = 2405060 + Int(Rnd(1)*99999)
  CallDLL #dp32, "GetGregorian", greg As struct, result As long
  Print "Julian ";greg.julian.struct;" equals Gregorian date: ";greg.value$.struct
Next x


'Test round trip to verify Julian and Gregorian conversion functions
' Julian day number and gregorian date should tie out from both functions
'----------------------------------------------------------------------------------------------
Print " *** Verify round trip: Julian to Gregorian to Julian ***"
greg.julian.struct = 2473822
CallDLL #dp32, "GetGregorian", greg As struct, result As long
Print "Julian ";greg.julian.struct;" equals Gregorian date: [";greg.value$.struct;"]"
value$ = greg.value$.struct + Chr$(0)
CallDLL #dp32, "GetJulian", value$ As ptr, result As long
Print "Julian date for [";greg.value$.struct;"] is equal to: ";result

greg.julian.struct = 2483927
CallDLL #dp32, "GetGregorian", greg As struct, result As long
Print "Julian ";greg.julian.struct;" equals Gregorian date: [";greg.value$.struct;"]"
value$ = greg.value$.struct + Chr$(0)
CallDLL #dp32, "GetJulian", value$ As ptr, result As long
Print "Julian date for [";greg.value$.struct;"] is equal to: ";result

greg.julian.struct =  1721426  'smallest julian date that DatePup32 will act on.
CallDLL #dp32, "GetGregorian", greg As struct, result As long
Print "Julian ";greg.julian.struct;" equals Gregorian date: [";greg.value$.struct;"]"
value$ = greg.value$.struct + Chr$(0)
CallDLL #dp32, "GetJulian", value$ As ptr, result As long
Print "Julian date for [";greg.value$.struct;"] is equal to: ";result

'Test the day of the week for a specific date
'----------------------------------------------------------------------------------------------
dow.dateval$.struct = "08/22/2002"
CallDLL #dp32, "DayOfWeek", dow As struct, result As long
Print "Test DayofWeek - Result of Call : ";result
Print "Day number of ";dow.dateval$.struct;" is ";dow.index.struct
Print "Day Name of ";dow.dateval$.struct;" is ";dow.dayname$.struct

'Test the date statistics for a specific day of the year
'----------------------------------------------------------------------------------------------
dtstat.dateval$.struct = "01/07/1983"
CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
Print "Test DateStat call - result of call : ";result
Print "DaysLeft: ";dtstat.daysleft.struct;"   ";
Print "Current Day Number: ";dtstat.daynum.struct;"   ";
Print "Week Number: ";dtstat.weeknum.struct

dtstat.dateval$.struct = "10/21/1467"
CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
Print "Test DateStat call - result of call : ";result
Print "DaysLeft: ";dtstat.daysleft.struct;"   ";
Print "Current Day Number: ";dtstat.daynum.struct;"   ";
Print "Week Number: ";dtstat.weeknum.struct

dtstat.dateval$.struct = "08/22/2002"
CallDLL #dp32, "GetDateStat", dtstat As struct, result As long
Print "Test DateStat call - result of call : ";result
Print "DaysLeft: ";dtstat.daysleft.struct;"   ";
Print "Current Day Number: ";dtstat.daynum.struct;"   ";
Print "Week Number: ";dtstat.weeknum.struct

'Test the Week Number Statistics call - returns weeks in year and week
'start and end dates (not calendar start and end)
'----------------------------------------------------------------------------------------------
wkstat.year.struct = 2005
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 2004
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 2003
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 2002
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 2001
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 2000
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

wkstat.year.struct = 1999
CallDLL #dp32, "GetWkNumStat", wkstat As struct, result As long
Print "Test WeekNumStat call - result of call : ";result
Print "Week one for year: ";wkstat.year.struct;
Print " starts : ";wkstat.wk1dt$.struct;" ends : ";wkstat.wk52dt$.struct
Print "Number of weeks in the year are: ";wkstat.yearweeks.struct

'Test the date math functions (add, subtract and get difference)
'----------------------------------------------------------------------------------------------
Print "Date Math -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"
datemath.datein$.struct = "05/10/2002"
datemath.days.struct = 15
CallDLL #dp32, "IncDate", datemath As struct, result As long
Print datemath.datein$.struct;" Plus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "05/10/2002"
datemath.days.struct = 45
CallDLL #dp32, "IncDate", datemath As struct, result As long
Print datemath.datein$.struct;" Plus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "01/01/0001"
datemath.days.struct = 600
CallDLL #dp32, "IncDate", datemath As struct, result As long
Print datemath.datein$.struct;" Plus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "05/10/2002"
datemath.days.struct = 15
CallDLL #dp32, "DecDate", datemath As struct, result As long
Print datemath.datein$.struct;" Minus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "05/10/2002"
datemath.days.struct = 45
CallDLL #dp32, "DecDate", datemath As struct, result As long
Print datemath.datein$.struct;" Minus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "01/01/3000"
datemath.days.struct = 600
CallDLL #dp32, "DecDate", datemath As struct, result As long
Print datemath.datein$.struct;" Minus ";datemath.days.struct;" Equals a date of : ";datemath.dateout$.struct

datemath.datein$.struct = "08/08/2001"
datemath.dateout$.struct = "09/06/2002"
CallDLL #dp32, "CompareDate", datemath As struct, result As long
Print "There are ";datemath.days.struct;" days between "; datemath.datein$.struct;" and ";datemath.dateout$.struct

datemath.datein$.struct = "01/01/1983"
datemath.dateout$.struct = "12/31/1983"
CallDLL #dp32, "CompareDate", datemath As struct, result As long
Print "There are ";datemath.days.struct;" days between "; datemath.datein$.struct;" and ";datemath.dateout$.struct

datemath.datein$.struct = "01/01/2000"
datemath.dateout$.struct = "12/31/2000"
CallDLL #dp32, "CompareDate", datemath As struct, result As long
Print "There are ";datemath.days.struct;" days between "; datemath.datein$.struct;" and ";datemath.dateout$.struct

datemath.datein$.struct = "01/01/0001"
datemath.dateout$.struct = "09/06/2002"
CallDLL #dp32, "CompareDate", datemath As struct, result As long
Print "There are ";datemath.days.struct;" days between "; datemath.datein$.struct;" and ";datemath.dateout$.struct

'Test the date formatter / reformatter
'----------------------------------------------------------------------------------------------
dateFmt.dateIn.struct = "09/06/2002"
dateFmt.formatIn.struct = 4
dateFmt.formatOut.struct = 1
CallDLL #dp32, "DateFormat", dateFmt As struct, result As long
Print "Date: ";dateFmt.dateIn.struct;" has been reformatted to: ";dateFmt.dateOut.struct
dateFmt.formatOut.struct = 2
CallDLL #dp32, "DateFormat", dateFmt As struct, result As long
Print "Date: ";dateFmt.dateIn.struct;" has been reformatted to: ";dateFmt.dateOut.struct
dateFmt.formatOut.struct = 3
CallDLL #dp32, "DateFormat", dateFmt As struct, result As long
Print "Date: ";dateFmt.dateIn.struct;" has been reformatted to: ";dateFmt.dateOut.struct 
dateFmt.dateIn.struct = dateFmt.dateOut.struct
dateFmt.formatIn.struct = 3
dateFmt.formatOut.struct = 4
CallDLL #dp32, "DateFormat", dateFmt As struct, result As long
Print "Date: ";dateFmt.dateIn.struct;" has been reformatted to: ";dateFmt.dateOut.struct

'I do this because I run my code from LBWorkshop
Print "Press ENTER to quit" 
Input b$

Close #dp32  