'ShootGal1.bas
'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 1
'Created by Richard Ryles April 2003
'I've already added the can and duck sprites onto the background.
'You are to add the rest of the sprites on the screen.
'The other bitmaps are as follows.
'bottle.bmp
'balloon.bmp
'squirl1.bmp
'bullet.bmp
'target.bmp
'and place the board.bmp at X0 and Y244

'I've left off many of the comments made in the 1stWindow.bas so if you
'need more explaination of what is going on then take a look at it.

'I'll give you my solution in the next issue.


'I.  Window Setup
nomainwin
WindowWidth = 500:WindowHeight =340 'increased the height by 20 pixels
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)


graphicbox #game.g, 0, 20, 500, 300  'dropped down 20 pixels from the top
statictext #game.st, "You can put a score here",0,0,200,18 'adding text at the top
                                'each control has to have it's own unique name.  Here the statictext
                                'belongs to window game and it's unique name is "st".

'*** Open your window, put your title where it says "Game Name"
open "1st Game Window" for window as #game  'once again we are opening a plain window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "can", "can.bmp"    'loading the bitmaps we will use into memory
loadbmp "duck", "duck.bmp"

'III.  Initialize Variables

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "down;fill black"
print #game.g, "flush"
print #game.g, "getbmp bg 0, 0, 500, 300";
print #game.g, "background bg";

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite duck duck";
print #game.g, "addsprite can can";


    'C.  Set Initial Location of Sprites - spritexy
print #game.g, "spritexy can 300 150";      'setting the beginning location of each sprite -
print #game.g, "spritexy duck 130 170";     ' it's location on the screen


   ' D.  Set other Sprite Attributes

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]
wait

'VI.  Initialize Keyboard and Mouse Events

'VII.  Timer Branch
[TimerBranch]
gosub [draw]
wait

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"
    unloadbmp "can"
    unloadbmp "duck"
    close #game
    end

'IX.  Branches called by Mouse and or Keyboard - user entity movement

'X.  Subs Called by Timer Branch
[draw]
print #game.g, "drawsprites";   'redraws background and sprites every 1/10th of a second
return
