' indexfunc3.2 - 21-12-2002
'by Richard Peeters
'test modified by Brad

dim finfo$(10,10)

dummy=initfunclib()
'if the index exists then kill it
files DefaultDir$,"bibi.lbx",finfo$()
If val(finfo$(0, 0)) > 0) then kill "bibi.lbx"

'Time how long it takes to create an index
t=Time$("seconds")
Print"indexing ........."

ind=index("bibi.lbd",23,"bibi.lbx",1,3,0)

If ind > 0 Then
    Notice"it took ";Time$("seconds")-t;" seconds to write ";ind;" records Binary"
Else
    Notice"no indexing ...."
End If    

[search]
While ch$<>"n"
Cls
'------------
' display part of index
Open "bibi.lbx" For Binary As #1

For j= 1 to 10
 pointer =(j-1)*(8)
 Seek #1,pointer
 key$=Input$(#1,8):rest$=Mid$(key$,4)
 key$=Left$(key$,3)
 Print j;"---"; key$;"  ";rest$ 
 Next
 Close #1
'------------

Input"key?  "; qq$

a=lookup("bibi.lbx",3,qq$)
If a > 0 Then    
    Print " masterrecord in ";a    
    For j=1 to 4
    Print globalinf$(j)
    Next
Else
     Print "not found"
     For j=1 to 4
    Print globalinf$(j)
    Next    
End If     
Input"more (y/n)?  "; ch$
Wend
'------------------------
'getfi
Print "-------------------------"
print "testing the seeking ability of LBISAM"
[getfi]
a=getfirst("bibi.lbx",3)
Print "first masterec = ";a
For j=1 to 4
    Print globalinf$(j)
Next 
'find a key
a=lookup("bibi.lbx",3,"lbx")
Print "Lookup a key ";a
For j=1 to 4
    Print globalinf$(j)
Next 

a=getnext("bibi.lbx",3)
Print "next masterec = ";a
For j=1 to 4
    Print globalinf$(j)
Next 

a=getnext("bibi.lbx",3)
Print "next masterec = ";a
For j=1 to 4
    Print globalinf$(j)
Next 
   

a=getlast("bibi.lbx",3)
Print "last masterec = ";a
For j=1 to 4
    Print globalinf$(j)
Next 
a=getprev("bibi.lbx",3)
Print "prev masterec = ";a
For j=1 to 4
    Print globalinf$(j)
Next    
Input "Press Enter to begin the next test sequence...";ggg$
'End
'-------------------------
[test]
Cls
'------------
Open "bibi.lbd" For random As #1 Len=23
Field  #1,3 As code$,20 As name$

' list all index
x=getcount("bibi.lbx",3)

Print "Found ";x;" records in the index - Listing records:"

'set the record pointer to zero so that the get next gets the first record
globalinf$(2)="0"

'now we can list all the records in first to last order.
For j=1 to x
    i=getnext("bibi.lbx",3)
    rec=Val(globalinf$(3))    
    Get #1,rec
    Print globalinf$(4);"  ";globalinf$(3);"  ";code$;" ---- ";name$;
    print globalinf$(1);"  ";globalinf$(2)
Next
Print
' list all index in reverse
x=getcount("bibi.lbx",3)
i=getlast("bibi.lbx",3)
rec=Val(globalinf$(3))    
    Get #1,rec
    Print globalinf$(4);"  ";globalinf$(3);"  ";code$;" ---- ";name$
    For j=x-1 to 1 step -1
    i=getprev("bibi.lbx",3)
    rec=Val(globalinf$(3))    
    Get #1,rec
    Print globalinf$(4);"  ";globalinf$(3);"  ";code$;" ---- ";name$
Next

Print
' list all index in reverse in another way
x=getcount("bibi.lbx",3)
globalinf$(2)=Str$(x+1)
For j=x to 1 step -1
    i=getprev("bibi.lbx",3)
    rec=Val(globalinf$(3))    
    Get #1,rec
    Print globalinf$(4);"  ";globalinf$(3);"  ";code$;" ---- ";name$
Next
Close #1
Input "Press ENTER to quit!";hhh$
End
'-------------------------------------------------------------------------------
'function initfunclib
' use once in your program before using any of the functions in this library
' does some initialisations
'-------------------------------------------------------------------------------
Function initfunclib()
Dim globalinf$(10)
End Function

'-------------------------------------------------------------------------------
'function getcount
' used to get the number of records in the index
' parameters passed
' indexname$ = name of indexfile
' keylength = length of key
' returns nr of records in the index
 '------------------------------------------
Function getcount(indexname$,keylength)
Open indexname$ For Binary As #oi9
'get nr of records
qtyBytes = Lof(#oi9)
getcount=qtyBytes/(5+keylength)
Close #oi9
End Function
'-------------------------------------------------------------------------------
'function index
' used to create an index on a file with fixed recordlengths (random or binary)
' the max number of records = 99999
' parameters to be passed:
'   filename$ = filename of file to be indexed
'   reclen    = recordlength
'   indexname$= name of the indexfile to be created
'   keybegin  = the position in the record where the key begins
'   keylength = length of the key
'   unique    = 0 = duplicate records allowed / 1 = no duplicates allowed

'the function returns the number of records indexed  
'-------------------------------------------------------------------------------

Function index(filename$,reclen,indexname$,keybegin,keylength,unique)
Open indexname$ For Binary As #2
If Lof(#2)> 0 Then      ' file already exists
    Confirm "Indexfile already exists - do you want to replace it?"; answer$
    If answer$="yes" Then 
        Close #2:Kill indexname$
    Else
        index=0:Close #2:GoTo [fin]
    End If
Else 
    Close #2  
End If
Open filename$ For Binary As #1
'get nr of records
qtyBytes = Lof(#1)
nrrec=qtyBytes/reclen
Dim rep$(10,2):ReDim rep$(nrrec+10,2)
top=0
For i=1 to nrrec
    pointer=(i-1)*reclen
    Seek #1,pointer
    var$=Input$(#1,reclen)
    x$=Str$(i):length=Len(x$)
    For j=1 to 5-length
        x$="0"+x$   'pad with zeroes till len=5    
    Next j
    
    rep$(i,1)=Mid$(var$,keybegin,keylength):rep$(i,2)=x$:top=top+1
    
Next i

Sort rep$(),1,top,1
' test for duplicates if unique=1
If unique=1 Then 
  For j=1 to top-1
    If rep$(j+1,1)=rep$(j,1) Then
        Notice"No duplicate keys allowed!!"
        index=0
        Close #1
        GoTo [fin]        
    End If
  Next    

End If
' writeindex
Open indexname$ For Binary As #2
indrl=keylength+5   'reclen of index rec
For i = 1 to top
    pointer=(i-1)*indrl
    tot$=rep$(i,1)+rep$(i,2)
    Print #2,tot$
Next i
index=nrrec   'ok
Close #1
Close #2
[fin]
ReDim rep$(10,2)

End Function
'-------------------------------------------------------------------------------
'function getkey
' used to search a key in an index 
' parameters to be passed:
'   
'   indexname$= name of the indexfile to be searched
'   keylength = length of the key
'   key$      = key to search for

'the function returns the recordnr in the masterfile of the found key or if not found
'the negative recordnr after which it should have been if present
'-------------------------------------------------------------------------------

Function getkey(indexname$,keylength,skey$)
Open indexname$ For Binary As #oi1
'get nr of records
qtyBytes = Lof(#oi1)
nrrec=qtyBytes/(5+keylength)
l=1:u=nrrec+1
'---------------------------
[search]
flag=0
i=Int((l+u)/2)
pointer =(i-1)*(5+keylength)
 Seek #oi1,pointer
 key$=Input$(#oi1,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
If key$=skey$ Then
        ' found !!
        

' look for 1st corresponding key if non unique index 
  If i>1 Then  
    For j=i to 1 step -1
        pointer =(j-1)*(5+keylength)
        Seek #oi1,pointer
        key$=Input$(#oi1,5+keylength )
        adress$=Mid$(key$,keylength+1):adress=Val(adress$)
        key$=Left$(key$,keylength)
        key$=Trim$(key$)    
        If key$ <> skey$ Then            
            getkey=j+1
            Exit For            
        End If    
    Next j 
  Else 
    getkey=1
  End If   
GoTo [ret]       
End If    

If key$<skey$ Then
    If flag=0 Then vorige=i:flag=1
    If l=i Then
        'Print"not found  - previous is:  ";vorige   
        'Print"           - next     is:  ";vorige+1
        getkey=vorige *(-1)
        GoTo [ret]
    Else
        l=i
        GoTo [search]
    End If
End If
If key$>skey$ Then
    If flag=0 Then volg=i:flag=1
    If u=i Then
        'Print"not found - previous is:  ";volg
        'Print"          - next     is:  ";volg-1
        getkey=vorige *(-1)
        GoTo [ret]        
    Else
        u=i
        GoTo [search]
    End If
End If
'------------------------------------
[ret]
If getkey>0 Then
 pointer =(getkey-1)*(5+keylength)
 Seek #oi1,pointer
 key$=Input$(#oi1,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(getkey)
 globalinf$(3)=adress$
 globalinf$(4)=key$
 getkey=adress
Else
 globalinf$(2)=Str$(getkey) 'returns neg pos after wich it should come
 globalinf$(3)="0"
 globalinf$(4)="NOT FOUND"  
End If 
Close #oi1
End Function
'-------------------------------------------------------------------------------
'function lookup
' used to search part of a key in an index 
' parameters to be passed:
'   
'   indexname$= name of the indexfile to be searched
'   keylength = length of the key
'   key$      = key to search for

'the function returns the recordnr in the referencefile of the 1st found key
' or if not found the negative recordnr after which it should have been if present

'-------------------------------------------------------------------------------

Function lookup(indexname$,keylength,skey$)
Open indexname$ For Binary As #oi1
'get nr of records
qtyBytes = Lof(#oi1)
nrrec=qtyBytes/(5+keylength)
l=1:u=nrrec+1
'---------------------------
[search]
flag=0
i=Int((l+u)/2)
pointer =(i-1)*(5+keylength)
 Seek #oi1,pointer
 key$=Input$(#oi1,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
If Left$(key$,Len(skey$))=skey$ Then
     ' found
 
' look for 1st corresponding key    
If i > 1 Then
    For j=i to 1 step -1
        pointer =(j-1)*(5+keylength)
        Seek #oi1,pointer
        key$=Input$(#oi1,5+keylength )
        adress$=Mid$(key$,keylength+1):adress=Val(adress$)
        key$=Left$(key$,keylength)
        key$=Trim$(key$)    
        If Left$(key$,Len(skey$))<> skey$ Then
            lookup=j+1
            Exit For            
        End If 
        If j=1 Then lookup=1   
    Next j 
Else 
    lookup=1           
End If         
     GoTo [ret]       
End If    

If key$<skey$ Then
    If flag=0 Then vorige=i:flag=1
    If l=i Then
        'Print"not found  - previous is:  ";vorige   
        'Print"           - next     is:  ";vorige+1
        lookup=vorige *(-1)
        GoTo [ret]
    Else
        l=i
        GoTo [search]
    End If
End If
If key$>skey$ Then
    If flag=0 Then volg=i:flag=1
    If u=i Then
        'Print"not found - previous is:  ";volg
        'Print"          - next     is:  ";volg-1
        lookup=vorige *(-1)
        GoTo [ret]        
    Else
        u=i
        GoTo [search]
    End If
End If
'------------------------------------
[ret]
If lookup>0 Then
 pointer =(lookup-1)*(5+keylength)
 Seek #oi1,pointer
 key$=Input$(#oi1,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(lookup)
 globalinf$(3)=adress$
 globalinf$(4)=key$
 lookup=adress
Else
 globalinf$(2)=Str$(lookup) 'returns neg pos after wich it should come
 globalinf$(3)="0"
 globalinf$(4)="NOT FOUND"  
End If 
Close #oi1
End Function
'-------------------------------------------------------------------------------
' function getfirst
'searches For the first key in the index 
'with Name=indexname and keylength=keylength
' returns recordnr of record in masterfile

Function getfirst(indexname$,keylength)
Open indexname$ For Binary As #oi9
i=1
pointer =(i-1)*(5+keylength)
 Seek #oi9,pointer
 key$=Input$(#oi9,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 getfirst=adress
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(i)
 globalinf$(3)=adress$
 globalinf$(4)=key$
 Close #oi9 
End Function
'-------------------------------------------------------------------------------
' function getlast
'searches For the last key in the index 
'with Name=indexname and keylength=keylength
' returns recordnr of record in masterfile

Function getlast(indexname$,keylength)
Open indexname$ For Binary As #oi9
'get nr of records
qtyBytes = Lof(#oi9)
i=qtyBytes/(5+keylength)
pointer =(i-1)*(5+keylength)
 Seek #oi9,pointer
 key$=Input$(#oi9,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 getlast=adress
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(i)
 globalinf$(3)=adress$
 globalinf$(4)=key$
 Close #oi9  
End Function
'-------------------------------------------------------------------------------
' function getnext
'searches For the next key in the index from present position in globalinf$(2)
'with Name=indexname and keylength=keylength
' returns position in masterfile of next

Function getnext(indexname$,keylength)
Open indexname$ For Binary As #oi9
'get nr of records
qtyBytes = Lof(#oi9)
nrrec=qtyBytes/(5+keylength)
i=Val(globalinf$(2))+1
If i>nrrec Then
    Notice"eof reached"
    i=0:getnext=0
Else    
 pointer =(i-1)*(5+keylength)
 Seek #oi9,pointer
 key$=Input$(#oi9,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 getnext=adress
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(i)
 globalinf$(3)=adress$
 globalinf$(4)=key$
End If 
 Close #oi9  
End Function
'-------------------------------------------------------------------------------
' function getprev
'searches For the previous key in the index from present position in globalinf$(2)
'with Name=indexname and keylength=keylength
' returns position in masterfile of previous

Function getprev(indexname$,keylength)
Open indexname$ For Binary As #oi9
i=Val(globalinf$(2))- 1
If i < 1 Then
    Notice"bof reached"
    i=0:getprev=0
Else    
 pointer =(i-1)*(5+keylength)
 Seek #oi9,pointer
 key$=Input$(#oi9,5+keylength )
 adress$=Mid$(key$,keylength+1):adress=Val(adress$)
 key$=Left$(key$,keylength)
 key$=Trim$(key$)    
 getprev=adress
 globalinf$(1)=indexname$
 globalinf$(2)=Str$(i)
 globalinf$(3)=adress$
 globalinf$(4)=key$
End If 
 Close #oi9  
End Function
'-------------------------------------------------------------------------------


