'SC2sol.bas
'Created by Richard Ryles April 2003
'rryles@jeff-davis.k12.ga.us
'http://jdexchange.jeff-davis.k12.ga.us/~rryles/

'Solution to Session 2 Challenges
'for use with the Beginning Game Programming Series - Session 3



'I.  Window Setup
nomainwin
WindowWidth = 500:WindowHeight =320
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)        'these two lines center the window on the screen
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)

graphicbox #game.g, 0, 20, 500, 300 'placed down 20 pixles to give the statictext room
statictext #game.st, "You can put a score here",0,0,200,18 'adding the statictext along the top

open "SubCommand 2" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "bg", "subBG.bmp"
loadbmp "sub", "goodsub.bmp"
loadbmp "enemy", "enemysub.bmp"
loadbmp "ship", "ship.bmp"
loadbmp "torpedo", "torpedo.bmp"
loadbmp "mine", "mine.bmp"

    'III.  Initialize Variables
    sx=20:sy=75     'initial location of sub
    mineX=250:mineY=45  'initial location of min

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite sub sub"
print #game.g, "addsprite enemy enemy"
print #game.g, "addsprite ship ship"
print #game.g, "addsprite torpedo torpedo"
print #game.g, "addsprite mine mine"

        'C.  Set Initial Location of Sprites - spritexy
    print #game.g, "spritexy sub ";sx;" ";sy  'pulled the variable values for the sub's x and y
    print #game.g, "spritexy enemy -70 200" 
    print #game.g, "spritexy ship 500 45"   '500 starts the ship out of view
    print #game.g, "spritexy torpedo 150 300"   
    print #game.g, "spritexy mine 250 45"

        'D.  Set other Sprite Attributes
    print #game.g, "spritemovexy ship -5 0"    '-5 causes the ship to move to the left
    print #game.g, "spritemovexy mine 0 6"     '6 causes the mine to move down
    print #game.g, "spritemovexy enemy 3 0"
    print #game.g, "spritemovexy torpedo 0 -6"

    print #game.g, "spriteorient torpedo flip"

    'V.  Initialize Timer, set no less than 56
    timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus"   'causes the program focus all keypresses and mouse events on the #game.g graphicbox
    print #game.g, "when characterInput [MoveSub]"  'when a key is pressed goto the MoveSub branch
    wait 'this first wait in the program will not allow the code below to be executed.  From now on the
            'timer, keyboard and mouse are in control of what happens.

    'VII.  Timer Branch
    [TimerBranch]   'the timer causes the program to come here every 10th of a second and run the following
    gosub [TrapShip]
    gosub [TrapMine]
    gosub [TrapEnemy]
    gosub [TrapTorpedo]
    gosub [draw]
    wait    'stops when it gets here, waits until told to do something else

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"
    unloadbmp "sub"
    unloadbmp "enemy"
    unloadbmp "ship"
    unloadbmp "torpedo"
    unloadbmp "mine"
    close #game
    end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [MoveSub]
    k$=Inkey$   'assigning the Inkey$ another name - shortens what we have to type in
    if k$="1" or k$="4" or k$="7" then
        sx=sx-1      'move the sub left
        print #game.g, "spriteorient sub mirror" 'causes the sub sprite to flip vertically
    end if  'terminates the if/then block

    if k$="9" or k$="6" or k$="3" then
        sx=sx+1     'moves the sub right
        print #game.g, "spriteorient sub normal" 'normal returns the sub to it's original direction
    end if

    if k$="7" or k$="8" or k$="9" then sy=sy-1      'moves the sub up
    if k$="1" or k$="2" or k$="3" then sy=sy+1     'moves the sub down

    print "sx= ";sx     'prints the value of sx in the main window if nomainwin is commented out
    print "sy= ";sy     'prints the value of sy in the main window if nomainwin is commented out

    if sx<1 then sx=1       'traps the left edge - sub won't move past 1
    if sx>425 then sx=425   'traps the right edge - sub won't move past 425
    if sy<55 then sy=55      'traps the top of the sub - will not move above the water line
    if sy>235 then sy=235   'traps the bottom edge - will not allow the sub to move past 235
    print #game.g, "spritexy sub "; sx; " ";sy 'prints the sub in the new location
    wait

'X.  Subs Called by Timer Branch
[TrapShip]
print #game.g, "spritexy? ship x y"     'gets the location of ship and places the x & y values in x and y
if x<-50 then print #game.g, "spritexy ship 500 45"     'if ship has moved beyond the left edge then it is placed
return                                                                    'back at it's initial location

[TrapMine]
print #game.g, "spritexy? mine mineX mineY"     'places the mine' coordinated in the variables mineX and mineY
if mineY>320 then print #game.g, "spritexy mine 250 45" 'when the mine goes off the bottom it is returned to its beginning location
return  'returns to the point in the program that directed the program here

[TrapEnemy]
print #game.g, "spritexy? enemy enemyX enemyY"
if enemyX>500 then print #game.g, "spritexy enemy -70 200"
return

[TrapTorpedo]
print #game.g, "spritexy? torpedo torpedoX torpedoY"
if torpedoY<-30 then print #game.g, "spritexy torpedo 150 300"
return

[draw]
print #game.g, "drawsprites";
return
urn

[draw]
print #game.g, "drawsprites";
return
