'ShootGallery2.bas
'Example file for Beginning Game Programming
'solution for the SGallery2.bas
'for use with the Beginning Game Programming Series - Article 3
'Created by Richard Ryles April 2003
'Modified June 2003


'I.  Window Setup
nomainwin
WindowWidth = 300:WindowHeight =340 'increased the height by 20 pixels
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)


graphicbox #game.g, 0, 20, 300, 300  'dropped down 20 pixels from the top
statictext #game.st, "You can put a score here",0,0,200,18

'I changed the window name to Shooting Gallery 2
open "Shooting Gallery 2" for window as #game  'once again we are opening a plain window
print #game, "trapclose [quit]"
cursor crosshair

'II.  Load Bitmaps
loadbmp "balloon", "balloon.bmp"
loadbmp "bottle", "bottle.bmp"
loadbmp "can", "can.bmp"
loadbmp "squirrel1", "squirl1.bmp"
loadbmp "squirrel2", "squirl2.bmp"
loadbmp "duck", "duck.bmp"
loadbmp "target", "target.bmp"
loadbmp "bullet", "bullet.bmp"
loadbmp "board", "board.bmp"
loadbmp "sight", "sight.bmp"

'III.  Initialize Variables

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "down;fill black"
print #game.g, "flush"
print #game.g, "getbmp bg 0, 0, 300, 300";
print #game.g, "background bg";

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite balloon balloon";
print #game.g, "addsprite bottle bottle";
print #game.g, "addsprite squirrel squirrel1 squirrel2";
print #game.g, "addsprite duck duck";
print #game.g, "addsprite target target";
print #game.g, "addsprite bullet bullet";
print #game.g, "addsprite can can";
print #game.g, "addsprite board board";
print #game.g, "addsprite sight sight";
print #game.g, "addsprite duck2 duck";  'here we are adding the second duck, we are using the same
                                                            'bitmap that we did for the first duck

        'C.  Set Initial Location of Sprites - spritexy
    print #game.g, "spritexy balloon 10 300";
    print #game.g, "spritexy bottle -20 170";
    print #game.g, "spritexy can 300 150";
    print #game.g, "spritexy squirrel 300 205";
    print #game.g, "spritexy duck 0 170";
    print #game.g, "spritexy target 125 -20";   'new initial location for target
    print #game.g, "spritexy bullet 300 170";
    print #game.g, "spritexy board 0 244";
    print #game.g, "spritexy duck2 300 100";    'duck2's start location on the right of the window

   ' D.  Set other Sprite Attributes
print #game.g, "spritemovexy squirrel -4 0"
print #game.g, "spritemovexy duck 4 0"
print #game.g, "spritemovexy balloon 4 -5"
print #game.g, "spritemovexy duck2 -5 0"    'moving duck2 5 pixels to the left each drawsprites
print #game.g, "spritemovexy target 0 7"    'moving target down 7 pixels each drawsprites

print #game.g, "spritescale sight 110"
print #game.g, "spritescale duck 150"
print #game.g, "spritescale duck2 150"      'make duck2 bigger

print #game.g, "cyclesprite squirrel 1"

print #game.g, "spriteorient duck mirror"

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus";
    print #game.g, " when mouseMove [MoveSight]"
    wait

        'VII.  Timer Branch
    [TimerBranch]
    gosub [TrapSquirrel]
    gosub [TrapDuck]
    gosub [TrapBalloon]
    gosub [TrapDuck2]       'added trapping routines for the duck and target
    gosub [TrapTarget]
    gosub [draw]
    wait




'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
'*** Unload all of your bitmaps
    unloadbmp "balloon"    'We can't forget to unload all of our bitmaps
    unloadbmp "bottle"  'This releases system resources (memory)
    unloadbmp "can"
    unloadbmp "squirrel1"
    unloadbmp "squirrel2"
    unloadbmp "duck"
    unloadbmp "bullet"
    unloadbmp "target"
    unloadbmp "board"
    close #game
    end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [MoveSight]
    print #game.g, "spritexy sight ";MouseX-12;" ";MouseY-12
    wait

        'X.  Subs Called by Timer Branch
    [TrapSquirrel]
     print #game.g, "spritexy? squirrel SqX SqY"
     if SqX<-50 then print #game.g, "spritexy squirrel 300 205"
     return

[TrapDuck]
    print #game.g, "spritexy? duck duckX duckY"
    if duckX>320 then print #game.g, "spritexy duck 0 170"
return

[TrapBalloon]
    print #game.g, "spritexy? balloon balloonX balloonY"
    if balloonY<-10 then print #game.g, "spritexy balloon 0 300"
return

[TrapDuck2]     'trapping routinge for duck2
    print #game.g, "spritexy? duck2 duck2X duck2Y"
    if duck2X<-20 then print #game.g, "spritexy duck2 300 120"
return

[TrapTarget]    'tapping routine for target
    print #game.g, "spritexy? target targetX targetY"
    if targetY>244 then print #game.g, "spritexy target 140 -20"
    return

[draw]
print #game.g, "drawsprites";   'redraws background and sprites every 1/10th of a second
return
