'SGallery3.bas
'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Article 3
'Created by Richard Ryles April 2003
'Modified June 2003


    'I.  Window Setup
    'nomainwin
    WindowWidth = 300:WindowHeight =340 'increased the height by 20 pixels
    UpperLeftX=Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY=Int((DisplayHeight-WindowHeight)/2)


    graphicbox #game.g, 0, 20, 300, 300  'dropped down 20 pixels from the top

    statictext #game.st, "Score: ",0,0,200,18

'I changed the window name to Shooting Gallery 3
open "Shooting Gallery 3" for window as #game  'once again we are opening a plain window
print #game, "trapclose [quit]"
cursor crosshair

'II.  Load Bitmaps
loadbmp "balloon", "balloon.bmp"
loadbmp "bottle", "bottle.bmp"
loadbmp "can", "can.bmp"
loadbmp "squirrel1", "squirl1.bmp"
loadbmp "squirrel2", "squirl2.bmp"
loadbmp "duck", "duck.bmp"
loadbmp "target", "target.bmp"
loadbmp "bullet", "bullet.bmp"
loadbmp "board", "board.bmp"
loadbmp "sight", "sight.bmp"


    'III.  Initialize Variables
    balloonX=10:balloonY=300
    bottleX=-20:bottleY=170
    canX=300:canY=150
    squirrelX=300:squirrelY=205
    duckX=0:duckY=170
    targetX=125:targetY=-20
    bulletX=0:bulletY=700
    boardX=0:boardY=244
    duck2X=300:duck2Y=100
    ShootFlag=0
    count=0
    Score=0
    i=0

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "down;fill black"
print #game.g, "flush"
print #game.g, "getbmp bg 0, 0, 300, 300";
print #game.g, "background bg";

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite balloon balloon";
print #game.g, "addsprite bottle bottle";
print #game.g, "addsprite squirrel squirrel1 squirrel2";
print #game.g, "addsprite duck duck";
print #game.g, "addsprite target target";
print #game.g, "addsprite bullet bullet";
print #game.g, "addsprite can can";
print #game.g, "addsprite board board";
print #game.g, "addsprite sight sight";
print #game.g, "addsprite duck2 duck";  'here we are adding the second duck, we are using the same
                                                            'bitmap that we did for the first duck

        'C.  Set Initial Location of Sprites - spritexy
    print #game.g, "spritexy balloon ";balloonX;" ";balloonY;
    print #game.g, "spritexy bottle ";bottleX;" ";botleY;
    print #game.g, "spritexy can ";canX;" ";canY;
    print #game.g, "spritexy squirrel ";squirrelX;" ";squirrelY;
    print #game.g, "spritexy duck ";duckX;" ";duckY;
    print #game.g, "spritexy target ";targetX;" ";targetY;
    print #game.g, "spritexy bullet ";bulletX;" ";bulletY;
    print #game.g, "spritexy board ";boardX;" ";boardY;
    print #game.g, "spritexy duck2 ";duck2X;" ";duck2Y;             'duck2's start location on the right of the window

   ' D.  Set other Sprite Attributes
print #game.g, "spritemovexy squirrel -4 0"
print #game.g, "spritemovexy duck 4 0"
print #game.g, "spritemovexy balloon 4 -5"
print #game.g, "spritemovexy duck2 -5 0"    'moving duck2 5 pixels to the left each drawsprites
print #game.g, "spritemovexy target 0 7"    'moving target down 7 pixels each drawsprites

print #game.g, "spritescale sight 110"
print #game.g, "spritescale duck 150"
print #game.g, "spritescale duck2 150"      'make duck2 bigger

print #game.g, "cyclesprite squirrel 1"

print #game.g, "spriteorient duck mirror"

'V.  Initialize Timer, set no less than 56
[Begin]
timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus";
    print #game.g, " when mouseMove [MoveSight]"
    print #game.g, "when leftButtonDown [Shoot]"
    wait

        'VII.  Timer Branch
    [TimerBranch]
    gosub [TrapSquirrel]
    gosub [TrapDuck]
    gosub [TrapBalloon]
    gosub [TrapDuck2]
    gosub [TrapTarget]
    gosub [count]
    gosub [CheckCollisions]
    gosub [draw]
    gosub [GameTime]
    wait

    'VIII.  Quit Branch - unloads bitmaps and closes windows
    [quit]
    timer 0
    notice "Game Over"+chr$(13)+"Your Score is: ";Score
    confirm "Would You Like To Play Again?";answer$
    if answer$="yes" then goto [StartAgain]
    '*** Unload all of your bitmaps
    unloadbmp "balloon"    'We can't forget to unload all of our bitmaps
    unloadbmp "bottle"  'This releases system resources (memory)
    unloadbmp "can"
    unloadbmp "squirrel1"
    unloadbmp "squirrel2"
    unloadbmp "duck"
    unloadbmp "bullet"
    unloadbmp "target"
    unloadbmp "board"
    close #game
    end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [MoveSight]
    print #game.g, "spritexy sight ";MouseX-12;" ";MouseY-12
    wait

    [Shoot]
    if ShootFlag=0 then     'if a shot is not currently happening then do the following
        ShootFlag=1            'Says now there is a bullet on the screen
        bx=MouseX-11        'set's the bullets location in the center of the cursor
        by=MouseY-11        'will need to be changed if bullet size is changed
        print #game.g, "spritexy bullet "; bx; " " ;by     'placed the bullet on-screen relative
                                                                         ' to mouse location
        print #game.g, "drawsprites"
        playwave "shot", async      'plays a wav file
    end if
    wait

        'X.  Subs Called by Timer Branch

    [TrapSquirrel]
     print #game.g, "spritexy? squirrel squirrelX squirrelY"
     if squirrelX<-50 then print #game.g, "spritexy squirrel 300 205"
     return

    [TrapDuck]
    print #game.g, "spritexy? duck duckX duckY"
    if duckX>320 then print #game.g, "spritexy duck 0 170"
    return

    [TrapBalloon]
    print #game.g, "spritexy? balloon balloonX balloonY"
    if balloonY<-10 then print #game.g, "spritexy balloon 0 300"
    return

    [TrapDuck2]     'trapping routinge for duck2
    print #game.g, "spritexy? duck2 duck2X duck2Y"
    if duck2X<-20 then print #game.g, "spritexy duck2 300 120"
    return

    [TrapTarget]    'tapping routine for target
    print #game.g, "spritexy? target targetX targetY"
    if targetY>244 then print #game.g, "spritexy target 140 -20"
    return

    [count]
    if ShootFlag=1 then         
        count=count+1           
            if count>3 then        
                ShootFlag=0         
                count=0
                print #game.g, "spritexy bullet 0 700"  
            end if
    end if
    return

    [CheckCollisions]
    print #game.g, "spritecollides bullet list$"

    if list$= "squirrel sight" or list$= "squirrel board sight" then
        print #game.g, "spritexy squirrel 300 205"
        if list$="squirrel sight" then Score=Score+1
        if list$="squirrel board sight" then Score=Score+1
    end if

    if list$="balloon duck sight" or list$="duck sight" then
        print #game.g, "spritexy duck -40 170"
        if list$="duck sight" then Score=Score+2
        if list$="balloon duck sight" then Score=Score+5
    end if

    print list$
    return

    [draw]
    print #game.st, "Score: ";Score
    print #game.g, "drawsprites";
    return

    [GameTime]
    Time=Time+1
    if Time>300 then [quit]
    print Time
    return

    [StartAgain]
    ShootFlag=0
    count=0
    Score=0
    Time=0
    goto [Begin]
