'SubCom3.bas
'Created by Richard Ryles April 2003
'rryles@jeff-davis.k12.ga.us
'http://jdexchange.jeff-davis.k12.ga.us/~rryles/

'Example file for Beginning Game Programming
'for use with the Beginning Game Programming Series - Session 3


    'I.  Window Setup
    nomainwin
    WindowWidth = 500:WindowHeight =320
    UpperLeftX=Int((DisplayWidth-WindowWidth)/2)        'these two lines center the window on the screen
    UpperLeftY=Int((DisplayHeight-WindowHeight)/2)

graphicbox #game.g, 0, 20, 500, 300 'placed down 20 pixles to give the statictext room
statictext #game.st, "Ships Sunk",0,0,200,18 'adding the statictext along the top

open "SubCommand 3" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"

'II.  Load Bitmaps
loadbmp "bg", "subBG.bmp"
loadbmp "sub", "goodsub.bmp"
loadbmp "enemy", "enemysub.bmp"
loadbmp "ship", "ship.bmp"
loadbmp "torpedo", "torpedo.bmp"
loadbmp "mine", "mine.bmp"

    'III.  Initialize Variables
    sx=20:sy=75     'initial location of sub
    enemyX=-70:enemyY=200   'initial location of enemy
    shipX=500:shipY=45   'initial location of ship
    torpedoX=150:torpedoY=300   'initial location of torpedo
    mineX=600:mineY=200  'initial location of mine
    TorpFlag=0 'Torpedo Flag, if this equals one then we have
                    'a torpedo on the screen
    score=0 'initial value of the score variable

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite
print #game.g, "addsprite sub sub"
print #game.g, "addsprite enemy enemy"
print #game.g, "addsprite ship ship"
print #game.g, "addsprite torpedo torpedo"
print #game.g, "addsprite mine mine"

        'C.  Set Initial Location of Sprites - spritexy
    print #game.g, "spritexy sub ";sx;" ";sy  'pulled the variable values for our entities in these five lines
    print #game.g, "spritexy enemy ";enemyX;" ";enemyY
    print #game.g, "spritexy ship ";shipX;" ";shipY
    print #game.g, "spritexy torpedo ";torpedoX;" ";torpedoY
    print #game.g, "spritexy mine ";mineX;" ";mineY

        'D.  Set other Sprite Attributes
    print #game.g, "spritemovexy ship -5 0"    '-5 causes the ship to move to the left
    print #game.g, "spritemovexy mine 0 6"     '6 causes the mine to move down
    print #game.g, "spritemovexy enemy 10 0"     'causes the enemy sub to move right
    'print #game.g, "spritemovexy torpedo 0 -6"      'causes the torpedo to move up

    print #game.g, "spriteorient torpedo flip"      'flips the torpedo to point up instead of down
    print #game.g, "spritescale torpedo 50"     'reduced the size of the torpedo by 50%

    'V.  Initialize Timer, set no less than 56
    timer 100, [TimerBranch]

    'VI.  Initialize Keyboard and Mouse Events
    print #game.g, "setfocus"   'causes #game.g to be the active window for keypresses and mouse movements
    print #game.g, "when characterInput [KeyCheck]"  'when a key is pressed goto the KeyCheck branch
    wait 'this first wait in the program will not allow the code below to be executed.  From now on the
            'timer, keyboard and mouse are in control of what happens.

    'VII.  Timer Branch
    [TimerBranch]   'the timer causes the program to come here every 10th of a second and run the following
    gosub [TrapShip]
    gosub [TrapMine]
    gosub [TrapEnemy]
    gosub [TorpShipCollision]
    gosub [TrapTorpedo]
    gosub [MoveTorpedo]
    gosub [draw]
    wait    'stops when it gets here, waits until told to do something else

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
    unloadbmp "bg"
    unloadbmp "sub"
    unloadbmp "enemy"
    unloadbmp "ship"
    unloadbmp "torpedo"
    unloadbmp "mine"
    close #game
    end

    'IX.  Branches called by Mouse and or Keyboard - user entity movement
    [KeyCheck]
    k$=Inkey$   'assigning the Inkey$ another name - shortens what we have to type in

    if k$=" " then gosub [ShootTorpedo]

    if k$="1" or k$="4" or k$="7" then
        sx=sx-1      'move the sub left
        print #game.g, "spriteorient sub mirror" 'causes the sub sprite to flip vertically
    end if  'terminates the if/then block

    if k$="9" or k$="6" or k$="3" then
        sx=sx+1     'moves the sub right
        print #game.g, "spriteorient sub normal" 'normal returns the sub to it's original direction
    end if

    if k$="7" or k$="8" or k$="9" then sy=sy-1      'moves the sub up
    if k$="1" or k$="2" or k$="3" then sy=sy+1     'moves the sub down

    'print "sx= ";sx     'prints the value of sx in the main window if nomainwin is commented out
    'print "sy= ";sy     'prints the value of sy in the main window if nomainwin is commented out

    if sx<1 then sx=1       'traps the left edge - sub won't move past 1
    if sx>425 then sx=425   'traps the right edge - sub won't move past 425
    if sy<55 then sy=55      'traps the top of the sub - will not move above the water line
    if sy>235 then sy=235   'traps the bottom edge - will not allow the sub to move past 235
    print #game.g, "spritexy sub "; sx; " ";sy 'prints the sub in the new location

    wait

    [ShootTorpedo]
    if TorpFlag=0 then
        TorpFlag=1
        torpedoY=sy
        torpedoX=sx+32
    end if
    return

'X.  Subs Called by Timer Branch
[TrapShip]
print #game.g, "spritexy? ship x y"     'gets the location of ship and places the x & y values in x and y
if x<-50 then print #game.g, "spritexy ship 500 45"     'if ship has moved beyond the left edge then it is placed
return                                                                       'back at it's initial location

    [DropMine]
        if MineActive=1 then
            MineActive=1
            print #game.g, "spritexy? ship shipX shipY"
            mineX=shipX
            mineY=shipY
        end if
    return


    [TrapMine]
    print #game.g, "spritexy? mine mineX mineY"     'places the mine' coordinated in the variables mineX and mineY
    if mineY>320 then
        print #game.g, "spritexy? ship shipX shipY"
        mineX=shipX+60
        mineY=shipY
    end if
    print #game.g, "spritexy mine ";mineX;" ";mineY
    return  'returns to the point in the program that directed the program here

    [TrapEnemy]
    print #game.g, "spritexy? enemy enemyX enemyY"
    if enemyX>500 then
        enemyY=int(rnd(0)*180)+55
        print #game.g, "spritexy enemy ";0;" ";enemyY
    end if
    return

    [TrapTorpedo]
        if torpedoY<-30 then
            torpedoX=150:torpedoY=300
            TorpFlag=0
        end if
    return


    [TorpShipCollision]
    print #game.g, "spritecollides torpedo list$"
    if list$= "ship" then
        print #game.g, "spritexy ship ";-100;" ";sy
        torpedoX=150:torpedoY=300
        TorpFlag=0
        score=score+1
        playwave "boom.wav", async
    end if
    return

    [MoveTorpedo]
    if TorpFlag=1 then torpedoY=torpedoY-6
    print #game.g, "spritexy torpedo ";torpedoX;" ";torpedoY
    return

    [draw]
    print #game.st, "Ships Sunk = ";score
    print #game.g, "drawsprites";
    return
