     rem  non linear equations solver
     PRINT "PROGRAM WITH PIVOTING STRATEGY"
     A=15'max number of variables
     DIM C(A,A):dim F(A):dim D(A,A):dim G(A)
     dim X(A):dim S(A):dim E(A):dim A(A)
     prompt "choose Sub 1 or 2";z$
     z= val(z$)
     if z=1 then GOSUB 1020
     if z=2 then gosub 1060
     M=NR:N=M+1
    PRINT "NUMBER OF EQUATIONS =";NR
   if z=2 then
    print " this problem requires rather close guesses to converge"
    print "z=2            guesses"
    REM ***** GUESS INITIAL ROOTS ******
    print "X1    O2        .1"
    print "X2    C0        1e-10"
    print "X3    CO2       .1"
    print "X4    H2        1e-10"
    print "X5    H20       .1"
    print "X6    NTOT      10"
    print "X7    N2        1"
    print "X8    NH3       1e-18"
    print "X9    CH4       1e-22"
    print""
    FOR J=1 TO M
      PRINT "X";J;"  ";A$(J);
      INPUT "     ";AA: S(J)=AA
    NEXT J
   else
    print "z=1 "
    PRINT" ALL GUESSES =1 "
    REM ***** GUESS INITIAL ROOTS ******
    FOR J=1 TO M
      PRINT "X";J;A$(J);
      INPUT "     ";AA: S(J)=AA
    NEXT J
   end if
 PP=200'MAX ITERATIONS
 DS=.0001'step in numder

 FOR Q=1 TO PP          'PP=MAX ITERATIONS
  REM     *****  Numeric derivation *****
  gosub [numder]
  REM   *****  Gauss-Jordan elimination *****
  gosub [gauss]
  print "  *** Solution vector ****"
        CC=0
    FOR J=1 TO M
      X(J)=C(J,N) 'calculated roots
      if  trim$(A$(J))<> "C" then X(J)=abs(X(J))
      H=(X(J)-S(J))/S(J)
        CC=CC+abs(H)
       X$=str$(X(J)):n5=len(X$)
       n6=len(A$(J))
       q$=A$(J):q1$=trim$(A$(J))
      PRINT J;"   ";A$(J);"    ";X(J)
      S(J)=X(J)/10*5+S(J)/10*5
    NEXT J
    PRINT "error  =";CC
    if CC<10^-4 then
    exit for
    end if
  next Q
    print "number of iterations=";Q
    print q2$
    print ""
    print " A(I) should be close to zero"
    for i=1 to M
    print i;"  ";A(i)
    next i
    print "end"
 END

[numder]
                                    'input to numder via A(I) and S(J)
    if z=1 then GOSUB 2020
    if z=2 then gosub 2060
    FOR I=1 TO M
      F(I)=A(I)
    NEXT I
    FOR J=1 TO M
       T=S(J)*DS                    'DS=step in numder, set in main program
       S(J)=S(J)+T
      if z=1 then GOSUB 2020
      if z=2 then gosub 2060
        FOR I=1 TO M
          D(I,J)=(A(I)-F(I))/T      'derivatives
        NEXT I
       S(J)=S(J)-T
    NEXT J
    FOR I=1 TO M
      G(I)=(-1)*F(I)                'parts of known terms
         FOR J=1 TO M
           G(I)=G(I)+S(J)*D(I,J)    'complete known terms
         NEXT J
    NEXT I
    FOR I=1 TO M
      C(I,N)=G(I)                   'known terms
        FOR J=1 TO M
          C(I,J)=D(I,J)             'derivatives: coeff for the unknown terms
        NEXT J
    NEXT I
    'output from numder via C(I,J)
    return

[gauss]
    'input to Gauss via C(I,J)
    'next 10 statements: Finds the first equation with a
    'non-zero coefficient for the current column
    FOR J=1 TO M                     'M= number of equations
       FOR I=J TO M
         IF C(I,J)<>0 THEN
         FOR K=1 TO N                'N= M+1=number of terms in an equation
           X=C(J,K)
           C(J,K)=C(I,K)
           C(I,K)=X
         NEXT K
        END IF
       NEXT I
         IF ABS(C(J,J))<10^(-80) THEN'only information
         q2$="Result wrong! Division with zero might be avoided."
         exit for
         else
         q2$= "No problems detected"
         end if                      ' end of "only information"
        Y=1/C(J,J)
        FOR K=1 TO N
          C(J,K)=Y*C(J,K)
        NEXT K
        FOR I=1 TO M
          IF I=J THEN goto [jump]
          Y=(-1)*C(I,J)
           FOR K=1 TO N
            C(I,K)=C(I,K)+Y*C(J,K)
           NEXT K
           [jump]
        NEXT I
  NEXT J                          'here ends the Gauss-Jordan substitution
                                  'The roots stored in C(I,N)for I=1 to M
  return

1020 REM *** SUBROUTINE NUMBER OF EQUATIONS ***
     NR=4
     A$(1)=" ROOT1 ":A$(2)=" ROOT2 ":A$(3)=" ROOT3 "
     A$(4)=" ROOT4 ":A$(5)=" ROOT5 ":A$(6)=" ROOT6 "
     A$(7)=" ROOT7 ":A$(8)=" ROOT8 ":A$(9)=" ROOT9 ":A$(10)=" ROOT10 "
     RETURN

2020 REM  **** SUBROUTINE EQUATIONS ****'TO USE: CHANGE AT 2 LOCATIONS IN THE MAIN PROGRAM
     S1=S(1): S2=S(2): S3=S(3): S4=S(4): S5=S(5)
     S6=S(6): S7=S(7): S8=S(8): S9=S(9): S10=S(10)
     REM ******************************************
     A(1)=S1+S2-3          'x1+x2=3
     A(2)=S1+S2^(2)-5      'x1+x2^2=5
     A(3)=S1^(2)+S4^(2)-17 'x1^2+x4^2=17
     A(4)=S4+S3^(2)-13     'x4+x3^2=13
     REM ******************************************
     RETURN


1060 REM *** SUBROUTINE NUMBER OF EQUATIONS ***
     NR=9
     A$(1)=" O2    ":A$(2)=" C0    ":A$(3)=" CO2   "
     A$(4)=" H2    ":A$(5)=" H20   ":A$(6)=" NTOT  "
     A$(7)=" N2    ":A$(8)=" NH3   ":A$(9)=" CH4   "
     RETURN

2060 REM  **** SUBROUTINE EQUATIONS ****
     S1=S(1): S2=S(2): S3=S(3): S4=S(4): S5=S(5)
     S6=S(6): S7=S(7): S8=S(8): S9=S(9): S10=S(10)
     REM *****************************************************
      PT=1    'pressure
      T1=1000   'temp K
      MO2=2'MOL
      MH2=.5'MOL
      MC =1'MOL
      MN2=6'MOL
      K2=.00574*EXP(5691/T1)            'SHIFT
      K3=5.22*10^(-11)*EXP(9367/T1)     'NH3
      K4=3.5*10^(-5)*EXP(8224/T1)       'CH4 1100K
      K5=9.6610^(-10)*EXP(67835/T1)     '2C0+O2

     A(1)=1-K5*S2^(2)*S1/S3^(2)                'C0 +1/2O2
     A(2)=1-K2*S2*S5/S3/S4                     'SHIFT EQ
     A(3)=1-K3*S7*S4^(3)/S8^(2)                'NH3 EQ
     A(4)=1-K4*S4^(2)/S9                       'CH4 EQ
     A(5)=(S2+S3+S9)*S6/PT             -MC     'C BAL.
     A(6)=(S4+S5+2*S9+1.5*S8)*S6/PT    -MH2    'H2 BAL
     A(7)=(S2+2*S3+S5+2*S1)*S6/PT      -MO2*2  'O BAL
     A(8)=(S8+2*S7)*S6/PT              -MN2*2  'N BAL.
     A(9)=S1+S2+S3+S4+S5+S7+S8+S9-PT           'DALTON
'    1=O2  2=CO 3=C02 4=H2  5=H20  6=NTOT  7=N2   8=NH3  9=CH4
     REM ******************************************************
     RETURN




