'** 8/16/2003 11:26:16 PM
'** Viewport Mapping

    True  = 1  
    False = 0
    
    ViewPortIsCaptured = 0
    
    MouseInViewPortHandle = 0

LOADBMP "VPort", "VPort.bmp"
    
Dim WorldX(20)
Dim WorldY(20)
Dim WallX(20)
Dim WallY(20)
Dim ScreenX(20)
Dim ScreenY(20)
Dim inode(20)
Dim jnode(20)

WorldX(1)  = 1.00  :  WorldY(1)  = 3.00
WorldX(2)  = 1.50  :  WorldY(2)  = 0.50
WorldX(3)  = 2.50  :  WorldY(3)  = 1.50
WorldX(4)  = 2.50  :  WorldY(4)  = 4.00
WorldX(5)  = 3.00  :  WorldY(5)  = 1.00
WorldX(6)  = 4.00  :  WorldY(6)  = 2.00
WorldX(7)  = 4.00  :  WorldY(7)  = 3.00
WorldX(8)  = 3.00  :  WorldY(8)  = 3.00
WorldX(9)  = 4.00  :  WorldY(9)  = 3.50
WorldX(10) = 3.50  :  WorldY(10) = 4.00
WorldX(11) = 4.50  :  WorldY(11) = 5.50
WorldX(12) = 9.00  :  WorldY(12) = 7.50
WorldX(13) = 7.00  :  WorldY(13) = 4.00
WorldX(14) = 7.00  :  WorldY(14) = 7.50
WorldX(15) = 9.00  :  WorldY(15) = 4.50

inode(1)  = 1   : jnode(1)  = 2
inode(2)  = 2   : jnode(2)  = 3
inode(3)  = 4   : jnode(3)  = 5
inode(4)  = 5   : jnode(4)  = 6
inode(5)  = 6   : jnode(5)  = 7
inode(6)  = 7   : jnode(6)  = 8
inode(7)  = 8   : jnode(7)  = 9
inode(8)  = 9   : jnode(8)  = 10
inode(9)  = 10  : jnode(9)  = 4
inode(10) = 11  : jnode(10) = 12
inode(11) = 12  : jnode(11) = 13
inode(12) = 13  : jnode(12) = 14
inode(13) = 14  : jnode(13) = 15
inode(14) = 15  : jnode(14) = 11

    NumLines = 14

for i = 1 to 15
    WallX(i) = WorldX(i)*(200 / 10)
    WallY(i) = 160 - (160/8)*WorldY(i)
next i

[InitColors]
    'It is suggested that default colors be used when possible.
    'Activate the following color statements only if 
    'they are really necessary in the program.
    'ForegroundColor$ = "Black"
    'BackgroundColor$ = "Buttonface"
    'TexteditorColor$ = "White"
    'TextboxColor$    = "White"
    'ComboboxColor$   = "White"
    'ListboxColor$    = "White"

[WindowSetup]
    NOMAINWIN
    WindowWidth = 608 : WindowHeight = 425
    UpperLeftX = INT((DisplayWidth-WindowWidth)/2)
    UpperLeftY = INT((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Menu        #main, "&File" , _ 
                   "E&xit", [btnQuit.click]
                   
Menu        #main, "Help" , _ 
                   "Open VPHelp.txt with Notepad...", [Open.VPHelp.txt.With.Notepad], |, _
                   "About Viewport...", [btnAbout.click]


graphicbox  #main.GboxWorld, 15, 15, 200, 160
graphicbox  #main.GboxPlot, 255, 15, 320, 240
statictext  #main.Stat01, "The box above represents", 20, 195, 200, 20
statictext  #main.Stat02, "the Real World.  Left click on", 20, 215, 200, 20
statictext  #main.statictext3, "the Viewport handle and move", 20, 235, 200, 20
statictext  #main.Stat04, "the Viewport to a new location.", 20, 255, 200, 20
statictext  #main.Stat4a, "Right click to release Viewport.", 20, 275, 200, 20
statictext  #main.Stat05, "World Coordinates:", 260, 270, 120, 20
statictext  #main.Stat06, "GraphicBox Coordinates:", 415, 270, 160, 20
statictext  #main.Stat07, "X:", 260, 295, 15, 20
statictext  #main.Stat08, "Y:", 260, 320, 15, 20
statictext  #main.Stat09, "X:", 415, 295, 15, 20
statictext  #main.Stat10, "Y:", 415, 320, 15, 20
button      #main.btnQuit, "Quit",[btnQuit.click],UL, 125, 305, 95, 35
button      #main.btnAbout, "About...",[btnAbout.click],UL, 20, 305, 95, 35
textbox     #main.txtWorldx, 280, 290, 80, 25
textbox     #main.txtWorldy, 280, 315, 80, 24
textbox     #main.txtScreenx, 435, 290, 80, 24
textbox     #main.txtScreeny, 435, 315, 80, 24

Open "Viewport by Tomas J. Nally" for Window as #main

    print #main, "trapclose [btnQuit.click]"
    print #main.GboxWorld, "down; fill White; flush"
    print #main.GboxWorld, "setfocus; when mouseMove [MouseChange1]"
    print #main.GboxWorld, "when leftButtonUp [LeftClick1]"
    print #main.GboxWorld, "when rightButtonUp [RightClick1]"
    print #main.GboxPlot, "down; fill White; flush"
    print #main.GboxPlot, "setfocus; when mouseMove [MouseChange2]"
    print #main, "font ms_sans_serif 10"
    
    Gosub [Draw.Objects.In.Wall.GraphicBox]
    Gosub [Capture.Wall.Image.For.Background]
    
    print #main.GboxWorld, "addsprite VPort VPort"
    print #main.GboxWorld, "spritevisible VPort on"
    print #main.GboxWorld, "spritexy VPort 5 5"
    print #main.GboxWorld, "drawsprites"
    VPortSX = 5
    VPortSY = 5
    Gosub [Find.World.Coordinates.Of.Viewport]

[loop]
    Wait



[MouseChange1]
    'MouseX and MouseY contain mouse coordinates
    
    MouseInViewPortHandle = 0
    If (ViewPortIsCaptured = 0) then
        gosub [Check.For.Mouse.In.ViewPort.Handle]
    end if
    
    If (ViewPortIsCaptured = 1) then
        VPortSX = MouseX
        VPortSY = MouseY
        print #main.GboxWorld, "spritexy VPort "; VPortSX; " "; VPortSY
        print #main.GboxWorld, "drawsprites"
        
        Gosub [Find.World.Coordinates.Of.Viewport]
        Gosub [Recalc.Screen.Coordinates.Of.Nodes]
        print #main.GboxPlot, "cls"  
        Gosub [Plot.Lines.In.Plot.Area]      
        
    end if
    
    Wait

[LeftClick1]

    if  ((ViewPortIsCaptured = 0) and (MouseInViewPortHandle = 1)) then
        ViewPortIsCaptured = 1
    end if
    
    Wait

[RightClick1]

    If (ViewPortIsCaptured = 1) then
        ViewPortIsCaptured = 0
        MouseInViewPortHandle = 0
        
        print #main.GboxWorld, "flush"
        print #main.GboxPlot,  "flush" 
        
    end if

    Wait



[MouseChange2]
    'MouseX and MouseY contain mouse coordinates
    
    MouseWorldX = MouseX*(4/320) + VPortWX
    MouseWorldY = (240 - MouseY)*(3/240) + (VPortWY - 3)
    
    print #main.txtWorldx, using("######.##", MouseWorldX)
    print #main.txtWorldy, using("######.##", MouseWorldY)

    print #main.txtScreenx, "   " + str$(MouseX)
    Print #main.txtScreeny, "   " + str$(MouseY)

    
    Wait

[btnQuit.click]
    close #main : END


[btnAbout.click]

    Notice "About Viewport                               " + chr$(13) + _
           "Copyright Tomas J. Nally                     " + chr$(13) + _
           "August 2003                                  " + chr$(13) + _
           "Steelweaver52@aol.com                        " + chr$(13) + _
           "Released as Open Source                      " + chr$(13) + _
           "                                             " + chr$(13) + _
           "Viewport is made with the following:         " + chr$(13) + _
           "                                             " + chr$(13) + _
           "Liberty BASIC by Carl Gundel                 " + chr$(13) + _
           "http://www.libertybasic.com                  " + chr$(13) + _
           "                                             " + chr$(13) + _
           "Liberty BASIC Workshop by Alyce Watson       " + chr$(13) + _
           "http://alycesrestaurant.com                  " + chr$(13) + _
           "                                             " + chr$(13) + _
           "MSPaint by Microsoft                         " + chr$(13) + _
           "http://www.microsoft.com                     "

    Wait


[Draw.Objects.In.Wall.GraphicBox]

    for i = 1 to NumLines
        WLX1 = WallX(inode(i))
        WLY1 = WallY(inode(i))
        WLX2 = WallX(jnode(i))
        WLY2 = WallY(jnode(i))
        print #main.GboxWorld, "line "; WLX1; " "; WLY1; " "; WLX2; " "; WLY2
    next i
    Return
    
[Capture.Wall.Image.For.Background]

    print #main.GboxWorld, "getbmp WallBkgnd 0 0 200 160"
    print #main.GboxWorld, "background WallBkgnd"

    Return

[Check.For.Mouse.In.ViewPort.Handle]

    If ((MouseX >= VPortSX) and (MouseX <= (VPortSX + 5)) and (MouseY >= VPortSY) and (MouseY <= (VPortSY + 5))) then
        MouseInViewPortHandle = 1
    end if

    Return

[Find.World.Coordinates.Of.Viewport]

    VPortWX = (10/200)*VPortSX
    VPortWY = (8/160)*(160-VPortSY)
    Return
    

[Recalc.Screen.Coordinates.Of.Nodes]

    For i = 1 to 15
        ScreenX(i) = (320/4)*(WorldX(i) - VPortWX)
        ScreenY(i) = 240 - (240/3)*(WorldY(i) - (VPortWY - 3))
    Next i

    Return
    
    
[Plot.Lines.In.Plot.Area]

    for i = 1 to NumLines
        SX1 = ScreenX(inode(i))
        SY1 = ScreenY(inode(i))
        SX2 = ScreenX(jnode(i))
        SY2 = ScreenY(jnode(i))
        print #main.GboxPlot, "line "; SX1; " "; SY1; " "; SX2; " "; SY2
    next i


    Return
    
[Open.VPHelp.txt.With.Notepad]

    RUN "NOTEPAD VPHelp.txt"

    Wait


