MODULE MsgLog;

  IMPORT W := Windows, S := SYSTEM, M := MyRtns;
  
TYPE
  STRING* = ARRAY 128 OF CHAR; 
  
  mLogP = POINTER TO mLog;
  mLog  =  RECORD
   prev, next:   mLogP;
   msg:          STRING;
   END;

CONST
  class = "MsgLogClass";
  TitleBar = "Message Log";   

VAR
  MLhWnd:  W.HWND;
  cline,
  lines:  INTEGER;
  oldTop,
  top, currM, thisM,
  firstM, lastM: mLogP;
  mll:  mLogP;
  
PROCEDURE Len(VAR s: STRING): INTEGER;
VAR
  i:  INTEGER;
BEGIN
  i := 0;
  WHILE (s[i] # CHR(0)) & (i <= SIZE(STRING)) DO i := i + 1 END;
  RETURN i;
END Len;

PROCEDURE PaintMsgLog(hWnd: W.HWND; hdc: W.HDC);
VAR
  rc,
  i:    INTEGER;
  cr:   W.COLORREF;
  saveTop:  mLogP;
BEGIN
  W.SetScrollRange(hWnd,W.SB_VERT, 0, M.Max(0,lines-19), 0);
  rc := W.SetScrollPos(hWnd, W.SB_VERT, cline, 1);
  top := firstM;
  FOR i := 1 TO cline-1 DO
    top := top^.next;
  END;
  thisM := top;
  saveTop := top;
  i := 0;
  WHILE thisM # NIL DO
    IF oldTop # NIL THEN   (* erase old text line in a 'flicker-free manner *)
      cr := W.SetTextColor(hdc, W.GetSysColor(W.COLOR_WINDOW));
      rc := W.TextOut(hdc, 10, i * 16, S.ADR(oldTop.msg), Len(oldTop.msg)); 
      oldTop := oldTop.next;
    END;                   (* Display a line of text  *)
      cr := W.SetTextColor(hdc, W.GetSysColor(W.COLOR_WINDOWTEXT));
    rc := W.TextOut(hdc, 10, i * 16, S.ADR(thisM.msg), Len(thisM.msg)); 
    thisM := thisM.next;
    i := i + 1;
  END;
  oldTop := saveTop;
END PaintMsgLog;  
  
PROCEDURE [WINDOWS] MLogWndProc*(hWnd: W.HWND;   (* window handle             *)
                                 message: W.WORD;(* type of message           *)
                                 wParam: W.WORD; (* additional information    *)
                                 lParam: LONGINT (* additional information    *)
                                     ): LONGINT;
VAR
  i, len,
  rc: INTEGER;
  hdc:  W.HDC;
  rect: W.RECT;
  ps:   W.PAINTSTRUCT;
BEGIN
  CASE message OF
    W.WM_PAINT:
      hdc := W.BeginPaint(hWnd, S.ADR(ps));
      PaintMsgLog(hWnd, hdc);
      W.EndPaint(hWnd, S.ADR(ps)); 
      RETURN 0;
  | W.WM_VSCROLL:         (* code for handling Vertical scrolling  *)
      CASE wParam OF
        W.SB_TOP:
          cline := 1;
      | W.SB_BOTTOM:
          cline := lines; 
      | W.SB_PAGEUP:
          cline := M.Max(0, cline - 19);
      | W.SB_PAGEDOWN:
          cline := M.Min(lines-19, cline+20);
      | W.SB_LINEUP:
          cline := M.Max(0, cline - 1);
      | W.SB_LINEDOWN:
          cline := M.Min(lines-19, cline+1);          
      ELSE
      END;
      W.InvalidateRect(hWnd, W.NULL, 1);
       
      RETURN 0;   
  | W.WM_DESTROY: 
    W.PostQuitMessage(0);
    RETURN 0;
  ELSE                                    (* Passes it on if unproccessed     *)
    RETURN W.DefWindowProc(hWnd, message, wParam, lParam)
  END;  
END MLogWndProc; 

PROCEDURE ClrScr*;           (* Used to Clear the Message Log display   *)
VAR
BEGIN
  top := firstM;
  oldTop := NIL;
  WHILE top # NIL DO
    firstM := top^.next;
    DISPOSE(top);
    top := firstM;
  END;
  cline := 0;
  lines := 0;
  firstM := NIL;
  lastM := NIL;
  top := NIL;
  W.InvalidateRect(MLhWnd, W.NULL, 0);
END ClrScr;
  

PROCEDURE LogMsg*(m: STRING; CR: BOOLEAN);   (* log a message of a text sting  *)
VAR
  hdc:    W.HDC;
  rc:     INTEGER;
BEGIN
  IF firstM = NIL THEN
    NEW(mll);
    firstM := mll;
    lastM := firstM;
    top := firstM;
    mll^.msg[0] := CHR(0);
    mll^.prev := NIL;
    mll^.next := NIL;
    currM := mll;
    top := mll;
    lines := 1;
  END;
  M.Append(mll.msg,m);
  IF CR THEN
    currM := mll;
    NEW(mll);
    mll.next := NIL;
    mll.prev := currM;
    currM.next := mll;
    lines := lines + 1;
    cline := M.Max(1,lines-19);
    IF lines > 20 THEN
      top := top.next;
    END;   
  END;
  hdc := W.GetDC(MLhWnd);
  PaintMsgLog(MLhWnd, hdc);
  rc := W.ReleaseDC(MLhWnd, hdc);
  RETURN;
END LogMsg;

PROCEDURE LogMsgI*(i: LONGINT; CR: BOOLEAN);
VAR
  msg: STRING;
BEGIN
  M.Str(i,msg);
  LogMsg(msg, CR);
END LogMsgI;

PROCEDURE LogMsgSI*(s: STRING; i: LONGINT; CR: BOOLEAN);
VAR
  msg: STRING;
BEGIN
  LogMsg(s, FALSE);
  M.Str(i,msg);
  LogMsg(msg, CR);
END LogMsgSI;

PROCEDURE LogMsgSS*(s1, s2: STRING;  CR: BOOLEAN);
VAR
  msg: STRING;
BEGIN
  LogMsg(s1, FALSE);
  LogMsg(s2, CR);
END LogMsgSS;

PROCEDURE DefineMsgLogClass*(hInstance: W.HANDLE);
VAR
  rc:  INTEGER;
  wc: W.WNDCLASS;
BEGIN
    wc.style := W.NULL;                     (* Class style(s).                  *)
    wc.lpfnWndProc := MLogWndProc;          (* Function to retrieve messages for*)
                                            (* windows of this class.           *)
    wc.cbClsExtra := 0;                     (* No per-class extra data.         *)
    wc.cbWndExtra := 0;                     (* No per-window extra data.        *)
    wc.hInstance := hInstance;              (* Application that owns the class. *)
    wc.hIcon := W.LoadIcon(hInstance, S.ADR("GENERICICON"));
    wc.hCursor := W.LoadCursor(W.NULL, W.IDC_ARROW);
    wc.hbrBackground := W.GetStockObject(W.WHITE_BRUSH);
    wc.lpszMenuName := W.NULL;              (* Name of menu resource in .RC file*)
    wc.lpszClassName := S.ADR(class);  (* Name used in call to CreateWindow*)
                                          (* Register the window class and    *)
                                          (*  return success/failure code.    *)
    rc := W.RegisterClass(S.ADR(wc));
END DefineMsgLogClass;

PROCEDURE DisplayMsgLog*(hInstance: W.HANDLE; nCmdShow: INTEGER): LONGINT;
VAR
  r:     LONGINT;
BEGIN
  MLhWnd := W.CreateWindow(S.ADR(class),(* See RegisterClass() call        *)
                         S.ADR(TitleBar),(* Text for window title bar    *)
                         W.WS_OVERLAPPEDWINDOW + (* Window style               *)
                         W.WS_VSCROLL + W.WS_HSCROLL,
                         0,               (* Default horizontal position      *)
                         0,               (* Default vertical position        *)
                         W.CW_USEDEFAULT, (* Default width                    *)
                         W.CW_USEDEFAULT, (* Default height                   *)
                         W.NULL,          (* Overlapped windows have no parent*)
                         W.NULL,          (* Use the window class menu        *)
                         hInstance,       (* This instance owns this window   *)
                         W.NULL);         (* Pointer not needed               *)
                                          (* If window could not be created,  *)
  IF MLhWnd = 0 THEN RETURN W.false END;      (* return "failure"                 *)
                                          (* Make the window visible; update  *)
                                          (* its client area; and return      *)
                                          (* "success"                        *)
  r := W.ShowWindow(MLhWnd, nCmdShow);      (* Show the window                  *)
  W.UpdateWindow(MLhWnd);                   (* Sends WM_PAINT message           *)
  RETURN r;
END DisplayMsgLog;

BEGIN                (* Initialise global variables   *)
  top := NIL;
  oldTop := NIL;
  currM := NIL;
  firstM := NIL;
  lastM := NIL;
  lines := 0;
END MsgLog.
