' Demo of a Timer CallBack for Animation
    nomainwin
                ' Open the DLL with the Timer Functions
    open "brosco.dll" for dll as #a


' ***********************************************************************
' The following window is used for communications with the TimerDll

    WindowWidth = 100
    WindowHeight = 50
    open "user" for dll as #user
    textbox #wd.tb, 0, 0, 80, 25   ' This will contain a count of "times" called
    open "Callback" for window as #wd
    Print #wd, "trapclose [st.button]"
    Print #wd, "resizehandler [st.button]"  ' This is the [label] activated by timer

'           The following two handles must be passed to the timer
'           They will be used to simulate a Callback
    hst = hwnd(#wd)
    htb = hwnd(#wd.tb)
    CallDll #a, "InitTimer", _
        hst as word, _          ' Handle of the callback window
        htb as word, _          ' Handle of the texbox in the callback window
        2 as word, _            ' Option 2 - use the mmSystem.dll
        r as word               ' 0 = success

'  For normal use you would HIDE this window -
'

    calldll #user, "ShowWindow",_
        hst as word,_
        _SW_HIDE as ushort,_
        result As word
' ***********************************************************************


' *****    Here's the real window where stuff happens ******

    WindowWidth = 640
    WindowHeight = 480

    menu #w, "&File", "&Open", [load.file], "E&xit", [close.w]
    menu #w, "&Edit"

    texteditor #w.te, 0, 0, 510, 435

    statictext #w.st, "Speed", 550, 170, 50, 20
    radiobutton #w.m10, "10 mSecs", [10ms], [reset], 520, 190, 90, 25
    radiobutton #w.m25, "25 mSecs", [25ms], [reset], 520, 210, 90, 25
    radiobutton #w.m50, "50 mSecs", [50ms], [reset], 520, 240, 90, 25
    radiobutton #w.m75, "75 mSecs", [75ms], [reset], 520, 270, 90, 25
    radiobutton #w.m100, "100 mSecs", [100ms], [reset], 520, 300, 90, 25
    radiobutton #w.m125, "125 mSecs", [125ms], [reset], 520, 330, 90, 25

    open "Test MM Timer CallBack - Animation" for graphics_nsb as #w
    print #w, "trapclose [close.w]"

    hw = hwnd(#w)

    Print #w.te, " ******* Please wait - Loading Images *******"

    LoadBmp "man1", "hman001.bmp"
    LoadBmp "man2", "hman002.bmp"
    LoadBmp "man3", "hman003.bmp"
    LoadBmp "man4", "hman004.bmp"
    LoadBmp "man5", "hman005.bmp"
    LoadBmp "man6", "hman006.bmp"
    LoadBmp "man7", "hman007.bmp"
    LoadBmp "man8", "hman008.bmp"
    LoadBmp "man9", "hman009.bmp"
    LoadBmp "man10", "hman010.bmp"
    LoadBmp "man11", "hman011.bmp"
    LoadBmp "man12", "hman012.bmp"
    LoadBmp "man13", "hman013.bmp"
    LoadBmp "man14", "hman014.bmp"

    print #w.m100, "set"
    speed = 100  ' Activate the CallBack routine every 100 mSeconds
                 ' (1000mSecs = 1 second)
                 ' NOTE: Minimum speed is 10ms - Max speed is 65535ms
                 '
    CallDll #a, "StartTimer", 1 as word, speed as word, r as word

    filename$ = "anim.txt"  'Load something to the text file
    goto [load.readme]
[loop]
    input var$
    goto [loop]

[st.button]         ' this routine is activated after the delay
    image = image + 1
    if image > 14 then image = 1
    Print #w, "drawbmp man"; str$(image); " 515 0;discard"
'
' *** NOTE 1.
'  The discard is VERY important.  Every output to a
' graphics screen causes a write to a MetaFile so that the FLUSH
' command can be used.  Without the DISCARD command - you will get
' a MetaFile error because of the number of screen updates without
' the Flush command being used by this program.
'
' *** NOTE 2.
' When using MMSystem.dll timer - you must inform Brosco.dll that
' the message has been processed and that you are ready to receive
' another.
'
    CallDll #a, "SetMsgProcessed", r as word
    goto [loop]

[reset]
    goto [loop]

[10ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 10 as word, r as word
    goto [loop]

[25ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 25 as word, r as word
    goto [loop]

[50ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 50 as word, r as word
    goto [loop]

[75ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 75 as word, r as word
    goto [loop]

[100ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 100 as word, r as word
    goto [loop]

[125ms]
    calldll #a, "PauseTimer", 1 as word, r as word
    calldll #a, "ResumeTimer", 1 as word, 125 as word, r as word
    goto [loop]


[load.file]
    filedialog "Open File", "*.txt", filename$
    if filename$ = "" then goto [loop]
[load.readme]
    open filename$ for input as #f
    print #w.te, "!contents #f";
    close #f
    print #w.te, ""
    calldll #a, "GetVersion", ver as word
    print #w.te, "Brosco's mm Timer - version "; str$(ver)
    goto [loop]

[close.w]
    CallDll #a, "EndTimer", 1 as word, r as word
    close #a
    close #w
    close #wd
    close #user
    end
