' Requires LB v1.41
'
' Invisible Windows Demo
' Brosco Nov 98
'
'    nomainwin
' Normally the NoMainWin command would be issued - here it is commented
' out so that you can see all the messages received by the callback
' function.
'
' *****************     DLLs required by this program
    open "user.dll" for dll as #user
    open "gdi.dll" for dll as #gdi
    open "brosco.dll" for dll as #brosco

' *****************     Image required for Logo
    loadbmp "travolta","jt2.bmp"
    hJT=hbmp("travolta")

'
' ****************  Create a small window to be used to receive Callbacks.
    WindowWidth = 50
    WindowHeight = 30
    open "CallBack" for window as #wcb
    print #wcb, "ResizeHandler [callback]"
    print #wcb, "trapclose [close]"
    hwcb = hwnd(#wcb)
' (You would normally hide this window, but you can use it for
' anything you like - just be aware - if it is moved/resized - it will
' activate the CallBack procedure).
'              *****************

    CallDll #brosco, "GetVersion", ver as word
    print "Brosco's DLL version - "; str$(ver)

    style = 0          ' Add any styles you want
                       ' _WS_POPUP is applied automatically
    CallDll #brosco, "CreateInvisibleWindow", _
        hwcb as word, _         ' Handle of the Callback Window
        style as long, _        ' Windows style
        100 as word, _          ' UpperLeftX
        1 as word, _            ' UpperLeftY
        200 as word, _          ' Width
        200 as word, _          ' Height
        hiw as word             ' Handle of the window
    print "Handle of invisible window is: "; str$(hiw)
'
' The window is owned by the DLL Instance - not the LB program - so
' you need to get the Instance number if you intend to create any
' child windows - like buttons.
'
    CallDll #brosco, "GetIwInstance", hInst as word
    print "Instance that owns the window is: ";str$(hInst)


[loop]
    input var$ 

[callback]
    msgQ$ = space$(64) + chr$(0)        ' 64 chars is big enough for any msg
    CallDll #brosco, "GetNextMessage", _
        msgQ$ as ptr, _     ' see below for format
        result as word      ' 0 if no messages
    if result = 0 then goto [loop]   ' no messages on q
'
'  ********* Display the messages on the lb #main window
    print msgQ$
'
' Message Format is:
' hhhh mmmm wwww lllll mx my
' where:
'   hhhh is the handle of the parent window
'   mmmm is the windows message number
'   wwww is the first 'extra info'
'   llll is the second 'extra info'
'   mx, my is llll split into two integer values and is usually
'               MouseX, MouseY values - always with a MouseMove
'               or MouseUp/Down command
'
    if val(word$(msgQ$,2)) = _WM_PAINT  then goto [paint]
    if val(word$(msgQ$,2)) = _WM_CREATE then goto [create]
    if val(word$(msgQ$,2)) = _WM_COMMAND then
        if val(word$(msgQ$, 3)) = 101 then goto [close] ' 101 is Button ID
        end if
    goto [loop]

[paint]         ' WM_PAINT is issued if the window needs to be redrawn
    calldll #user, "GetDC", _
        hiw as word, _          ' Handle of invisible window
        hdc as word
'
' Between the GetDC and ReleaseDC you should have all the code
' for painting your window
'

' *****************     This section transfers the image to the
' *****************     window as a sprite

    calldll #gdi,"CreateCompatibleDC",_
        hdc as word,_            'Device Context of invisible window
        hDCmemory as word        'memory Device Context

    calldll #gdi,"SelectObject",_
        hDCmemory as word,_      'memory device context will contain:
        hJT as word,_            'handle of travolta bitmap
        result as word

    X=10:Y=10
    calldll #gdi, "BitBlt",_     'add mask of John Travolta
        hdc AS short,_           'destination DC
        X AS short,_             'x location destination
        Y AS short,_             'y location destination
        100 AS short,_           'image width
        146 AS short,_           'image height
        hDCmemory AS short,_     'source DC
        100 AS short,_           'x location source
        0 AS short,_             'y location source
        _SRCAND AS long,_        'dwROP
        RESULT AS short

    calldll #gdi, "BitBlt",_     'add sprite of John Travolta
        hdc AS short,_           'destination DC
        X AS short,_             'x location destination
        Y AS short,_             'y location destination
        100 AS short,_           'image width
        146 AS short,_           'image height
        hDCmemory AS short,_     'source DC
        0 AS short,_             'x location source
        0 AS short,_             'y location source
        _SRCPAINT AS long,_      'dwROP
        RESULT AS short

    calldll #gdi,"deleteDC",_
        hDCmemory as word,_     'DC we created
        r as ushort

    calldll #user, "ReleaseDC", _
        hiw as word, _          ' Handle of invisible window
        hdc as word, _
        result as word
'
' If you have added controls - like buttons - you must issue this
' command - because the any images will have drawn over the top of
' any controls
'
    CallDll #brosco, "RedrawControls", _
        hiw as word, _
        result as word
    goto [loop]

[create]
'
' WM_CREATE command is queued when a Parent window has been created -
' so its now time to draw any controls you want.
'
    buttonStyle = _WS_CHILD + _WS_VISIBLE + _BS_PUSHBUTTON
    CallDll #user, "CreateWindow", _
        "button" as ptr, _          ' Windows defined Button class
        "Close"  as ptr, _          ' Text on the button
        buttonStyle as long, _      ' Button style
        120 as word, _              ' TopLeftX (within parent)
        100 as word, _              ' TopLeftY (within parent)
        60 as word, _               ' Width
        25 as word, _               ' Height
        hiw as word, _              ' Parent of this window
        101 as word, _              ' When button clicked - 101 is in wwww
        hInst as word, _            ' Instance of owner of this child
        0 as long, _                ' Not Required here
        hPB as word                 ' Handle of the button
    goto [loop]



[close]


    CallDll #brosco, "CloseInvisibleWindow", _
        hiw as word, _          ' Handle of Invisible Window
        result as word

    unloadbmp ("travolta")      'free memory

    close #brosco
    close #user
    close #gdi
    close #wcb
    end


