'  Move mouse or hit any key to exit!
'  Set speed here:
    speed=6       'higher numbers mean faster speed
    numberFish=5  'pick 1-10 here.  Slower pc's should choose fewer fish
    DIM fishes(10,5)

NOMAINWIN

WindowWidth=DisplayWidth
WindowHeight=DisplayHeight+18

    Count=0
    T$=TIME$()
    WHILE T$=TIME$()
     Count=Count+1
    WEND
    Count=0
    T$=TIME$()
    WHILE T$=TIME$()
     Count=Count+1
    WEND

    pause = int(Count/speed) 'maximum of (speed) frames per second

    'hide the cursor
    open "user.dll" for dll as #user
    calldll #user, "ShowCursor",0 as ushort, result as void
    close #user


open "Aquarium Simulation" for graphics_nsb_nf as #1
print #1, "trapclose [quit]"

    GOSUB [load]
    GOSUB [init]
    GOSUB [sim.setup]

[loop]
    print #1, "setfocus; when characterInput [quit]"
    print #1, "when mouseMove [quit]"  'stop program at keystroke or mouse move
    scan
    GOSUB [move]
    GOSUB [draw.screen]

    if Count>2500 then
        for i = 1 to pause: next i  'generate a delay on fast cpu's
    end if
    goto [loop]


[quit] 'free memory, close dlls and window
    unloadbmp ("f1"):unloadbmp ("f2")
    unloadbmp ("f3"):unloadbmp ("f4")
    unloadbmp ("f5"):unloadbmp ("water")

    'show cursor
    open "user.dll" for dll as #user
    calldll #user, "ShowCursor",1 as ushort, result as void
    close #user

    close #1:close #s:end



[load] 'load bmps and get bmp handles
       'get handle of window
    loadbmp "f1", "fish1.bmp"
    hf1=hbmp("f1")
    loadbmp "f2", "fish2.bmp"
    hf2=hbmp("f2")
    loadbmp "f3", "fish3.bmp"
    hf3=hbmp("f3")
    loadbmp "f4", "fish4.bmp"
    hf4=hbmp("f4")
    loadbmp "f5", "fish5.bmp"
    hf5=hbmp("f5")
    loadbmp "water", "water.bmp"

    h=hwnd(#1)   'handle of window
    RETURN


[init] 'initialize dll and draw water background
    for x=0 to 1200 step 200
      for y=0 to 1000 step 200
        print #1, "drawbmp water ";x;" ";y
      next y
    next x

    open "lbsprite.dll" for dll as #s
    'load background from screen:
    CallDll #s, "Init",h as short, r as short
    RETURN



[sim.setup]
    if numberFish>10 then numberFish=10  'trap error - too many fish
    if numberFish<1 then numberFish=1    'trap error - no fish
    'x,y location to start each fish:
    for i=1 to numberFish
        fishes(i,1)=int(rnd(1)*600)  'x location
        fishes(i,2)=int(rnd(1)*380)  'y location
    next i

   'bmp for each fish
    for i=1 to numberFish STEP 5
        if i<=numberFish then fishes(i,3)=hf1
        if i+1<=numberFish then fishes(i+1,3)=hf2
        if i+2<=numberFish then fishes(i+2,3)=hf3
        if i+3<=numberFish then fishes(i+3,3)=hf4
        if i+4<=numberFish then fishes(i+4,3)=hf5
    next i

    'set fish speed = fast or slow
    for i=1 to int(numberFish/2)
        fishes(i,4)=10   'speed of first half of fish
    next i

    for i = (int(numberFish/2) +1) to numberFish
        fishes(i,4)=14  'speed of last half of fish
    next i

    'set y-speed
    for i=1 to numberFish
        fishes(i,5)=i
    next i

    'change direction of half of fish:
    for i=1 to numberFish STEP 2
        fishes(i,4)=0-fishes(i,4)
    next i

    for i=2 to numberFish STEP 2
        fishes(i,5)=0-fishes(i,5)
    next i
    RETURN

[move]
    for i=1 to numberFish
        fishes(i,1)=fishes(i,1)+fishes(i,4)
            if fishes(i,1)<0 then
                fishes(i,4)=0-fishes(i,4)   'reverse direction
                fishes(i,1)=0
            end if

            if fishes(i,1)>(DisplayWidth-100) then
                fishes(i,4)=0-fishes(i,4)    'reverse direction
                fishes(i,1)=(DisplayWidth-100)
            end if
    next i

    for i=1 to numberFish
        fishes(i,2)=fishes(i,2)+fishes(i,5)
            if fishes(i,2)<0 then
                fishes(i,5)=0-fishes(i,5)    'reverse direction
                fishes(i,2)=0
            end if

            if fishes(i,2)>(DisplayHeight-40) then
                fishes(i,5)=0-fishes(i,5)     'reverse direction
                fishes(i,2)=(DisplayHeight-40)
            end if
    next i
RETURN


[draw.screen]
    for i=1 to numberFish
        hFish=fishes(i,3)  'proper bmp for this fish
        xfish=fishes(i,1)  'current x location for this fish
        yfish=fishes(i,2)  'current y location for this fish
        if fishes(i,4)>0 then
            CallDll #s, "DrawSprite",h as short, hFish as short, xfish as short, yfish as short,r as short
          else
            CallDll #s, "DrawSpriteMirror",h as short, hFish as short, xfish as short, yfish as short,r as short
        end if
     next i


    CallDll #s, "UpdateScreen",h as short, r as short,
    RETURN
