'  This program will open icon files, or DLL's or EXE's and
'  display icons for editing.  You may alter these, or draw
'  icons of your own by choosing a color and drawing with
'  the mouse cursor.  There is no transparent color function
'  in this version of the Icon Machine.  Icons will be saved
'  in 16-color format, suitable for use with the Liberty
'  BASIC runtime engine.
'
'  16-Color Icon Machine (c) Alyce Watson 1999, 2000
'  contact awatson@wctc.net

    PixColor=256*256*256 + 256*256 + 256 'white
    cl=256*256*10 + 256*10 + 10 'almost black for grid lines

    DIM k(15)         'make a palette
    k(15)=0           'black
    k(14)=8421504     'darkgray
    k(13)=12632256    'lightgray
    k(12)=16777215    'white
    k(11)=8388608     'darkblue
    k(10)=16711680    'blue
    k(9)=32768        'darkgreen
    k(8)=65280        'green
    k(7)=8421376      'darkcyan
    k(6)=16776960     'cyan
    k(5)=32896        'brown
    k(4)=65535        'yellow
    k(3)=128          'darkred
    k(2)=255          'red
    k(1)=8388736      'darkpink
    k(0)=16711935     'pink

    DIM k$(15)        'set values for palette entries in hex
    for i = 0 to 9
        k$(i)=str$(i)
    next i
    k$(10)="A"
    k$(11)="B"
    k$(12)="C"
    k$(13)="D"
    k$(14)="E"
    k$(15)="F"

'write the ico file header for 16-color icon, using palette above
    head$="0 0 1 0 1 0 32 32 16 0 0 0 0 0 232 2 0 0 22 0 0 0 40 0 0 0 32 0 0 0 64 0 0 0 1 0 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 0 255 0 128 0 128 0 0 0 255 0 0 0 128 0 0 255 255 0 0 128 128 0 255 255 0 0 128 128 0 0 0 255 0 0 0 128 0 0 255 0 0 0 128 0 0 0 255 255 255 0 192 192 192 0 128 128 128 0 0 0 0 0 0 0 "
    DIM header(127)
    for i=1 to 127
        header(i)=val(word$(head$,i))
    next i
    head$="" 'free memory


    WindowWidth = 500
    WindowHeight = 400
    UpperLeftX=1:UpperLeftY=1
    nomainwin

    menu #main, "&File","&New",[new],"&Open Icon",[open],_
    "&Update Icon View",[update],"&Save Icon",[save],"E&xit",[exit]
    menu #main, "&Help","H&elp",[help],"&About",[about]
    open "16-Color Icon Machine" for graphics_nsb_nf as #main
    print #main, "trapclose [exit]"
    Handle=hwnd(#main)

    open "user" for dll as #user
    open "gdi" for dll as #gdi

    Calldll #user, "GetDC", Handle as word, hdc as word
    calldll #user, "GetWindowWord",_
    Handle as word,_
    _GWL_HINSTANCE as word,_
    hCurrentInst as word

 
    print #main, "down"
    print #main, "color 1 1 1;backcolor white;place 400 0;boxfilled 500 20"
    print #main, "backcolor lightgray;place 400 20;boxfilled 500 40"
    print #main, "backcolor darkgray;place 400 40;boxfilled 500 60"
    print #main, "backcolor black;place 400 60;boxfilled 500 80"
    print #main, "backcolor yellow;place 400 80;boxfilled 500 100"
    print #main, "backcolor brown;place 400 100;boxfilled 500 120"
    print #main, "backcolor green;place 400 120;boxfilled 500 140"
    print #main, "backcolor darkgreen;place 400 140;boxfilled 500 160"
    print #main, "backcolor red;place 400 160;boxfilled 500 180"
    print #main, "backcolor darkred;place 400 180;boxfilled 500 200"
    print #main, "backcolor blue;place 400 200;boxfilled 500 220"
    print #main, "backcolor darkblue;place 400 220;boxfilled 500 240"
    print #main, "backcolor cyan;place 400 240;boxfilled 500 260"
    print #main, "backcolor darkcyan;place 400 260;boxfilled 500 280"
    print #main, "backcolor pink;place 400 280;boxfilled 500 300"
    print #main, "backcolor darkpink;place 400 300;boxfilled 500 320;flush"
    gosub [grid]
    FileName$="UNTITLED.ICO"
    gosub [print.name]


[loop]
    print #main, "setfocus; when leftButtonDown [mouse.down]"
    print #main, "when leftButtonMove [mouse.down]"
    print #main, "place 5 80;boxfilled 45 120"
    Input a$ 


[mouse.down]
    if MouseX<60  OR MouseY<0 OR MouseY>320 then [loop]
    if MouseX>60 and MouseX<380 then [put.color]
    if MouseX>400 then [get.color]
    goto [loop]


[get.color]
    Y=MouseY
    if Y<20 then print #main, "backcolor white":goto [loop]
    if Y<40 then print #main, "backcolor lightgray":goto [loop]
    if Y<60 then print #main, "backcolor darkgray":goto [loop]
    if Y<80 then print #main, "backcolor black":goto [loop]
    if Y<100 then print #main, "backcolor yellow":goto [loop]
    if Y<120 then print #main, "backcolor brown":goto [loop]
    if Y<140 then print #main, "backcolor green":goto [loop]
    if Y<160 then print #main, "backcolor darkgreen":goto [loop]
    if Y<180 then print #main, "backcolor red":goto [loop]
    if Y<200 then print #main, "backcolor darkred":goto [loop]
    if Y<220 then print #main, "backcolor blue":goto [loop]
    if Y<240 then print #main, "backcolor darkblue":goto [loop]
    if Y<260 then print #main, "backcolor cyan":goto [loop]
    if Y<280 then print #main, "backcolor darkcyan":goto [loop]
    if Y<300 then print #main, "backcolor pink":goto [loop]
    if Y<320 then print #main, "backcolor darkpink":goto [loop]
    goto [loop]


[put.color]  'color working area and preview area
    if MouseX/10 = int(MouseX/10) then [loop] 'mouse is on grid line
    if MouseY/10 = int(MouseY/10) then [loop] 'mouse is on grid line
    filx=MouseX:fily=MouseY
     calldll #gdi, "FloodFill", _
        hdc as word, _
        filx as short, _
        fily as short, _
        cl as long, _  'boundary color for flood fill
      results as short

    iconX=int(((filx-60)/10)+5)
    iconY=int((fily/10)+200)

    calldll #gdi, "GetPixel",_
        hdc AS short,_
        filx AS short,_
        fily AS short,_
        pixColor AS long


    calldll#gdi,"SetPixel",_
        hdc as word,_
        iconX as short,_
        iconY as short,_
        pixColor as long,_
        result as long

    goto [loop]

[open]
    gosub [clear]
    filedialog "Choose Icon","*.ico;*.exe;*.dll",FileName$
    if FileName$="" then [loop]
    File$=FileName$+chr$(0)

    open "shell" for dll as #shell
    calldll #shell, "ExtractIcon",_
        hCurrentInst as word,_
        File$ as ptr,_
        0 as ushort,_
        hicon as word  'returns icon handle
        close #shell

    if hicon>1 then
        calldll #user, "DrawIcon",_ 'draw icon from file
        hdc as short,_
        0 as short,_
        0 as short,_
        hicon as word,_
        Ret as short

        calldll #user, "DrawIcon",_ 'draw icon to edit
        hdc as short,_
        5 as short,_
        200 as short,_
        hicon as word,_
        Ret as short
    End if


    calldll #gdi,"StretchBlt",_  'draw large copy of icon
        hdc as word,_
        60 as word,_
        0 as word,_
        320 as word, _
        320 as word,_
        hdc as word,_
        0 as word,_
        0 as word,_
        32 as word,_
        32 as word,_
        _SRCCOPY as long,_
        r as ushort

    gosub [grid]    'draw grid over large copy
    gosub [print.name]
    goto [loop]


[save]
    filedialog "Save as...","*.ico",savefile$
    if savefile$="" then [loop]

    cursor hourglass
    bits$="" 'reset string to hold bit information

    x2=5:y2=232  'get fresh copy for saving
    for y1=315 to 5 step -10
        for x1=65 to 375 step 10
            gosub [get.pixel]
            gosub [draw.new.icon]
            gosub [add.to.file]
        next x1
    next y1
    gosub [write.file]
    cursor normal
    goto [loop]

[write.file]
    saveicon$="" 'reset
    for i = 1 to 126
        saveicon$=saveicon$+chr$(header(i))
    next i

    for i = 1 to 1026 step 2
        saveicon$=saveicon$+chr$(hexdec(mid$(bits$,i,1)+mid$(bits$,i+1,1)))
    next i

    for i = 1 to 127
        saveicon$=saveicon$+chr$(0)
    next i

    open savefile$ for output as #sf
        print #sf, left$(saveicon$,766)
    close #sf
    cursor normal
    notice "File saved as "+lower$(savefile$)
    goto [loop]


[update]
    cursor hourglass
    x2=5:y2=200
    for y1=315 to 5 step -10
        for x1=65 to 375 step 10
            gosub [get.pixel]
            gosub [draw.new.icon]
        next x1
    next y1
    cursor normal
    goto [loop]


[draw.new.icon]
    calldll#gdi,"SetPixel",_
        hdc as word,_
        x2 as short,_
        y2 as short,_
        pixColor as long,_
        result as long
    x2=x2+1
    if x2>=37 then x2=5:y2=y2-1
    RETURN

[add.to.file]  'check color and add bit to bit string
    for j=0 to 15
        if pixColor=k(j) then bits$=bits$+k$(j)
    next j
    return

[get.pixel]
    calldll #gdi, "GetPixel",_
        hdc AS short,_
        x1 AS short,_
        y1 AS short,_
        pixColor AS long
    RETURN


[grid] 'color 10 10 10 is almost black
    print #main, "down;color 10 10 10;size 1"
    for x=60 to 380 step 10
        print #main, "line ";x;" 0 ";x;" 320"
    next x

    for y=0 to 320 step 10
        print #main, "line 60 ";y;" 380 ";y
    next y
    print #main, "color 10 10 10;place 4 199;box 38 233"
    print #main, "backcolor white;place 5 254;|view"
    print #main, "place 5 140;|color"
    RETURN


[print.name]
    print #main, "backcolor white"
    print #main, "place 100 340;|";FileName$+space$(100)
    RETURN


[clear]
    print #main, "place 0 0;color white;backcolor white;boxfilled 381 321"
    RETURN


[new]
    FileName$="UNTITLED.ICO"
    gosub [clear]
    gosub [grid]
    gosub [print.name]
    goto [loop]


[exit]
    calldll #user, "ReleaseDC", Handle as word, hdc as word, Ret as ushort
    close #main
    close #user
    Close #gdi
    end

[help]
    notice "Help"+chr$(13)+"Either choose file/open to open an existing icon, or file/new to begin a new icon.  Click on the drawing color desired.  Click and drag the mouse in the grid to color the icon.  To save the result as a 16-color icon, choose file/save.  Only 16 color icons may be saved, and there is no transparent color function in this version."
    goto [loop]

[about]
    notice "16-Color Icon Machine "+chr$(169)+" Alyce Watson, 1999-2000."
    goto [loop]



