'** Liberty BASIC Newsletter
'** Open Source Editor
'** Please add your name to
'** the list of authors:
'**
'** Authors:
'**
'** Alyce Watson
'**
nomainwin
    open "user" for dll as #user
    dim info$(10,10)        'for file exist check
    open "commctrl.dll" for dll as #cctl

'** NEW **
    dim branch$(40)         'array to hold branch labels
    open "ctl3d.dll" for dll as #ctl3d
    calldll #ctl3d,"Ctl3dRegister",0 as short,result as short
    calldll #ctl3d,"Ctl3dAutoSubclass",0 as short,result as short


cursor hourglass

'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'red                red value
'green              green value
'blue               blue value
'menuColor          system menu color
'hInstance          window instance handle

'** NEW **
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection


'for tooltips:
    GWW = _GWW_HINSTANCE or 0
    style           = 0
    CW.USEDEFAULT   = hexdec("8000")
    TTF.IDISHWND    = hexdec("0001")
    TTF.SUBCLASS    = hexdec("0010")
    TTM.ADDTOOL     = _WM_USER+4


menu #1, "&File",_
    "&New",[new],_
    "&Open",[open],_
    "&Save",[save],_
    "Save &As",[saveas],|,_
    "&Print",[print],_
    "E&xit",[quit]

menu #1, "&Edit" 'LB supplies the Edit Menu

menu #1, "&Run",_
    "Ru&n", [run],_
    "&Debug",[debug],_
    "&Make TKN",[maketkn],_
    "Run &TKN",[runtkn]

menu #1, "E&xternals",_
    "&Paintbrush",[paint],_
    "&File Manager",[winfile],_
    "&Notepad",[notepad],_
    "&Calculator",[calculator]

'** NEW **
menu #1, "&Tools",_
    "&Branch Labels",[branchlabels]

menu #1, "&Help",_
    "&Liberty BASIC Help",[help],_
    "LB &Tutorial",[tutorial]

    texteditor #1.t, 0,40,600,400  'edit window

    graphicbox #1.g, -1,-1,800,21  'toolbar
    button #1.new,     "New",   [new],       UL,3,2,30,15
    button #1.open,    "Open",  [open],      UL,34,2,30,15
    button #1.save,    "Save",  [save],      UL,65,2,30,15
    button #1.saveas,  "..As",  [saveas],    UL,96,2,30,15
    button #1.print,   "Print", [print],     UL,127,2,30,15

    button #1.run,     "Run",   [run],       UL,167,2,30,15
    button #1.debug,   "Debug", [debug],     UL,198,2,30,15
    button #1.token,   "TKN",   [maketkn],   UL,229,2,30,15
    button #1.runtkn,  "R tkn", [runtkn],    UL,260,2,30,15

    button #1.paint,   "Paint", [paint],     UL,300,2,30,15
    button #1.file,    "F Mgr", [winfile],   UL,331,2,30,15
    button #1.note,    "Note",  [notepad],   UL,362,2,30,15
    button #1.calc,    "Calc",  [calculator],UL,393,2,30,15

    button #1.help,    "Help",  [help],      UL,433,2,30,15
    button #1.tutor,   "Tutor", [tutorial],  UL,464,2,30,15

open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"

    calldll #user, "ShowWindow",h as word,_SW_MAXIMIZE as ushort,result As word

    print #1.new,     "!font arial 0 12"
    print #1.open,    "!font arial 0 12"
    print #1.save,    "!font arial 0 12"
    print #1.saveas,  "!font arial 0 12"
    print #1.print,   "!font arial 0 12"
    print #1.run,     "!font arial 0 12"
    print #1.debug,   "!font arial 0 12"
    print #1.token,   "!font arial 0 12"
    print #1.runtkn,  "!font arial 0 12"
    print #1.paint,   "!font arial 0 12"
    print #1.file,    "!font arial 0 12"
    print #1.note,    "!font arial 0 12"
    print #1.calc,    "!font arial 0 12"
    print #1.help,    "!font arial 0 12"
    print #1.tutor,   "!font arial 0 12"


    print #1.t, "!setfocus";
    gosub [colorToolbar]
    gosub [addTooltips]
    cursor normal

[loop]
    input a$



[quit]
    gosub [isModified]
 '** NEW **
    calldll #ctl3d,"Ctl3dUnregister",0 as short,result as short
    close #ctl3d

    close #user: close #1 : close #cctl
    if tempfilename$<>"" then kill tempfilename$ 
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 20 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 20 ";WindowWidth-1;" ";WindowHeight-21
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** LOCATE GRAPHICBOX - WindowWidth+2 WIDE, 21 PIXELS HIGH
    print #1.g, "locate -1 -1 ";WindowWidth+2;" 21"

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    gosub [settext]
    goto [loop]



[open]
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas",file$ 
    if file$="" then [loop]

    fileindex=len(file$)  'separate path and filename
    filelength=len(file$)
        while mid$(file$, fileindex,1)<>"\"
            fileindex=fileindex-1
        wend

'** USE FILES STATEMENT TO CHECK FOR FILE'S EXISTENCE
    shortFile$=right$(file$,filelength-fileindex)
    filePath$=left$(file$,fileindex)
    files filePath$,shortFile$,info$(
    if val(info$(0,0))<1 then
        notice "Error"+chr$(13)+"File does not exist."
        goto [loop]
    end if

[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    goto [loop]



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user, "SetWindowText", h as word, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$
    filedialog "Save file as..",filePath$+"*.bas",file$ 
      if file$="" then
        notice "You must choose a file name."
        goto [loop]
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    goto [loop]


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

'** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.bas") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 
    lprint saveit$
    dump
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    goto [loop]



[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
'** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

'** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","liberty.exe",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    goto [loop]

[maketkn]
    gosub [readyRun]
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]



[paint]
    run "pbrush.exe",SHOWNORMAL
    goto [loop]

[notepad]
    run "notepad.exe",SHOWNORMAL
    goto [loop]

[winfile]
    run "winfile.exe",SHOWNORMAL
    goto [loop]

[calculator]
    run "calc.exe" ,SHOWNORMAL
    goto [loop]



[help]
    run "winhelp liberty.hlp"
    goto [loop]

[tutorial]
    run "winhelp tutorial.hlp"
    goto [loop]



[colorToolbar]
    '** GET SYSTEM MENU COLOR VALUE
    calldll #user,  "GetSysColor",_
        _COLOR_MENU as word,_
        menuColor as long

    '** RETRIEVE VALUES FOR red, green, blue
    blue = int(menuColor / (256 * 256))
    green = int((menuColor - blue *256*256) / 256)
    red = menuColor - blue *256 * 256 - green * 256

    '** FILL TOOLBAR WITH THIS COLOR
    print #1.g, "down;size 50; color ";red;" ";green;" ";blue
    print #1.g, "line 0 20 1200 20"
    print #1.g, "flush"
    RETURN



[addTooltips]
    calldll #cctl, "InitCommonControls", re as void
    calldll #user, "GetWindowWord", h as word,_
        GWW as word, hInstance as word

    calldll #user, "CreateWindow", _
        "tooltips_class" as ptr, _
        "" as ptr, _
        style as long, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        h as word, _
        0 as word, _
        hInstance as word, _
        "" as ptr, _
        hwndTT as word

'** MAKE A STRUCT FOR EACH TOOL
    struct toolinfo1, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo2, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo3, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo4, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo5, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo6, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo7, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo8, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo9, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo10, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo11, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo12, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo13, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo14, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo15, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr



    toolinfo1.cbSize.struct = 22
    toolinfo1.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo1.hwnd.struct = h
    toolinfo1.uId.struct = hwnd(#1.new)
    toolinfo1.hInst.struct = hInstance
    toolinfo1.lpstrText$.struct = "New File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo1 as struct, re as long

    toolinfo2.cbSize.struct = 22
    toolinfo2.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo2.hwnd.struct = h
    toolinfo2.uId.struct = hwnd(#1.open)
    toolinfo2.hInst.struct = hInstance
    toolinfo2.lpstrText$.struct = "Open File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo2 as struct, re as long

    toolinfo3.cbSize.struct = 22
    toolinfo3.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo3.hwnd.struct = h
    toolinfo3.uId.struct = hwnd(#1.save)
    toolinfo3.hInst.struct = hInstance
    toolinfo3.lpstrText$.struct = "Save File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo3 as struct, re as long

    toolinfo4.cbSize.struct = 22
    toolinfo4.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo4.hwnd.struct = h
    toolinfo4.uId.struct = hwnd(#1.saveas)
    toolinfo4.hInst.struct = hInstance
    toolinfo4.lpstrText$.struct = "Save File As..."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo4 as struct, re as long

    toolinfo5.cbSize.struct = 22
    toolinfo5.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo5.hwnd.struct = h
    toolinfo5.uId.struct = hwnd(#1.print)
    toolinfo5.hInst.struct = hInstance
    toolinfo5.lpstrText$.struct = "Print File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo5 as struct, re as long

    toolinfo6.cbSize.struct = 22
    toolinfo6.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo6.hwnd.struct = h
    toolinfo6.uId.struct = hwnd(#1.run)
    toolinfo6.hInst.struct = hInstance
    toolinfo6.lpstrText$.struct = "Run Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo6 as struct, re as long

    toolinfo7.cbSize.struct = 22
    toolinfo7.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo7.hwnd.struct = h
    toolinfo7.uId.struct = hwnd(#1.debug)
    toolinfo7.hInst.struct = hInstance
    toolinfo7.lpstrText$.struct = "Debug Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo7 as struct, re as long

    toolinfo8.cbSize.struct = 22
    toolinfo8.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo8.hwnd.struct = h
    toolinfo8.uId.struct = hwnd(#1.token)
    toolinfo8.hInst.struct = hInstance
    toolinfo8.lpstrText$.struct = "Tokenize Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo8 as struct, re as long

    toolinfo9.cbSize.struct = 22
    toolinfo9.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo9.hwnd.struct = h
    toolinfo9.uId.struct = hwnd(#1.runtkn)
    toolinfo9.hInst.struct = hInstance
    toolinfo9.lpstrText$.struct = "Run an existing TKN"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo9 as struct, re as long

    toolinfo10.cbSize.struct = 22
    toolinfo10.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo10.hwnd.struct = h
    toolinfo10.uId.struct = hwnd(#1.paint)
    toolinfo10.hInst.struct = hInstance
    toolinfo10.lpstrText$.struct = "Run Windows Paintbrush"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo10 as struct, re as long

    toolinfo11.cbSize.struct = 22
    toolinfo11.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo11.hwnd.struct = h
    toolinfo11.uId.struct = hwnd(#1.file)
    toolinfo11.hInst.struct = hInstance
    toolinfo11.lpstrText$.struct = "Run File Manager"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo11 as struct, re as long

    toolinfo12.cbSize.struct = 22
    toolinfo12.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo12.hwnd.struct = h
    toolinfo12.uId.struct = hwnd(#1.note)
    toolinfo12.hInst.struct = hInstance
    toolinfo12.lpstrText$.struct = "Run Notepad"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo12 as struct, re as long

    toolinfo13.cbSize.struct = 22
    toolinfo13.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo13.hwnd.struct = h
    toolinfo13.uId.struct = hwnd(#1.calc)
    toolinfo13.hInst.struct = hInstance
    toolinfo13.lpstrText$.struct = "Run Windows Calculator"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo13 as struct, re as long

    toolinfo14.cbSize.struct = 22
    toolinfo14.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo14.hwnd.struct = h
    toolinfo14.uId.struct = hwnd(#1.help)
    toolinfo14.hInst.struct = hInstance
    toolinfo14.lpstrText$.struct = "Liberty BASIC Help"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo14 as struct, re as long

    toolinfo15.cbSize.struct = 22
    toolinfo15.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo15.hwnd.struct = h
    toolinfo15.uId.struct = hwnd(#1.tutor)
    toolinfo15.hInst.struct = hInstance
    toolinfo15.lpstrText$.struct = "Liberty BASIC Tutorial"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo15 as struct, re as long

    RETURN



'** NEW **
[branchlabels]
'** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    listbox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"
    goto [loop]


[cancelbranch]
'** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    goto [loop]


[branch]
'** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        goto [loop]
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            goto [loop]
          END If
    Next i
    cursor normal
    goto [loop]
