'  Demo of functions in vbprint.dll
'
'  Alyce Watson -- January 2000

nomainwin
statictext #w.s, "Please wait...",10,40,200,30
open "Printing Test" for window as #w
print #w, "trapclose [quitw]"
    gosub [setupValues]
    gosub [initialize]
    gosub [pageLayout]
    gosub [setParagraphSpacing]
    gosub [printHeadline]
    gosub [printGraphic]
    gosub [setupParagraph]
    gosub [getPrinterInfo]
    gosub [printParagraph]
    gosub [printSecondParagraph]
    gosub [printCheckbox]
    gosub [setupColumns]
    gosub [printColumnHeaders]
    gosub [printColumns]
'    gosub [altPrintParagraph]  
'    gosub [ejectPage]
'    gosub [killJob]
'    gosub [moveCursor]
    gosub [endPrint]

    print #w.s, "Job has been sent to printer!"
[loop]
    input aVar$

[quitw]
    close #w:end


[setupValues]
    NORMAL.FONT=0
    BOLD.FONT=hexdec("0x0001")
    ITALIC.FONT=hexdec("0x0002")
    TOP.BORDER=hexdec("0x0004")
    LEFT.BORDER=hexdec("0x0008")
    RIGHT.BORDER=hexdec("0x0010")
    BOTTOM.BORDER=hexdec("0x0020")
    CHECK.BOX=hexdec("0x0100")
    RETURN


[initialize]
    h=hwnd(#w)
    open "vbprint.dll" for dll as #vb
    CallDll #vb, "InitializePrinter",h as short, r as short
    return


[pageLayout]
    top=100     'in hundredths of an inch
    right=50
    bottom=100
    left=50

    CallDll #vb, "PageLayoutSetup",_
        top as short,_
        right as short,_
        bottom as short,_
        left as short,_
        r as short
    return


[printHeadline]
    Headline$="Liberty BASIC Printing"+chr$(0)
    FontName$="Arial"+chr$(0)
    FontSize=30
    Style=BOTTOM.BORDER or BOLD.FONT
    gosub [headline]
    return


[setParagraphSpacing]
    beforespace=6  'in points
    afterspace=24
    CallDll #vb, "SetParagraphSpacing",_
        beforespace as short, afterspace as short, r as short
    return


[setupParagraph]
    FontName$="Times New Roman"+chr$(0)
    FontSize=20
    Style=ITALIC.FONT
    gosub [startPara]
    return


[getPrinterInfo]
    Port$=space$(256)+chr$(0)
    pName$=space$(256)+chr$(0)
    CallDll #vb, "PrinterPort",Port$as ptr, r as short
    CallDll #vb, "PrinterName",pName$ as ptr, r as short
    CallDll #vb, "PageSizeY", pageheight as short
    CallDll #vb, "PageSizeX", pagewidth as short
    CallDll #vb, "PrintDLLVersion",version as short
        minor=int(version/256)
        major=version - (major*256)
    return


[altPrintParagraph]
    FontName$="Rockwell"+chr$(0)
    FontSize=12
    Style=NORMAL.FONT
    gosub [startPara]

    filedialog "Open Text File","*.txt",file$
        if file$="" then return
    open file$ for input as #m
    Text$=input$(#m,lof(#m))
    close #m
    gosub [paraPrint]

    CallDll #vb, "FinishParagraph",r as short
    return


[printParagraph]
    Text$="Printer port is:  "+Port$ +"   " +chr$(0)
    gosub [paraPrint]
    Text$="  Printer name is:  "+pName$+"  "  +chr$(0)
    gosub [paraPrint]
    Text$="  Printable page size is:  "+str$(pagewidth/1440)+"x"+str$(pageheight/1440)+" inches."  +chr$(0)
    gosub [paraPrint]
    Text$="  Dll version is:  "+str$(major)+"."+str$(minor)+chr$(0)
    gosub [paraPrint]

    CallDll #vb, "FinishParagraph",r as short
    return


[printSecondParagraph]
    FontName$="Times New Roman"+chr$(0)
    FontSize=16
    Style=NORMAL.FONT
    gosub [startPara]

    Text$="    This text should automatically line-wrap "
    Text$=Text$+"at the edge of the  printed page."
    Text$=Text$+"  This will be a great help to us"
    Text$=Text$+" when we print things in Liberty BASIC."
    Text$=Text$+"  Thank you, David Szafranski!"
    Text$=Text$+"  I get by with a little help from"
    Text$=Text$+" my friends!" +chr$(0)

    gosub [paraPrint]

    CallDll #vb, "FinishParagraph",r as short
    return


[setupColumns]
    ncolumn=7
    struct column,_
        cone as short,_
        ctwo as short,_
        cthree as short,_
        cfour as short,_
        cfive as short,_
        csix as short,_
        cseven as short

    column.cone.struct=110
    column.ctwo.struct=110
    column.cthree.struct=110
    column.cfour.struct=110
    column.cfive.struct=110
    column.csix.struct=110
    column.cseven.struct=110

    FontName$="Courier New"+chr$(0)
    Style=NORMAL.FONT OR LEFT.BORDER OR RIGHT.BORDER OR BOTTOM.BORDER OR TOP.BORDER
    FontSize=8

    CallDll #vb, "SetUpColumns",_
        ncolumn as short,_
        column as struct,_
        FontName$ as ptr,_
        FontSize as short,_
        Style as short,_
        r as short
    return


[printColumnHeaders]
    Style=BOLD.FONT OR LEFT.BORDER OR RIGHT.BORDER OR BOTTOM.BORDER OR TOP.BORDER
    FontName$="Courier New"+chr$(0)
    FontSize=10

    Text$="Sunday"+chr$(9)+"Monday"+chr$(9)
    Text$=Text$+"Tuesday"+chr$(9)+"Wednesday"+chr$(9)
    Text$=Text$+"Thursday"+chr$(9)+"Friday"+chr$(9)
    Text$=Text$+"Saturday"+chr$(9)+"Sunday"+chr$(0)
    CallDll #vb, "PrintColumnHeaders",_
        Text$ as ptr,_
        ncolumn as short,_
        column as struct,_
        FontName$ as ptr,_
        FontSize as short,_
        Style as short,_
        r as short
    return


[printColumns]
    Text$="Apple"+chr$(9)+"Banana"+chr$(9)
    Text$=Text$+"Melon"+chr$(9)+"Orange"+chr$(9)
    Text$=Text$+"Peach"+chr$(9)+"Grape"+chr$(9)
    Text$=Text$+"Kiwi"+chr$(9)+"Pear"+chr$(0)

    CallDll #vb, "PrintColumnText",_
        Text$ as ptr,r as short

    Text$="Red"+chr$(9)+"Yellow"+chr$(9)
    Text$=Text$+"Green"+chr$(9)+"Blue"+chr$(9)
    Text$=Text$+"Violet"+chr$(9)+"Gray"+chr$(9)
    Text$=Text$+"Black"+chr$(9)+"White"+chr$(0)

    CallDll #vb, "PrintColumnText",_
        Text$ as ptr,r as short

    Text$="David"+chr$(9)+"Carl"+chr$(9)
    Text$=Text$+"Bill"+chr$(9)+"Doyle"+chr$(9)
    Text$=Text$+"John"+chr$(9)+"Eldron"+chr$(9)
    Text$=Text$+"Brian"+chr$(9)+"Marc"+chr$(0)

    CallDll #vb, "PrintColumnText",_
        Text$ as ptr,r as short

    num1$=using("##########.##",10.95)
    num2$=using("##########.##",123.45)
    Text$=num2$+chr$(9)+num2$+chr$(9)+_
        num1$+chr$(9)+""+chr$(9)+_
        num1$+chr$(9)+num2$+chr$(9)+num1$+chr$(0)
    CallDll #vb, "PrintColumnText",_
        Text$ as ptr,r as short

    Text$=num1$+chr$(9)+num2$+chr$(9)+_
        num2$+chr$(9)+num1$+chr$(9)+_
        num2$+chr$(9)+""+chr$(9)+num2$+chr$(0)
    CallDll #vb, "PrintColumnText",_
        Text$ as ptr,r as short

    CallDll #vb, "EndColumnPrinting",r as short
    return


[printGraphic] 'later printing obscures earlier!
'sized in twips - a twip is 1/1440 inch
    ulx=1*1440
    uly=7*1440
    lrx=7*1440
    lry=int(10.5*1440)
    CallDll #vb, "DrawEllipse",_
        ulx as short, uly as short,_
        lrx as short, lry as short, r as short

    ulx=4*1440
    uly=8*1440
    lrx=6*1440
    lry=10*1440
    elx=1*1440
    ely=int(.75 * 1440) 'half inch
    CallDll #vb, "DrawRndRectangle",_
        ulx as short, uly as short,_
        lrx as short, lry as short,_
        elx as short, ely as short, r as short

    ulx=2*1440
    uly=8*1440
    lrx=3*1440
    lry=10*1440
    CallDll #vb, "DrawRectangle",_
        ulx as short, uly as short,_
        lrx as short, lry as short, r as short

    ulx=1*1440
    uly=6*1440
    lrx=7*1440
    lry=10*1440
    CallDll #vb, "DrawLine",_
        ulx as short, uly as short,_
        lrx as short, lry as short, r as short

    return


[printCheckbox]
    Headline$="Checkbox!"+chr$(0)
    FontName$="Verdana"+chr$(0)
    FontSize=12
    Style=CHECK.BOX
    distY=250
    gosub [moveCursor]
    gosub [headline]
    return


[headline]
    CallDll #vb, "PrintHeadline",_
        Headline$ as ptr,_
        FontName$ as ptr,_
        FontSize as short,_
        Style as short,_
        r as short
    return


[startPara]
    CallDll #vb, "StartParagraph",_
        FontName$ as ptr,_
        FontSize as short,_
        Style as short,_
        r as short
    return


[paraPrint]
    CallDll #vb, "ParagraphText",_
        Text$ as ptr,r as short
    RETURN



[killJob]
    CallDll #vb, "KillJob",r as short
    return


[endPrint]
    CallDll #vb, "DonePrinting",r as short
    close #vb
    return 

[ejectPage]
    CallDll #vb, "EjectPage",r as short
    return


[moveCursor]
    'distY is in hundredths of an inch
    CallDll #vb, "MoveYPos",_
        distY as short, r as short
    return





