'  Get printer and DLL info
'  Set up page layout -- margins
'  Print a paragraph
'
'  Alyce Watson -- January 2000


nomainwin
statictext #w.s, "Please wait...",10,40,200,30
open "Printing Test" for window as #w
print #w, "trapclose [quitw]"
    gosub [setupValues]
    gosub [initialize]
    gosub [pageLayout]
    gosub [setParagraphSpacing]
    gosub [setupParagraph]
    gosub [getPrinterInfo]
    gosub [printParagraph]
    gosub [endPrint]

    print #w.s, "Job has been sent to printer!"
[loop]
    input aVar$

[quitw]
    close #w:end


[getPrinterInfo]
    Port$=space$(256)+chr$(0)
    pName$=space$(256)+chr$(0)
    CallDll #vb, "PrinterPort",Port$as ptr, r as short
    CallDll #vb, "PrinterName",pName$ as ptr, r as short
    CallDll #vb, "PageSizeY", pageheight as short
    CallDll #vb, "PageSizeX", pagewidth as short
    CallDll #vb, "PrintDLLVersion",version as short
        minor=int(version/256)
        major=version - (major*256)
    return


[printParagraph]
    Text$="Printer port is:  "+Port$ +"   " +chr$(0)
    gosub [paraPrint]
    Text$="  Printer name is:  "+pName$+"  "  +chr$(0)
    gosub [paraPrint]
    Text$="  Printable page size is:  "+str$(pagewidth/1440)+"x"+str$(pageheight/1440)+" inches."  +chr$(0)
    gosub [paraPrint]
    Text$="  Dll version is:  "+str$(major)+"."+str$(minor)+chr$(0)
    gosub [paraPrint]

    CallDll #vb, "FinishParagraph",r as short
    return



[paraPrint]
    CallDll #vb, "ParagraphText",_
        Text$ as ptr,r as short
    RETURN



[setupValues]
    NORMAL.FONT=0
    BOLD.FONT=hexdec("0x0001")
    ITALIC.FONT=hexdec("0x0002")
    TOP.BORDER=hexdec("0x0004")
    LEFT.BORDER=hexdec("0x0008")
    RIGHT.BORDER=hexdec("0x0010")
    BOTTOM.BORDER=hexdec("0x0020")
    CHECK.BOX=hexdec("0x0100")
    RETURN


[initialize]
    h=hwnd(#w)
    open "vbprint.dll" for dll as #vb
    CallDll #vb, "InitializePrinter",h as short, r as short
    return



[pageLayout]
    top=100     'in hundredths of an inch
    right=150
    bottom=100
    left=150

    CallDll #vb, "PageLayoutSetup",_
        top as short,_
        right as short,_
        bottom as short,_
        left as short,_
        r as short
    return


[setParagraphSpacing]
    beforespace=10  'in points
    afterspace=10
    CallDll #vb, "SetParagraphSpacing",_
        beforespace as short, afterspace as short, r as short
    return


[setupParagraph]
    FontName$="Courier New"+chr$(0)
    FontSize=24
    Style=ITALIC.FONT  

    CallDll #vb, "StartParagraph",_
        FontName$ as ptr,_
        FontSize as short,_
        Style as short,_
        r as short
    return


[endPrint]
    CallDll #vb, "DonePrinting",r as short
    close #vb
    return


