'Uses PrinterDialog
'Gets printer and font information:
'   writes printer info in texteditor
'   prints one-line message on printer page


nomainwin
WindowWidth=500:WindowHeight=480
texteditor #1.t, 0,0,400,400
open "Printer Info Test" for window as #1
print #1, "trapclose [quit]"

    h=hwnd(#1)
    cursor hourglass
    print #1.t, "Please wait..."
    print #1.t, ""


[print]
    open "lbprnt01.dll" for dll as #lb
    gosub [create.printer.dc]

    if pDC=0 THEN
        notice "Print is cancelled!"
        close #lb:close #1
        END
    end if

    gosub [get.number.copies]
    gosub [get.text.line.height]
    gosub [get.ave.char.width]
    gosub [get.max.char.width]
    gosub [get.dot.info]

    text$="X location is 2 inches, Y location is 6 inches."+chr$(0)
    length=len(text$)-1
    xloc=200
    yloc=600
    gosub [print.text.locate]

    gosub [end.print]
    close #lb
    cursor normal
    print #1.t, ""
    print #1.t, "Finished."
    input a$

[quit]
    close #1
    END



[create.printer.dc]
    CallDll #lb, "PrinterDialog",_    'init with no print dialog
        h as short,_                'window handle
        pDC as short                'nonzero if successful = printer DC

    print #1.t, "PrinterDC is:  ";str$(pDC)
    RETURN



[end.print] 'must call at end of job
    CallDll #lb, "EndPrint",_   'ends document
        h as short,_            'window handle
        r as short              'nonzero if successful

    print #1.t, "EndPrint return is:  ";str$(r)
    RETURN


[get.number.copies]
    CallDll #lb, "GetNumberCopies",_ 'only works with PrinterDialog call
        h as short,_            'window handle
        numbercopies as short   'number of copies chosen by user
    print #1.t, ""
    print #1.t, "User chose to print -"+str$(numbercopies)+"- number of copies."
    RETURN


[get.max.char.width]
    CallDll #lb, "GetMaxCharWidth",_    'maximum width of char in current font
        h as short,_                    'window handle
        maxwidth as short               'max char width in printer dots
    print #1.t, "MaxCharWidth return is:  "+str$(maxwidth)
    RETURN


[get.ave.char.width]
    CallDll #lb, "GetAveCharWidth",_    'average width of char in current font
        h as short,_                    'window handle
        avewidth as short               'ave char width in printer dots
    print #1.t, "AveCharWidth return is:  "+str$(avewidth)
    RETURN


[get.text.line.height]
    CallDll #lb, "GetTextLineHeight",_  'height for lines in current font
        h as short,_                    'window handle
        lineheight as short             'height in hundredths of text line
    print #1.t, "TextLineHeight in hundredths of inch:  "+str$(lineheight)
    RETURN

[get.dot.info]
    CallDll #lb, "GetDotsInchWidth",_
        h as short,_    'window handle
        dpix as short   'dots per inch in width

    CallDll #lb, "GetDotsInchHeight",_
        h as short,_    'window handle
        dpiy as short   'dots per inch in height

    CallDll #lb, "GetDotsTotalWidth",_
        h as short,_       'window handle
        dotswide as short  'total dots in width

    CallDll #lb, "GetDotsTotalHeight",_
        h as short,_       'window handle
        dotshigh as short  'total dots in height

    print #1.t, "GetDotsInchWidth return is:  "+str$(dpix)
    print #1.t, "GetDotsInchHeight return is:  "+str$(dpiy)
    print #1.t, "GetDotsTotalWidth return is:  "+str$(dotswide)
    print #1.t, "GetDotsTotalHeight return is:  "+str$(dotshigh)
    print #1.t, "Printable page width is "+str$(dotswide/dpix)+" inches."
    print #1.t, "Printable page height is "+str$(dotshigh/dpiy)+" inches."
    RETURN



[print.text.locate]
    CallDll #lb, "PrintTextLocate",_    'print one line of text
        h as short,_                    'window handle
        text$ as ptr,_                  'text string to print
        xloc as short,_                 'x location in hundredths of inch
        yloc as short,_                 'y location in hundredths of inch
        length as short,_               'length of text string
        r as short                      'nonzero if successful
    RETURN

