'  This demo creates a font by point-size
'  then retrieves the line height for that font
'  in hundredths of an inch.
'  It then prints some lines, and adds some
'  blank lines, getting the y cursor position
'  in hundredths of an inch, to find out where
'  the y cursor for PrintTextLine is on the page.

    open "lbprnt01.dll" for dll as #lb
    gosub [create.printer.dc]

    if pDC=0 THEN
        print "Print is cancelled!"
        close #lb
        END
    end if

    pfontname$="Courier New" + chr$(0) 'fixed width font
    height=14                          'in points - 72 pts in one inch
    gosub [create.font.point.size]

'PRINT LINE HEIGHT VALUE:
    gosub [get.line.height]
    text$="Line height:  "+str$(lineheight)+chr$(0)
    line.length=len(text$)-1
    gosub [print.text.line]
    gosub [print.blank.line]  'print two blank lines
    gosub [print.blank.line]


'PRINT LINE POSITION, IN LOOP:

for i = 1 to 4      'do it four times
    gosub [get.y.pos]
    text$="Y position:  "+str$(linepos)+chr$(0)
    line.length=len(text$)-1
    gosub [print.text.line]
    gosub [print.blank.line]  'print two blank lines
    gosub [print.blank.line]
next i

[quit]
    gosub [end.print]
    close #lb
    print "Job has been sent to the printer."
    cursor normal
    END


[print.blank.line]
    CallDll #lb, "PrintBlankLine",_ 'move cursor down page the height of one line
        h as short,_                'window handle
        r as void                   'no return
    RETURN

[create.printer.dc]
    CallDll #lb, "PrinterDialog",_  'must call this to start a document
        h as short,_                'handle of program window
        pDC as short                'nozero if successful = printer DC
    RETURN



[end.print] 'must call at end of job
    CallDll #lb, "EndPrint",_   'ends document
        h as short,_            'window handle
        r as short              'nonzero if successful
    RETURN

[create.font.point.size]
    CallDll #lb, "PointSizeFont",_      'create a font with many attributes
        h as short,_                    'window handle
        height as short,_               'height in points - 72 pts per inch
        bold as short,_                 '0=normal  1=bold
        italic as short,_               '0=normal  1=italic
        underline as short,_            '0=normal  1=underline
        strikeout as short,_            '0=normal  1=strikeout
        pfontname$ as ptr,_             'null terminated, no LB underscores
        hfont as short                  'returns handle of font
    RETURN



[print.text.line]
    CallDll #lb, "PrintTextLine",_
        h as short,_                'window handle
        text$ as ptr,_              'text string to print
        line.length as short,_      'length of text string
        r as short                  'nonzero if successful
    RETURN


[get.y.pos]
    CallDll #lb, "GetLineYPos",_    'cursor position for PrintTextLine
        h as short,_                'window handle
        linepos as short            'position of y cursor in hundredths
    print "GetLineYPos return is:  ";str$(linepos)
    return

[get.line.height]
    CallDll #lb, "GetTextLineHeight",_  'height for lines in current font
        h as short,_                    'window handle
        lineheight as short             'height in hundredths of text line
print "GetTextLineHeight return is:  ";str$(lineheight)
    return
