'demo that opens a file, then uses line-wrap code
'to print the entire file
'no wrap at hyphens 
'no true tabs available - tabs replaced with 4 spaces 
'
'creates font from point size
'
'WORKS BEST WITH FIXED-WIDTH FONT!
'awatson@wctc.net
'-------------------------------------------------
    open "lbprnt01.dll" for dll as #lb
    gosub [create.printer.dc]

    if pDC=0 THEN
        print "Print is cancelled!"
        close #lb
        END
    end if

    pfontname$="Courier New" + chr$(0) 'fixed width font
    height=14                          'in points - 72 pts in one inch
    gosub [create.font.point.size]

    filedialog "Open text file","*.txt",file$
    if file$="" then [quit]

    open file$ for input as #fl
        TextBlock$ = input$(#fl,lof(#fl))
    close #fl
             
    print TextBlock$
'-----------------------------------------------
    'to print a block of text, make sure it is
    'contained in a string called TextBlock$
    'then call the [print.text.block] subroutine
'-----------------------------------------------

    gosub [print.text.block]

[quit]
    gosub [end.print]
    close #lb
    print "Job has been sent to the printer."
    cursor normal
    END



[create.printer.dc]
    CallDll #lb, "PrinterDialog",_  'must call this to start a document
        h as short,_                'handle of program window
        pDC as short                'nozero if successful = printer DC
    RETURN



[end.print] 'must call at end of job
    CallDll #lb, "EndPrint",_   'ends document
        h as short,_            'window handle
        r as short              'nonzero if successful
    RETURN

[create.font.point.size]
    CallDll #lb, "PointSizeFont",_      'create a font with many attributes
        h as short,_                    'window handle
        height as short,_               'height in points - 72 pts per inch
        bold as short,_                 '0=normal  1=bold
        italic as short,_               '0=normal  1=italic
        underline as short,_            '0=normal  1=underline
        strikeout as short,_            '0=normal  1=strikeout
        pfontname$ as ptr,_             'null terminated, no LB underscores
        hfont as short                  'returns handle of font
    RETURN


'-----------------------------------------------
'-----------------------------------------------
'          BEGIN LINE-WRAP ROUTINE
'       DO NOT CHANGE THE CODE BELOW!
'
'       LBPRNT01.DLL MUST BE OPENED
'               AS #lb
'
'       PRINTER MUST BE INITIALIZED WITH
'             PrinterDialog
'                 OR
'              PrinterInit
'
'       SEND IN A BLOCK OF TEXT IN
'       A STRING CALLED TextBlock$
'       CALL GOSUB [print.text.block]
'-----------------------------------------------
'-----------------------------------------------

[print.text.block]
    gosub [get.max.chars.in.line] 'returns max.char
    gosub [print.wrap]            'wraps and places in temp file tf.tmp

    Open "tf.tmp" for input as #5
    While eof(#5)=0
        Line input #5, temp.line$  'send one line of text to printer

[fix.tab.stops]'removes chr$(9) and replaces with blank spaces
        if instr(temp.line$,chr$(9))>0 then
             blank=instr(temp.line$,chr$(9))
             temp.line$=left$(temp.line$,blank-1)+space$(4)+Mid$(temp.line$,blank+1)
        if instr(temp.line$,chr$(9))>0 then goto [fix.tab.stops]
        end if

        line.length=len(temp.line$)
        temp.line$=temp.line$+chr$(0)

        gosub [print.text.line.from.block]
    wend
    close #5
    kill "tf.tmp"
    return


[print.text.line.from.block]
    CallDll #lb, "PrintTextLine",_
        h as short,_                'window handle
        temp.line$ as ptr,_         'text string to print
        line.length as short,_      'length of text string
        r as short                  'nonzero if successful
    RETURN



[get.max.chars.in.line]
    CallDll #lb, "GetMaxChars",_
        h as short,_         'window handle
        max.char as short    'returns maximum chars in line
    RETURN


[print.wrap]  'word wrap for printing based on max.char formula
        newL$=""
        CrLf$=chr$(13)
    ist = 1
    while ist < len(TextBlock$)
        nst = instr(TextBlock$, CrLf$, ist)
        if nst = 0 then
            line$ = mid$(TextBlock$, ist)
            ist = len(TextBlock$)
        else
            line$ = mid$(TextBlock$, ist, nst-ist)
            ist = nst + 2
            if line$ = "" then newL$ = newL$ + CrLf$
            end if
        while line$ <> ""
            if len(line$) <= max.char then
                newL$ = newL$ + line$ + CrLf$
                line$ = ""
              else
                if instr(line$, " ") < 1 then
                    newL$ = newL$ + left$(line$, max.char) + CrLf$
                    line$ = mid$(line$, max.char+1)
                  else
                    char$ = ""
                    index = max.char + 1
                    while char$ <> " "
                        char$ = mid$(line$, index, 1)
                        index = index - 1
                    wend
                    newL$ = newL$ + left$(line$, index+1) + CrLf$
                    line$ = mid$(line$, index+2)
                end if
            end if
        wend
    wend
        open "tf.tmp" for output as #5
            print #5, newL$
            close #5
        cursor normal
return

'-----------------------------------------------
'-----------------------------------------------
'          END LINE-WRAP ROUTINE
'       DO NOT CHANGE THE CODE ABOVE!
'-----------------------------------------------
'-----------------------------------------------

