'Demo of line-wrap with a texteditor.
'A file can be opened, or text can be typed
'into the texteditor, then printed.
'There is no wrap at hyphens.
'There are no true tabs available -
'  - tabs replaced with 4 spaces.
'
'No font is created, and margins are not changed
'so the default font and default one inch
'margins are used.
'
'awatson@wctc.net
'-------------------------------------------------

nomainwin
WindowWidth=640:WindowHeight=480

texteditor #1.t, 0,0,639,440
menu #1, "&File","&Open",[open],"&Print",[print],"E&xit",[quit]
open "Printing with line-wrap" for window_nf as #1
    print #1, "trapclose [quit]"



[loop]
    input a$


[quit]
    close #1:end


[open]
    filedialog "Open text file","*.txt",file$
    if file$="" then [loop]

    open file$ for input as #fl
        print #1.t, "!contents #fl"
    close #fl
    print #1.t, "!origin 1 1";
    goto [loop]



[print]
    open "lbprnt01.dll" for dll as #lb
    gosub [create.printer.dc]

    if pDC=0 THEN
        notice "Print is cancelled!"
        goto [loop]
    end if

'CREATE A FIXED-WIDTH FONT
    pfontname$="Times New Roman" + chr$(0)  'must be null terminated -
                                            'no underscores between words
    height=18                               'in hundredths of inch
    CallDll #lb, "EasyFont",_               'easy create font
        h as short,_                        'window handle
        height as short,_                   'height in hundedths of inch
        pfontname$ as ptr,_                 'null terminated, no LB underscores
        hfont as short                      'returns handle of font

'-----------------------------------------------
    'to print a block of text, make sure it is
    'contained in a string called TextBlock$
    'then call the [print.text.block] routine
'-----------------------------------------------
    print #1.t, "!contents?";
    input #1.t, TextBlock$

    gosub [print.text.block]
    gosub [end.print]
    close #lb
    goto [loop]



[create.printer.dc]
    CallDll #lb, "PrinterDialog",_  'must call this to start a document
        h as short,_                'handle of program window
        pDC as short                'nozero if successful = printer DC
    RETURN



[end.print] 'must call at end of job
    CallDll #lb, "EndPrint",_   'ends document
        h as short,_            'window handle
        r as short              'nonzero if successful
    RETURN


'-----------------------------------------------
'-----------------------------------------------
'          BEGIN LINE-WRAP ROUTINE
'       DO NOT CHANGE THE CODE BELOW!
'
'       LBPRNT01.DLL MUST BE OPENED
'               AS #lb
'
'       PRINTER MUST BE INITIALIZED WITH
'             PrinterDialog
'                 OR
'              PrinterInit
'
'       SEND IN A BLOCK OF TEXT IN
'       A STRING CALLED TextBlock$
'       CALL GOSUB [print.text.block]
'-----------------------------------------------
'-----------------------------------------------

[print.text.block]
    gosub [get.max.chars.in.line] 'returns max.char
    gosub [print.wrap]            'wraps and places in temp file tf.tmp

    Open "tf.tmp" for input as #5
    While eof(#5)=0
        Line input #5, temp.line$  'send one line of text to printer

[fix.tab.stops]'removes chr$(9) and replaces with blank spaces
        if instr(temp.line$,chr$(9))>0 then
             blank=instr(temp.line$,chr$(9))
             temp.line$=left$(temp.line$,blank-1)+space$(4)+Mid$(temp.line$,blank+1)
        if instr(temp.line$,chr$(9))>0 then goto [fix.tab.stops]
        end if

        line.length=len(temp.line$)
        temp.line$=temp.line$+chr$(0)

        gosub [print.text.line.from.block]
    wend
    close #5
    kill "tf.tmp"
    return


[print.text.line.from.block]
    CallDll #lb, "PrintTextLine",_
        h as short,_                'window handle
        temp.line$ as ptr,_         'text string to print
        line.length as short,_      'length of text string
        r as short                  'nonzero if successful
    RETURN



[get.max.chars.in.line]
    CallDll #lb, "GetMaxChars",_
        h as short,_         'window handle
        max.char as short    'returns maximum chars in line
    RETURN


[print.wrap]  'word wrap for printing based on max.char formula
        newL$=""
        CrLf$=chr$(13)
    ist = 1
    while ist < len(TextBlock$)
        nst = instr(TextBlock$, CrLf$, ist)
        if nst = 0 then
            line$ = mid$(TextBlock$, ist)
            ist = len(TextBlock$)
        else
            line$ = mid$(TextBlock$, ist, nst-ist)
            ist = nst + 2
            if line$ = "" then newL$ = newL$ + CrLf$
            end if
        while line$ <> ""
            if len(line$) <= max.char then
                newL$ = newL$ + line$ + CrLf$
                line$ = ""
              else
                if instr(line$, " ") < 1 then
                    newL$ = newL$ + left$(line$, max.char) + CrLf$
                    line$ = mid$(line$, max.char+1)
                  else
                    char$ = ""
                    index = max.char + 1
                    while char$ <> " "
                        char$ = mid$(line$, index, 1)
                        index = index - 1
                    wend
                    newL$ = newL$ + left$(line$, index+1) + CrLf$
                    line$ = mid$(line$, index+2)
                end if
            end if
        wend
    wend
        open "tf.tmp" for output as #5
            print #5, newL$
            close #5
        cursor normal
return

'-----------------------------------------------
'-----------------------------------------------
'          END LINE-WRAP ROUTINE
'       DO NOT CHANGE THE CODE ABOVE!
'-----------------------------------------------
'-----------------------------------------------

