'   prwrap3b.bas  --  printer word wrap

'demo that opens a file, then uses line-wrap code
'to print the entire file.
'Handles tab stops and wraps
'lines at hyphens and spaces.
'
'by Bill Jennings <bbjen@tir.com>
'-------------------------------------------------
    open "lbprnt01.dll" for dll as #lb
    open "gdi" for dll as #gdi
    open "user.dll" for dll as #user
    gosub [create.printer.dc]

'--------------- define desired maximum printed
'                line width in inches -------------
    xWidth=6   'if too large (much over 6 inches), lines get
        'truncated at right margin.   '**********************

    pfontname$="Times New Roman" + chr$(0)
    height=16                       'in hundedths of inch
    gosub [create.font.easy]

    'get max chars in line
      calldll #lb, "GetMaxChars",_
        h as short,_   'window handle
        max.char as short   'returns max chars in a line

    'get adjustment factor, based on max.char & line width
      x2=.0108-4.62/10^5*xWidth
      Adj=.04+x2*max.char
      xWidthAdjusted=xWidth*Adj-(.017*xWidth)

    filedialog "Open text file","*.txt",file$
    if file$="" then [quit]

    open file$ for input as #fl
        TextBlock$ = input$(#fl,lof(#fl))
    close #fl

'-------------- fake window reqd -----------------
    'to get display pixels per inch.  This is used
    'to calculate PF, print factor ratio
    ' --------------------------------------------
    WindowWidth=0 : WindowHeight=0   'arbitrary size
    UpperLeftX=0  'off screen
    open "calculation box" for window as #w1
      print #w1, "trapclose [quit]"
      hw1=hwnd(#w1)   'handle of hidden window
      struct SIZE, cx as word, cy as word
      gosub [getWfactor]   'with max width in pixels
      gosub [print.text.block]
      goto [quit]
    input r$

[quit]
    gosub [end.print]
    close #lb : close #gdi : close #user : close #w1
    print "Job has been sent to the printer."
    cursor normal
    END

[create.printer.dc]
    CallDll #lb, "PrinterDialog",_  'must call this to start a document
        h as short,_                'handle of program window
        pDC as short                'nozero if successful = printer DC

    if pDC=0 then
        notice "Failure initializing printer!"
        gosub [end.print]
        goto [quit]
    end if
  RETURN

[getWfactor]
    calldll #user, "GetDC", hw1 as word, hDC as short   'handle of fake window
    calldll #gdi, "GetDeviceCaps", hDC as word, 88 as word,_
      sDPIx as word   'screen, pixels per inch
    calldll #gdi, "GetDeviceCaps", pDC as word, 88 as word,_
      DPIx as word   'printer, dots per inch
    Wfactor=DPIx/sDPIx
    sWidth=int(xWidthAdjusted*DPIx/Wfactor)   'max line in pixels
    RETURN

[end.print] 'must call at end of job
    CallDll #lb, "EndPrint",_   'ends document
        h as short,_            'window handle
        r as short              'nonzero if successful
    RETURN

[create.font.easy]
    CallDll #lb, "EasyFont",_           'easy create font
        h as short,_                    'window handle
        height as short,_               'height in hundedths of inch
        pfontname$ as ptr,_             'null terminated, no LB underscores
        hfont as short                  'returns handle of font
    RETURN

'-----------------------------------------------
'-----------------------------------------------
'          BEGIN LINE-WRAP ROUTINE
'       DO NOT CHANGE THE CODE BELOW!
'
'       SEND IN A BLOCK OF TEXT IN
'       A STRING CALLED TextBlock$
'-----------------------------------------------
'-----------------------------------------------

[print.text.block]

    lf$=""    '***replace tab stops with 4 spaces each
    pt=instr(TextBlock$,chr$(9))     'pt, position of tab
    while pt>0
      lf$=lf$+left$(TextBlock$,pt-1)+space$(4)
      TextBlock$=mid$(TextBlock$,pt+1)
      pt=instr(TextBlock$,chr$(9))
    wend
    TextBlock$=lf$+TextBlock$   '***add tail end of text

    CrLf$=chr$(13)+chr$(10)

    if right$(TextBlock$,2)<>CrLf$ then _
      TextBlock$=TextBlock$+CrLf$

         '***wrap and/or print one paragraph at a time
    while len(TextBlock$)>0
      p=instr(TextBlock$,CrLf$)
      line$=left$(TextBlock$,p-1)
      if p>0 then TextBlock$=mid$(TextBlock$,p+2)
      gosub [wrap]
    wend

  RETURN


[print.text.line.from.block]
    line.length=len(L$)
    CallDll #lb, "PrintTextLine",_
        h as short,_                'window handle
        L$ as ptr,_         'text string to print
        line.length as short,_      'length of text string
        r as short                  'nonzero if successful
    RETURN


[wrap]        '***wrap lines to sWidth
    text$=line$ : gosub [getTextExtentPoint]
    if width<=sWidth then _
      L$=left$(line$,len(line$)) : _
      gosub [print.text.line.from.block] : _
      RETURN
    ps=0    '****position of space
  [repeat1]   '***look for spaces
    p=instr(line$," ",ps+1)
    if p=0 then [end1]
    text$=left$(line$,p-1) : gosub [getTextExtentPoint]
    if width>sWidth then [end1]
    ps=p : goto [repeat1]   '***ps= position of last space
  [end1]
    ph=0    '***position of hyphen
  [repeat2]   '***look for hyphens
    p=instr(line$,"-",ph+1)
    if p=0 then [end2]
    text$=left$(line$,p) : gosub [getTextExtentPoint]
    if width>sWidth then [end2]
    ph=p : goto [repeat2]   '***ph= position of last hyphen
  [end2]
    p0=ps : en$="" : if ph>ps then p0=ph : en$="-"
        'en$= character for end of L$ line
    if ps=0 and ph=0 then _
        p0=int(0.65*max.char)   'word too long to wrap

    L$=left$(line$,p0)+en$ 
    gosub [print.text.line.from.block]
    line$=mid$(line$,p0+1)
  goto [wrap]   '***loop back as long as line is long


[getTextExtentPoint]
    count=len(text$)
    calldll #gdi, "GetTextExtentPoint", hDC as word, text$ as ptr,_
      count as word, SIZE as struct, result as word
    width=SIZE.cx.struct
  RETURN
