'** Liberty BASIC Newsletter
'** Open Source Editor v0.8
'** Please add your name to
'** the list of authors:
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn - tooltip routines
'** Chris Robertson - font choice routine
'**
'** this program will not work in LBv2.0!
'** Add Editor Display Font Selection

    if val(Version$)>1.42 then
        notice "This program will not work in LBv2.0!"
        end
    end if

nomainwin
    open "user" for dll as #user
    dim info$(10,10)        'for file exist check
    open "commctrl.dll" for dll as #cctl

    dim branch$(20)         'array to hold branch labels
    open "ctl3d.dll" for dll as #ctl3d
    calldll #ctl3d,"Ctl3dRegister",0 as short,result as short
    calldll #ctl3d,"Ctl3dAutoSubclass",0 as short,result as short


cursor hourglass

'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'red                red value
'green              green value
'blue               blue value
'menuColor          system menu color
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'pic$               string to hold bitmap file header
'savebmpfile$       name to save bmp AS
'picDepth           color depth of bitmap
'picCols            number of colors in bitmap
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphibox
'ybmp               y location to draw bitmap in graphibox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename


'** NEW **
'drv$               variable for drive in font list routine
'path$              variable for path in font list routine
'ttf$               name of font loaded from list
'sp,f,fs            counter variables in font routine
'font$              font name in font routine
'fX$                width of font
'fY$                height of font
'setFont$           LB fontname and size info for chosen font
'font$              facename of font
'fX$                font size width
'fY$                font size height

'for font choice routine:
    dim fontList$(500)  'array of font names
    dim fontSize$(31)   'array of font sizes
    dim temp$(10,10)    'for files statement in font routine

    fontsLoaded = 0     'flag for fontloading routine


'for tooltips:
    GWW = _GWW_HINSTANCE or 0
    style           = 0
    CW.USEDEFAULT   = hexdec("8000")
    TTF.IDISHWND    = hexdec("0001")
    TTF.SUBCLASS    = hexdec("0010")
    TTM.ADDTOOL     = _WM_USER+4


menu #1, "&File",_
    "&New",[new],_
    "&Open",[open],_
    "&Save",[save],_
    "Save &As",[saveas],|,_
    "&Print",[print],_
    "E&xit",[quit]

menu #1, "&Edit" 'LB supplies the Edit Menu

menu #1, "&Run",_
    "Ru&n", [run],_
    "&Debug",[debug],_
    "&Make TKN",[maketkn],_
    "Run &TKN",[runtkn]

menu #1, "E&xternals",_
    "&Paintbrush",[paint],_
    "&File Manager",[winfile],_
    "&Notepad",[notepad],_
    "&Calculator",[calculator]

'** NEW **
menu #1, "&Tools",_
    "&Branch Labels",[branchlabels],_
    "Bit&map Preview",[bmp],_
    "&Wav Preview",[wav],_
    "&Font Change",[fontBox]

menu #1, "&Help",_
    "&Liberty BASIC Help",[help],_
    "LB &Tutorial",[tutorial],_
    "&About",[about]

    texteditor #1.t, 0,40,600,400  'edit window

    graphicbox #1.g, -1,-1,800,21  'toolbar
    button #1.new,     "New",   [new],       UL,3,2,30,15
    button #1.open,    "Open",  [open],      UL,34,2,30,15
    button #1.save,    "Save",  [save],      UL,65,2,30,15
    button #1.saveas,  "..As",  [saveas],    UL,96,2,30,15
    button #1.print,   "Print", [print],     UL,127,2,30,15

    button #1.run,     "Run",   [run],       UL,167,2,30,15
    button #1.debug,   "Debug", [debug],     UL,198,2,30,15
    button #1.token,   "TKN",   [maketkn],   UL,229,2,30,15
    button #1.runtkn,  "R tkn", [runtkn],    UL,260,2,30,15

    button #1.paint,   "Paint", [paint],     UL,300,2,30,15
    button #1.file,    "F Mgr", [winfile],   UL,331,2,30,15
    button #1.note,    "Note",  [notepad],   UL,362,2,30,15
    button #1.calc,    "Calc",  [calculator],UL,393,2,30,15

    button #1.help,    "Help",  [help],      UL,433,2,30,15
    button #1.tutor,   "Tutor", [tutorial],  UL,464,2,30,15

open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"

    calldll #user, "ShowWindow",h as word,_SW_MAXIMIZE as ushort,result As word

    print #1.new,     "!font arial 0 12"
    print #1.open,    "!font arial 0 12"
    print #1.save,    "!font arial 0 12"
    print #1.saveas,  "!font arial 0 12"
    print #1.print,   "!font arial 0 12"
    print #1.run,     "!font arial 0 12"
    print #1.debug,   "!font arial 0 12"
    print #1.token,   "!font arial 0 12"
    print #1.runtkn,  "!font arial 0 12"
    print #1.paint,   "!font arial 0 12"
    print #1.file,    "!font arial 0 12"
    print #1.note,    "!font arial 0 12"
    print #1.calc,    "!font arial 0 12"
    print #1.help,    "!font arial 0 12"
    print #1.tutor,   "!font arial 0 12"


    print #1.t, "!setfocus";
    gosub [colorToolbar]
    gosub [addTooltips]

'** NEW **
    gosub [read.ini.file]

    cursor normal

[loop]
    input a$



[quit]
    gosub [isModified]
    calldll #ctl3d,"Ctl3dUnregister",0 as short,result as short
    close #ctl3d

    close #user: close #1 : close #cctl
    if tempfilename$<>"" then kill tempfilename$ 
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 20 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 20 ";WindowWidth-1;" ";WindowHeight-21
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** LOCATE GRAPHICBOX - WindowWidth+2 WIDE, 21 PIXELS HIGH
    print #1.g, "locate -1 -1 ";WindowWidth+2;" 21"

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    gosub [settext]
    goto [loop]



[open]
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas",file$ 
    if file$="" then [loop]

    fileindex=len(file$)  'separate path and filename
    filelength=len(file$)
        while mid$(file$, fileindex,1)<>"\"
            fileindex=fileindex-1
        wend

'** USE FILES STATEMENT TO CHECK FOR FILE'S EXISTENCE
    shortFile$=right$(file$,filelength-fileindex)
    filePath$=left$(file$,fileindex)
    files filePath$,shortFile$,info$(
    if val(info$(0,0))<1 then
        notice "Error"+chr$(13)+"File does not exist."
        goto [loop]
    end if

[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    goto [loop]



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user, "SetWindowText", h as word, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$
    filedialog "Save file as..",filePath$+"*.bas",file$ 
      if file$="" then
        notice "You must choose a file name."
        goto [loop]
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    goto [loop]


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

'** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.bas") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 

    open "tempedit.txt" for output as #tprint
        print #tprint, saveit$
    close #tprint

    printFile$ = "tempedit.txt"+chr$(0)

    open "shell.dll" for dll as #shell
    calldll #shell, "ShellExecute", _
        h as word, _
        "print" as ptr, _
        printFile$ as ptr, _
        "" as ptr, _
        DefaultDir$ as ptr, _
        _SW_HIDE as short, _
        result as word
    close #shell

    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    goto [loop]


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
'** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

'** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","liberty.exe",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    goto [loop]

[maketkn]
    gosub [readyRun]
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]



[paint]
    run "pbrush.exe",SHOWNORMAL
    goto [loop]

[notepad]
    run "notepad.exe",SHOWNORMAL
    goto [loop]

[winfile]
    run "winfile.exe",SHOWNORMAL
    goto [loop]

[calculator]
    run "calc.exe" ,SHOWNORMAL
    goto [loop]



[help]
    run "winhelp liberty.hlp"
    goto [loop]

[tutorial]
    run "winhelp tutorial.hlp"
    goto [loop]



[colorToolbar]
    '** GET SYSTEM MENU COLOR VALUE
    calldll #user,  "GetSysColor",_
        _COLOR_MENU as word,_
        menuColor as long

    '** RETRIEVE VALUES FOR red, green, blue
    blue = int(menuColor / (256 * 256))
    green = int((menuColor - blue *256*256) / 256)
    red = menuColor - blue *256 * 256 - green * 256

    '** FILL TOOLBAR WITH THIS COLOR
    print #1.g, "down;size 50; color ";red;" ";green;" ";blue
    print #1.g, "line 0 20 1200 20"
    print #1.g, "flush"
    RETURN



[addTooltips]
    calldll #cctl, "InitCommonControls", re as void
    calldll #user, "GetWindowWord", h as word,_
        GWW as word, hInstance as word

    calldll #user, "CreateWindow", _
        "tooltips_class" as ptr, _
        "" as ptr, _
        style as long, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        h as word, _
        0 as word, _
        hInstance as word, _
        "" as ptr, _
        hwndTT as word

'** MAKE A STRUCT FOR EACH TOOL
    struct toolinfo1, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo2, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo3, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo4, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo5, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo6, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo7, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo8, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo9, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo10, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo11, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo12, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo13, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo14, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo15, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr



    toolinfo1.cbSize.struct = 22
    toolinfo1.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo1.hwnd.struct = h
    toolinfo1.uId.struct = hwnd(#1.new)
    toolinfo1.hInst.struct = hInstance
    toolinfo1.lpstrText$.struct = "New File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo1 as struct, re as long

    toolinfo2.cbSize.struct = 22
    toolinfo2.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo2.hwnd.struct = h
    toolinfo2.uId.struct = hwnd(#1.open)
    toolinfo2.hInst.struct = hInstance
    toolinfo2.lpstrText$.struct = "Open File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo2 as struct, re as long

    toolinfo3.cbSize.struct = 22
    toolinfo3.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo3.hwnd.struct = h
    toolinfo3.uId.struct = hwnd(#1.save)
    toolinfo3.hInst.struct = hInstance
    toolinfo3.lpstrText$.struct = "Save File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo3 as struct, re as long

    toolinfo4.cbSize.struct = 22
    toolinfo4.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo4.hwnd.struct = h
    toolinfo4.uId.struct = hwnd(#1.saveas)
    toolinfo4.hInst.struct = hInstance
    toolinfo4.lpstrText$.struct = "Save File As..."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo4 as struct, re as long

    toolinfo5.cbSize.struct = 22
    toolinfo5.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo5.hwnd.struct = h
    toolinfo5.uId.struct = hwnd(#1.print)
    toolinfo5.hInst.struct = hInstance
    toolinfo5.lpstrText$.struct = "Print File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo5 as struct, re as long

    toolinfo6.cbSize.struct = 22
    toolinfo6.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo6.hwnd.struct = h
    toolinfo6.uId.struct = hwnd(#1.run)
    toolinfo6.hInst.struct = hInstance
    toolinfo6.lpstrText$.struct = "Run Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo6 as struct, re as long

    toolinfo7.cbSize.struct = 22
    toolinfo7.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo7.hwnd.struct = h
    toolinfo7.uId.struct = hwnd(#1.debug)
    toolinfo7.hInst.struct = hInstance
    toolinfo7.lpstrText$.struct = "Debug Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo7 as struct, re as long

    toolinfo8.cbSize.struct = 22
    toolinfo8.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo8.hwnd.struct = h
    toolinfo8.uId.struct = hwnd(#1.token)
    toolinfo8.hInst.struct = hInstance
    toolinfo8.lpstrText$.struct = "Tokenize Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo8 as struct, re as long

    toolinfo9.cbSize.struct = 22
    toolinfo9.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo9.hwnd.struct = h
    toolinfo9.uId.struct = hwnd(#1.runtkn)
    toolinfo9.hInst.struct = hInstance
    toolinfo9.lpstrText$.struct = "Run an existing TKN"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo9 as struct, re as long

    toolinfo10.cbSize.struct = 22
    toolinfo10.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo10.hwnd.struct = h
    toolinfo10.uId.struct = hwnd(#1.paint)
    toolinfo10.hInst.struct = hInstance
    toolinfo10.lpstrText$.struct = "Run Windows Paintbrush"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo10 as struct, re as long

    toolinfo11.cbSize.struct = 22
    toolinfo11.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo11.hwnd.struct = h
    toolinfo11.uId.struct = hwnd(#1.file)
    toolinfo11.hInst.struct = hInstance
    toolinfo11.lpstrText$.struct = "Run File Manager"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo11 as struct, re as long

    toolinfo12.cbSize.struct = 22
    toolinfo12.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo12.hwnd.struct = h
    toolinfo12.uId.struct = hwnd(#1.note)
    toolinfo12.hInst.struct = hInstance
    toolinfo12.lpstrText$.struct = "Run Notepad"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo12 as struct, re as long

    toolinfo13.cbSize.struct = 22
    toolinfo13.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo13.hwnd.struct = h
    toolinfo13.uId.struct = hwnd(#1.calc)
    toolinfo13.hInst.struct = hInstance
    toolinfo13.lpstrText$.struct = "Run Windows Calculator"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo13 as struct, re as long

    toolinfo14.cbSize.struct = 22
    toolinfo14.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo14.hwnd.struct = h
    toolinfo14.uId.struct = hwnd(#1.help)
    toolinfo14.hInst.struct = hInstance
    toolinfo14.lpstrText$.struct = "Liberty BASIC Help"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo14 as struct, re as long

    toolinfo15.cbSize.struct = 22
    toolinfo15.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo15.hwnd.struct = h
    toolinfo15.uId.struct = hwnd(#1.tutor)
    toolinfo15.hInst.struct = hInstance
    toolinfo15.lpstrText$.struct = "Liberty BASIC Tutorial"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo15 as struct, re as long


    struct toolinfo16, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    toolinfo16.cbSize.struct = 22
    toolinfo16.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo16.hwnd.struct = h
    toolinfo16.uId.struct = hwnd(#1.t)
    toolinfo16.hInst.struct = hInstance
    toolinfo16.lpstrText$.struct = "Right click here for an edit menu."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo16 as struct, re as long
    RETURN



[branchlabels]
'** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    listbox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"
    goto [loop]


[cancelbranch]
'** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    goto [loop]


[branch]
'** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        goto [loop]
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            goto [loop]
          END If
    Next i
    cursor normal
    goto [loop]




[bmp] '** BITMAP PREVIEWER
    WindowWidth=451:WindowHeight=350

    button #bit.open, "Open",   [openbmp],  UL,350,5,80,26
    button #bit.save, "Save As",[savebmp],  UL,350,35,80,26
    button #bit.exit, "Exit",   [closebit], UL,350,65,80,26

    textbox #bit.t1, 20,35,300,26
    textbox #bit.t2, 20,65,300,26

    graphicbox #bit.box1, 20,100,410,200
    statictext #bit.s, "Bitmap File:",20,5,150,20
    open "Bitmap Preview" for dialog_modal as #bit
    print #bit, "trapclose [closebit]"

    print #bit.t1,   "!font Times_New_Roman 0 16"
    print #bit.t2,   "!font Times_New_Roman 0 16"
    print #bit.save, "!font Times_New_Roman 0 16"
    print #bit.open, "!font Times_New_Roman 0 16"
    print #bit.exit, "!font Times_New_Roman 0 16"
    print #bit.s,    "!font Times_New_Roman 0 16"


    goto [loop]

[closebit]
    print #bit.box1, "cls"
    close #bit
    if bmploaded=1 then unloadbmp "tempPicture"
    bmploaded=0
    goto [loop]

[savebmp]
    if picFile$="" then
        notice "It is not possible to SAVE.  No Bitmap has been chosen."
        goto [loop]
    end if

    open picFile$ for input as #pf
        pic$=input$(#pf, lof(#pf))
    close #pf

    filedialog "Save As..","*.bmp",savebmpfile$ 
    if savebmpfile$="" then [loop]

    cursor hourglass
    open savebmpfile$ for output as #bpf
        print #bpf, pic$
    close #bpf
    cursor normal
    notice "Bitmap saved as "+savebmpfile$ 
    goto [loop]


[openbmp]
    filedialog "Open Bitmap","*.bmp", picFile$
    if picFile$ = "" then [loop]

    print #bit.t1, picFile$

    open picFile$ for input as #pic
    pic$=input$(#pic,29)
    close #pic
    picDepth=asc(right$(pic$,1))
    picColors=2^picDepth

    bmpwidth = asc(mid$(pic$,19,1)) + (asc(mid$(pic$,20,1)) * 256)
    bmpheight = asc(mid$(pic$,23,1)) + (asc(mid$(pic$,24,1)) * 256)

    if picColors > 256 then
        print #bit.t2, ""
        print #bit.t1, ""
        print #bit.box1, "cls"
        message$="The chosen bitmap has more than 256 colors, "+_
            "so Liberty BASIC cannot load it.  Would you like to "+_
            "view it with Paintbrush?"
        confirm message$;answer$
        if answer$="yes" then
            run "pbrush "+picFile$ 
            picFile$=""
            goto [closebit]
            else
            picFile$=""
            goto [loop]
          end if
    end if

    if bmploaded=1 then unloadbmp "tempPicture"
    loadbmp "tempPicture", picFile$
    bmploaded=1

    print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    xbmp=int((410-bmpwidth)/2)
    ybmp=int((200-bmpheight)/2)

    print #bit.box1, "cls"
    print #bit.box1, "drawbmp tempPicture ";xbmp;" ";ybmp
    print #bit.box1, "flush"
    goto [loop]



[about]
    message$="About this editor..."+chr$(13)+_
        chr$(169)+"The Liberty BASIC Community"
    notice message$
    goto [loop]




[wav]
    if wavPath$="" then wavPath$=DefaultDir$
    filedialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    if wavFile$="" then
        playwave ""
        goto [loop]
    end if

    slash=len(wavFile$)
        while instr(wavFile$, "\", slash)=0
            slash=slash-1
        wend
    wavPath$=left$(wavFile$,slash)
    playwave wavFile$,async
    goto [wav]




'** NEW **
'Chris Robertson, September 9, 1999
'donnaf@ihug.co.nz
[fontBox]

    if fontsLoaded=1 then [open.font.dialog] 'skip font loading routine

'** export font list from registry
    run "regedit /e ";DefaultDir$;"\font.lst Hkey_Local_Machine\Software\Microsoft\Windows\CurrentVersion\Fonts", SW_HIDE

    drv$ = left$(DefaultDir$,3)
    path$ = right$(DefaultDir$, len(DefaultDir$)-3)+"\font.lst"
    gosub [check4DosOutput]

''''''sample entry in list: "Arial (TrueType)"="ARIAL.TTF"

    open "font.lst" for input as #list   'load font list to array
    while eof(#list)=0
        f = f + 1
        input #list, ttf$ 
        if left$(ttf$,1) = chr$(34) then   'chr$(34) is double quote mark
            fn = instr(ttf$, "(", 2)       
            fontList$(f) = Trim$(mid$(ttf$,2,fn-2))
        end if
    wend
    close #list
    kill "font.lst"


'add fixedsys font
    f = f + 1
    fontList$(f) = "Fixedsys"

    if f > 2 then sort fontList$(, 1, f   'sort font list

    for fs = 1 to 30            'load font size
        fontSize$(fs) = "";fs
    next fs

[open.font.dialog]
    fontsLoaded = 1     'set a flag that fonts have been loaded
    WindowWidth = 400
    WindowHeight = 175

    listbox #fontBox.fontList, fontList$(, [fontBox.fontListClick], 6, 6, 237, 100
    listbox #fontBox.fontSizeX, fontSize$(, [fontBox.fontListClick], 248, 6, 64, 100
    listbox #fontBox.fontSizeY, fontSize$(, [fontBox.fontListClick], 318, 6, 64, 100
    statictext #fontBox.sample, "sample", 6, 121, 232, 25
    button #fontBox.fontAccept, "Accept", [fontBox.fontAcceptClick], UL, 246, 116, 58, 25
    button #fontBox.fontCancel, "Cancel", [fontBox.fontCancelClick], UL, 326, 116, 58, 25
    open "Chris Robertson's Font Selection" for dialog_modal as #fontBox
    print #fontBox, "trapclose [fontBox.fontCancelClick]"
    print #fontBox.fontList, "font Arial 7 17"
    print #fontBox.fontSizeX, "font Arial 7 17"
    print #fontBox.fontSizeY, "font Arial 7 17"
    print #fontBox.fontAccept, "!font Arial 7 17"
    print #fontBox.fontCancel, "!font Arial 7 17"
    print #fontBox.fontList, "singleclickselect"
    print #fontBox.fontSizeX, "singleclickselect"
    print #fontBox.fontSizeY, "singleclickselect"
    print #fontBox.fontList, "select ";font$
    print #fontBox.fontSizeX, "select ";fX$
    print #fontBox.fontSizeY, "select ";fY$

[fontBox.fontListClick]   'Perform action for the listbox named 'fontList'

    print #fontBox.fontList, "selection?": input #fontBox.fontList, font$
    print #fontBox.fontSizeX, "selection?": input #fontBox.fontSizeX, fX$
    print #fontBox.fontSizeY, "selection?": input #fontBox.fontSizeY, fY$
    sp = 1   'remove blanks and replace with LB underscores
    while sp > 0
        sp = instr(font$, " ", sp)
        if sp <> 0 then font$ = left$(font$, sp-1);"_";mid$(font$, sp+1)
    wend

    print #fontBox.sample, "!font ";font$;" ";val(fX$);" ";val(fY$)
    print #fontBox.sample, "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"

[waitLoop]   'wait here for input event
    input aVar$
    goto [waitLoop]

[fontBox.fontAcceptClick]   'Perform action for the button named 'fontAccept'
    setFont$ = font$;" ";val(fX$);" ";val(fY$)
    print #1.t, "!font ";setFont$

[fontBox.fontCancelClick]   'Perform action for the button named 'fontCancel'
    close #fontBox
    gosub [write.ini.file]
    goto [loop]

'________subroutines_________

[check4DosOutput] 'checks to see if a command line file has been created
'used to wait for dos output
'requires drv$ = drive\
'requires path$ = \path\*.*
'requires temp$(10,10) array

    redim temp$(10,10)
    while val(temp$(0,0)) <> 1
        files drv$, path$, temp$(
    wend

    while val(temp$(0,1)) = 0
        files drv$, path$, temp$(
    wend

    return

'** NEW **
[write.ini.file]
    open DefaultDir$ + "\editor.ini" for output as #inifile
        print #inifile, setFont$
    close #inifile
    RETURN


'** NEW **
[read.ini.file]
    open DefaultDir$ + "\editor.ini" for append as #inifile
        if lof(#inifile) <> 0 then
            close #inifile
            open DefaultDir$ + "\editor.ini" for input as #inifile
            line input #inifile, setFont$
        end if
    close #inifile

    if setFont$="" then setFont$="Fixedsys 8 15"
    print #1.t, "!font ";setFont$  'set font in texteditor

    font$ = word$(setFont$, 1)     'facename
    fX$   = word$(setFont$, 2)     'width
    fY$   = word$(setFont$, 3)     'height
    RETURN

