'** Liberty BASIC Newsletter
'** Open Source Editor v1.0
'** Please add your name to
'** the list of authors:
'**
'** Authors:
'**
'** Alyce Watson
'** Brent Thorn     - tooltip routines
'** Thomas Watson   - RGB color choice
'** Anthony Liquori - runtime icon changer
'** Brian Pugh      - gui for runtime icon changer
'**
'** added runtime icon changer


    if val(Version$)<2 then
        notice "This program is meant for in LBv2.0!"
        end
    end if

    nomainwin

    gosub [makebmpbutton]

    if FileExist(DefaultDir$,"\qbutton.bmp")<1 then
        notice "Error"+chr$(13)+"Unable to create bmpbutton!"
        end
    end if


    open "user" for dll as #user
    dim info$(10,10)        'for file exist check
    open "commctrl.dll" for dll as #cctl

    dim branch$(20)         'array to hold branch labels

cursor hourglass

'variables:
'file$              name of file to open
'title$             titlebar caption
'h                  is window handle
'modflag$           is answer to modified query
'answer$            receiver variable for confirm messages
'tempfilename$      name to use when running and debugging code
'rowVar,columnVar   location of texteditor origin
'fileindex          used for counter in path/file separation
'filelength         used for counter in path/file separation
'shortFile$         just filename without path
'filePath$          path without filename
'saveit$            receiver for input from texteditor
'libertyexe$        path to Liberty.exe for running/tokenizing/debugging
'tknfile$           name of tkn to run
'hInstance          window instance handle
'rowcount           number of lines in editor
'line$              contents of line in editor
'bx                 counter variable for branch label loading
'branchlength       length of branch label
'branchselect$      branch label selection
'picFile$           filename for opened bitmap
'pic$               string to hold bitmap file header
'savebmpfile$       name to save bmp AS
'bmpwidth           width of bitmap
'bmpheight          height of bitmap
'xbmp               x location to draw bitmap in graphibox
'ybmp               y location to draw bitmap in graphibox
'bmploaded          flag to set when a bitmap is loaded
'message$           string variable to hold notice and confirm messages
'printFile$         temporary file for printing with Notepad
'wavPath$           path to last wav played
'wavFile$           name of wav file to play
'slash              counter variable to separate wav path from filename
'setFont$           LB fontname and size info for chosen font
'timemsg$           variable to hold time info
'datemsg$           variable to hold date info

'** NEW**
'hicon              icon handle
'szFile$            runtime engine name
'runtime$           runtime engine name
'icon$              icon file name
'#1icon             icon file handle
'success=0
'ico                used for icon changer
'runpos             used for icon changer
'error              error flag in icon changer
'icopath$           path in icon changer
'hico               handle of icon window
'hicodc             dc of icon window
'hFile              icon file handle
'icont$             buffer for icon file input
'iconlength         length of icon buffer


'for tooltips:
    GWW = _GWW_HINSTANCE or 0
    style           = 0
    CW.USEDEFAULT   = hexdec("8000")
    TTF.IDISHWND    = hexdec("0001")
    TTF.SUBCLASS    = hexdec("0010")
    TTM.ADDTOOL     = _WM_USER+4


    ForegroundColor$=   "darkblue"
    TexteditorColor$=   "lightgray"
    drawcolor$=         "black"     'default color for drawing on bitmaps
    longcol=            0           'default color for drawing on bitmaps
    colorred=           0           'default red value for drawing on bitmaps
    colorgreen=         0           'default green value for drawing on bitmaps
    colorblue=          0           'default blue value for drawing on bitmaps
    decnum$=            "255"       'default starter for number conversion
    decnum=val(decnum$)
    hexnum$=            "FF"        'default starter for number conversion

    btnhigh =           15          'button height value
    btnwide =           30          'button width value
    btnY    =           2           'button y location


menu #1, "&File",_
    "&New",               [new],_
    "&Open",              [open],_
    "&Save",              [save],_
    "Save &As",           [saveas],|,_
    "&Print",             [print],_
    "E&xit",              [quit]

menu #1, "&Edit" 'LB supplies the Edit Menu

menu #1, "&Run",_
    "Ru&n",               [run],_
    "&Debug",             [debug],_
    "&Make TKN",          [maketkn],_
    "Run &TKN",           [runtkn]

menu #1, "E&xternals",_
    "&Paintbrush",        [paint],_
    "&File Manager",      [winfile],_
    "&Notepad",           [notepad],_
    "&Calculator",        [calculator]

'** NEW **
menu #1, "&Tools",_
    "&Branch Labels",       [branchlabels],_
    "Bit&map Preview",      [bmp],_
    "&Wav Preview",         [wav],_
    "Font &Dialog",         [fontdialog],_
    "&Number Tools	->",     [numbertools],_
    "Time and &Date	->",    [timetools],_
    "Runtime &Icon Changer",[changeicon]

menu #1, "&Help",_
    "&Liberty BASIC Help", [help],_
    "LB &Tutorial",        [tutorial],_
    "&About",              [about]

    texteditor #1.t, 0,40,600,400  'edit window

    button #1.new,     "New",   [new],       UL,3,btnY,btnwide,btnhigh
    button #1.open,    "Open",  [open],      UL,34,btnY,btnwide,btnhigh
    button #1.save,    "Save",  [save],      UL,65,btnY,btnwide,btnhigh
    button #1.saveas,  "..As",  [saveas],    UL,96,btnY,btnwide,btnhigh
    button #1.print,   "Print", [print],     UL,127,btnY,btnwide,btnhigh

    button #1.run,     "Run",   [run],       UL,167,btnY,btnwide,btnhigh
    button #1.debug,   "Debug", [debug],     UL,198,btnY,btnwide,btnhigh
    button #1.token,   "TKN",   [maketkn],   UL,229,btnY,btnwide,btnhigh
    button #1.runtkn,  "R tkn", [runtkn],    UL,260,btnY,btnwide,btnhigh

    button #1.paint,   "Paint", [paint],     UL,300,btnY,btnwide,btnhigh
    button #1.file,    "F Mgr", [winfile],   UL,331,btnY,btnwide,btnhigh
    button #1.note,    "Note",  [notepad],   UL,362,btnY,btnwide,btnhigh
    button #1.calc,    "Calc",  [calculator],UL,393,btnY,btnwide,btnhigh

    button #1.help,    "Help",  [help],      UL,433,btnY,btnwide,btnhigh
    button #1.tutor,   "Tutor", [tutorial],  UL,464,btnY,btnwide,btnhigh

    bmpbutton #1.quit, "qbutton.bmp",[quit],UL,504,btnY


open "Open Source LB Editor" for window as #1

    h=HWND(#1)
    print #1, "trapclose [quit]"
    print #1, "resizehandler [resize]"

    calldll #user, "ShowWindow",h as word,_SW_MAXIMIZE as ushort,result As word

    print #1.new,     "!font arial 0 12"
    print #1.open,    "!font arial 0 12"
    print #1.save,    "!font arial 0 12"
    print #1.saveas,  "!font arial 0 12"
    print #1.print,   "!font arial 0 12"
    print #1.run,     "!font arial 0 12"
    print #1.debug,   "!font arial 0 12"
    print #1.token,   "!font arial 0 12"
    print #1.runtkn,  "!font arial 0 12"
    print #1.paint,   "!font arial 0 12"
    print #1.file,    "!font arial 0 12"
    print #1.note,    "!font arial 0 12"
    print #1.calc,    "!font arial 0 12"
    print #1.help,    "!font arial 0 12"
    print #1.tutor,   "!font arial 0 12"


    print #1.t, "!setfocus";
    gosub [addTooltips]

    gosub [read.ini.file]

    cursor normal

[loop]
    input a$



[quit]
    gosub [isModified]

    close #user: close #1 : close #cctl
    if tempfilename$<>"" then kill tempfilename$ 
    END


[isModified]'** CHECK TO SEE IF FILE HAS BEEN MODIFIED
    print #1.t, "!modified?":input #1.t, modflag$
    if modflag$="true" then
        confirm "This file has been modified.  Save?";answer$
        if answer$="yes" then gosub [savesub]
    end if
    RETURN


[resize]'** LOCATE TEXT EDITOR
    '** LOCATE TEXTEDITOR 20 PIXELS FROM TOP OF CLIENT AREA
    print #1.t, "!locate 0 20 ";WindowWidth-1;" ";WindowHeight-21
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    '** UPDATE WINDOW
    print #1, "refresh"
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]


[new]'** CLEAR EDITOR CONTENTS, RESET VARIABLES
    gosub [isModified]
    print #1.t, "!cls"
    file$="untitled.bas"
    filePath$=""
    gosub [settext]
    goto [loop]



[open]
    gosub [isModified]
    filedialog "Open file..",filePath$+"*.bas",file$ 
    if file$="" then [loop]

    shortFile$=SeparateFile$(file$)
    filePath$=SeparatePath$(file$)

    if FileExist(filePath$,shortFile$)<1 then
        notice "Error"+chr$(13)+"File does not exist."
        goto [loop]
    end if


[loadFile]'** OPEN FILE AND LOAD INTO TEXTEDITOR
    cursor hourglass
    open file$ for input as #file
    print #1.t, "!contents #file"
    close #file
    gosub [settext]
    print #1.t, "!origin 1 1";
    cursor normal
    goto [loop]



[settext]'** ADD FILENAME TO TITLEBAR
    title$="Open Source LB Editor "+file$
    calldll #user, "SetWindowText", h as word, title$ as ptr, result as void
    return



[saveas]'** SAVES CONTENTS AS file$
    filedialog "Save file as..",filePath$+"*.bas",file$ 
      if file$="" then
        notice "You must choose a file name."
        goto [loop]
      end if
    gosub [settext]

[save]'** SAVES CURRENT FILE
    gosub [savesub]
    goto [loop]


[savesub]
    cursor hourglass
    print #1.t, "!contents?";
    input #1.t, saveit$

'** IF THERE IS NO CURRENT FILENAME, ASK USER FOR ONE
    if (right$(file$,12)="untitled.bas") or (file$="") then
        filedialog "Save file as...",filePath$+"*.bas",file$ 
          if file$="" then
            notice "You must choose a file name."
            RETURN
          end if
    end if

    open file$ for output as #file
    print #file, saveit$
    close #file

    cursor normal
    notice "File saved as "+ file$
    RETURN


[print]
    cursor hourglass
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar
    print #1.t, "!contents?";
    input #1.t, saveit$ 

    open "tempedit.txt" for output as #tprint
        print #tprint, saveit$
    close #tprint

    printFile$ = "tempedit.txt"+chr$(0)

    open "shell.dll" for dll as #shell
    calldll #shell, "ShellExecute", _
        h as word, _
        "print" as ptr, _
        printFile$ as ptr, _
        "" as ptr, _
        DefaultDir$ as ptr, _
        _SW_HIDE as short, _
        result as word
    close #shell

    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    cursor normal
    goto [loop]


[readyRun]'** MAKE A TEMP FILE TO RUN IN LIBERTY BASIC
'** GET CURRENT TEXTEDIT ORIGIN
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

'** GET CONTENTS OF TEXTEDITOR AND SAVE TO TEMPFILE
    if tempfilename$<>"" then kill tempfilename$
    print #1.t, "!contents?"
    input #1.t, saveit$ 
    tempfilename$=filePath$+"tempfile.bas"
    open tempfilename$ for output as #temp
    print #temp, saveit$
    close #temp

    if libertyexe$="" then gosub [findLiberty]
    RETURN


[findLiberty]'** FIND LIBERTY.EXE
    filedialog "Find Liberty.exe","*.*",libertyexe$ 
    RETURN


[run]
    gosub [readyRun]
    run libertyexe$+" -R -A -M "+tempfilename$ 
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[debug]
    gosub [readyRun]
    run libertyexe$+" -D -A -M "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]

[runtkn]
    filedialog "Choose TKN..","*.TKN",tknfile$
    run tknfile$
    goto [loop]

[maketkn]
    gosub [readyRun]
    run libertyexe$+" -T "+tempfilename$
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    goto [loop]



[paint]
    run "pbrush.exe",SHOWNORMAL
    goto [loop]

[notepad]
    run "notepad.exe",SHOWNORMAL
    goto [loop]

[winfile]
    run "winfile.exe",SHOWNORMAL
    goto [loop]

[calculator]
    run "calc.exe" ,SHOWNORMAL
    goto [loop]



[help]
    run "winhelp liberty.hlp"
    goto [loop]

[tutorial]
    run "winhelp tutorial.hlp"
    goto [loop]



[addTooltips]
    calldll #cctl, "InitCommonControls", re as void
    calldll #user, "GetWindowWord", h as word,_
        GWW as word, hInstance as word

    calldll #user, "CreateWindow", _
        "tooltips_class" as ptr, _
        "" as ptr, _
        style as long, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        CW.USEDEFAULT as word, _
        h as word, _
        0 as word, _
        hInstance as word, _
        "" as ptr, _
        hwndTT as word

'** MAKE A STRUCT FOR EACH TOOL
    struct toolinfo1, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo2, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo3, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo4, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo5, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo6, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo7, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo8, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo9, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo10, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo11, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo12, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo13, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo14, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    struct toolinfo15, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr


    toolinfo1.cbSize.struct = 22
    toolinfo1.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo1.hwnd.struct = h
    toolinfo1.uId.struct = hwnd(#1.new)
    toolinfo1.hInst.struct = hInstance
    toolinfo1.lpstrText$.struct = "New File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo1 as struct, re as long

    toolinfo2.cbSize.struct = 22
    toolinfo2.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo2.hwnd.struct = h
    toolinfo2.uId.struct = hwnd(#1.open)
    toolinfo2.hInst.struct = hInstance
    toolinfo2.lpstrText$.struct = "Open File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo2 as struct, re as long

    toolinfo3.cbSize.struct = 22
    toolinfo3.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo3.hwnd.struct = h
    toolinfo3.uId.struct = hwnd(#1.save)
    toolinfo3.hInst.struct = hInstance
    toolinfo3.lpstrText$.struct = "Save File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo3 as struct, re as long

    toolinfo4.cbSize.struct = 22
    toolinfo4.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo4.hwnd.struct = h
    toolinfo4.uId.struct = hwnd(#1.saveas)
    toolinfo4.hInst.struct = hInstance
    toolinfo4.lpstrText$.struct = "Save File As..."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo4 as struct, re as long

    toolinfo5.cbSize.struct = 22
    toolinfo5.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo5.hwnd.struct = h
    toolinfo5.uId.struct = hwnd(#1.print)
    toolinfo5.hInst.struct = hInstance
    toolinfo5.lpstrText$.struct = "Print File"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo5 as struct, re as long

    toolinfo6.cbSize.struct = 22
    toolinfo6.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo6.hwnd.struct = h
    toolinfo6.uId.struct = hwnd(#1.run)
    toolinfo6.hInst.struct = hInstance
    toolinfo6.lpstrText$.struct = "Run Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo6 as struct, re as long

    toolinfo7.cbSize.struct = 22
    toolinfo7.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo7.hwnd.struct = h
    toolinfo7.uId.struct = hwnd(#1.debug)
    toolinfo7.hInst.struct = hInstance
    toolinfo7.lpstrText$.struct = "Debug Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo7 as struct, re as long

    toolinfo8.cbSize.struct = 22
    toolinfo8.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo8.hwnd.struct = h
    toolinfo8.uId.struct = hwnd(#1.token)
    toolinfo8.hInst.struct = hInstance
    toolinfo8.lpstrText$.struct = "Tokenize Program"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo8 as struct, re as long

    toolinfo9.cbSize.struct = 22
    toolinfo9.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo9.hwnd.struct = h
    toolinfo9.uId.struct = hwnd(#1.runtkn)
    toolinfo9.hInst.struct = hInstance
    toolinfo9.lpstrText$.struct = "Run an existing TKN"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo9 as struct, re as long

    toolinfo10.cbSize.struct = 22
    toolinfo10.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo10.hwnd.struct = h
    toolinfo10.uId.struct = hwnd(#1.paint)
    toolinfo10.hInst.struct = hInstance
    toolinfo10.lpstrText$.struct = "Run Windows Paintbrush"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo10 as struct, re as long

    toolinfo11.cbSize.struct = 22
    toolinfo11.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo11.hwnd.struct = h
    toolinfo11.uId.struct = hwnd(#1.file)
    toolinfo11.hInst.struct = hInstance
    toolinfo11.lpstrText$.struct = "Run File Manager"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo11 as struct, re as long

    toolinfo12.cbSize.struct = 22
    toolinfo12.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo12.hwnd.struct = h
    toolinfo12.uId.struct = hwnd(#1.note)
    toolinfo12.hInst.struct = hInstance
    toolinfo12.lpstrText$.struct = "Run Notepad"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo12 as struct, re as long

    toolinfo13.cbSize.struct = 22
    toolinfo13.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo13.hwnd.struct = h
    toolinfo13.uId.struct = hwnd(#1.calc)
    toolinfo13.hInst.struct = hInstance
    toolinfo13.lpstrText$.struct = "Run Windows Calculator"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo13 as struct, re as long

    toolinfo14.cbSize.struct = 22
    toolinfo14.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo14.hwnd.struct = h
    toolinfo14.uId.struct = hwnd(#1.help)
    toolinfo14.hInst.struct = hInstance
    toolinfo14.lpstrText$.struct = "Liberty BASIC Help"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo14 as struct, re as long

    toolinfo15.cbSize.struct = 22
    toolinfo15.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo15.hwnd.struct = h
    toolinfo15.uId.struct = hwnd(#1.tutor)
    toolinfo15.hInst.struct = hInstance
    toolinfo15.lpstrText$.struct = "Liberty BASIC Tutorial"
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo15 as struct, re as long


    struct toolinfo16, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    toolinfo16.cbSize.struct = 22
    toolinfo16.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo16.hwnd.struct = h
    toolinfo16.uId.struct = hwnd(#1.t)
    toolinfo16.hInst.struct = hInstance
    toolinfo16.lpstrText$.struct = "Right click here for an edit menu."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo16 as struct, re as long

    struct toolinfo17, cbSize as word, uFlags as word,_
        hwnd as word, uId as word, x as word, y as word,_
        w as word, h as word, _
        hInst as word, lpstrText$ as ptr

    toolinfo17.cbSize.struct = 22
    toolinfo17.uFlags.struct = TTF.IDISHWND or TTF.SUBCLASS
    toolinfo17.hwnd.struct = h
    toolinfo17.uId.struct = hwnd(#1.quit)
    toolinfo17.hInst.struct = hInstance
    toolinfo17.lpstrText$.struct = "Close Program."
    calldll #user, "SendMessage", hwndTT as word, TTM.ADDTOOL as word, _
    0 as word, toolinfo17 as struct, re as long

    RETURN



[branchlabels]
'** OPEN DIALOG, FILL LISTBOX WITH BRANCH LABELS
    cursor hourglass
    WindowWidth=420:WindowHeight=440
    button #2.okay,   "OKAY",  [branch],      UL, 320,10,80,26
    button #2.cancel, "CANCEL",[cancelbranch],UL, 320,40,80,26
    listbox #2.branch, branch$(, [branch],10, 10, 300,380
    open "Branch Labels" for dialog_modal as #2

    print #2.branch,  "font Courier_New 0 16"
    print #2.okay,   "!font Courier_New 0 20"
    print #2.cancel, "!font Courier_New 0 20"

    Print #1.t,"!lines";
    Input #1.t, rowcount
    print #1.t, "!origin?";
    input #1.t, rowVar,columnVar

    rowcount=int(rowcount)
    REDIM branch$(rowcount)
    branch$(0)="<start>"

    bx=1
    for i=1 to rowcount
        print #1.t,"!line ";i;"";
        Input #1.t, line$ 
            if left$(trim$(line$),1)="[" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
            if lower$(left$(trim$(line$),8))="function" then
                branch$(bx)=trim$(line$)
                bx=bx+1
            end if
    next i

    SORT branch$(,0,bx

    Print #2.branch,"reload"
    print #2.branch, "selectindex 1";
    cursor normal
    print #2.branch, "setfocus"
    goto [loop]


[cancelbranch]
'** CANCEL, RETURN TO EDITOR
    close #2
    print #1.t, "!origin ";rowVar;" ";columnVar;"";
    print #1.t, "!setfocus";
    goto [loop]


[branch]
'** CHOOSE BRANCH, SET EDITOR TO THAT POSITION
    cursor hourglass
    print #2.branch,"selection?"
    Input #2.branch,branchselect$ 

    if branchselect$="<start>" then
        print #1.t, "!origin 1 1";
        print #1.t, "!setfocus";
        cursor normal
        close #2
        goto [loop]
    end if

    branchlength=len(branchselect$)

    For i = 1 TO rowcount
       print #1.t,"!line ";i;
       Input #1.t,line$
          If trim$(line$)= branchselect$ Then
            Print #1.t, "!origin ";i;" ,0";
            i=rowcount
            close #2
            print #1.t, "!setfocus";
            cursor normal
            goto [loop]
          END If
    Next i
    cursor normal
    goto [loop]




[bmp] '** BITMAP PREVIEWER
    WindowWidth=640:WindowHeight=480

    button #bit.open, "Open",   [openbmp],  UL,350,5,80,26
    button #bit.save, "Save As",[savebmp],  UL,350,35,80,26
    button #bit.exit, "Exit",   [closebit], UL,350,65,80,26

    button #bit.draw, "Choose Pen Color",[colorChoice],UL,450,5,160,26
    statictext #bit.ins, "Click and drag to draw on bitmap.",450,40,150,60
    textbox #bit.t1, 20,35,300,26
    textbox #bit.t2, 20,65,300,26


    graphicbox #bit.box1, 20,100,600,340

    statictext #bit.s, "Bitmap File:",20,5,150,20
    open "Bitmap Preview" for dialog_modal as #bit
    print #bit, "trapclose [closebit]"

    print #bit.t1,   "!font Times_New_Roman 0 16"
    print #bit.t2,   "!font Times_New_Roman 0 16"
    print #bit.save, "!font Times_New_Roman 0 16"
    print #bit.open, "!font Times_New_Roman 0 16"
    print #bit.exit, "!font Times_New_Roman 0 16"
    print #bit.draw, "!font Times_New_Roman 0 16"
    print #bit.s,    "!font Times_New_Roman 0 16"
    print #bit.ins,  "!font Times_New_Roman 0 16"

    print #bit.box1, "down"
    print #bit.box1, "size 2; color ";drawcolor$
    print #bit.box1, "setfocus; when leftButtonMove [drawit]"
    print #bit.box1, "when leftButtonDown [drawit]"

    goto [loop]

[closebit]
    print #bit.box1, "cls"
    close #bit
    if bmploaded=1 then unloadbmp "tempPicture"
    bmploaded=0
    goto [loop]

[drawit]
    if bmploaded=0 then
        notice "You must choose a bitmap first."
        goto [loop]
    end if

    if MouseX>bmpwidth or MouseY>bmpheight then [loop]

    print #bit.box1, "set ";MouseX;" ";MouseY
    goto [loop]



[savebmp]
    if picFile$="" then
        notice "It is not possible to SAVE.  No Bitmap has been chosen."
        goto [loop]
    end if

    filedialog "Save As..","*.bmp",savebmpfile$ 
    if savebmpfile$="" then [loop]

    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"
    BMPSAVE "tempPicture", savebmpfile$ 

    cursor normal
    notice "Bitmap saved as "+savebmpfile$ 
    goto [loop]


[openbmp]
    filedialog "Open Bitmap","*.bmp", picFile$
    if picFile$ = "" then [loop]

    print #bit.t1, lower$(picFile$)

    bmpheight=HeightBitmap(picFile$)
    bmpwidth=WidthBitmap(picFile$)

    if bmploaded=1 then unloadbmp "tempPicture"
    loadbmp "tempPicture", picFile$
    bmploaded=1

    print #bit.t2, "Width:  ";bmpwidth;"    Height:  ";bmpheight;""

    print #bit.box1, "cls"
    print #bit.box1, "drawbmp tempPicture 0 0"
    print #bit.box1, "flush"
    goto [loop]



[colorChoice]
    print #bit.box1, "getbmp tempPicture 0 0 ";bmpwidth;" ";bmpheight
    print #bit.box1, "flush"

    WindowWidth=320:WindowHeight=350
    button     #color.default,   "Get Color",[get.col],        UL,200,10,100,30
    button     #color.okay,      "Close",    [quitColorChoice],UL,200,50,100,30
    textbox    #color.red,       20, 50, 150, 30
    textbox    #color.green,     20, 150, 150, 30
    textbox    #color.blue,      20, 250, 150, 30
    statictext #color.redtext,   "Red:  (0-255)", 20, 20, 100, 20
    statictext #color.greentext, "Green:  (0-255)", 20, 120, 100, 20
    statictext #color.bluetext,  "Blue:  (0-255)", 20, 220, 100, 20
    statictext #color.colorname, "Color is...", 200, 120, 100, 20
    statictext #color.colornum,  " ", 200, 150, 100, 20
    graphicbox #color.color,     200, 180, 100, 100
    open "RGB Color Choice" for dialog as #color
    print #color, "trapclose [quitColorChoice]"
    print #color.red,   str$(colorred)
    print #color.green, str$(colorgreen)
    print #color.blue,  str$(colorblue)

[get.col]
    print #color.red, "!contents?"
    input #color.red, colorred
    print #color.green, "!contents?"
    input #color.green, colorgreen
    print #color.blue, "!contents?"
    input #color.blue, colorblue

    if colorred>255 then colorred=255
    if colorred<0 then colorred=0
    print #color.red, str$(colorred)

    if colorgreen>255 then colorgreen=255
    if colorgreen<0 then colorgreen=0
    print #color.green, str$(colorgreen)

    if colorblue>255 then colorblue=255
    if colorblue<0 then colorblue=0
    print #color.blue, str$(colorblue)

    longcol=(colorblue*65536)+(colorgreen*256)+colorred
    print #color.colornum, str$(longcol)

    print #color.color, "down; size 200; color ";colorred;" ";colorgreen;" ";colorblue
    print #color.color, "line 50 0 50 100"
    print #color.red, "!setfocus"
    goto [loop]

[quitColorChoice]
    drawcolor$=str$(colorred)+" "+str$(colorgreen)+" "+str$(colorblue)
    print #bit.box1, "color "+drawcolor$
    close #color
    goto [loop]


[about]
    message$="About this editor..."+chr$(13)+_
        chr$(169)+"The Liberty BASIC Community"
    notice message$
    goto [loop]




[wav]
    if wavPath$="" then wavPath$=DefaultDir$
    filedialog "Open WAV file",wavPath$+"\*.WAV",wavFile$
    if wavFile$="" then
        playwave ""
        goto [loop]
    end if

    slash=len(wavFile$)
        while instr(wavFile$, "\", slash)=0
            slash=slash-1
        wend
    wavPath$=left$(wavFile$,slash)
    playwave wavFile$,async
    goto [wav]



[write.ini.file]
    open DefaultDir$ + "\editor.ini" for output as #inifile
        print #inifile, setFont$
    close #inifile
    RETURN



[read.ini.file]
    open DefaultDir$ + "\editor.ini" for append as #inifile
        if lof(#inifile) <> 0 then
            close #inifile
            open DefaultDir$ + "\editor.ini" for input as #inifile
            line input #inifile, setFont$
        end if
    close #inifile

    if setFont$="" then setFont$="Fixedsys 8 15"
    print #1.t, "!font ";setFont$  'set font in texteditor
    RETURN


[numbertools]
    popupMenu "&Decimal to Hex Converter",[dectohex],_
        "&Hex to Decimal Converter",[hextodec]
    goto [loop]

[dectohex]
    prompt "Enter a number...";decnum$
    decnum=val(decnum$)
    notice dechex$(decnum)
    goto [loop]

[hextodec]
    prompt "Enter a hex number...";hexnum$
    notice hexdec(hexnum$)
    goto [loop]



[timetools]
    popupMenu "Current &Time",[timenow],_
        "Today's &Date",[datenow]
    goto [loop]

[timenow]
    timemsg$="Current time is:  "+chr$(13)+_
    time$()+chr$(13)+chr$(13)+_
    "Seconds since midnight:  "+str$(time$("seconds"))+chr$(13)+_
    "Milliseconds since midnight:  "+str$(time$("milliseconds"))
    notice timemsg$
    goto [loop]

[datenow]
    datemsg$="Date is" +chr$(13)+_
    date$() +chr$(13)+_
    date$("mm/dd/yyyy") +chr$(13)+_
    date$("mm/dd/yy") +chr$(13)+_
    date$("yyyy/mm/dd") +chr$(13)+_
    "Days since Jan 1, 1900:  "+ date$("days")
    notice datemsg$
    goto [loop]



[fontdialog]
    fontdialog setFont$,setFont$
    print #1.t, "!font ";setFont$
    gosub [write.ini.file]
    goto [loop]


[makebmpbutton]
    WindowWidth=btnwide+40:WindowHeight=btnhigh+60
    graphicbox #b.g, 0,0,200,100
    open "BmpButton" for window_nf as #b
    print #b, "trapclose [closeb]"

    print #b.g, "font arial 0 12 bold"
    print #b.g, "down;color red ; place 5 10"
    print #b.g, "|Quit"
    print #b.g, "color 230 230 230"
    print #b.g, "line 0 0 29 0;line 0 0 0 14"
    print #b.g, "color darkgray"
    print #b.g, "line 28 1 28 14;line 1 13 28 13"
    print #b.g, "color 45 45 45"
    print #b.g, "line 29 1 29 15;line 1 14 29 14"
    print #b.g, "getbmp quitbutton 0 0 30 15"
    BMPSAVE "quitbutton","qbutton.bmp"
[closeb]
    WindowWidth=600:WindowHeight=480
    close #b:return



'** NEW **
[changeicon]
' Icon changer code begins here
' This cannot make Icons
' Ok first I have tried to document this well
' If you don't understand or something doesn't work, PLEASE
' email me at ajl13@bellatlantic.net
' Oh, real quick. I, Anthony Liguori, copyright this or
' whatever under the GNU copyright
' So you can play with or include this in your programs as
' long as you give me credit
' Heh-hee. It didn't take that long, but...

' Modified Feb, 1999, by Brian D. Pugh
' Cosmetic changes to GUI
' Retains path after selecting runtime exe, in anticipation
' that the icon required is in the same dir as the runtime
' Shows current icon in selected runtime exe
' Shows new icon in runtime exe AFTER pressing the Change! button
' Won't let you select an icon until you have selected the runtime exe
' Icon change coding remains the same (couldn't alter anything of Anthony's!)

    UpperLeftX=int((DisplayWidth-268)/2)
    UpperLeftY=int((DisplayHeight-230)/2)
    WindowWidth=268:WindowHeight=230

    textbox #icon.Textbox2,21,30,174,24
    textbox #icon.Textbox1,21,83,174,24
    button #icon.Button4,"...",[get.runtime],UL,216,30,30,24
    button #icon.Button3,"...",[get.icon],UL,216,83,30,24
    button #icon.Button5,"Change!",[change.it],UL,21,124,69,24
    button #icon.Button6,"Exit",[exit.now],UL,176,124,69,24

    open "Icon changer V0.90b" for graphics_nsb_nf as #icon

    print #icon,"trapclose [exiticon]"
    print #icon,"fill darkcyan;place 21 22"
    print #icon, "color white;backcolor darkcyan;\Runtime Engine Path"
    print #icon,"place 21 74;\Icon Path"
    print #icon,"flush"

    open "user" for dll as #iconuser
    open "shell" for dll as #iconshell

[mainloop]
    input loop$

[exiticon]
    close #iconuser:close #iconshell:close #icon
    goto [loop]

[get.runtime]
    filedialog "Find Runtime Engine","*.exe",runtime$
    print #icon.Textbox2,lower$(runtime$)
    gosub [ShowBefore]
    goto [mainloop]

[get.icon]
    if runtime$="" then notice "Icon Changer error"+chr$(13)+_
    "Please select the Runtime Engine Path first":goto [mainloop]

    icopath$=runtime$
    while instr(icopath$,"\"):icopath$=mid$(icopath$,instr(icopath$,"\")+1):wend
    icopath$=left$(runtime$,len(runtime$)-len(icopath$))
    icopath$=lower$(icopath$)+"*.ico"
    filedialog "Icon",icopath$,icon$
    print #icon.Textbox1,lower$(icon$)
    goto [mainloop]

[change.it]
    print #icon.Textbox2,"!contents?"
    input #icon.Textbox2,runtime$
    print #icon.Textbox1,"!contents?"
    input #icon.Textbox1,icon$ 
    gosub [CheckRuntimeEngine]
    if error=0 then
        gosub [CheckIcon]
        if error=0 then
            gosub [change]
            gosub [ShowAfter]
        end if
    end if
    if error=1 then notice "Error changing Runtime Icon"
goto [mainloop]

[exit.now]
goto [exiticon]

[change]
    success=0
    ico=hexdec("16") 'I used a hex editor for the offsets, it's easier for me
    runpos=hexdec("19ff")  ''        ''
    open icon$ for input as #1icon 'open up the icon
    icont$=input$(#1icon,lof(#1icon)) 'read the icon

'skip the header and put all the actual data into icondata$
'    icondata$=mid$(icont$,ico,len(icont$))    'ERROR?
    icondata$=mid$(icont$,ico,len(icont$)-ico) 'substitute this

    close #1icon 'close icon
    iconlength=len(icondata$) 'improves speed
    open "kernel" for dll as #kernel 'loads kernel

    ' Opens up runtime for write & read access and returns the handle into hFile
    calldll #kernel,"_lopen",runtime$ as ptr,_
        _OF_WRITE as short,hFile as word

    ' Moves the file pointer to the beginning of the file,
    ' this is why i used apis instead of lb
    calldll #kernel,"_llseek",hFile as word,_
        0 as long,0 as short,result as long

    ' Moves to the position of the icon resource
    calldll #kernel,"_llseek",hFile as word,_
        runpos as long,1 as short,result as long

    calldll #kernel,"_lwrite",hFile as word,icondata$ as ptr,_
        iconlength as short,result as short

    calldll #kernel,"_lclose",hFile as word,result as short
    close #kernel
    return

[CheckIcon]
    error=0
    if icon$<>"" then
    open icon$ for input as #1icon
    icont$=input$(#1icon,lof(#1icon))
    close #1icon
    else error=1
    end if
    ' check to see if the icon is 32 x 32
    if mid$(icont$,7,1)<>" " or mid$(icont$,8,1)<>" " then error=1
    ' check to see if the icon is 16 colour
    if mid$(icont$,9,1)<>chr$(16) then error=1
    ' ok, that's enough error checking for me :)
    return

[CheckRuntimeEngine]
    error=0
    if runtime$="" then error=1
    return

[ShowBefore]
    print #icon,"discard;redraw"
    szFile$=runtime$+chr$(0):hico=hWnd(#icon):x=120:y=160
    calldll #iconuser,"GetDC",hico as word,hicodc as word
    calldll #iconuser,"GetWindowWord",hico as word,_
        _GWL_HINSTANCE as word,hCurrentInst as word

    calldll #iconshell,"ExtractIcon",hCurrentInst as word,_
        szFile$ as ptr,0 as ushort,hicon as word

    if hicon>1 then
        print #icon,"place 21 174;\Existing"
        print #icon,"place 21 190;\Icon >>>         "
        calldll #iconuser,"DrawIcon",hicodc as short,_
            x as short,y as short,hicon as word,Ret as short
    else
        print #icon,"place 21 190;\Icon - None"
    end if

    print #icon,"flush"
    calldll #iconuser,"ReleaseDC",hico as word,hicodc as word,Ret as ushort
    return

[ShowAfter]
    print #icon,"discard;redraw"
    szFile$=runtime$+chr$(0):hico=hWnd(#icon):x=120:y=160
    calldll #iconuser,"GetDC",hico as word,hicodc as word

    calldll #iconuser,"GetWindowWord",hico as word,_
        _GWL_HINSTANCE as word,hCurrentInst as word

    calldll #iconshell,"ExtractIcon",hCurrentInst as word,_
        szFile$ as ptr,0 as ushort,hicon as word

    if hicon>1 then
        print #icon,"place 21 174;\New       "
        print #icon,"place 21 190;\Icon >>>  "
        calldll #iconuser,"DrawIcon",hicodc as short,_
            x as short,y as short,hicon as word,Ret as short
    end if

    print #icon,"flush"
    calldll #iconuser,"ReleaseDC",hico as word,_
        hicodc as word,Ret as ushort
    return




'*************** FUNCTION LIBRARY **********************
    function WidthBitmap(name$)
        open name$ for input as #pic
        pic$=input$(#pic,29)
        close #pic
        WidthBitmap = asc(mid$(pic$,19,1)) + (asc(mid$(pic$,20,1)) * 256)
    end function

    function HeightBitmap(name$)
        open name$ for input as #pic
        pic$=input$(#pic,29)
        close #pic
        HeightBitmap = asc(mid$(pic$,23,1)) + (asc(mid$(pic$,24,1)) * 256)
    end function


    function SeparateFile$(f$)
        fileindex=len(f$)
        filelength=len(f$)
          while mid$(f$, fileindex,1)<>"\"
            fileindex=fileindex-1
          wend
        SeparateFile$=right$(f$,filelength-fileindex)
        end function


    function SeparatePath$(f$)
        fileindex=len(f$)
        filelength=len(f$)
          while mid$(f$, fileindex,1)<>"\"
            fileindex=fileindex-1
          wend
        SeparatePath$=left$(f$,fileindex)
        end function


    function FileExist(fPath$,fFile$)
        files fPath$,fFile$,info$(
        FileExist=val(info$(0,0))
        end function


