' Example to use API call FindExecutable to find default web browser associated with *.htm files
' Also uses API call ShellExecute to launch a URL with the default browser.
' You can launch a URL, an e-mail address to write e-mail, or a NewsGroup using this code, assuming that the
' same browser can handle all three functions. This works fine with Netscape Communicator 4.04 and Win95.
' Free free to change/modify any way you want! Bon Chance!

    nomainwin
    WindowWidth = 308
    WindowHeight = 120

    UpperLeftX = int((DisplayWidth - WindowWidth) / 2)
    UpperLeftY = int((DisplayHeight - WindowHeight) / 2)

    button #main.button1, "http://www.liberty-basic.com/", [http], UL, 0, 0, 300, 30
    button #main.button2, "news://news/alt.lang.basic", [news], UL, 0, 30, 300, 30
    button #main.button3, "mailto:libertybasic@world.std.com", [mailto], UL, 0, 60, 300, 30

    open "Launch Browser!" for window as #main
    print #main, "trapclose [quit]"

    browserExec$ = space$(255) + chr$(0)
    fileName$ = "C:\TEMPHTM.HTM" + chr$(0)   'create a temp htm file
    open fileName$ for output as #1     ' Create temp HTML file
    print #1, "<HTML> <\HTML>"          ' Output text
    close #1                            ' Close file

    lpFile$ = fileName$
    lpDirectory$ = "" + chr$(0)
    lpResult$ = browserExec$

    open "shell.dll" for dll as #shell

    calldll #shell,  "FindExecutable", _     'find executable program corresponding to *.htm
        lpFile$ as ptr, _
        lpDirectory$ as ptr, _
        lpResult$ as ptr, _
        result as word

    close #shell

    a$ = lpResult$

    x = INSTR(trim$(a$), chr$(0))
    browserExec$ = left$(a$, x-1)

    if result <= 32 then notice "No Web Browser Found!"
    kill fileName$        'get rid of temp file

    open "user" for dll as #user
    calldll #user, _
        "GetDesktopWindow", _
        h as word               'get handle for current window
    close #user



[mainLoop]
    input aVar$
    goto [mainLoop]




[http]
    url$ = "http://www.liberty-basic.com/"    'select a url address
    gosub [launchBrowser]
    goto [mainLoop]

[news]
    url$ = "news://news/alt.lang.basic"       'or select a newsgroup
    gosub [launchBrowser]
    goto [mainLoop]

[mailto]
    url$ = "mailto:libertybasic@world.std.com?Subject=This really works!"
'or enter an e-mail address
    gosub [launchBrowser]
    goto [mainLoop]


[quit]
    close #main
    end



[launchBrowser]
    lpOperation$ = "open" + chr$(0)
    lpFile$ = browserExec$  + chr$(0)
    lpParameters$ = url$ + chr$(0)
    lpDirectory$ = "" + chr$(0)
    nShowCmd = _SW_SHOWNORMAL

    open "shell.dll" for dll as #shell

    calldll #shell, "ShellExecute", _     'make call to launch browser with selected URL
        h as word, _
        lpOperation$ as ptr, _
        lpFile$ as ptr, _
        lpParameters$ as ptr, _
        lpDirectory$ as ptr, _
        nShowCmd as short, _
        result as word

    close #shell

    if result <= 32 then notice "Error, Address Failure!"
return

